#ifndef __MAINWIN_H
#define __MAINWIN_H
/*-------------------------------------------------------------------------
 * Copyright (c) 2000 Kenneth W. Sodemann (stufflehead@bigfoot.com)
 *-------------------------------------------------------------------------
 * mainwin
 *
 * Synopsis:
 *    The main MathWars window
 *
 * $Id: mainwin.h,v 1.1 2000/10/15 15:36:40 stuffle Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to 
 * Free Software Foundation, Inc. 
 * 59 Temple Place, Suite 330 
 * Boston, MA  02111-1307  USA
 *
 *-------------------------------------------------------------------------
 */
/*! \file mainwin.h

  \brief Main MathWar window

  Create and manipulate the main window of the MathWar game.

  \author Kenneth W. Sodemann <stufflehead@bigfoot.com>
  $Revision: 1.1 $
  $Date: 2000/10/15 15:36:40 $
*/

#include <gtk/gtk.h>

#include "operators.h"

/*! \fn GtkWidget *create_mainwin (void)
 
  \brief Create the main window for the application

  \return
  A pointer to the created main widget.
*/
GtkWidget *create_mainwin (void);

/*! \fn void set_timer_pct (GtkWidget *mainwin,
                            gfloat     pct)

  \brief Set the timer dial percent.

  \param mainwin
  The widget that contains the dial

  \param pct
  The percent to set it to, between 0.0 and 1.0

  \return
  Nothing.
*/
void set_timer_pct (GtkWidget  *mainwin,
                    gfloat      pct);

/*! \fn void display_pause (GtkWidget *mainwin)
 
  \brief User interface between rounds or when game paused.

  Display the card backs.  

  \param mainwin 
  The topmost parent widget.

  \return
  Nothing.
*/
void display_pause (GtkWidget *mainwin);

/*! \fn void display_cards (GtkWidget     *mainwin,
                            gint           card_one_val,
                            gint           card_two_val,
                            operator_type  operator)
                       
  \brief UI start of the round.

  Display the cards.  Display the operator.  Make the game controls
  sensative.

  \param mainwin 
  The topmost parent widget.

  \param card_one_val
  The face value of card one

  \param card_two_val
  The face value of card two

  \param operator
  The operation to be performed

  \return
  Nothing.
*/
void display_cards (GtkWidget      *mainwin,
                    gint            card_one_val,
                    gint            card_two_val,
                    operator_type   operator);


/*! \fn void display_names (GtkWidget    *mainwin,
                            const gchar  *name1,
                            const gchar  *name2)
  
  \brief Display the player names

  \param mainwin
  The topmost parent widget.

  \param name1
  The name for player #1.

  \param name2
  The name for player #2.

  \return
  Nothing.
*/
void display_names (GtkWidget   *mainwin,
                    const gchar *name1,
                    const gchar *name2);


/*! \fn void display_rounds_left (GtkWidget *mainwin, gint rounds)
 
  \brief Display the number of rounds left to play

  \param mainwin
  The topmost parent widget.

  \param rounds
  The number of rounds left to play.

  \return
  Nothing.
*/
void display_rounds_left (GtkWidget *mainwin,
                          gint       rounds);


/*! \fn void display_scores (GtkWidget *mainwin,
                             gint       score1,
                             gint       score2)

  \brief Display the current scores for both players.

  \param mainwin
  The topmost parent widget.

  \param score1
  The current score for player #1.

  \param score2
  The current score for player #2.

  \return
  Nothing.
*/
void display_scores (GtkWidget *mainwin,
                     gint       score1,
                     gint       score2);
#endif
