/*!******************************************************************************

  @file         hbd07.h

  ------------------------------------------------------------------------------

  @author       JuergenP

  @brief        filesysteminterface_7

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif

********************************************************************************/

#ifndef HBD07_H
#define HBD07_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x07\xd3\xf5\xd8\x44\xc2\x9c\x30\x54\xe7\x89\xdd\xd7\xc9\x7b\x82'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gbd00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void b07cadd_record (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    tgg00_Rec             VAR_VALUE_REF  b);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b07cappend_record (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    tgg00_FilePos         VAR_VALUE_REF  tree_pos,
    tgg00_Rec             VAR_VALUE_REF  b);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b07crepl_record (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    tgg00_Rec             VAR_VALUE_REF  b);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b07ctrepl_record (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    tgg00_FilePos         VAR_VALUE_REF  tree_pos,
    tgg00_Rec             VAR_VALUE_REF  b);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b07cdel_record (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    tgg00_Lkey            VAR_VALUE_REF  rk);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b07ctget_record (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    tgg00_FilePos         VAR_VALUE_REF  tree_pos,
    tgg00_Lkey            VAR_VALUE_REF  rk,
    tgg00_Rec             VAR_VALUE_REF  b);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b07cget_record (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    tgg00_Lkey            VAR_VALUE_REF  rk,
    tgg00_Rec             VAR_VALUE_REF  b);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b07cprev_record (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    tgg00_Lkey            VAR_VALUE_REF  rk,
    tgg00_BdSetResultRecord  VAR_VALUE_REF  set_result,
    tgg00_FilePos         VAR_VALUE_REF  tree_pos,
    void                  *  b);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b07cnext_record (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    tgg00_Lkey            VAR_VALUE_REF  rk,
    tgg00_BdSetResultRecord  VAR_VALUE_REF  set_result,
    tgg00_FilePos         VAR_VALUE_REF  tree_pos,
    void                  *  b);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b07get_result_leaf (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    tgg00_Lkey            VAR_VALUE_REF  rk,
    pasbool                              get_next,
    pasbool                              prepare_for_upd,
    tgg00_FilePos         VAR_VALUE_REF  tree_pos,
    tbd_node_ptrs         VAR_VALUE_REF  nptr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b07release_result_leaf (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    pasbool                              node_changed,
    tbd_node_ptrs         VAR_VALUE_REF  nptr);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

