#!/devtool/local/bin/perl
#
# Execute a single command in a certain chr-Environment
#

BEGIN {
    if ($^O !~ /MSWin32/i) {
		unshift @INC, "/devtool/local/bin";
		unshift @INC, "/devtool/TOOL/tool/bin";
		unshift @INC, "/devtool/TOOL/tool/lib/perl5";
		unshift @INC, "/devtool/TOOL/tool/lib";
		unshift @INC, "/SAP_DB/TESTDB/lib";
		unshift @INC, "/SAP_DB/TESTDB";
    }
}
$| = 1;

use testdbchr;
use IniFile;
use Getopt::Long;

print "\n\nchr_destroy v0.1 (c)2004, SAP AG\n\n";

my %options = ();
if (! &GetOptions(  \%options,
            'h|help|?',
            'dir=s',
	    'cfg=s'
            )) {
    print("Run testdb.pl -h for help\n");
    exit(1);
}

my $tdb;
my $cfg = "";

#
# Get the .cfg-File right
#

if ($options{'cfg'}) {
	if (!(-r $options{'cfg'})) {
		print "Could not read $cfg\nExiting\n";
		exit(1);
	}
	$cfg = $options{'cfg'};
}

if ($options{'dir'}) {
	$options{'dir'} = ($options{'dir'} =~ /^0.*/ ? $options{'dir'} : "0$options{'dir'}");
	
	my $etc_ref;
	print "Checking for chr $options{'dir'}..";
	
	if (-e "/SAP_DB/chr/etc/$options{'dir'}") {
		print "..OK\n";
		print "Reading configuration in /SAP_DB/chr/etc/$options{'dir'}..";
		
		$etc_ref = IniFile::load("/SAP_DB/chr/etc/$options{'dir'}");
		unless($etc_ref) {
			print "..FAILED\n";
		}
	} else {
		print "..does not exist. -> Skipping the polite part...\n";
		clean_exit(0);
	}
	
	print "OK\nChecking configuration parameters..";
	unless ($etc_ref->{'IDMAKE'} && $etc_ref->{'IDSESSION'}) {
		print "..FAILED\n\tIDMAKE = $etc_ref->{'IDMAKE'}\n\tIDSESSION = $etc_ref->{'IDSESSION'}\n";
		print "No config, no testdb instance. -> Trying the hard way...\n";
		clean_exit(0);
	} else {
		print "..OK\n"
	}
	
	print "Creating new testdbchr-Instance..\n";
	$tdb = testdbchr->new({	'ID' => $etc_ref->{'IDMAKE'},
				'profile' => $options{'test_profile'},
				'DIR' => $options{'dir'},
				'profile' => $options{'test_profile'},
				'no_objstat' => ($options{'no_objstat'} ? 1 : 0),
				'CFG' => $cfg},
				{'ID' => $etc_ref->{'IDSESSION'}});
	
	$tdb->verify_chr();
	$tdb->destroy_chr();
	
	clean_exit(0);
	
} else {
	print "$0 - Destroy a chr-Area. Syntax:\n$0 -dir <CHR_DIRECTORY>\n";
	exit(0);
}


sub clean_exit
{
	my $rc = shift;
	print "Cleaning up:\n";
	if (-e "/SAP_DB/chr/etc/$options{'dir'}") {
		print "\tRemoving /SAP_DB/chr/etc/$options{'dir'}..";
		$rc += system ("rm -rf /SAP_DB/chr/etc/$options{'dir'}");
		print "..OK\n";
	}
	if (-e "/SAP_DB/chr/$options{'dir'}") {
		print "\tRemoving /SAP_DB/chr/$options{'dir'}..";
		$rc += system ("rm -rf /SAP_DB/chr/$options{'dir'}");
		print "..OK\n";
	}
	exit($rc);
}
