;;; -*-  Mode: Lisp; Package: Maxima; Syntax: Common-Lisp; Base: 10 -*- ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;     The data in this file contains enhancments.                    ;;;;;
;;;                                                                    ;;;;;
;;;  Copyright (c) 1984,1987 by William Schelter,University of Texas   ;;;;;
;;;     All rights reserved                                            ;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;     (c) Copyright 1982 Massachusetts Institute of Technology         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "MAXIMA")
(macsyma-module limit)


;;;	**************************************************************
;;;	**							    **
;;;	**			   LIMIT PACKAGE		    **
;;;	**							    **
;;;	**************************************************************


;;; TOP LEVEL FUNCTION(S): $LIMIT $LDEFINT

(DECLARE-TOP(GENPREFIX L)
	 (SPECIAL ERRORSW errrjfflag raterr ORIGVAL $LHOSPITALLIM LOW*
		  IND* *INDICATOR LIMFUNC 
		  HALF%PI NN* DN* numer denom EXP VAR VAL VARLIST
		  *ZEXPTSIMP? $TLIMSWITCH ORIGVAL
		  $LOGARC *LIMORDER TAYLORED LOGCOMBED
		  $EXPONENTIALIZE LHP? LHCOUNT
		  $RATFAC GENVAR COMPLEX-LIMIT LNORECURSE
		  LOGINPROD? $LIMSUBST $LOGABS A 
		  context global-assumptions limit-assumptions
		  limit-top limitp integer-info old-integer-info
		  behavior-count behavior-count-now $KEEPFLOAT $logexpand)
	 (*LEXPR $LIMIT limit-list $FACTOR FACTOR $EXPAND
		 $RATSIMP $RAT $RATCOEF context)
	 (*expr $trigexpand)
	 (FIXNUM NARGS BEHAVIOR-COUNT BEHAVIOR-COUNT-NOW))

(load-macsyma-macros rzmac)

(DEFMVAR INFINITIES '($INF $MINF $INFINITY) 
  "The types of infinities recognized by Macsyma. 
   INFINITY is complex infinity")

(DEFMVAR REAL-INFINITIES '($INF $MINF)
  "The real infinities, INF is positive infinity, MINF negative infinity")

(DEFMVAR INFINITESIMALS '($ZEROA $ZEROB)
  "The infinitesimals recognized by Macsyma. ZEROA zero from above,
   ZEROB zero from below")

(defmvar RD* NIL
  "The full implications of this flag have yet to be determined.
It appears in LIMIT and DEFINT.......")

(defmvar simplimplus-problems ()
  "A list of all problems in the stack of recursive calls to simplimplus.")

(defmvar limit-answers ()
  "An association list for storing limit answers.")

(defmvar preserve-direction () "Makes LIMIT return Direction info.")

(if (not (boundp 'integer-info)) (setq integer-info ()))

(if (not (boundp 'behavior-count)) (setq behavior-count 4))

;; This should be made to give more information about the error.
;(DEFun DISCONT () 
;       (cond (errorsw (throw 'errorsw t))
;	     (t (merror "Discontinuity Encountered"))))

;(DEFUN PUTLIMVAL (E V) 
;  (let ((exp (cons '(%limit) (list e var val))))
;    (cond ((not (assolike exp limit-answers))
;	   (setq limit-answers (cons (cons exp v) limit-answers))
;	   v)
;	  (t ()))))

(defun putlimval (e v &aux exp)
  (setq exp `((%limit) ,e ,var ,val))
  (unless (assolike exp limit-answers)
    (setq limit-answers (cons (cons exp v) limit-answers)))
  v)

(DEFun GETLIMVAL (E) 
  (let ((exp (cons '(%limit) (list e var val))))
    (assolike exp limit-answers)))

(DEFMACRO LIMIT-CATCH (EXP VAR VAL) 
 `(LET ((ERRORSW T))
    (LET ((ANS (CATCH 'ERRORSW 
		  (CATCH 'LIMIT (LIMIT ,EXP ,VAR ,VAL 'THINK)))))
	(COND ((OR (NULL ANS) (EQ ANS T))  ())
	      (T ANS)))))

(defmfun $limit nargs
(let ((global-assumptions ())  (limit-assumptions ())
      (old-integer-info ())
      ($keepfloat t)  (limit-top t))
	 (DECLARE (special global-assumptions limit-assumptions old-integer-info
      $keepfloat  limit-top t))
  (if (not limitp)
      (progn (setq old-integer-info integer-info)
	     (setq integer-info ())))

  (unwind-protect
   (let ((exp1 ()) (rd* t) (lhcount $lhospitallim) (behavior-count-now 0)     
         (d ()) (exp ()) (var ()) (val ()) (dr ()) 
         (*indicator ()) (taylored ()) (origval ())
	 (logcombed ()) (lhp? ()) ($logexpand t)
	 (varlist ()) (ans ()) (genvar ()) (loginprod? ()) 
	 (limit-answers ()) (limitp t) (simplimplus-problems ()))
     (declare (special lhcount behaviour-count-now exp var val *indicator taylored origval logcombed lhp?
     $logexpand varlist genvar loginprod? limitp ))
     (prog ()
       (if (not (or (= nargs 3) (= nargs 4) (= nargs 1))) (wna-err '$limit))
;;;Is it a LIST of Things?
       (if (setq ans (apply #'limit-list (listify nargs))) (return ans))
       (setq exp1 (specrepcheck (arg 1)))
       (cond ((= nargs 1) (setq var 'foo val 0))
	     (t (setq var (arg 2))
		(cond (($constantp var) 
		       (merror 
			"Second argument cannot be a constant - LIMIT")))
		(setq val (arg 3))
		(if (eq val '$zeroa) (setq dr '$plus))
		(if (eq val '$zerob) (setq dr '$minus))))
       (cond ((= nargs 4)
	      (if (not (memq (arg 4) '($plus $minus)))
		  (merror
		   "Fourth argument must be either PLUS or MINUS - LIMIT"))
	      (setq dr (arg 4))))
       (cond ((and (atom var) (not (among var val)))
	      (setq exp exp1))
;;;Var is funny so make it a gensym.
	     (t (let ((realvar var))
		     (setq var (gensym))
		     (setq exp (MAXIMA-SUBSTITUTE var realvar exp1))
		     (putprop var realvar 'limitsub))))
       (if (and (not $limsubst) (not (eq var 'foo)))
	   (if (limunknown exp)
	       (return `((%limit) ,@(cons exp1 (cdr (listify nargs)))))))
       (setq varlist (ncons var) genvar nil origval val)
;;;Limit is going to want to make its own assumptions about the variable
;;;based on what the calling program knows. Old assumptions are saved
;;;for restoration upon exit.
       (if (not (= nargs 1)) (limit-context (arg 2) origval dr))
;;;Transform the limit value.	     
       (cond ((not (infinityp val))
	      (if (not (zerop2 val))
		  (setq exp (subin (m+ var val) exp)))
	      (setq val (cond ((eq dr '$plus) '$zeroa)
			      ((eq dr '$minus) '$zerob)
			      (t 0)))
	      (setq origval 0)))
       (if (eq val '$minf) (setq val '$inf 
				 origval '$inf
				 exp (subin (m* -1 var) exp)))
       (setq exp (resimplify
		  (factosimp (tansc (lfibtophi
				     (limitsimp ($expand (hide exp) 1 0)
						var))))))
;;;Resimplify in light of new assumptions.
       (setq d (catch 'mabs (mabs-subst exp var val)))
       (cond ((eq d 'both) (or (setq ans (both-side exp var val))
			       (nounlimit exp var val)))
	     ((eq d '$und) (return '$und))
	     ((eq d 'retn) (return (nounlimit exp var val)))
	     (t (setq exp d)))
       (setq ans (limit-catch exp var val))
       (cond ((null ans)
	      (if (or (real-epsilonp val)
		      (real-infinityp val))
		  (return (nounlimit exp var val))))
	     (t (return (clean-limit-exp ans))))
       (cond ((setq ans (both-side exp var val))
	      (return (clean-limit-exp ans)))
	     (t (return (nounlimit exp var val))))))
   (restore-assumptions))))

(defun clean-limit-exp (exp)
  (setq exp (restorelim exp))
  (if preserve-direction exp (ridofab exp)))

(defmfun limit-list nargs
       (let (((exp1 . rest) (listify nargs)))
	    (cond ((mbagp exp1)
		   `(,(car exp1) ,@(mapcar
				    #'(lambda (x)
					      (apply '$limit `(,x ,@rest)))
				    (cdr exp1))))
		  (t ()))))

(defun limit-context (var val direction) ;Only works on entry!
 (cond (limit-top 
	(mapc 'forget (setq global-assumptions (cdr ($facts var))))
	(assume '((mgreaterp) epsilon 0))
	(assume '((mlessp) epsilon 1.0e-8))
	(assume '((mgreaterp) prin-inf 1.0e+8))
	(setq limit-assumptions
	      (make-limit-assumptions global-assumptions var val direction))
	(setq limit-top ()))
       (t ()))
 limit-assumptions)

(defun make-limit-assumptions (old-assumptions var val direction)
  (prog (new-assumptions)
  (setq new-assumptions (use-old-context old-assumptions var val))
  (mapc #'assume new-assumptions)
  (if (or (null var) (null val)) (return ()))
  (cond ((and (not (infinityp val)) (null direction)) (return ()))
	((eq val '$inf)
	 (setq new-assumptions `(,(assume `((mgreaterp) ,var 1.0e+8))
				 ,@new-assumptions))
	 (return new-assumptions))
	((eq val '$minf)
	 (setq new-assumptions `(,(assume `((mgreaterp) 1.0e+8 ,var))
				 ,@new-assumptions))
	 (return new-assumptions))
	((eq direction '$plus)
	 (setq new-assumptions `(,(assume `((mgreaterp) ,var 0)) ;All limits
				 ,@new-assumptions))             ;around 0
	 (return new-assumptions))
	((eq direction '$minus)
	 (setq new-assumptions `(,(assume `((mgreaterp) 0 ,var))
				 ,@new-assumptions))
	 (return new-assumptions))
	(t (return ())))))

(defun use-old-context (old-assumptions var val)
   (setq var (ridofab var))
   (cond ((null old-assumptions) ())
	 ((not (infinityp val))
	  (do ((list old-assumptions (cdr list))
	       (pred) (part1) (part2) (assumptions))
	      ((null list) assumptions)
	    (setq pred (caar (car list))
		  part1 (cadr (car list))
		  part2 (caddr (car list)))
	    (if (memq pred '(mgreaterp mlessp))
		(push (make-assump pred part1 part2 var val) 
		      assumptions))))))

(defun make-assump (pred part1 part2 var val)
  (cond ((eq part1 var)
	 (cond ((and (free part2 '$inf)
		     (free part2 '$minf)
		     (free part2 '$infinity))
		`((,pred) ,part1 ,(m+t part2 (m*t -1 val))))
	       (t `((,pred) ,part1 ,part2))))
	((eq part2 var)
	 (cond ((and (free part1 '$inf)
		     (free part1 '$minf)
		     (free part1 '$infinity))
		`((,pred) ,(m+t part1 (m*t -1 val)) ,part2))
	       (t `((,pred) ,part1 ,part2))))))
		
(defun restore-assumptions ()
;;;Hackery until assume and forget take reliable args. Nov. 9 1979.
;;;JIM.
       (do ((assumption-list limit-assumptions (cdr assumption-list)))
	   ((null assumption-list) t)
	   (forget (car assumption-list)))
       (forget '((mgreaterp) epsilon 0))
       (forget '((mlessp) epsilon 1.0e-8))
       (forget '((mgreaterp) prin-inf 1.0e+8))
       (cond ((and (not (null integer-info))
		   (not limitp))
	      (do ((list integer-info (cdr list)))
		  ((null list) t)
		  (I-$remove `(,(cadar list) ,(caddar list))))
	      (setq integer-info old-integer-info)))
       (do ((assumption-list global-assumptions (cdr assumption-list)))
	   ((null assumption-list) t)
	   (assume (car assumption-list))))

(DEFUN BOTH-SIDE (EXP VAR VAL)
  (let ((preserve-direction t))
    (let ((la ($LIMIT EXP VAR VAL '$PLUS))
	  (lb ($LIMIT EXP VAR VAL '$MINUS)))
      (cond ((ALIKE1 (ridofab LA) (ridofab LB))  (ridofab la))
	    ((and (not (free la '%limit))
		  (not (free la '%limit)))  ())
	    (t '$und)))))

;; Warning:  (CATCH NIL ...) will catch all throws.
;; NIL should not be used as a tag name.

(DEFUN LIMUNKNOWN (F) (CATCH 'limunknown (LIMUNKNOWN1 (SPECREPCHECK F))))

(DEFUN LIMUNKNOWN1 (F)
       (COND ((mapatom f) nil)
	     ((OR (NOT (safe-GET (CAAR F) 'OPERATORS))
		  (MEMQ (CAAR F) '(%SUM %PRODUCT %SIGNUM MNCEXPT))
;Special function code here i.e. for li[2](x).
		  (and (eq (caar f) 'mqapply)
		       (not (get (subfunname f) 'specsimp))))
	      (IF (NOT (FREE F VAR)) (THROW 'limunknown T)))
	     (T (MAPC #'LIMUNKNOWN1 (CDR F)) NIL)))

(DEFUN FACTOSIMP(E)
       (IF (INVOLVE E '(%GAMMA)) (SETQ E ($MAKEFACT E))) 
       (COND ((INVOLVE E '(MFACTORIAL))
	      (SETQ E (SIMPLIFY ($MINFACTORIAL E))))
	     (T E)))

(DEFUN GETSIGNL (Z)
  (let ((z (ridofab z)))
    (if (not (free z var)) (setq z ($limit z var val)))
    (let ((sign ($asksign z)))
      (cond ((eq sign '$pos) 1)
	    ((eq sign '$neg) -1)
	    ((eq sign '$zero) 0)))))

(defun restorelim (exp)
       (cond ((null exp) nil)
	     ((atom exp) (or (and (symbolp exp) (get exp 'limitsub)) exp))
	     ((and (consp (car exp)) (eq (caar exp) 'mrat))
	      (cons (car exp)
		    (cons (restorelim (cadr exp))
			  (restorelim (cddr exp)))))
	     (t (cons (car exp) (mapcar #'restorelim (cdr exp))))))


(DEFUN MABS-SUBST (EXP VAR VAL)	; RETURNS EXP WITH MABS REMOVED, OR THROWS.
 (let ((d (involve exp '(mabs))))
   (cond ((null d) exp)
	 (t (cond
	     ((not (and (equal ($imagpart (limit d var val 'think)) 0)
			(equal ($imagpart var) 0))) (throw 'mabs 'retn))
	     (t (DO ((ANS D (INVOLVE EXP '(MABS))) (a () ()))
		    ((NULL ANS) EXP)
		  (SETQ A (MABS-SUBST ANS VAR VAL))
		  (SETQ D (LIMIT A VAR VAL T))
		  (cond 
		   ((or (null a) (null d))
		    (if (not (OR (eq val '$zeroa)
				 (eq val '$zerob)
				 (REAL-INFINITYP VAL)))  (THROW 'MABS 'BOTH)))
		   ((AND A D)
		    (COND ((ZEROP1 D)  (SETQ D (BEHAVIOR A VAR VAL))
				       (if (ZEROP1 D) (THROW 'MABS 'RETN))))
		    (if (OR (EQ D '$ZEROA) (EQ D '$INF) (RATGREATERP D 0))
			(SETQ EXP (MAXIMA-SUBSTITUTE A `((MABS) ,ANS) EXP)))
		    (if (OR (EQ D '$ZEROB) (EQ D '$MINF) (RATGREATERP 0 D))
			(SETQ EXP (MAXIMA-SUBSTITUTE (M* -1 A) `((MABS) ,ANS) EXP)))
		    (if (EQ D '$UND) (THROW 'MABS '$UND)))
		   (t (THROW 'MABS 'RETN))))))))))

(DEFUN INFCOUNT (EXP)
       (COND ((ATOM EXP)
	      (COND ((INFINITYP EXP) 1)
		    (T 0)))
	     (T (f+ (INFCOUNT (CAR EXP)) (INFCOUNT (CDR EXP))))))

(DEFUN SIMPINF (EXP)
 (declare (SPECIAL exp val))
  (LET ((INFC (INFCOUNT EXP)) NEXP)
    (COND
     ((= INFC 0)  EXP)
     ((= INFC 1)  (SETQ INFC (inf-typep exp))
		  ($LIMIT (SUBST VAR INFC EXP) VAR INFC))
     (t 
      (SETQ NEXP (CONS (CAR EXP) (MAPCAR 'SIMPINF (CDR EXP))))
      (SETQ INFC (INFCOUNT NEXP))
      (cond
       ((AMONG '$UND NEXP)  '$UND)
       ((AMONGL '(%LIMIT $IND) NEXP)  EXP)
       ((mtimesp nexp)
	(COND ((zl-MEMBER 0 NEXP)
	       (COND ((> INFC 0) '$UND)
		     (T 0)))
	      ((MEMQ '$INFINITY NEXP) '$INFINITY)
	      (T (SIMPLIMIT NEXP VAR VAL))))
       ((mexptp nexp)
	(COND ((AND (EQ (CADR NEXP) '$INF) (EQ (CADDR NEXP) '$INF)) '$INF)
	      (T (SIMPINF (m^ '$%E (m* (CADDR EXP) `((%LOG) ,(CADR EXP))))))))
       ((< INFC 2)  (SIMPINF NEXP))
       ((mplusp nexp)
	(COND ((MEMQ '$INFINITY (CDR NEXP)) '$INFINITY)
	      (T (SETQ INFC (inf-typep nexp))
		 (COND 
		  ((AMONGL (zl-DELETE INFC 
				   (copy-top-level '($infinity $minf inf)))
			   NEXP)
		   '$UND)
		  (T INFC)))))
       (T NEXP))))))

(defun simpab (small)
   (cond ((null small) ())
	 ((memq small '($zeroa $zerob $inf $minf $infinity)) small)
	 ((not (free small '$ind)) '$ind) ;Not exactly right but not
	 ((not (free small '$und)) '$und) ;causing trouble now.
	 ((mapatom small)  small)
	 ((and (not (free-infp small))
	       (or (not (free small '$zeroa))
		   (not (free small '$zerob))))
	  (throw 'limit t)) ;Terrible loss, can do better
	 (t (let ((preserve-direction t)
		  (new-small (subst 'epsilon '$zeroa 
				    (subst (m- 'epsilon) '$zerob small))))
	      (limit new-small 'epsilon '$zeroa 'think)))))


;;;*I* INDICATES: T => USE LIMIT1,THINK, NIL => USE SIMPLIMIT.
(DEFMFUN LIMIT (EXP VAR VAL *I*) 
  (COND
   ((AMONG '$UND EXP)  '$UND)
   ((EQ VAR EXP)  VAL)
   ((ATOM EXP)  EXP)
   ((NOT (AMONG VAR EXP))
    (COND ((AMONGL '($INF $MINF $INFINITY $IND) EXP)
	   (SIMPINF EXP))
	  (T EXP)))
   ((GETLIMVAL EXP))
   (T (PUTLIMVAL EXP (COND ((AND $TLIMSWITCH
				 (NULL TAYLORED)
				 (TLIMP EXP))
			    (TAYLIM EXP *I*))
			   ((RATP EXP VAR) (RATLIM EXP))
			   ((OR (EQ *I* T) (RADICALP EXP VAR))
			    (LIMIT1 EXP VAR VAL))
			   ((EQ *I* 'THINK)		
			    (COND ((or (mtimesp exp) (mexptp exp))
				   (LIMIT1 EXP VAR VAL))
				  (T (SIMPLIMIT EXP VAR VAL))))
			   (T (SIMPLIMIT EXP VAR VAL)))))))
      
(defun limitsimp (exp var)
   (limitsimp-dispatch (sin-sq-cos-sq-sub exp) var))
;Hack for sin(x)^2+cos(x)^2.

(defun limitsimp-dispatch (exp var)
  (cond ((or (atom exp)
	     (mnump exp)
	     (freeof var exp))   exp)
	((mexptp exp)
	 (limitsimp-expt exp var))
	(t (subst0 (cons (cons (caar exp) ())
			 (mapcar #'(lambda (x)
				     (limitsimp-dispatch x var))
				 (cdr exp)))
		    exp))))


(defun limitsimp-expt (exp var)
  (cond ((and (mexptp exp)
	      (not (freeof var (cadr exp)))
	      (not (freeof var (caddr exp))))
	 (m^ '$%e (simplify `((%log) ,exp))))
	(t exp)))

(defun sin-sq-cos-sq-sub (exp) ;Hack ... Hack
  (let ((arg (involve exp '(%sin %cos))))
    (cond
     ((null arg) exp)
     (t (let ((new-exp ($substitute (m+t 1 (m- (m^t `((%sin) ,arg) 2)))
				    (m^t `((%cos) ,arg) 2)
				    ($substitute 
				     (m+t 1 (m- (m^t `((%cos) ,arg) 2)))
					  (m^t `((%sin) ,arg) 2)
					  exp))))
	     (cond ((not (involve new-exp '(%sin %cos)))  new-exp)
		   (t exp)))))))

(defun expand-trigs (x var)
       (cond ((atom x) x)
	     ((mnump x) x)
	     ((and (or (eq (caar x) '%sin)
		       (eq (caar x) '%cos))
		   (not (free (cadr x) var)))
	      ($trigexpand x))
	     (t (simplify (cons (ncons (caar x))
				(mapcar #'(lambda (x)
						 (expand-trigs x var))
					(cdr x)))))))


(DEFUN TANSC (E) 
       (COND ((NOT (INVOLVE E
			    '(%COT %CSC %BINOMIAL
				   %SEC %COTH %SECH %CSCH
				   %ACOT %ACSC %ASEC %ACOTH
				   %ASECH %ACSCH)))
	      E)
	     (T ($RATSIMP (TANSC1 E))))) 

(DEFUN TANSC1 (E &aux tem)
  (COND ((ATOM E) E)
	((AND (SETQ E (CONS (CAR E) (MAPCAR 'TANSC1 (CDR E))))  ()))
	((SETQ TEM (ASSQ (CAAR E) '((%COT . %TAN) (%COTH . %TANH)
				    (%SEC . %COS) (%SECH . %COSH)
				    (%CSC . %SIN) (%CSCH . %SINH))))
	 (TANSC1 (m^ (LIST (NCONS (CDR TEM)) (CADR E)) -1.)))
	((SETQ TEM (MEMQ (CAAR E) '(%SINH %COSH %TANH)))
	 (let (($EXPONENTIALIZE t)) 
	   (RESIMPLIFY E)))
	((SETQ TEM (ASSQ (CAAR E) '((%ACSC . %ASIN) (%ASEC . %ACOS)
				    (%ACOT . %ATAN) (%ACSCH . %ASINH)
				    (%ASECH . %ACOSH) (%ACOTH . %ATANH))))
	 (LIST (NCONS (CDR TEM)) (m^t (CADR E) -1.)))
	((AND (EQ (CAAR E) '%BINOMIAL) (AMONG VAR (CDR E)))
	 (m//  `((MFACTORIAL) ,(CADR E))
	       (m* `((MFACTORIAL) ,(m+t (CADR E) (m- (CADDR E))))
		   `((MFACTORIAL) ,(CADDR E)))))
	(t E)))

(DEFUN HYPEREX (EX) 
       (COND ((NOT (INVOLVE EX
			    '(%SIN %COS %TAN %ASIN %ACOS %ATAN
			      %SINH %COSH %TANH %ASINH %ACOSH %ATANH)))
	      EX)
	     (T (HYPEREX0 EX)))) 

(DEFUN HYPEREX0 (EX) 
       (COND ((ATOM EX) EX)
	     ((eq (caar ex) '%sinh)
	      (m// (m+ (m^ '$%e (cadr ex)) (m- (m^ '$%e (m- (cadr ex)))))
		   2))
	     ((eq (caar ex) '%cosh)
	      (m// (m+ (m^ '$%e (cadr ex)) (m^ '$%e (m- (cadr ex))))
		   2))
	     ((AND (MEMQ (CAAR EX)
			 '(%SIN %COS %TAN %ASIN %ACOS %ATAN %SINH
			   %COSH %TANH %ASINH %ACOSH %ATANH))
		   (AMONG VAR EX))
	      (HYPEREX1 EX))
	     (T (CONS (CAR EX) (MAPCAR #'HYPEREX0 (CDR EX)))))) 

(DEFUN HYPEREX1 (EX) 
  (LET ( ;; Can't exponentialize now because complex plane isn't handled right yet
	  ;; ($EXPONENTIALIZE T)
	 ($LOGARC T))
	(SSIMPLIFYA EX)))

;Used by tlimit also.
(DEFMFUN LIMIT1 (EXP VAR VAL) 
       (prog ()
       (let ((lhprogress? lhp?)  (lhp? ())  (ans ()))
	    (COND ((SETQ ans (AND (NOT (ATOM EXP))
				  (GETLIMVAL EXP))) 
		   (RETURN ans))
		  ((and (not (INFINITYP VAL))
			(SETQ ans (SIMPLIMSUBST VAL EXP)))
		   (RETURN ans))
		  (t nil))

;;;NUMDEN* => (numerator . denominator)	     
	    (LET (((n . dn) (NUMDEN* EXP)))    
		 (COND
		  ((NOT (AMONG VAR DN))
		   (RETURN (SIMPLIMIT (M// (SIMPLIMIT N VAR VAL) DN) 
				      VAR
				      VAL)))
		  ((NOT (AMONG VAR N))
		   (RETURN (SIMPLIMIT (M* N
					  (SIMPLIMEXPT DN
						       -1.
						       (SIMPLIMIT DN
								  VAR
								  VAL)
						       -1.))
				      VAR
				      VAL)))
		  ((AND (RADICALP N VAR) (RADICALP DN VAR))
		   (RETURN (RADLIM (m* N (m^ DN -1.))
				   N
				   DN)))
		  ((AND LHPROGRESS?
			(/#ALIKE N (CAR LHPROGRESS?))
			(/#ALIKE DN (CDR LHPROGRESS?)))
		   (THROW 'LHOSPITAL NIL)))
		 (RETURN (LIMIT2 N DN VAR VAL))))))

(DEFUN /#ALIKE (E F)
       (cond ((ALIKE1 E F)
	      t)
	     (t (let ((deriv (sdiff (m// e f) var)))
		     (cond ((=0 deriv)
			    t)
			   ((=0 ($ratsimp deriv))
			    t)
			   (t nil))))))

;(DECLARE (SPECIAL N DN)) 

(DEFUN LIMIT2 (N DN VAR VAL)
  (PROG (N1 D1 lim-SIGN GCP SHEUR-ANS)
    (setq n (hyperex n) dn (hyperex dn))
;;;Change to uniform limit call.
    (COND ((INFINITYP VAL)  (SETQ D1 (LIMIT DN VAR VAL NIL))
			    (SETQ N1 (LIMIT N VAR VAL NIL)))
	  (T (COND ((SETQ N1 (SIMPLIMSUBST VAL N)) NIL)
		   (T (SETQ N1 (LIMIT N VAR VAL NIL))))
	     (COND ((SETQ D1 (SIMPLIMSUBST VAL DN)) NIL)
		   (T (SETQ D1 (LIMIT DN VAR VAL NIL))))))
    (COND ((OR (NULL N1) (NULL D1)) (RETURN NIL))
	  (T (SETQ N1 (SRATSIMP N1) D1 (SRATSIMP D1))))
    (COND ((OR (INVOLVE N '(MFACTORIAL)) (INVOLVE DN '(MFACTORIAL)))
	   (let ((ANS (limfact2 n dn var val)))
	     (COND (ANS (RETURN ANS))))))
    (COND ((AND (ZEROP2 N1) (ZEROP2 D1))
	   (COND  ((NOT (EQUAL (SETQ GCP (GCPOWER N DN)) 1))
		   (RETURN (COLEXPT N DN GCP)))
		  ((and (real-epsilonp val)
			(not (free n '%log))
			(not (free dn '%log)))
		   (return (liminv (m// n dn))))
		  ((SETQ N1 (TRY-LHOSPITAL-QUIT N DN NIL))
		   (RETURN N1))))
	  ((AND (ZEROP2 N1) (NOT (MEMQ D1 '($IND $UND)))) (RETURN 0))
	  ((ZEROP2 D1) 
	   (SETQ N1 (RIDOFAB N1))
	   (return (SIMPLIMTIMES `(,N1 ,(SIMPLIMEXPT DN -1 D1 -1))))))
    (SETQ N1 (RIDOFAB N1))
    (SETQ D1 (RIDOFAB D1))
    (COND ((OR (EQ D1 '$UND)
	       (AND (EQ N1 '$UND) (NOT (REAL-INFINITYP D1))))
	   (RETURN '$UND))
	  ((EQ D1 '$IND) (RETURN '$UND))
	  ((EQ N1 '$IND) (RETURN (COND ((INFINITYP D1) 0)
				       ((EQUAL D1 0) '$UND)
				       (T '$IND)))) ;SET LB
	  ((AND (REAL-INFINITYP D1) (MEMQ N1 '($INF $UND $MINF)))
	   (COND ((EXPFACTORP N DN)  (RETURN (EXPFACTOR N DN VAR)))
		 ((AND (NOT (ATOM DN)) (NOT (ATOM N))
		       (COND ((NOT (EQUAL (SETQ GCP (GCPOWER N DN)) 1))
			      (RETURN (COLEXPT N DN GCP)))
			     ((AND (EQ '$INF VAL)
				   (OR (INVOLVE DN '(MFACTORIAL %GAMMA))
				       (INVOLVE N '(MFACTORIAL %GAMMA))))
			      (RETURN (LIMFACT N DN))))))
		 ((EQ N1 D1) (SETQ LIM-SIGN 1) (GO CP))
		 (T (SETQ LIM-SIGN -1) (GO CP))))
	  ((AND (INFINITYP D1) (INFINITYP N1))
	   (SETQ LIM-SIGN (IF (OR (EQ D1 '$MINF) (EQ N1 '$MINF)) -1 1))
	   (GO CP))
	  (T (RETURN (SIMPLIMTIMES `(,N1 ,(m^ d1 -1))))))
CP   (SETQ N ($EXPAND N) DN ($EXPAND DN))
     (COND ((mplusp n)
	    (let ((MAXI-TERMS (maxi (cdr n))) (NEW-N ()))
	      (SETQ NEW-N (COND ((NOT (NULL (CDR MAXI-TERMS)))
				 (m+l MAXI-TERMS))
				(T (CAR MAXI-TERMS))))
	      (COND ((NOT (ALIKE1 NEW-N N))
		     (RETURN (LIMIT (M// NEW-N DN) VAR '$INF 'THINK))))
	      (SETQ N1 (CAR MAXI-TERMS))))
	   (T (SETQ N1 N)))
     (COND ((mplusp dn)
	    (let ((MAXI-TERMS (maxi (cdr dn)))
		  (NEW-DN ()))
	      (SETQ NEW-DN (COND ((NOT (NULL (CDR MAXI-TERMS)))
				  (m+l MAXI-TERMS))
				 (T (CAR MAXI-TERMS))))
	      (COND ((NOT (ALIKE1 NEW-DN DN))
		     (RETURN (LIMIT (M// N NEW-DN) VAR '$INF 'THINK))))
	      (SETQ D1 (CAR MAXI-TERMS))))
	   (T (SETQ D1 DN)))
     (SETQ SHEUR-ANS (SHEUR0 N1 D1))
     (COND ((or (MEMQ SHEUR-ANS '($INF $ZEROA))
		(free sheur-ans var))
	    (RETURN (SIMPLIMTIMES `(,lim-SIGN ,SHEUR-ANS))))
	   ((AND (ALIKE1 SHEUR-ANS DN)
		 (NOT (mplusp n))))
	   ((MEMQ (SETQ N1 (cond ((expfactorp n1 d1)  (EXPFACTOR N1 D1 VAR))
				 (t ())))
		  '($INF $ZEROA))
	    (RETURN N1))
	   ((NOT (NULL (SETQ N1 (cond ((expfactorp n dn)  (EXPFACTOR N DN VAR))
				      (t ())))))
	    (RETURN N1))
	   ((AND (ALIKE1 SHEUR-ANS DN) (NOT (MPLUSP N))))
	   ((not (alike1 sheur-ans (m// n dn)))
	    (RETURN (SIMPLIMIT (M// ($EXPAND (M// N SHEUR-ANS))
				    ($EXPAND (M// DN SHEUR-ANS)))
			       VAR
			       VAL))))
     (cond ((and (NOT (AND (EQ VAL '$INF) (EXPP N) (EXPP DN)))
		 (SETQ N1 (TRY-LHOSPITAL-quit N DN NIL))
		 (NOT (EQ N1 '$UND)))
	    (RETURN N1)))
     (THROW 'LIMIT T)))

(DEFUN EXPFACTORP (N DN)
       (DO ((LLIST (APPEND (COND ((MTIMESP N) (CDR N))
				(T (NCONS N)))
			  (COND ((MTIMESP DN) (CDR DN))
				(T (NCONS DN))))
		  (CDR LLIST))
	    (RATEXP? T)     ;IS EVERY ELEMENT SO FAR A POLY^RAT?
	    (ONE-RAT? NIL)  ;IS THERE AT LEAST ONE POLY^RAT WHICH IS NOT
	    (FACTOR NIL))   ;A POLY^POLY?
	   ((OR (NULL LLIST)
		(NOT RATEXP?))
	    (AND RATEXP? ONE-RAT?))
	   (SETQ FACTOR (CAR LLIST))
	   (SETQ RATEXP? (OR (POLYP FACTOR)
			     (AND (MEXPTP FACTOR)
				  (POLYP (CADR FACTOR))
				  (RATP (CADDR FACTOR) VAR))))
	   (SETQ ONE-RAT? (OR ONE-RAT?
			      (AND (MEXPTP FACTOR)
				   (RATP (CADDR FACTOR) VAR)
				   (NOT (POLYP (CADDR FACTOR))))))))

(DEFUN EXPFACTOR (N DN VAR)  ;ATTEMPS TO EVALUATE LIMIT BY GROUPING
       (PROG (HIGHEST-DEG)   ; TERMS WITH SIMILAR EXPONENTS.
	     (LET ((NEW-EXP (EXPPOLY N)))		;EXPPOLY UNRATS EXPON
		   (SETQ N (CAR NEW-EXP)		;AND RTNS DEG OF EXPONS
			 HIGHEST-DEG (CDR NEW-EXP)))
	     (COND ((NULL N) (RETURN NIL)))		;NIL MEANS EXPON IS NOT
	     (LET ((NEW-EXP (EXPPOLY DN)))		;A RAT FUNC.
		   (SETQ DN (CAR NEW-EXP)
			 HIGHEST-DEG (MAX HIGHEST-DEG (CDR NEW-EXP))))
	     (COND ((NULL DN) (RETURN NIL)))
	     (RETURN
	      (DO ((ANSWER 1.)
		   (DEGREE HIGHEST-DEG (f1- DEGREE))
		   (NUMERATOR N)
		   (DENOMENATOR DN)
		   (NUMFACTORS NIL)
		   (DENFACTORS NIL))
		  ((= DEGREE -1.)
		   (M* ANSWER
		       (LIMIT (M// NUMERATOR DENOMENATOR)
			      VAR
			      '$INF
			      'THINK)))
		  (LET ((NEWNUMER-FACTOR (GET-NEWEXP&FACTORS
					   NUMERATOR
					   DEGREE
					   VAR)))
			(SETQ NUMERATOR (CAR NEWNUMER-FACTOR)
			      NUMFACTORS (CDR NEWNUMER-FACTOR)))
		  (LET ((NEWDENOM-FACTOR (GET-NEWEXP&FACTORS
					   DENOMENATOR
					   DEGREE
					   VAR)))
			(SETQ DENOMENATOR (CAR NEWDENOM-FACTOR)
			      DENFACTORS (CDR NEWDENOM-FACTOR)))
		  (SETQ ANSWER (LIMIT (M^ (M* ANSWER
					      (M// NUMFACTORS DENFACTORS))
					  (COND ((> DEGREE 0) VAR)
						(T 1)))
				      VAR
				      '$INF 'think))
		  (COND ((EQ ANSWER '$UND) (RETURN NIL))
			((zl-MEMBER ANSWER '($INF $MINF 0)) ;Really? ZEROA ZEROB?
			 (RETURN ANSWER))
			(T NIL))))))

(DEFUN EXPPOLY (EXP)          ;RETURNS EXPRESSION WITH UNRATTED EXPONENTS
       (DO ((FACTOR NIL)
	    (HIGHEST-DEG 0)
	    (NEW-EXP 1)
	    (EXP (COND ((MTIMESP EXP)
			(CDR EXP))
		       (T (NCONS EXP)))
		 (CDR EXP)))
	   ((NULL EXP) (CONS NEW-EXP HIGHEST-DEG))
	   (SETQ FACTOR (CAR EXP))
	   (SETQ NEW-EXP
		 (M* (COND ((or (NOT (MEXPTP FACTOR))
				(NOT (RATP (CADDR FACTOR) VAR)))
			    FACTOR)
			   (T (SETQ HIGHEST-DEG
				    (MAX HIGHEST-DEG
					 (RATDEGREE (CADDR FACTOR))))
			      (m^ (cadr factor) (unrat (caddr factor)))))
		     NEW-EXP))))

(DEFUN UNRAT (EXP)  ;RETURNS UNRATTED EXPRESION
       (LET ((N-DN (NUMDEN* EXP)))
	     (LET ((TEM ($DIVIDE (CAR N-DN) (CDR N-DN))))
		   (M+ (CADR TEM)
		       (M// (CADDR TEM)
			    (CDR N-DN))))))

(DEFUN GET-NEWEXP&FACTORS (EXP DEGREE VAR)       ;RETURNS (CONS NEWEXP FACTORS)
       (DO ((TERMS (COND ((MTIMESP EXP)(CDR EXP)); SUCH THAT
			 (T (NCONS EXP)))        ; NEWEXP*FACTORS^(VAR^DEGREE)
		   (CDR TERMS))                  ; IS EQUAL TO EXP.        
	    (FACTORS 1)                 
	    (NEWEXP 1)                          
	    (FACTOR NIL))                
	   ((NULL TERMS)
	    (CONS NEWEXP
		  FACTORS))
	   (SETQ FACTOR (CAR TERMS))
	   (COND ((NOT (MEXPTP FACTOR))
		  (COND ((= DEGREE 0)
			 (SETQ FACTORS (M* FACTOR FACTORS)))
			(T (SETQ NEWEXP (M* FACTOR NEWEXP)))))
		 ((OR (= DEGREE -1)
		      (= (RATDEGREE (CADDR FACTOR))
			 DEGREE))
		  (SETQ FACTORS (M* (M^ (CADR FACTOR)
					(LEADING-COEF (CADDR FACTOR)))
				    FACTORS)
			NEWEXP (M* (M^ (CADR FACTOR)
				       (M- (CADDR FACTOR)
					   (M* (LEADING-COEF (CADDR FACTOR))
					       (M^ VAR DEGREE))))
				   NEWEXP)))
		 (T (SETQ NEWEXP (M* FACTOR NEWEXP))))))

(DEFUN LEADING-COEF (RAT)
       (RATLIM (M// RAT (M^ VAR (RATDEGREE RAT)))))

(DEFUN RATDEGREE (RAT)
       (LET ((N-DN (NUMDEN* RAT)))
	     (f- (DEG (CAR N-DN))
		(DEG (CDR N-DN)))))

(DEFUN LIMFACT2 (N D VAR VAL)
       (LET ((N1 (REFLECT0 N VAR VAL))
	      (D1 (REFLECT0 D VAR VAL)))
	     (COND ((AND (ALIKE1 N N1)
			 (ALIKE1 D D1))
		    NIL)
		   (T (LIMIT (m// N1 D1) VAR VAL 'THINK)))))

(DEFUN REFLECT0 (EXP VAR VAL)
       (COND ((ATOM EXP) EXP)
	     ((AND (EQ (CAAR EXP) 'MFACTORIAL)
		   (LET ((ARGVAL (LIMIT (CADR EXP) VAR VAL 'THINK)))
			 (OR (EQ ARGVAL '$MINF)
			     (AND (NUMBERP ARGVAL)
				  (> 0 ARGVAL)))))
	      (REFLECT (CADR EXP)))
	     (T (CONS (NCONS (CAAR EXP))
		      (MAPCAR (FUNCTION
			       (LAMBDA (TERM)
				       (REFLECT0 TERM VAR VAL)))
			      (CDR EXP))))))

(DEFUN REFLECT (ARG)
       (M* -1.
	   '$%PI
	   (M^ (LIST (NCONS 'MFACTORIAL)
		     (M+ -1.
			 (M* -1. ARG)))
	       -1.)
	   (M^ (LIST (NCONS '%SIN)
		     (M* '$%PI ARG))
	       -1.)))

(DEFUN LIMFACT (N D)
  (let ((ANS ()))
    (SETQ N (STIRLING0 N)
	  D (STIRLING0 D))
    (SETQ ANS ($LIMIT (m// N D) VAR '$INF))
    (COND ((and (atom ans)
	   (not (MEMQ ANS '(UND IND ))))  ans)
	  ((eq (caar ans) '%limit)  ())
	  (t ans))))

(DEFUN STIRLING0 (E) 
  (COND ((ATOM E) E)
	((AND (SETQ E (CONS (CAR E) (MAPCAR 'STIRLING0 (CDR E))))
	      NIL))
	((AND (EQ (CAAR E) '%GAMMA)
	      (AMONG VAR (CADR E)))
	 (STIRLING (CADR E)))
	((AND (EQ (CAAR E) 'MFACTORIAL)
	      (AMONG VAR (CADR E)))
	 (m* (CADR E) (STIRLING (CADR E))))
	(T E)))

(DEFUN STIRLING (X)
       (MAXIMA-SUBSTITUTE X '$Z 
		    '((MTIMES SIMP)
		      ((MEXPT SIMP) 2 ((RAT SIMP) 1 2))
		      ((MEXPT SIMP) $%PI ((RAT SIMP) 1 2))
		      ((MEXPT SIMP) $Z ((MPLUS SIMP) ((RAT SIMP) -1 2) $Z))
		      ((MEXPT SIMP) $%E ((MTIMES SIMP) -1 $Z)))))

(DEFUN NO-ERR-SUB (V E &AUX ANS) 
  (LET ((ERRORSW T) (ERRRJFFLAG T) (*ZEXPTSIMP? T))
    ;; (CATCH '(ERRORSW RATERR) (SRATSIMP (SUBIN V E)))
    ;; broken on the Lispm
    (SETQ ANS (CATCH 'ERRORSW
		      (CATCH 'RATERR 
			      (SRATSIMP (SUBIN V E)))))
    (COND ((NULL ANS) T)  ; Ratfun package returns NIL for failure.
	  (T ANS)))) ; Simplifier returns T for failure.

(DEFUN SIMPLIMSUBST (V E) 
       (PROG (ANS)  
	     (SETQ ANS (NO-ERR-SUB (RIDOFAB V) E))
	     (COND ((EQ ANS T)
		    (RETURN NIL))
		   ((INVOLVE E '(MFACTORIAL)) NIL)
		   ((AND (MEMQ V '($ZEROA $ZEROB)) (=0 ANS))
		    (SETQ ANS (BEHAVIOR E VAR V))
		    (RETURN (COND ((EQUAL ANS 1) '$ZEROA)
				  ((EQUAL ANS -1) '$ZEROB)
				  (T ANS))))
		   (T (RETURN ANS))))) 

;;;returns (cons numerator denomenator)
(defun numden* (e)    
       (let ((e (factor (simplify e)))
	     (numer ())  (denom ()))
	    (cond ((atom e) 
		   (setq numer (cons e numer)))
		  ((mtimesp e)
		   (mapc 'forq (cdr e)))
		  (t (forq e)))
	    (cond ((null numer) 
		   (setq numer 1.))
		  ((null (cdr numer))
		   (setq numer (car numer)))
		  (t (setq numer (m*l numer))))
	    (cond ((null denom) 
		   (setq denom 1.))
		  ((null (cdr denom))
		   (setq denom (car denom)))
		  (t (setq denom (m*l denom))))
	    (cons (factor numer) (factor denom))))

;;;FACTOR OR QUOTIENT
;;;Setq's the special vars numer and denom from numden*
(DEFUN FORQ (E)
       (COND ((AND (MEXPTP E)
		   (null (pos-neg-p (caddr e))))
	      (SETQ DENOM (cons (m^ (CADR E) (m* -1. (CADDR E))) DENOM)))
	     (T (SETQ numer (cons E NUMER)))))

;;;Predicate to tell whether an expression is pos,zero or neg as var -> val.
;;;returns T if pos,zero. () if negative or don't know.
(defun pos-neg-p (exp)
       (let ((ans (limit exp var val 'think)))
	    (cond ((and (not (memq ans '($und $ind $infinity)))
			(equal ($imagpart ans) 0))
		   (let ((sign (getsignl ans)))
			(cond ((or (equal sign 1)
				   (equal sign 0))
			       t)
			      ((equal sign -1)  nil))))
		  (t 'UNKNOWN))))

(DECLARE-TOP(UNSPECIAL N DN)) 

(SETQ LIMFUNC '(%LOG %SIN %COS %TAN %SINH %COSH %TANH MFACTORIAL
		%ASIN %ACOS %ATAN %ASINH %ACOSH %ATANH)) 

(DEFUN EXPP (E) 
       (COND ((RADICALP E VAR) NIL)
	     ((MEMQ (CAAR E) LIMFUNC) NIL)
	     ((SIMPLEXP E) T)
	     ((DO ((E (CDR E) (CDR E)))
		  ((NULL E) NIL)
		  (AND (EXPP (CAR E)) (RETURN T)))))) 

(DEFUN SIMPLEXP (E) 
       (AND (mexptp e)
	    (RADICALP (CADR E) VAR)
	    (AMONG VAR (CADDR E))
	    (RADICALP (CADDR E) VAR))) 


(DEFUN GCPOWER (A B)
       ($GCD (GETEXP A) (GETEXP B)))
	
(DEFUN GETEXP (EXP)
       (COND ((and (MEXPTP EXP)
		   (free (caddr exp) var)
		   (eq (ask-integer (caddr exp) '$integer) '$yes))
	      (CADDR EXP))
	     ((MTIMESP EXP) (GETEXPLIST (CDR EXP)))
	     (T 1.)))

(DEFUN GETEXPLIST (LIST)
       (COND ((NULL (CDR LIST))
	      (GETEXP (CAR LIST)))
	     (T ($GCD (GETEXP (CAR LIST))
		      (GETEXPLIST (CDR LIST))))))

(DEFUN LIMROOT (EXP POWER)
       (COND ((OR (ATOM EXP) (NOT (MEMQ (CAAR EXP) '(MTIMES MEXPT))))
	      (LIMROOT (LIST '(MEXPT) EXP 1) POWER)) ;This is strange-JIM.
	     ((mexptp exp)  (m^ (CADR EXP)
				(sRATSIMP (m* (CADDR EXP) (m^ POWER -1.)))))
	     (T (m*l (MAPCAR #'(LAMBDA (X)
				 (LIMROOT X POWER))
			     (CDR EXP))))))

;NUMERATOR AND DENOMENATOR HAVE EXPONENTS WITH GCD OF GCP.
;;; Used to call simplimit but some of the transformations used here
;;; were not stable w.r.t. the simplifier, so try keeping exponent separate
;;; from bas.

(DEFUN COLEXPT (N DN GCP)
  (let ((bas (m* (LIMROOT N GCP) (LIMROOT DN (m*  -1. GCP))))
	(expo gcp) 
	baslim expolim)
       (setq baslim (limit bas var val 'think))
       (setq expolim (limit expo var val 'think))
       (SIMPLIMexpt bas expo baslim expolim))) 

;;; This function will transform an expression such that either all logarithms
;;; contain arguments not becoming infinite or are of the form 
;;; LOG(LOG( ... LOG(VAR))) This reduction takes place only over the operators
;;; MPLUS, MTIMES, MEXPT, and %LOG.

(DEFUN LOG-RED-CONTRACT (FACS)
 (DO ((L FACS (CDR L))
      (CONSTS ())
      (LOG ()))
     ((NULL L)
      (IF LOG (CONS (CADR LOG) (M*L CONSTS))
	  ()))
     (COND ((FREEOF VAR (CAR L)) (PUSH (CAR L) CONSTS))
	   ((MLOGP (CAR L)) 
	    (IF (NULL LOG) (SETQ LOG (CAR L))
		(RETURN ())))
	   (T (RETURN ())))))

(DEFUN LOG-REDUCE (X)
 (COND ((ATOM X) X)
       ((FREEOF VAR X) X)
       ((MPLUSP X)
	(DO ((L (CDR X) (CDR L))
	     (SUM ())
	     (WEAK-LOGS ())
	     (STRONG-LOGS ())
	     (TEMP))
	    ((NULL L) (M+L `(((%LOG) ,(M*L STRONG-LOGS))
			     ((%LOG) ,(M*L WEAK-LOGS)) 
			     ,@SUM)))
	    (SETQ X (LOG-REDUCE (CAR L)))
	    (COND ((MLOGP X)
		   (IF (INFINITYP (LIMIT (CADR X) VAR VAL 'THINK))
		       (PUSH (CADR X) STRONG-LOGS)
		       (PUSH (CADR X) WEAK-LOGS)))
		  ((AND (MTIMESP X) (SETQ TEMP (LOG-RED-CONTRACT (CDR X))))
		   (IF (INFINITYP (LIMIT (CAR TEMP) VAR VAL 'THINK))
		       (PUSH (M^ (CAR TEMP) (CDR TEMP)) STRONG-LOGS)
		       (PUSH (M^ (CAR TEMP) (CDR TEMP)) WEAK-LOGS)))
		  (T (PUSH X SUM)))))
       ((MTIMESP X)
	(DO ((L (CDR X) (CDR L))
	     (ANS 1))
	    ((NULL L) ANS)
	    (SETQ ANS ($EXPAND (M* (LOG-REDUCE (CAR L)) ANS)))))
       ((MEXPTP X) (M^T (LOG-REDUCE (CADR X)) (CADDR X)))
       ((MLOGP X)
	(IFN (INFINITYP (LIMIT (CADR X) VAR VAL 'THINK))
	     X
	     (COND ((EQ (CADR X) VAR) X)
		   ((MPLUSP (CADR X))
		    (LET ((STRONGL (MAXI (CDADR X))))
			 (M+ (LOG-REDUCE `((%LOG) ,(CAR STRONGL)))
			     `((%LOG) ,(M// (CADR X) (CAR STRONGL))))))
		   ((MTIMESP (CADR X))
		    (DO ((L (CDADR X) (CDR L))
			 (ANS 0))
			((NULL L) ANS)
			(SETQ ANS
			      (M+ (LOG-REDUCE
				   (SIMPLIFY `((%LOG) ,(LOG-REDUCE (CAR L)))))
				  ANS))))
		   (T (LET ((RED-LOG (SIMPLIFY `((%LOG)
						 ,(LOG-REDUCE (CADR X))))))
			   (IF (ALIKE1 RED-LOG X)
			       X
			       (LOG-REDUCE RED-LOG)))))))
       (T X)))


(defun ratlim (e) 
       (cond ((memq val '($inf $infinity))
	      (setq e (MAXIMA-SUBSTITUTE (m^t 'x -1) var e)))
	     ((eq val '$minf)
	      (setq e (MAXIMA-SUBSTITUTE (m^t -1 (m^t 'x -1)) var e)))
	     ((eq val '$zerob)
	      (setq e (MAXIMA-SUBSTITUTE (m- 'x) var e)))
	     ((eq val '$zeroa)
	      (setq e (MAXIMA-SUBSTITUTE 'x var e)))
	     ((setq e (MAXIMA-SUBSTITUTE (m+t 'x val) var e))))
       (let* ((e (let (($ratfac ()))
		      ($rat (sratsimp e) 'x)))
	      ((h n . d) e)
	      (g (genfind h 'x))
	      (nd (lodeg n g))
	      (dd (lodeg d g)))
	     (cond ((and 
		     (setq e
			   (subst var 
				  'x 
				  (sratsimp
				   (m//
				    ($ratdisrep `(,h ,(locoef n g) . 1))
				    ($ratdisrep `(,h ,(locoef d g) . 1))))))
			 (greaterp nd dd))
		    (cond ((not (memq val
				      '($zerob $zeroa $inf $minf)))
			   0)
			  ((not (equal ($imagpart e) 0)) 
			   0)
			  ((null (setq e (getsignl ($realpart e))))
			   0)
			  ((equal e 1) '$zeroa)
			  ((equal e -1) '$zerob)
			  (t 0)))
		   ((equal nd dd) e)
		   ((not (memq val '($zerob $zeroa $infinity $inf $minf)))
		    (throw 'limit t))
		   ((eq val '$infinity)  '$infinity)
		   ((not (equal ($imagpart e) 0)) '$infinity)
		   ((null (setq e (getsignl ($realpart e)))) '$infinity)
		   ((equal e 1) '$inf)
		   ((equal e -1) '$minf)
		   (t 0))))

(DEFUN LODEG (N X) (IF (OR (ATOM N) (NOT (EQ (CAR N) X))) 0 (LOWDEG (CDR N)))) 

(DEFUN LOCOEF (N X) (IF (OR (ATOM N) (NOT (EQ (CAR N) X))) N (CAR (LAST N)))) 


(defun behavior (exp var val)  ; returns either -1, 0, 1.
  (if (= behavior-count-now behavior-count)
      0
      (let ((behavior-count-now (f1+ behavior-count-now)) pair sign)
	(cond ((real-infinityp val)
	       (setq val (cond ((eq val '$inf) '$zeroa)
			       ((eq val '$minf) '$zerob)))
	       (setq exp (sratsimp (subin (m^ var -1) exp)))))
	(cond ((eq val '$infinity) 0)  ; Needs more hacking for complex.
	      ((and (mtimesp exp)
		    (prog2 (setq pair (partition exp var 1))
			   (not (mtimesp (cdr pair)))))
	       (setq sign (getsignl (car pair)))
	       (if (not (fixnump sign))
		   0
		   (f* sign (behavior (cdr pair) var val))))
	      ((and (=0 (no-err-sub (ridofab val) exp))
		    (mexptp exp)
		    (free (caddr exp) var)
		    (equal (getsignl (caddr exp)) 1))
	       (let ((bas (cadr exp)) (expo (caddr exp)))
		 (behavior-expt bas expo)))
	      (t (behavior-by-diff exp var val))))))
		  
(defun behavior-expt (bas expo)
  (let ((behavior (behavior bas var val)))
    (COND ((= behavior 1) 1)
	  ((= behavior 0) 0)
	  ((eq (ask-integer expo '$integer) '$yes)
	   (cond ((eq (ask-integer expo '$even) '$yes) 1)
		 (t behavior)))
	  ((ratnump expo)
	   (cond ((evenp (cadr expo)) 1)
		 ((oddp (caddr expo)) behavior)
		 (t 0)))
	  (t 0))))

(defun behavior-by-diff (exp var val)
  (cond ((not (or (eq val '$zeroa) (eq val '$zerob))) 0)
	(t (let ((old-val val) (old-exp exp))
	     (setq val (ridofab val))
	     (do ((ct 0 (f1+ ct))
		  (exp (sratsimp (sdiff exp var)) (sratsimp (sdiff exp var)))
		  (n () (not n))
		  (ans ()))
	         ((> ct 4) 0) ;This do wins by a return.
	       (setq ans (no-err-sub val exp)) ;Why not do an EVENFN and ODDFN
	                                       ;test here.
	       (cond ((eq ans t)  
		      (return (behavior-numden old-exp var old-val)))
		     ((=0 ans) ()) ;Do it again.
		     (t (setq ans (getsignl ans))
			(COND (N (RETURN ANS)) 
			      ((EQUAL ANS 1)
			       (RETURN (if (EQ old-val '$zeroa) 1 -1)))
			      ((equal ans -1)
			       (RETURN (if (EQ old-val '$zeroa) -1 1)))
			      (t (return 0))))))))))

(defun behavior-numden (exp var val)
   (let ((num ($num exp)) (denom ($denom exp)))
     (cond ((equal denom 1) 0) ;Could be hacked more from here.
	   (t (let ((num-behav (behavior num var val))
		    (denom-behav (behavior denom var val)))
		(cond ((or (= num-behav 0) (= denom-behav 0)) 0)
		      ((= num-behav denom-behav) 1)
		      (t -1)))))))

(DEFUN TRY-LHOSPITAL (N D IND)
;;;Make one catch for the whole bunch of lhospital trials.
       (let ((ans (LHOSPITAL-catch N D IND)))
	 (cond ((null ans) ())
	       ((not (free-infp ans)) (simpinf ans))
	       ((not (free-epsilonp ans)) (simpab ans))
	       (t ans))))

(DEFUN TRY-LHOSPITAL-QUIT (N D IND)
  (let ((ans (lhospital-catch n d ind)))
       (cond ((null ans) (THROW 'LIMIT T))
	     ((not (free-infp ans)) (simpinf ans))
	     ((not (free-epsilonp ans)) (simpab ans))
	     (t ans))))

(defun lhospital-catch (n d ind)
  (cond ((> 0 lhcount)
	 (setq lhcount $lhospitallim)
	 (throw 'lhospital nil))
	((equal lhcount $lhospitallim)
	 (let ((lhcount (m+ lhcount -1)))
	      (catch 'lhospital (lhospital n d ind))))
	(t (setq lhcount (m+ lhcount -1))
	   (prog1 (lhospital n d ind)
		  (setq lhcount (m+ lhcount 1))))))
;If this succeeds then raise LHCOUNT.


(DEFUN LHOSPITAL (N D IND)
  (declare (special val lhp?))
  (IF (MTIMESP N)
      (SETQ N (m*l (MAPCAR #'(LAMBDA (TERM) (LHSIMP TERM VAR VAL))
			   (CDR N)))))
  (IF (MTIMESP D)
      (SETQ D (m*l (MAPCAR #'(LAMBDA (TERM) (LHSIMP TERM VAR VAL))
			   (CDR D)))))
  (let (((n . d) (lhop-numden n d))
	const nconst dconst)
    (SETQ LHP? (AND (NULL IND) (CONS N D)))
    (desetq (nconst . n) (var-or-const n))
    (desetq (dconst . d) (var-or-const d))
    (setq n (sdiff n var) d (sdiff d var))
    (if (or (not (free n '%derivative)) (not (free d '%derivative)))
        (throw 'lhospital ()))
    (setq N (expand-trigs (TANSC n) var))
    (setq D (expand-trigs (TANSC d) var))
    (desetq (const . (n . d)) (remove-singularities n d))
    (setq const (m* const (m// nconst dconst)))
    (simpinf
      (COND (IND (let ((ans (LIMIT2 N D VAR VAL)))
		   (if ans (m* const ans))))
	    (t (let ((ans (LIMIT 
			   (cond ((mplusp n)
				  (m+l (mapcar #'(lambda (x)
						   (sratsimp (m// x d)))
					       (cdr n))))
				 (t ($multthru (sratsimp (M// N D)))))
			   VAR VAL 'think)))
		 (if ans (m* const ans))))))))

;Hueristics for picking the right way to express a LHOSPITAL problem.
(defun lhop-numden (num denom)
  (declare (special var))
  (cond ((let ((log-num (involve num '(%log))))
	   (cond ((null log-num) ())
		 ((< (num-of-logs (factor (sratsimp (sdiff (M^ num -1) var))))
		     (num-of-logs (factor (sratsimp (sdiff num var)))))
		  (psetq num (M^ denom -1) denom (m^ num -1)) T)
		 (t t))))
	((let ((log-denom (involve denom '(%log))))
	   (cond ((null log-denom) ())
		 ((< (num-of-logs (sratsimp (sdiff (m^ denom -1) var)))
		     (num-of-logs (sratsimp (sdiff denom var))))
		  (psetq denom (M^ num -1) num (m^ denom -1))
		  ;;psetq might return nil but we want to select this clause.
		  T
		  )
		 (t t))))
	((let ((exp-num (%einvolve num)))
	      (cond (exp-num (cond ((%e-right-placep exp-num)  t)
				   (t (psetq num (m^ denom -1)
					     denom (m^ num -1)) T)))
		    (t ()))))
	((let ((exp-den (%einvolve denom)))
	      (cond (exp-den (cond ((%e-right-placep exp-den) t)
				   (t (psetq num (m^ denom -1)
					     denom (m^ num -1)) T)))
		    (t ()))))
	((let ((scnum (involve num '(%sin))))
	      (cond (scnum (cond ((trig-right-placep '%sin scnum) t)
				(t (psetq num (m^ denom -1)
					  denom (m^ num -1)) T)))
		    (t ()))))
	((let ((scden (involve denom '(%sin))))
	      (cond (scden (cond ((trig-right-placep '%sin scden) t)
				 (t (psetq num (m^ denom -1)
					   denom (m^ num -1)) T)))
		    (t ()))))
	((or (oscip num) (oscip denom)))
	((or (polyinx num var ())
	     (polyinx denom var ())))
	((or (polyinx (m^ num -1) var ())
	     (polyinx (m^ denom -1) var ()))
	 (psetq num (m^ denom -1) denom (m^ num -1)))
	((frac num)
	 (psetq num (m^ denom -1) denom (m^ num -1))))
  (cons num denom))

;i don't know what to do here for some cases, may have to be refined.
(defun num-of-logs (exp)
       (cond ((mapatom exp) 0)
	     ((equal (caar exp) '%log) 
	      (m+ 1 (num-of-log-l (cdr exp))))
	     ((and (mexptp exp) (mnump (caddr exp)))
	      (m* (simplify `((mabs) ,(caddr exp)))
		  (num-of-logs (cadr exp))))
	     (t (num-of-log-l (cdr exp)))))

(defun num-of-log-l (llist)
  (do ((temp llist (cdr temp)) (ans 0))
      ((null temp) ans)
      (setq ans (m+ ans (num-of-logs (car temp))))))

(defun %e-right-placep (%e-arg)
  (let ((%e-arg-diff (sdiff %e-arg var)))
   (cond
    ((free %e-arg-diff var)) ;simple cases
    ((or (and (mexptp denom)
	      (equal (cadr denom) -1))
	 (polyinx (m^ denom -1) var ()))  ())
    ((let ((%e-arg-diff-lim (ridofab (limit %e-arg-diff var val 'think)))
	   (%e-arg-exp-lim (ridofab (limit (m^ '$%e %e-arg) var val 'think))))
       (cond ((equal %e-arg-diff-lim %e-arg-exp-lim)  t)
	     ((and (mnump %e-arg-diff-lim) (mnump %e-arg-exp-lim))  t)
	     (t ())))))))

(defun trig-right-placep (trig-type arg)
  (let ((arglim (ridofab (limit arg var val 'think)))
	(triglim (ridofab (limit `((,trig-type) ,arg) var val 'think))))
       (cond ((and (equal arglim 0) (equal triglim 0))  t)
	     ((and (infinityp arglim)  (infinityp triglim))  t)
	     (t ()))))

;Takes a numerator and a denominator. If they tries all combinations of
;products to try and make a simpler set of subproblems for LHOSPITAL.
(defun remove-singularities (numer denom)
  (cond
   ((or (null numer) (null denom)
	(atom numer) (atom denom)
	(not (mtimesp numer)) ;Leave this here for a while.
	(not (mtimesp denom)))
    (cons 1 (cons numer denom)))
   (t 
    (let (((num-consts . num-vars) (var-or-const numer))
	  ((denom-consts . denom-vars) (var-or-const denom))
	  (const 1))
	 (if (not (mtimesp num-vars))
	     (setq num-vars (list num-vars)) 
	     (setq num-vars (cdr num-vars)))
	 (if (not (mtimesp denom-vars))
	     (setq denom-vars (list denom-vars))
	     (setq denom-vars (cdr denom-vars)))
	 (do ((nl num-vars (cdr nl))
	      (num-list (copy-top-level num-vars ))
	      (den-list denom-vars den-list-temp)
	      (den-list-temp (copy-top-level denom-vars )))
	     ((null nl)  (cons (m* const (m// num-consts denom-consts))
			       (cons  (m*l num-list) (m*l den-list-temp))))
	   (do ((dl den-list (cdr dl)))
	       ((null dl) t)
	       (cond ((or (%einvolve (car nl))
			  (%einvolve (car nl))) t)
		     (t (let ((lim (catch 'limit
				   (simpinf 
				    (simpab (limit (m// (car nl) (car dl))
						   var val 'think))))))
			   (cond ((or (eq lim t) (eq lim ())
				      (equal (ridofab lim) 0)
				      (infinityp lim)
				      (not (free lim '$inf))
				      (not (free lim '$minf))
				      (not (free lim '$infinity))
				      (not (free lim '$ind))
				      (not (free lim '$und)))
				  ())
				 (t (setq const (m* lim const))	
				    (setq num-list (zl-DELETE (car nl) 
							   num-list 1))
				    (setq den-list-temp
					  (zl-DELETE (car dl) 
						  den-list-temp 1))
				    (return t))))))))))))

(defun var-or-const (expr)
  (setq expr ($factor expr))
  (cond ((atom expr)
	 (cond ((eq expr var) (cons 1 expr))
	       (t (cons expr 1))))
	((free expr var) (cons expr 1))
	((mtimesp expr)
	 (do ((l (cdr expr) (cdr l))
	      (const 1)  (varl 1)  (lim ()))
	     ((null l)  (cons const varl))
	     (cond ((free (car l) var)
		    (setq const (m* (car l) const)))
		   ((and (setq lim (limit (car l) var val 'think))
			 (free-infp lim)
			 (not (equal (ridofab lim) 0)))
		    (setq const (m* lim const)))
		   (t (setq varl (m* (car l) varl))))))
	(t (cons 1 expr))))

(DEFUN LHSIMP (TERM VAR VAL)
  (COND ((ATOM TERM)  TERM)
	((NOT (EQ (CAAR TERM) 'MFACTORIAL))  TERM)
	(T
	 (LET ((TERM-VALUE (LIMIT TERM VAR VAL 'THINK)))
	   (COND ((NOT (MEMQ TERM-VALUE
			     '($INF $MINF $UND $IND $INFINITY $ZEROA $ZEROB)))
		  TERM-VALUE)
		 (T TERM))))))

(DEFUN BYLOG (EXPO BAS)
       (SIMPLIMEXPT '$%E 
		    (SETQ BAS 
			  (TRY-LHOSPITAL-QUIT (simplify `((%log) ,(TANSC BAS)))
					      (m^ expo -1)
					      NIL))
		    '$%E BAS))

(DEFUN SIMPLIMEXPT (BAS EXPO BL EL) 
  (COND
   ((OR (EQ BL '$UND) (EQ EL '$UND)) '$UND)
   ((ZEROP2 BL)
    (COND ((EQ EL '$INF) (IF (EQ BL '$ZEROA) BL 0))
	  ((EQ EL '$MINF) (IF (EQ BL '$ZEROA) '$INF '$INFINITY))
	  ((eq EL '$IND) '$ind)
	  ((eq el '$INFINITY) '$UND)
	  ((ZEROP2 EL)  (BYLOG EXPO BAS))
;;;Needs more code here for limit(x^(-a),x,0,plus) or minus.
	  ((AND (NOT (MNUMP EL)) (EQ BL '$ZEROB)) (THROW 'LIMIT t))
	  (T (COND ((EQUAL (GETSIGNL EL) -1)
		    (COND ((EQ BL '$ZEROA) '$INF)
			  ((EQ BL '$ZEROB)
			   (COND ((EVEN1 EL) '$INF)
				 ((eq (ask-integer el '$integer) '$yes)
				  (cond ((eq (ask-integer el '$even) '$yes)
					 '$inf)
					(t '$minf))))) ;Gotta be ODD.
			  (T (SETQ BAS (BEHAVIOR BAS VAR VAL))
			     (COND ((EQUAL BAS 1) '$INF)
				   ((EQUAL BAS -1) '$MINF)
				   (t (throw 'limit t))))))
		   ((AND (MNUMP EL)
			 (MEMQ BL '($ZEROA $ZEROB)))
		    (COND ((EVEN1 EL) '$ZEROA)
			  ((AND (EQ BL '$ZEROB)
				(RATNUMP EL)
				(EVENP (CADDR EL))) 0)
			  (T BL)))
		   ((AND (EQUAL (getsignl el) 1)
			 (EQ BL '$ZEROA)) BL)
		   (T 0)))))
   ((EQ BL '$INFINITY)
    (COND ((ZEROP2 EL) (BYLOG EXPO BAS))
	  ((EQ EL '$MINF) 0)
	  ((EQ EL '$INF) '$INFINITY)
	  ((MEMQ EL '($INFINITY $IND)) '$UND)
	  ((EQUAL (SETQ EL (GETSIGNl EL)) 1) '$INFINITY)
	  ((NULL EL) '$UND)
	  ((EQUAL EL -1) 0)))
   ((EQ BL '$INF)
    (COND ((EQ EL '$INF) '$INF)
	  ((EQUAL EL '$MINF) 0)
	  ((ZEROP2 EL) (BYLOG EXPO BAS))
	  ((MEMQ EL '($INFINITY $IND)) '$UND)
	  (T (COND ((ZEROP (GETSIGNl EL)) 1)
		   ((RATGREATERP 0 EL) '$ZEROA)
		   (T '$INF)))))
   ((EQ BL '$MINF)
    (COND ((ZEROP2 EL) (bylog expo bas))
	  ((EQ EL '$INF) '$UND)
	  ((EQUAL EL '$MINF) 0)
;;;Why not generalize this. We can ask about the number. -Jim 2/23/81
	  ((MNUMP EL)  (COND ((MNEGP EL)
			      (COND ((EVEN1 EL) '$ZEROA)
				    (T (cond
					((eq (ask-integer el '$integer) '$yes)
					 (cond ((eq (ask-integer el '$even)
							'$yes)  '$ZEROA)
					       (t '$zerob)))
					(t 0)))))
			     (T (COND
				 ((EVEN1 EL) '$INF)
				 ((eq (ask-integer el '$integer) '$yes)
				  (cond ((eq (ask-integer el '$even) '$yes)
					 '$inf)
					(t '$minf)))
				 (T '$infinity)))))
	  (LOGINPROD? (THROW 'LIP? 'LIP!))
	  (T '$UND)))
   ((EQUAL (SIMPLIFY (RATDISREP (RIDOFAB BL))) 1)
    (IF (INFINITYP EL) (BYLOG EXPO BAS) 1))
   ((AND (EQUAL (RIDOFAB BL) -1)
	 (INFINITYP EL))  '$IND)   ;LB
   ((EQ BL '$IND)  (COND ((OR (ZEROP2 EL) (INFINITYP EL)) '$UND)
			 ((NOT (EQUAL (GETSIGNl EL) -1)) '$IND)
			 (T '$UND)))
   ((EQ EL '$INF)  (COND ((ABLESS1 BL)
			  (COND ((EQUAL (GETSIGNl BL) 1) '$ZEROA)
				(T 0)))
			 ((EQUAL (GETSIGNL BL) -1) '$INFINITY)
			 (T '$INF)))
   ((EQ EL '$MINF)  (COND ((NOT (ABLESS1 BL))
			   (COND ((EQUAL (GETSIGNl BL) 1)  '$ZEROA)
				 (T 0)))
			  ((RATGREATERP 0 BL)  '$INFINITY)
			  (T '$INF)))
      ((EQ EL '$INFINITY)
    (if (equal val '$infinity)
	'$und ;Not enough info to do anything.
	(let (((real-el . imag-el) (trisplit expo)))
	  (setq real-el (limit real-el var origval nil))
	  (COND ((EQ real-el '$MINF) 0)
		((and (EQ real-el '$INF) 
		      (not (equal (ridofab (limit imag-el var origval nil))
				  0)))   '$INFINITY)
		(T  '$IND)))))

   ((EQ EL '$IND)  '$IND)
   ((ZEROP2 EL) 1)
   (T (m^ BL EL))))

(defun even1 (x) 
  (cond ((numberp x) (and (integerp x) (evenp x)))
	((and (mnump x) (evenp (cadr x))))))

(DEFUN ABLESS1 (BL) 
       (SETQ BL (NMR BL))
       (COND ((MNUMP BL)
	      (AND (RATGREATERP 1. BL) (RATGREATERP BL -1.)))
	     (T (EQUAL (GETSIGNl (M1- `((mabs) ,BL))) -1.))))

(DEFMFUN SIMPLIMIT (EXP VAR VAL) 
  (COND
   ((EQ VAR EXP) VAL)
   ((OR (ATOM EXP) (MNUMP EXP)) EXP)
   ((AND (NOT (INFINITYP VAL))
	 (NOT (AMONGL '(%SIN %COS %TAN %ATANH %COSH %SINH %TANH MFACTORIAL)
		      EXP))
	 (NOT (inf-typep exp))
	 (SIMPLIMSUBST VAL EXP)))
   ((eq (caar exp) '%limit) (throw 'limit t))
   ((mplusp exp)  (SIMPLIMPLUS EXP))
   ((mtimesp exp)  (SIMPLIMTIMES (CDR EXP)))
   ((mexptp exp)  (SIMPLIMEXPT (CADR EXP) (CADDR EXP)
			       (LIMIT (CADR EXP) VAR VAL 'THINK)
			       (LIMIT (CADDR EXP) VAR VAL 'THINK)))
   ((mlogp exp)  (SIMPLIMLN (CADR EXP)))
   ((MEMQ (CAAR EXP) '(%SIN %COS))
    (SIMPLIMSC EXP (CAAR EXP) (LIMIT (CADR EXP) VAR VAL 'THINK)))
   ((EQ (CAAR EXP) '%TAN) (SIMPLIM%TAN (CADR EXP)))
   ((EQ (CAAR EXP) '%ATAN) (SIMPLIM%ATAN (LIMIT (CADR EXP) VAR VAL 'THINK)))
   ((MEMQ (CAAR EXP) '(%SINH %COSH))
    (SIMPLIMSCH (CAAR EXP) (LIMIT (CADR EXP) VAR VAL 'THINK)))
   ((EQ (CAAR EXP) 'MFACTORIAL)
    (SIMPLIMFACT (CADR EXP) VAR VAL (LIMIT (CADR EXP) VAR VAL 'THINK)))
   ((MEMQ (CAAR EXP) '(%ERF %TANH))
    (SIMPLIM%ERF-%TANH (CAAR EXP) (CADR EXP)))
   ((MEMQ (CAAR EXP) '(%ACOS %ASIN))
    (SIMPLIM%ASIN-%ACOS (CAAR EXP) (LIMIT (CADR EXP) VAR VAL 'THINK)))
   ((EQ (CAAR EXP) '%ATANH)
    (SIMPLIM%ATANH (LIMIT (CADR EXP) VAR VAL 'THINK)))
   ((EQ (CAAR EXP) '%ACOSH)
    (SIMPLIM%ACOSH (LIMIT (CADR EXP) VAR VAL 'THINK)))
   ((EQ (CAAR EXP) '%ASINH)
    (SIMPLIM%ASINH (LIMIT (CADR EXP) VAR VAL 'THINK)))
   ((and (eq (caar exp) 'mqapply)
	 (eq (subfunname exp) '$li))
    (simplim$li (subfunsubs exp) (subfunargs exp) val))
   ((and (eq (caar exp) 'mqapply)
	 (eq (subfunname exp) '$psi))
    (simplim$psi (subfunsubs exp) (subfunargs exp) val))
   ((and (eq (caar exp) var)
	 (memq 'array (car exp))
	 (andmapc #'(lambda (sub-exp)
		      (free sub-exp var))
		  (cdr exp)))
    exp) ;LIMIT(B[I],B,INF); -> B[I]
   (T (if $limsubst 
	  (let ((head (cond ((memq 'array (car exp))
			     (list (caar exp) 'array))
			    (t (list (caar exp))))))
	    (SIMPLIFY (CONS head
			    (MAPCAR #'(LAMBDA (A) 
					(LIMIT A VAR VAL 'THINK))
				    (CDR EXP)))))))))

(DEFUN LIMINV (E)
  (setq e (RESIMPLIFY (SUBST (M// 1 VAR) VAR E)))
  (let ((new-val (cond ((eq val '$zeroa)  '$inf)
		       ((eq val '$zerob)  '$minf))))
    (if new-val (let ((preserve-direction t))
		  ($limit e var new-val)) (throw 'limit t))))

(DEFUN SIMPLIMTIMES (EXP)
  (PROG (SIGN PROD Y NUM DENOM FLAG ZF FLAG2 EXP1)
    (SETQ PROD (SETQ NUM (SETQ DENOM 1)) EXP1 EXP)
LOOP
    (SETQ Y (LET ((LOGINPROD? (INVOLVE (CAR EXP1) '(%LOG))))
		 (CATCH 'LIP? (LIMIT (CAR EXP1) VAR VAL 'THINK))))
    (COND ((EQ Y 'LIP!) (RETURN (liminv (cons '(mtimes simp) exp))))
	  ((ZEROP2 Y)
	   (SETQ NUM (M* NUM (CAR EXP1)))
	   (COND ((EQ Y '$ZEROA)
		  (COND (ZF NIL)
			(T (SETQ ZF 1))))
		 ((EQ Y '$ZEROB)
		  (COND (ZF (SETQ ZF (TIMES -1 ZF)))
			(T (SETQ ZF -1))))))
	  ((NOT (MEMQ Y '($INF $MINF $INFINITY $IND $UND)))
	   (SETQ PROD (M* PROD Y)))
	  ((EQ Y '$UND) 
	   (RETURN '$UND))
	  ((EQ Y '$IND)
	   (SETQ FLAG2 T))
	  (T (SETQ DENOM (M* DENOM (CAR EXP1)))
	     (COND ((EQ Y '$INFINITY) (SETQ FLAG Y))
		   ((EQ FLAG '$INFINITY) NIL)
		   ((NULL FLAG) (SETQ FLAG Y))
		   ((EQ Y FLAG) (SETQ FLAG '$INF))
		   (T (SETQ FLAG '$MINF)))))
    (SETQ EXP1 (CDR EXP1))
    (COND ((NULL EXP1)
	   (COND ((AND (EQUAL NUM 1) (EQUAL DENOM 1))
		  (RETURN (IF FLAG2 '$IND PROD)))
		 ((EQUAL DENOM 1)
		  (COND ((NULL ZF) (RETURN 0))
			(T (SETQ SIGN (GETSIGNL PROD))
			   (COND ((eq sign 'complex) (RETURN 0))
				 (SIGN (SETQ ZF (TIMES ZF SIGN))
				       (RETURN
					(COND ((EQUAL ZF 1) '$ZEROA)
					      ((EQUAL ZF -1) '$ZEROB)
					      (T 0))))
				 (T (RETURN 0))))))
		 ((EQUAL NUM 1)
		  (RETURN (COND (FLAG2 '$UND)
				((or (EQUAL (SETQ SIGN (GETSIGNL PROD)) 0)
				     (null sign))
				 (throw 'limit t))
				((EQUAL SIGN -1)
				 (COND ((EQ FLAG '$INF) '$MINF)
				       ((EQ FLAG '$INFINITY) FLAG)
				       (T '$INF)))
				(T FLAG))))
		 (T (GO DOWN))))
	  (T (GO LOOP)))
 DOWN
     (COND ((OR (NOT (AMONG VAR DENOM))
		(NOT (AMONG VAR NUM)))
	    (THROW 'LIMIT t)))
     (RETURN (let ((ans (LIMIT2 NUM (M^ DENOM -1) VAR VAL)))
	       (if ans 
		 (SIMPLIMTIMES (LIST PROD ans))
		 (throw 'limit t))))))
		   
;;;PUT CODE HERE TO ELIMINATE FAKE SINGULARITIES??

(defun simplimplus (exp)
  (cond ((memalike exp simplimplus-problems)
	 (throw 'limit t))
	(t (unwind-protect 
	    (progn (push exp simplimplus-problems)
		   (let ((ans (catch 'limit (simplimplus1 exp))))
		     (cond ((or (eq ans ())
				(eq ans t)
				(among '%limit ans))
			    (let ((new-exp (sratsimp exp)))
				 (cond ((not (alike1 exp new-exp))
					(setq ans
					      (limit new-exp var val 'think))))
				 (cond ((or (eq ans ())
					    (eq ans t))
					(throw 'limit t))
				       (t ans))))
			   (t ans))))
	    (pop simplimplus-problems)))))
	  
(DEFUN SIMPLIMPLUS1 (EXP) 
  (PROG (SUM Y INFL INFINITYL MINFL INDL) 
	(SETQ SUM 0.)
	(DO ((EXP (CDR EXP) (CDR EXP)) (F))
	    ((OR Y (NULL EXP)) NIL)
	    (SETQ F (LIMIT (CAR EXP) VAR VAL 'THINK))
	    (COND ((EQ F '$UND) (SETQ Y T))
		  ((NOT (MEMQ F '($INF $MINF $INFINITY $IND)))
		   (SETQ SUM (M+ SUM F)))
		  ((EQ F '$IND)  (PUSH (CAR EXP) INDL))
		  (infinityl (throw 'limit t))
;;;Don't know what to do with an '$infinity and an $inf or $minf
		  ((EQ F '$INF)  (PUSH (CAR EXP) INFL))
		  ((EQ F '$MINF)  (PUSH (CAR EXP) MINFL))
		  ((eq f '$infinity) 
		   (cond ((or infl minfl)
			  (throw 'limit t))
			 (t (push (car exp) infinityl))))))
	(COND (Y (RETURN '$UND))
	      ((NOT (OR INFL MINFL INDL INFINITYL))
	       (RETURN (COND ((ATOM SUM)  SUM)
			     ((or (not (free sum '$zeroa))
				  (not (free sum '$zerob)))
			      (simpab SUM))
			     (T SUM))))
	      (t (cond ((null infinityl)
			(cond (INFL (COND ((NULL MINFL) (RETURN '$INF))
					  (T (GO OON))))
			      (MINFL (RETURN '$MINF))
			      (T (RETURN '$IND))))
		       (t (setq infl (append infl infinityl))))))
	
OON  (SETQ Y (M+L (APPEND MINFL INFL)))
     (cond ((alike1 exp (setq y (sratsimp (log-reduce (hyperex y)))))
	    (cond ((not (infinityp val))
		   (SETQ INFL (CNV INFL VAL)) ;THIS IS HORRIBLE!!!!
		   (SETQ MINFL (CNV MINFL VAL))))
	    (let ((val '$inf))
	      (COND ((ANDMAPC (FUNCTION (LAMBDA (J) (RADICALP J VAR)))
			      (APPEND INFL MINFL))
		     (SETQ Y (RHEUR INFL MINFL)))
		    (T (SETQ Y (SHEUR INFL MINFL))))))
	   (t (SETQ Y (LIMIT Y VAR VAL 'THINK))))
     (COND ((or (eq y ())
		(eq y t))  (return ()))
	   ((INFINITYP Y)  (RETURN Y))
	   (t (RETURN (M+ SUM Y))))))

(DEFUN SHEUR0 (N D) 
  (let ((orig-n n))
       (COND ((/#ALIKE N D) 1)
	     ((and (free n var)
		   (free d var))
	      (m// n d))
	     (T (SETQ N (CPA N D NIL))
		(COND ((EQUAL N 1.)
		       (cond ((oscip orig-n)  '$UND)
			     (t '$inf)))
		      ((EQUAL N -1.)  '$ZEROA)
		      ((EQUAL N 0.)  (m// orig-n d)))))))


;;;L1 is a list of INF's and L2 is a list of MINF's. Added together
;;;it is indeterminate.
(DEFUN SHEUR (L1 L2) 
  (LET ((TERM (SHEUR1 L1 L2)))
    (COND ((EQUAL TERM '$INF)  '$INF)
	  ((EQUAL TERM '$MINF)   '$MINF)
	  (t (let ((new-num (m+l (mapcar #'(lambda (num-term)
					     (m// num-term (car l1)))
					 (append l1 l2)))))
	       (cond ((limit2 new-num (m// 1 (car l1)) var val))))))))
	       
;To chicken to throw this code out yet. 
(comment ((not (alike1 term (m+ (m+l l1) (m+l l2))))
	  (LET ((LIM1 (LIMIT1 TERM VAR VAL))
		(LIM2 (M+L (MAPCAR #'(LAMBDA (J)
				       (LIMIT1 (M// J TERM) VAR VAL))
				   `(,@L1 ,@L2)))))
	       (COND
		((OR (AND (EQUAL LIM1 0.)
			  (MEMQ LIM2 '($INF $MINF $UND $IND)))
		     (AND (EQUAL LIM2 0.)
			  (MEMQ LIM1 '($INF $MINF $UND $IND))))
		   (limit2 ($RATSIMP (M// (M+ (M+L L1) (M+L L2)) TERM))
			   (M^ TERM -1) var val))
		(T (SIMPLIMTIMES `(,LIM1 ,LIM2))))))
	 (t (throw 'limit t)))

(DEFUN FRAC (EXP) 
       (COND ((ATOM EXP) NIL)
	     (T (SETQ EXP (NFORMAT EXP))
		(COND ((AND (EQ (CAAR EXP) 'MQUOTIENT)
			    (AMONG VAR (CADDR EXP)))
		       T))))) 

(DEFUN ZEROP2 (Z) (=0 (RIDOFAB Z))) 

(DEFUN RAISE (A) (M+ A '$ZEROA)) 

(DEFUN LOWER (A) (M+ A '$ZEROB)) 

(DEFUN SINCOSHK (EXP1 L SC) 
       (COND ((EQUAL L 1) (LOWER L))
	     ((EQUAL L -1) (RAISE L))
	     ((AMONG SC L) L)
	     ((MEMQ VAL '($ZEROA $ZEROB)) (SPANGSIDE EXP1 L))
	     (T L))) 

(DEFUN SPANGSIDE (E L) 
       (SETQ E (BEHAVIOR E VAR VAL))
       (COND ((EQUAL E 1) (RAISE L))
	     ((EQUAL E -1) (LOWER L))
	     (T L))) 

(DEFMFUN RIDOFAB (E) 
       (IF (AMONG '$ZEROA E) (SETQ E (MAXIMA-SUBSTITUTE 0 '$ZEROA E)))
       (IF (AMONG '$ZEROB E) (SETQ E (MAXIMA-SUBSTITUTE 0 '$ZEROB E)))
       E)

(DEFUN SIMPLERD (EXP) 
       (AND (mexptp exp)
	    (OR (AND RD* (NOT (AMONG VAR (CADDR EXP))))
		(MNUMP (CADDR EXP)))
	    (POLYP (CADR EXP)))) 

(DEFUN BRANCH1 (EXP VAL) 
       (COND ((POLYP EXP) NIL)
	     ((SIMPLERD EXP) (ZEROP2 (SUBIN VAL (CADR EXP))))
	     (T ;(APPLY 'OR (MAPCAR #'(LAMBDA (J) (BRANCH1 J VAL)) (CDR EXP)))
	      (sloop for v on (cdr exp)
		     when (branch1 (car v) val)
		     do (loop-return v))
		;(zl-SOME #'(lambda (j) (branch1 j val)) (the list (cdr exp)))
		))) 

(DEFUN BRANCH (EXP VAL) 
       (COND ((POLYP EXP) NIL)
	     ((OR (SIMPLERD EXP) (mtimesp exp))
	      (BRANCH1 EXP VAL))
	     ((mplusp exp)
	      ;(ANDMAPC #'(LAMBDA (J) (BRANCH J VAL)) (CDR EXP))
	      (every #'(lambda (j) (branch j val)) (the list (cdr exp))))))

(DEFUN SER0 (E N D VAL) 
       (COND ((AND (BRANCH N VAL) (BRANCH D VAL))
	      (SETQ NN* NIL)
	      (SETQ N (SER1 N))
	      (SETQ D (SER1 D))
;;;NN* gets set by POFX, called by SER1, to get a list of exponents.
	      (SETQ NN* (RATMIN NN*))
	      (SETQ N (sratsimp (m^ n (m^ var nn*))))
	      (SETQ D (sratsimp (m^ d (m^ var nn*))))
	      (COND ((MEMQ VAL '($ZEROA $ZEROB)) NIL)
		    (T (SETQ VAL 0.)))
	      (RADLIM E N D))
	     (T (TRY-LHOSPITAL-QUIT N D NIL)))) 

(DEFUN RHEUR (L1 L2) 
  (PROG (ANS M1 M2) 
    (SETQ M1 (MAPCAR (FUNCTION ASYMREDU) L1))
    (SETQ M2 (MAPCAR (FUNCTION ASYMREDU) L2))
    (SETQ ANS (m+l (APPEND M1 M2)))
    (COND ((RPTROUBLE (m+l (APPEND L1 L2)))
	   (RETURN (LIMIT (SIMPLIFY (RDSGET (m+l (APPEND L1 L2))))
			  VAR
			  VAL
			  NIL)))
	  ((mplusp ans)  (RETURN (SHEUR M1 M2)))
	  (T (RETURN (LIMIT ANS VAR VAL T)))))) 

(DEFUN RPTROUBLE (RP) 
       (NOT (EQUAL (RDDEG RP NIL) (RDDEG (ASYMREDU RP) NIL)))) 

(DEFUN RADICALP (EXP VAR) 
       (COND ((POLYinx EXp var ()))
	     ((mexptp exp)  (COND ((EQUAL (CADDR EXP) -1.)
				   (RADICALP (CADR EXP) VAR))
				  ((SIMPLERD EXP))))
	     ((MEMQ (CAAR EXP) '(MPLUS MTIMES))
	      (ANDMAPC (FUNCTION (LAMBDA (J) (RADICALP J VAR)))
		       (CDR EXP))))) 

(DEFUN INVOLVE (E NN*)
  (declare (special var))
       (COND ((ATOM E) NIL)
	     ((MNUMP E) NIL)
	     ((AND (MEMQ (CAAR E) NN*) (AMONG VAR (CADR E))) (CADR E))
	     (T (ORMAPC (FUNCTION (LAMBDA (J) (INVOLVE J NN*)))
			(CDR E)))))


  

(DEFUN NOTINVOLVE (EXP NN*) 
       (COND ((ATOM EXP) T)
	     ((MNUMP EXP) T)
	     ((MEMQ (CAAR EXP) NN*) (NOT (AMONG VAR (CADR EXP))))
	     ((ANDMAPC (FUNCTION (LAMBDA (J) (NOTINVOLVE J NN*)))
		       (CDR EXP))))) 

(DEFUN SHEUR1 (L1 L2) 
       (PROG (ANS) 
	     (SETQ L1 (CAR (MAXI L1)))
	     (SETQ L2 (CAR (MAXI L2)))
	     (SETQ ANS (CPA L1 L2 T))
	     (RETURN (COND ((=0 ANS)  (m+  l1 l2))
			   ((EQUAL ANS 1.) '$INF)
			   (T '$MINF))))) 

(DEFUN ZERO-LIM (CPA-LIST)
 (DO ((L CPA-LIST (CDR L)))
     ((NULL L) ())
     (AND (EQ (CAAR L) 'GEN)
	  (ZEROP2 (LIMIT (CADAR L) VAR VAL 'THINK))
	  (RETURN T))))

(DEFUN CPA (R1 R2 FLAG) 
  (let ((t1 r1)
	(t2 r2))
    (COND ((ALIKE1 T1 T2)   0.)
	  ((FREE T1 VAR)
	   (COND ((FREE T2 VAR)  0.)
		 (T (LET ((LIM-ANS (LIMIT1 T2 VAR VAL)))
		      (COND ((NOT (MEMQ LIM-ANS '($INF $MINF $UND $IND)))  0.)
			    (T  -1.))))))
	  ((FREE T2 VAR)
	   (LET ((LIM-ANS (LIMIT1 T1 VAR VAL)))
	     (COND ((NOT (MEMQ LIM-ANS '($INF $MINF $UND $IND)))  0.)
		   (T  1.))))
	  (t (cond ((MTIMESP T1)  (SETQ T1 (CDR T1)))
		   (T (SETQ T1 (LIST T1))))
	     (COND ((MTIMESP T2)  (SETQ T2 (CDR T2)))
		   (T (SETQ T2 (LIST T2))))
	     (SETQ T1 (MAPCAR (FUNCTION ISTRENGTH) T1))
	     (SETQ T2 (MAPCAR (FUNCTION ISTRENGTH) T2))
	     (let ((ans (ISMAX T1))
		   (D (ISMAX T2)))
	       (COND ((or (null ans) (null d)
			  (EQ (CAR ANS) 'GEN) (eq (car d) 'gen))  0.))
	       (if (EQ (CAR ANS) 'VAR)  (SETQ ANS (ADD-UP-DEG T1)))
	       (if (EQ (CAR D) 'VAR)  (SETQ D (ADD-UP-DEG T2)))
	       ;Cant just just compare dominating terms if there are indeterm-
	       ;inates present; e.g. X-X^2*LOG(1+1/X). So check for this.
	       (cond ((OR (ZERO-LIM T1) 
			  (ZERO-LIM T2))  
		      (cpa-indeterm ans d t1 t2 flag))
		     ((ISGREATERP ANS D)  1.)
		     ((ISGREATERP D ANS)  -1.)
		     (t  0)))))))

(defun cpa-indeterm (ans d t1 t2 flag)
  (cond ((NOT (EQ (CAR ANS) 'VAR))
	 (SETQ ANS (GATHER ANS T1)  D (GATHER D T2))))
  (let ((*INDICATOR (AND (EQ (CAR ANS) 'EXP) 
			 FLAG))
	(test ()))
    (SETQ TEST (CPA1 ANS D))
    (COND ((AND (ZEROP1 TEST)
		(OR (EQUAL ($RADCAN (M// (CADR ANS) (CADR D))) 1.)
		    (AND (POLYP (CADR ANS))
			 (POLYP (CADR D))
			 (EQUAL (LIMIT (M// (CADR ANS) (CADR D)) VAR '$INF 'think)
				1.))))
	   (let ((new-term1 (m// t1 (cadr ans)))
		 (new-term2 (m// t2 (cadr d))))
	     (CPA new-term1 new-term2 FLAG)))
	  (t 0))))

(DEFUN ADD-UP-DEG (STRENGTHL)
       (DO ((STL STRENGTHL (CDR STL))
	    (POXL)
	    (DEGL))
	   ((NULL STL) (LIST 'VAR (M*L POXL) (M+L DEGL)))
	   (cond ((EQ (CAAR STL) 'VAR)
		  (push (cadar stl) poxl)
		  (push (caddar stl) degl)))))

(DEFUN CPA1 (P1 P2) 
       (PROG (FLAG S1 S2) 
	     (COND ((EQ (CAR P1) 'GEN) (RETURN 0.)))
	     (SETQ FLAG (CAR P1))
	     (SETQ P1 (CADR P1))
	     (SETQ P2 (CADR P2))
	     (COND
	      ((EQ FLAG 'VAR)
	       (SETQ S1 (ISTRENGTH P1))
	       (SETQ S2 (ISTRENGTH P2))
	       (RETURN
		(COND
		 ((ISGREATERP S1 S2) 1.)
		 ((ISGREATERP S2 S1) -1.)
		 (*INDICATOR
		  (SETQ *INDICATOR NIL)
		  (COND
		   ((AND (POLY? P1 VAR) (POLY? P2 VAR))
		    (SETQ P1 (M- P1 P2))
		    (COND ((ZEROP1 P1) 0.)
			  (T (GETSIGNl (HOT-COEF P1)))))
		   (T
		    (SETQ S1
			  (RHEUR (LIST P1)
				 (LIST (m*t -1 P2))))
		    (COND ((ZEROP2 S1) 0.)
			  ((RATGREATERP S1 0.) 1.)
			  (T -1.)))))
		 (T 0.))))
	      ((EQ FLAG 'EXP)
	       (SETQ P1 (CADDR P1))
	       (SETQ P2 (CADDR P2))
	       (COND ((AND (POLY? P1 VAR) (POLY? P2 VAR))
		      (SETQ P1 (M- P1 P2))
		      (RETURN (COND ((OR (ZEROP1 P1)
					 (NOT (AMONG VAR P1)))
				     0.)
				    (T (GETSIGNl (HOT-COEF P1))))))
		     ((AND (RADICALP P1 VAR) (RADICALP P2 VAR))
		      (SETQ S1
			    (RHEUR (LIST P1)
				   (LIST (m*t -1 P2))))
		      (RETURN (COND ((EQ S1 '$INF) 1.)
				    ((EQ S1 '$MINF) -1.)
				    ((MNUMP S1)
				     (COND ((RATGREATERP S1 0.) 1.)
					   ((RATGREATERP 0. S1) -1.)
					   (T 0.)))
				    (T 0.))))
		     (T (RETURN (CPA P1 P2 T)))))
	      ((EQ FLAG 'LOG)
	       (SETQ P1 (TRY-LHOSPITAL (ASYMREDU P1) (ASYMREDU P2) NIL))
	       (RETURN (COND ((ZEROP2 P1) -1.)
			     ((REAL-INFINITYP P1) 1.)
			     (T 0.))))))) 

(SETQ *LIMORDER '(NUM LOG VAR EXP FACT GEN))

;;;EXPRESSIONS TO ISGREATERP ARE OF THE FOLLOWING FORMS
;;;	("VAR" POLY DEG)
;;;	("EXP" %E^EXP)
;;;	("LOG" LOG(EXP))
;;;	("FACT"	<A FACTORIAL EXPRESSION>)
;;;	("GEN" <ANY OTHER TYPE OF EXPRESSION>)

(DEFUN ISGREATERP (A B) 
  (let ((TA (car a))
	(TB (car b)))
    (COND ((or (eq ta 'gen)
	       (eq tb 'gen))  ())
	  ((AND (EQ TA TB) (EQ TA 'VAR))
	   (RATGREATERP (CADDR A) (CADDR B)))
	  ((MEMQ TA (CDR (MEMQ TB *LIMORDER)))))))

(DEFUN ISMAX (L) 
  (cond ((null l)  ())
	((atom l)   ())
	((= (length l) 1)  (car l)) ;If there is only 1 thing give it back.
	((andmapc #'(lambda (x) 
		      (not (eq (car x) 'gen))) l)
			  
	 (do ((l1 (cdr l) (cdr l1))
	      (temp-ans (car l))
	      (ans ()))
	     ((null l1) ans)
	   (cond ((isgreaterp temp-ans (car l1)) 
		  (setq ans temp-ans))
		 ((isgreaterp (car l1) temp-ans)
		  (setq temp-ans (car l1))
		  (setq ans temp-ans))
		 (t (setq ans ()))))) 
	(t ())))

(DEFUN MAXI (L)   ;RETURNS LIST OF HIGH TERMS
  (COND ((ATOM L)  NIL)
	(T (DO ((L (CDR L) (CDR L))
		(HI-TERM (CAR L))
		(HI-TERMS (NCONS (CAR L)))
		(COMPARE NIL))
	       ((NULL L) HI-TERMS)
	     (SETQ COMPARE (LIMIT (M// (CAR L) HI-TERM) VAR val 'THINK))
	     (COND
	      ((INFINITYP COMPARE)
	       (SETQ HI-TERMS (NCONS (SETQ HI-TERM (CAR L)))))
	      ((EQ COMPARE '$UND)
	       (LET ((COMPARE2 (LIMIT (M// HI-TERM (CAR L)) VAR val 'THINK)))
		 (COND ((ZEROP2 COMPARE2)
			(SETQ HI-TERMS (NCONS (SETQ HI-TERM (CAR L)))))
		       (T NIL))))
	      ((ZEROP2 COMPARE)  NIL)
;;;COMPARE IS IND OR FINITE-VALUED
	      (T (SETQ HI-TERMS (APPEND HI-TERMS (NCONS (CAR L))))))))))

(DEFUN RATMAX (L) 
       (PROG (ANS) 
	     (COND ((ATOM L) (RETURN NIL)))
	L1   (SETQ ANS (CAR L))
	L2   (SETQ L (CDR L))
	     (COND ((NULL L) (RETURN ANS))
		   ((RATGREATERP ANS (CAR L)) (GO L2))
		   (T (GO L1))))) 

(DEFUN RATMIN (L) 
       (PROG (ANS) 
	     (COND ((ATOM L) (RETURN NIL)))
	L1   (SETQ ANS (CAR L))
	L2   (SETQ L (CDR L))
	     (COND ((NULL L) (RETURN ANS))
		   ((RATGREATERP (CAR L) ANS) (GO L2))
		   (T (GO L1))))) 

(DEFUN POFX (E) 
       (COND ((atom e)
	      (cond ((eq e var)
		     (setq nn* (cons 1 nn*)))
		    (t ())))
	     ((OR (MNUMP E) (NOT (AMONG VAR E))) NIL)
	     ((AND (mexptp e) (EQ (CADR E) VAR))
	      (SETQ NN* (CONS (CADDR E) NN*)))
	     ((SIMPLERD E) NIL)
	     (T (MAPC (FUNCTION POFX) (CDR E))))) 

(DEFUN SER1 (E) 
       (COND ((MEMQ VAL '($ZEROA $ZEROB)) NIL)
	     (T (SETQ E (SUBIN (M+ VAR VAL) E))))
       (SETQ E (RDFACT E))
       (COND ((POFX E) E))) 

(DEFUN GATHER (IND L) 
       (PROG (ANS) 
	     (SETQ IND (CAR IND))
	LOOP (COND ((NULL L)
		    (RETURN (LIST IND (m*l ANS))))
		   ((EQUAL (CAAR L) IND)
		    (SETQ ANS (CONS (CADAR L) ANS))))
	     (SETQ L (CDR L))
	     (GO LOOP)))

(DEFUN ISTRENGTH (TERM) 
  (COND ((MNUMP TERM)  (LIST 'NUM TERM))
	((ATOM TERM)   (COND ((EQ TERM VAR)
			      (LIST 'VAR VAR 1.))
			     (T (LIST 'num TERM))))
	((NOT (AMONG VAR TERM))  (LIST 'num TERM))
	((RADICALP TERM VAR)  (LIST 'VAR TERM (RDDEG TERM NIL)))
	((mplusp TERM)  
	 (let ((temp (ISMAX (MAPCAR (FUNCTION ISTRENGTH) (CDR TERM)))))
	      (cond ((not (null temp))  temp)
		    (t `(gen ,term)))))
	((mtimesp term) 
	 (let ((TEMP (MAPCAR (FUNCTION ISTRENGTH) (CDR TERM)))
	       (temp1 ()))
	   (setq temp1 (ismax temp))
	   (COND ((null temp1)  `(gen ,term))
		 ((eq (car temp1) 'log)  `(log ,temp))
		 ((EQ (CAR TEMP1) 'VAR)  (ADD-UP-DEG TEMP))
		 (T `(gen ,TEMP)))))
	((AND (mexptp term)
	      (REAL-INFINITYP (LIMIT TERM VAR VAL T)))
	 (COND ((AND (AMONG VAR (CADDR TERM))
		     (MEMQ (CAR (ISTRENGTH (SETQ TERM (LOGRED TERM))))
			   '(VAR EXP FACT))
		     (REAL-INFINITYP (LIMIT TERM VAR VAL T)))
		(LIST 'EXP (m^ '$%E TERM)))
	       ((NOT (AMONG VAR (CADDR TERM)))
		(let ((TEMP (ISTRENGTH (CADR TERM))))
		     (cond ((not (alike1 temp term))
			    (RPLACA (CDR TEMP) TERM)
			    (AND (EQ (CAR TEMP) 'VAR)
				 (RPLACA (CDDR TEMP)
					 (M* (CADDR TEMP) (CADDR TERM))))
			    TEMP)
			   (t `(gen ,term)))))
	       (T (LIST 'GEN (m^ '$%E TERM)))))
	((AND (EQ (CAAR TERM) '%LOG)
	      (REAL-INFINITYP (LIMIT TERM VAR VAL T)))
	 (let ((stren (istrength (cadr term))))
	      (COND ((MEMQ (CAR stren) '(LOG VAR))
		     `(LOG ,TERM))
		    ((eq (car stren) 'exp)
		     (istrength (car (cddadr stren))))
		    (T `(GEN ,TERM)))))
	((EQ (CAAR TERM) 'MFACTORIAL)
	 (LIST 'FACT TERM))
	((let ((TEMP (HYPEREX TERM)))
	      (AND (NOT (ALIKE1 TERM TEMP))
	           (ISTRENGTH TEMP))))
	(T (LIST 'GEN TERM))))

(DEFUN LOGRED (S1) 
       (OR (AND (EQ (CADR S1) '$%E) (CADDR S1))
	   (m*t (CADDR S1) `((%LOG) ,(CADR S1))))) 

(DEFUN ASYMREDU (RD) 
       (COND ((ATOM RD) RD)
	     ((MNUMP RD) RD)
	     ((NOT (AMONG VAR RD)) RD)
	     ((POLYINX RD VAR T))
	     ((SIMPLERD RD)
	      (COND ((EQ (CADR RD) VAR) RD)
		    (T (MABS-SUBST 
			(FACTOR ($EXPAND (M^ (POLYINX (CADR RD) VAR T)
					     (CADDR RD))))
			VAR
			VAL))))
	     (T (SIMPLIFY (CONS (LIST (CAAR RD))
				(MAPCAR (FUNCTION ASYMREDU)
					(CDR RD)))))))

(DEFUN RDFACT (RD) 
       (let ((DN** ())  (NN** ()))
	    (COND ((ATOM RD) RD)
		  ((MNUMP RD) RD)
		  ((NOT (AMONG VAR RD)) RD)
		  ((POLYP RD)
		   (FACTOR RD))
		  ((SIMPLERD RD)
		   (COND ((EQ (CADR RD) VAR) RD)
			 (T (SETQ DN** (CADDR RD))
			    (SETQ NN** (FACTOR (CADR RD)))
			    (COND ((mtimesp nn**)
				   (m*l (MAPCAR (FUNCTION
						 (LAMBDA (J)
							 (m^ j dn**)))
						(CDR NN**))))
				  (T RD)))))
		  (T (SIMPLIFY (CONS (NCONS (CAAR RD))
				     (MAPCAR #'RDFACT (CDR RD))))))))

(DEFUN CNV (EXPL VAL) 
  (MAPCAR #'(LAMBDA (E) 
	      (MAXIMA-SUBSTITUTE (COND ((EQ VAL '$ZEROB)
				 (m* -1 (m^ var -1)))
				((EQ VAL '$ZEROA)
				 (m^ var -1))
				((eq val '$minf)
				 (m* -1 var))
				(T (m^ (m+ VAR (m* -1 val)) -1.)))
			  VAR
			  E))
	  EXPL))

(DEFUN PWTAYLOR (EXP VAR L TERMS) 
       (PROG (COEF ANS C MC) 
	     (COND ((=0 TERMS) (RETURN NIL)) ((=0 L) (SETQ MC T)))
	     (SETQ C 0.)
	     (GO TAG1)
	LOOP (SETQ C (ADD1 C))
	     (COND ((OR (GREATERP C 10.) (EQUAL C TERMS))
		    (RETURN (m+l ANS)))
		   (T (SETQ EXP (SDIFF EXP VAR))))
	TAG1 (SETQ COEF ($RADCAN (SUBIN L EXP)))
	     (COND ((=0 COEF) (SETQ TERMS (ADD1 TERMS)) (GO LOOP)))
	     (SETQ 
	      ANS
	      (APPEND
	       ANS
	       (LIST
		(m* COEF
		    (m^ `((MFACTORIAL) ,C) -1)
		    (m^ (IF MC VAR (m+t (m*t -1 L) VAR)) C)))))
	     (GO LOOP))) 

(DEFUN RDSGET (E) 
       (COND ((POLYP E) E)
	     ((SIMPLERD E) (RDTAY E))
	     (T (CONS (LIST (CAAR E))
		      (MAPCAR (FUNCTION RDSGET) (CDR E)))))) 

(DEFUN RDTAY (RD) 
       (COND ($TLIMSWITCH ($RATDISREP ($TAYLOR RD VAR VAL 1.)))
	     (T (LRDTAY RD)))) 

(DEFUN LRDTAY (RD) 
       (PROG (VARLIST P C E D $RATFAC)
	     (SETQ VARLIST (NCONS VAR))
	     (SETQ P (RATNUMERATOR (CDR (RATREP* (CADR RD)))))
	     (COND ((LESSP (LENGTH P) 3.) (RETURN RD)))
	     (SETQ E (CADDR RD))
	     (SETQ D (PDEGR P))
	     (SETQ C (m^ VAR (m* D E)))
	     (SETQ D ($RATSIMP (VARINVERT (m* (PDIS P) (m^ VAR (m- D)))
					  VAR)))
	     (SETQ D (PWTAYLOR (m^ D E) VAR 0. 3.))
	     (RETURN (M* C (VARINVERT D VAR))))) 

(DEFUN VARINVERT (E VAR) (SUBIN (m^t VAR -1.) E)) 

(DEFUN DEG (P)
       (PROG (VARLIST)
	     (SETQ VARLIST (LIST VAR))
	     (RETURN ((LAMBDA ($RATFAC)
			      (NEWVAR P)
			      (PDEGR (CADR (RATREP* P))))
		      NIL))))

(DEFUN RAT-NO-RATFAC (E)
       ((LAMBDA ($RATFAC)
		(NEWVAR E)
		(RATREP* E))
	NIL))
(SETQ LOW* NIL) 

(DEFUN RDDEG (RD LOW*) 
       (COND ((OR (MNUMP RD)
		  (NOT (AMONG VAR RD))) 
	      0.)
	     ((POLYP RD)
	      (DEG RD))
	     ((SIMPLERD RD)
	      (M* (DEG (CADR RD)) (CADDR RD)))
	     ((mtimesp rd)
	      (ADDN (MAPCAR #'(LAMBDA (J) 
				(RDDEG J LOW*))
			    (CDR RD)) NIL))
	     ((and (mplusp rd)
		   (SETQ RD (ANDMAPCAR #'(LAMBDA (J) (RDDEG J LOW*))
				       (CDR RD))))
	      (COND (LOW* (RATMIN RD))
		    (T (RATMAX RD)))))) 

(DEFUN PDEGR (PF) 
       (COND ((OR (ATOM PF) (NOT (EQ (CAADR (RATF VAR)) (CAR PF))))
	      0.)
	     (LOW* (CADR (REVERSE PF)))
	     (T (CADR PF))))
;There is some confusion here. We need to be aware of Branch cuts etc....
;when doing this section of code. It is not very carefully done so there
;are bugs still lurking. Another misfortune is that LIMIT or its inferiors
;somtimes decides to change the limit VAL in midstream. This must be corrected
;since LIMIT's interaction with the data base environment must be maintained.
;I'm not sure that this code can ever be called with VAL other than $INF but
;there is a hook in the first important cond clause to cathc them anyway.

(DEFUN ASY (N D) 
  (let ((num-power (rddeg n nil))
	(den-power (rddeg d nil))
	(coef ())  (coef-sign ())  (power ()))
    (setq coef (m// ($RATCOEF N VAR num-power) ($ratcoef d var den-power)))
    (setq coef-sign (getsignl coef))
    (setq power (m// num-power den-power))
    (cond ((eq (ask-integer power '$integer) '$integer)
	   (cond ((eq (ask-integer power '$even) '$even)  '$even)
		 (t   '$odd)))) ;Can be extended from here.
    (COND ((or (eq val '$minf)
	       (eq val '$zerob)
	       (eq val '$zeroa)
	       (equal val 0))  ()) ;Can be extended to cover some these.
	  ((RATGREATERP den-power num-power)
	   (COND ((EQUAL coef-sign 1.)  '$ZEROA)
		 ((equal coef-sign -1)  '$zerob)
		 ((equal coef-sign 0)   0)
		 (t 0)))
	  ((RATGREATERP num-power den-power)
	   (COND ((EQUAL coef-sign 1.)  '$INF)
		 ((equal coef-sign -1)  '$minf)
		 ((equal coef-sign 0)   0)           ;Questionable!
		 ((null coef-sign)   '$infinity)))
	  (T coef))))

(DEFUN RADLIM (E N D)
  (PROG (NL DL) 
    (COND ((EQ VAL '$INFINITY) (THROW 'LIMIT NIL))
	  ((EQ VAL '$MINF)
	   (SETQ NL (m* var -1))
	   (SETQ N (SUBIN nl n))
	   (SETQ D (SUBIN NL D))
	   (SETQ VAL '$INF))) ;This is the Culprit. Doesn't tell the DATABASE.
    (COND ((EQ VAL '$INF)
	   (SETQ NL (ASYMREDU N))
	   (SETQ DL (ASYMREDU D))
	   (COND 
	    ((OR (RPTROUBLE N) (RPTROUBLE D))
	     (RETURN (LIMIT (m* (RDSGET N) (m^ (RDSGET D) -1.)) VAR VAL T)))
	    (T (RETURN (ASY NL DL))))))
    (SETQ NL (LIMIT N VAR VAL T))
    (SETQ DL (LIMIT D VAR VAL T))
    (COND ((AND (ZEROP2 NL) (ZEROP2 DL))
	   (COND ((OR (POLYP N) (POLYP D))
		  (RETURN (TRY-LHOSPITAL-QUIT N D T)))
		 (T (RETURN (SER0 E N D VAL)))))
	  (T (RETURN ($RADCAN (RATRAD (m// N D) N D NL DL)))))))

(DEFUN RATRAD (E N D NL DL) 
  (PROG (N1 D1) 
	(COND ((EQUAL NL 0) (RETURN 0))
	      ((ZEROP2 DL)
	       (SETQ N1 NL)
	       (COND ((equal dl 0) (SETQ D1 '$INFINITY)) ;No direction Info.
		     ((EQ DL '$ZEROA)
		      (SETQ D1 '$INF))
		     ((EQUAL (SETQ D (BEHAVIOR D VAR VAL)) 1)
		      (SETQ D1 '$INF))
		     ((EQUAL D -1) (SETQ D1 '$MINF))
		     (T (THROW 'LIMIT NIL))))
	      ((ZEROP2 NL)
	       (SETQ D1 DL)
	       (COND ((EQUAL (SETQ N (BEHAVIOR N VAR VAL)) 1)
		      (SETQ N1 '$ZEROA))
		     ((EQUAL N -1) (SETQ N1 '$ZEROB))
		     (T (SETQ N1 0))))
	      (T (RETURN ($RADCAN (RIDOFAB (SUBIN VAL E))))))
	(RETURN (SIMPLIMTIMES (LIST N1 D1)))))

(DEFUN SIMPLIMLN (ARG)
 (LET* ((ARGLIM (LIMIT ARG VAR VAL 'THINK))
	(REAL-LIM (RIDOFAB ARGLIM)))
       (IF (=0 REAL-LIM)
	   (cond ((eq arglim '$ZEROA)  '$MINF)
		 ((eq arglim '$ZEROB)  '$INFINITY)
		 (T (LET ((DIR (BEHAVIOR ARG VAR VAL)))
			 (COND ((EQUAL DIR 1) '$MINF)
			       ((EQUAL DIR -1) '$INFINITY)
			       (T (THROW 'LIMIT T))))))
	   (cond ((eq arglim '$INF) '$INF)
		 ((memq arglim '($MINF $INFINITY)) '$INFINITY)
		 ((memq arglim '($IND $UND)) '$UND)
		 ((equal arglim 1)
		  (let ((dir (behavior arg var val)))
		    (if (equal dir 1) '$zeroa 0)))
		 (T (SIMPLIFY `((%LOG) ,REAL-LIM)))))))

(DEFUN SIMPLIMFACT (EXP VAR VAL ARG)
       (COND ((EQ ARG '$INF) '$INF)
	     ((MEMQ ARG '($MINF $INFINITY $UND $IND)) '$UND)
	     ((AND (MAXIMA-INTEGERP ARG) (> 0 ARG))
	      (LET ((DIR (LIMIT (m+ exp (m* arg -1)) VAR VAL 'THINK))
		     (EVENP (MAXIMA-INTEGERP (QUOTIENT ARG 2.0))))
		    (COND ((OR (AND EVENP
				    (EQ DIR '$ZEROA))
			       (AND (NOT EVENP)
				    (EQ DIR '$ZEROB)))
			   '$MINF)
			  ((OR (AND EVENP
				    (EQ DIR '$ZEROB))
			       (AND (NOT EVENP)
				    (EQ DIR '$ZEROA)))
			   '$INF)
			  (T (THROW 'LIMIT NIL)))))
	      (T (SIMPFACT (LIST '(MFACTORIAL) (RIDOFAB ARG)) 1 NIL)))) 

(defun simplim%erf-%tanh (fn arg) 
  (let ((arglim (limit arg var val 'think)))
    (cond ((eq arglim '$inf) 1)
	  ((eq arglim '$minf) -1)
	  ((eq arglim '$infinity)
	   (let (((rpart . ipart) (trisplit arg))
		 (ans ()) (rlim ()))
	     (setq rlim (limit rpart var origval 'think))
	     (cond ((eq fn '%tanh)
		    (cond ((equal rlim '$inf) 1)
			  ((equal rlim '$minf) -1)))
		   ((eq fn '%erf)
		    (setq ans
			  (limit (m* rpart (m^t ipart -1)) var origval 'think))
		    (setq ans ($asksign (m+ `((mabs) ,ans) -1)))
		    (cond ((or (eq ans '$pos) (eq ans '$zero))
			   (cond ((eq rlim '$inf) 1)
				 ((eq rlim '$minf) -1)
				 (t '$und)))
			  (t '$und))))))
	  ((eq arglim '$und) '$und)
	  ((memq arglim '($zeroa $zerob $ind)) arg)
;;;Ignore tanh(%pi/2*%I) and multiples of the argument.
	  (t (simplify (list (ncons fn) arg))))))

(DEFUN SIMPLIM%ATAN (EXP1) 
       (COND ((ZEROP2 EXP1) EXP1)
	     ((EQ EXP1 '$INF) HALF%PI)
	     ((EQ EXP1 '$MINF)
	      (m*t -1. HALF%PI))
	     (T `((%ATAN) ,EXP1)))) 

(DEFUN SIMPLIMSCH (SCH ARG) 
       (COND ((REAL-INFINITYP ARG)
	      (COND ((EQ SCH '%SINH) ARG) (T '$INF)))
	     ((EQ ARG '$INFINITY) '$INFINITY)
	     ((EQ ARG '$UND) '$UND)
	     (T (LET (($EXPONENTIALIZE T))
		  (RESIMPLIFY (LIST (NCONS SCH) (RIDOFAB ARG))))))) 

(DEFUN SIMPLIMSC (EXP FN ARG) 
       (COND ((MEMQ ARG '($INF $MINF $IND)) '$IND)
	     ((MEMQ ARG '($UND $INFINITY)) '$UND)
	     ((MEMQ ARG '($ZEROA $ZEROB))
	      (COND ((EQ FN '%SIN) ARG)
		    (T (m+ 1 '$zerob))))
	     ((SINCOSHK EXP
			(SIMPLIFY (LIST (NCONS FN) (RIDOFAB ARG)))
			FN))))

(DEFUN SIMPLIM%TAN (ARG) 
   (let ((arg1 (ridofab (limit arg var val 'think))))
     (COND
      ((MEMQ ARG1 '($INF $MINF $INFINITY $IND $UND))  '$UND)
      ((PIP ARG1)  
       (let ((C (TRIGRED (PIP ARG1))))
	 (COND ((not (equal ($imagpart arg1) 0)) '$infinity)
	       ((AND (EQ (CAAR C) 'RAT)
		     (EQUAL (CADDR C) 2) 
		     (GREATERP (CADR C) 0))
		(SETQ ARG1 (BEHAVIOR ARG VAR VAL))
		(COND ((= ARG1 1) '$INF)
		      ((= ARG1 -1) '$MINF)
		      (T '$UND)))
	       ((AND (EQ (CAAR C) 'RAT)
		     (EQUAL (CADDR C) 2) 
		     (LESSP (CADR C) 0))
		(SETQ ARG1 (BEHAVIOR ARG VAR VAL))
		(COND ((= ARG1 1) '$MINF)
		      ((= ARG1 -1) '$INF)
		      (T '$UND)))
	       (T (throw 'limit ())))))
      ((equal arg1 0)
       (setq arg1 (behavior arg var val))
       (cond ((equal arg1 1) '$zeroa)
	     ((equal arg1 -1) '$zerob)
	     (t 0)))
      (t (SIMP-%TAN (LIST '(%TAN) ARG1) 1. NIL)))))

(DEFUN SIMPLIM%ASINH (ARG) 
       (COND ((MEMQ ARG '($INF $MINF $ZEROA $ZEROB $IND $UND))
	      ARG)
	     ((EQ ARG '$INFINITY) '$UND)
	     (T (SIMPLIFY (LIST '(%ASINH) (RIDOFAB ARG)))))) 

(DEFUN SIMPLIM%ACOSH (ARG) 
       (COND ((EQUAL (RIDOFAB ARG) 1.) '$ZEROA)
	     ((EQ ARG '$INF) ARG)
	     ((EQ ARG '$MINF) '$INFINITY)
	     ((MEMQ ARG '($UND $IND $INFINITY)) '$UND)
	     (T (SIMPLIFY (LIST '(%ACOSH) (RIDOFAB ARG))))))

(DEFUN SIMPLIM%ATANH (ARG) 
       (COND ((ZEROP2 ARG) ARG)
	     ((MEMQ ARG '($IND $UND $INFINITY $MINF $INF))
	      '$UND)
	     ((EQUAL (SETQ ARG (RIDOFAB ARG)) 1.) '$INF)
	     ((EQUAL ARG -1.) '$MINF)
	     (T (SIMPLIFY (LIST '(%ATANH) ARG))))) 

(DEFUN SIMPLIM%ASIN-%ACOS (FN ARG) 
       (COND ((MEMQ ARG '($UND $IND $INF $MINF $INFINITY))
	      '$UND)
	     ((AND (EQ FN '%ASIN)
		   (MEMQ ARG '($ZEROA $ZEROB)))
	      ARG)
	     (T (SIMPLIFY (LIST (NCONS FN) (RIDOFAB ARG))))))

(defun simplim$li (order arg val)
  (cond ((and (not (equal (length order) 1))
	      (not (equal (length arg) 1)))  (throw 'limit ()))
	(t (setq order (car order) arg (car arg))))
  (cond ((not (equal order 2))  (throw 'limit ()))
	(t (let (((rpart . ipart) (trisplit arg)))
	     (cond ((not (equal ipart 0))  (throw 'limit ()))
		   (t (setq rpart (limit rpart var val 'think))
		      (cond ((eq rpart '$zeroa)  '$zeroa)
			    ((eq rpart '$zerob)  '$zerob)
			    ((eq rpart '$minf)  '$minf)
			    ((eq rpart '$inf)  '$infinity)
			    (t (simplify (subfunmake '$li (list order)
						     (list rpart)))))))))))

(defun simplim$psi (order arg val)
  (cond ((and (not (equal (length order) 1))
	      (not (equal (length arg) 1)))  (throw 'limit ()))
	(t (setq order (car order) arg (car arg))))
  (cond ((not (equal order 0))  (throw 'limit ()))
	(t (let (((rpart . ipart) (trisplit arg)))
	     (cond ((not (equal ipart 0))  (throw 'limit ()))
		   (t (setq rpart (limit rpart var val 'think))
		      (cond ((eq rpart '$zeroa)  '$minf)
			    ((eq rpart '$zerob)  '$inf)
			    ((eq rpart '$inf)  '$inf)
			    ((eq rpart '$minf)   '$und)
			    ((equal (getsignl rpart) -1)  (throw 'limit ()))
			    (t (simplify (subfunmake '$psi (list order)
						     (list rpart)))))))))))

(COMMENT MORE FUNCTIONS FOR LIMIT TO HANDLE)

(DEFUN LFIBTOPHI (E)
       (COND ((NOT (INVOLVE E '($FIB))) E)
	     ((EQ (CAAR E) '$FIB)
	      ((LAMBDA (LNORECURSE)
		       ($FIBTOPHI (LIST '($FIB) (LFIBTOPHI (CADR E)))))
	       T))
	     (T (CONS (CAR E)
		      (MAPCAR (FUNCTION LFIBTOPHI) (CDR E))))))

;;;     FOLLOWING CODE MAKES $LDEFINT WORK

(DEFMFUN $LDEFINT (EXP VAR LL UL &aux $logabs ans a1 a2)
   (SETQ $LOGABS T ANS (SININT EXP VAR) 
	 A1 ($LIMIT ANS VAR UL '$MINUS) 
	 A2 ($LIMIT ANS VAR LL '$PLUS))
   (AND (MEMQ A1 '($INF $MINF $INFINITY $UND $IND))
	(SETQ A1 (NOUNLIMIT ANS VAR UL)))
   (AND (MEMQ A2 '($INF $MINF $INFINITY $UND $IND))
	(SETQ A2 (NOUNLIMIT ANS VAR LL)))
   ($EXPAND (M- A1 A2)))

(DEFUN NOUNLIMIT (EXP VAR VAL) 
       (SETQ EXP (RESTORELIM EXP))
       (NCONC (LIST '(%LIMIT) EXP VAR (RIDOFAB VAL))
	      (COND ((EQ VAL '$ZEROA) '($PLUS))
		    ((EQ VAL '$ZEROB) '($MINUS))))) 

(DEFUN HIDE (EXP) 
  (COND ((ATOM EXP) EXP)
	((let ((FUNC (MEMQ (CAAR EXP) '(%INTEGRATE %LIMIT %DERIVATIVE %SUM))))
	      (cond ((not (null func))
		     (HIDELIM EXP (CAR FUNC)))
		    (t ()))))
	(T (CONS (CAR EXP) (MAPCAR 'HIDE (CDR EXP))))))

(DEFUN HIDELIM (EXP FUNC) 
       (COND ((OR (EQ FUNC '%INTEGRATE) (EQ FUNC '%SUM))
	      (SETQ FUNC (GENSYM))
	      (PUTPROP FUNC
		       (COND ((OR (NULL (CDDDR EXP))
				  (NOT (EQ VAR (third EXP))))
			      (HIDELIMA EXP))
			     ((AND (NOT (AMONG VAR (fourth EXP)))
				   (NOT (AMONG VAR (fifth EXP))))
			      EXP)
			     (T (NOUNLIMIT EXP VAR VAL)))
		       'LIMITSUB))
	     ((EQ FUNC '%LIMIT)
	      (SETQ FUNC (GENSYM))
	      (PUTPROP FUNC
		       (COND ((EQ VAR (fourth EXP))
			      (NCONC (LIST (first EXP)
					   (second EXP)
					   (third EXP))
				     (SUBST VAL VAR (CDDDR EXP))))
			     ((EQ VAR (CADDR EXP)) EXP)
			     (T (HIDELIMA EXP)))
		       'LIMITSUB))
	     (T (SETQ FUNC (GENSYM))
		(PUTPROP FUNC (HIDELIMA EXP) 'LIMITSUB)))
       FUNC) 

(DEFUN HIDELIMA (E) 
       (COND ((AMONG VAR E) (NOUNLIMIT E VAR VAL)) (T E))) 

;;;Used by Defint also.
(DEFUN OSCIP (E)
       (OR (INVOLVE E '(%SIN %COS %TAN))
	   (AMONG '$%I (%EINVOLVE E))))

(DEFUN %EINVOLVE (E) (COND ((AMONG '$%E E) (%EINVOLVE01 E)))) 

(DEFUN %EINVOLVE01 (E)
       (COND ((ATOM E) NIL)
	     ((MNUMP E) NIL)
	     ((AND (mexptp E)
		   (EQ (CADR E) '$%E)
		   (AMONG VAR (CADDR E)))
	      (CADDR E))
	     (T (ORMAPC (FUNCTION %EINVOLVE) (CDR E))))) 


#-NIL
(DECLARE-TOP(UNSPECIAL *INDICATOR NN* DN* EXP VAR VAL
		    ORIGVAL *LIMORDER TAYLORED 
		    $TLIMSWITCH LOGCOMBED LHP? LHCOUNT $RATFAC))
