import sys
import os
from os import path

if sys.platform == 'win32':
    # by importing wininst functions into the builtin module,
    # post install scripts which check if they are being ran
    # from a wininst installer will now execute as if they were
    # installed via the wininst installer
    try:
        import wininst.wininst as wininst
        from wininst.common import get_enthought_start_menu
        
        et_menu = get_enthought_start_menu()
        
        # Remove the MayaVi link.
        mayavi_link = os.path.join(et_menu, 'MayaVi.lnk')
        if path.exists( mayavi_link ):
            os.remove( mayavi_link )

    except ImportError:
        print "WARNING: wininst module not found, some installs may not be complete"
    
