/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __RECORDING_MANAGER_H__
#define __RECORDING_MANAGER_H__

#include "string.hh"
#include "xml.hh"
#include "channel.hh"
#include "epg.hh"
#include "configuration.hh"
#include "scheduled_recording.hh"

typedef enum
{
	SCHEDULED_RECORDING_STATE_PENDING,
	SCHEDULED_RECORDING_STATE_CURRENT,
	SCHEDULED_RECORDING_STATE_OLD
} ScheduledRecordingState;

class ScheduledRecordingConfigurationSection
{
private:
	Configuration& configuration;
	xmlNodePtr scheduled_recordings_node;	
public:
	ScheduledRecordingConfigurationSection(Configuration& configuration);
	void add(const ScheduledRecording& scheduled_recording);
	void remove(const String& description);
	xmlXPathObjectPtr get_scheduled_recordings();
	xmlNodePtr get_scheduled_recording(const String& description);
};

class RecordingManager
{
private:
	static gboolean is_in(guint value, guint start, guint end);
	static gboolean is_overlapped(guint a, guint b, guint c, guint d);
	static gboolean check_conflict(const ScheduledRecording& a, const ScheduledRecording& b);
	ScheduledRecordingState check(ScheduledRecording& scheduled_recording);
	ScheduledRecordingConfigurationSection* scheduled_recording_configuration_section;
		
public:
	RecordingManager();
	
	xmlNodePtr check();
	void add_scheduled_recording(const ScheduledRecording& scheduled_recording);
	void remove_scheduled_recording(const String& description);
	xmlNodePtr get_scheduled_recording(const String& description);
	xmlXPathObjectPtr get_scheduled_recordings();
	
	gboolean has_scheduled_recordings();
};

#endif
