/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#include "status_icon.hh"
#include "application.hh"
#include "exception_handler.hh"

StatusIcon::StatusIcon()
{
	status_icon = gtk_status_icon_new();
	gtk_status_icon_set_from_icon_name(status_icon, "me-tv");
	gtk_status_icon_set_visible(status_icon, true);

	Glade& glade = Application::get_current().get_glade();
	menu_application_popup = glade.get_widget("menu_application_popup");

	g_signal_connect( G_OBJECT ( status_icon ), "popup_menu", G_CALLBACK ( on_status_icon_popup_menu ), this );
	g_signal_connect( G_OBJECT ( status_icon ), "activate", G_CALLBACK ( on_status_icon_activate ), this );

	g_signal_connect( G_OBJECT ( glade.get_widget("application_menu_item_me_tv") ), "activate", G_CALLBACK ( on_menu_item_me_tv_activate ), this );	
	g_signal_connect( G_OBJECT ( glade.get_widget("application_menu_item_help") ), "activate", G_CALLBACK ( on_menu_item_help_activate ), this );	
	g_signal_connect( G_OBJECT ( glade.get_widget("application_menu_item_about") ), "activate", G_CALLBACK ( on_menu_item_about_activate ), this );	
	g_signal_connect( G_OBJECT ( glade.get_widget("application_menu_item_quit") ), "activate", G_CALLBACK ( on_menu_item_quit_activate ), this );	

	gtk_widget_show_all(menu_application_popup);
}

void StatusIcon::on_status_icon_popup_menu(GtkStatusIcon* widget, guint button, guint activate_time, StatusIcon* status_icon)
{
	TRY
	gtk_menu_popup(GTK_MENU(status_icon->menu_application_popup), NULL, NULL, NULL, NULL, button, activate_time);
	CATCH
}

void StatusIcon::on_status_icon_activate(GtkStatusIcon* widget, StatusIcon* status_icon)
{
	TRY
	Application::get_current().toggle_visibility();
	CATCH
}

void StatusIcon::on_menu_item_me_tv_activate(GtkMenuItem* widget, StatusIcon* status_icon)
{
	TRY
	Application::get_current().toggle_visibility();
	CATCH
}

void StatusIcon::on_menu_item_help_activate(GtkMenuItem* widget, StatusIcon* status_icon)
{
	TRY
	Application::get_current().show_help();
	CATCH
}

void StatusIcon::on_menu_item_about_activate(GtkMenuItem* widget, StatusIcon* status_icon)
{
	TRY
	Application::get_current().show_about();
	CATCH
}

void StatusIcon::on_menu_item_quit_activate(GtkMenuItem* widget, StatusIcon* status_icon)
{
	TRY
	Application::get_current().quit();
	CATCH
}

void StatusIcon::set_title(const String& title)
{
	gtk_status_icon_set_tooltip(status_icon, title.c_str());
}
