C*************************************************************************
C COPYRIGHT (C) 1999 - 2003  EDF R&D
C THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
C AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
C EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
C
C THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
C
C YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
C ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
C INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
C
C**************************************************************************

C ******************************************************************************
C * - Nom du fichier : test3.f
C *
C * - Description : lecture des informations sur les maillages dans un fichier
C*                  MED.
C *
C ******************************************************************************
      program test3
C     
      implicit none
      include 'med.hf'
C
C
      integer       cret,ret, fid,cres,type
      character*32  maa
      character*80  nomu
      character*200 desc
      integer       nmaa,i,mdim,edim
      
C ** Ouverture du fichier en lecture seule
      call efouvr(fid,'test2.med',MED_LECTURE, cret)
      print *,cret

C ** lecture du nombre de maillage                      **
      if (cret .eq. 0) then
         call efnmaa(fid,nmaa,cret)
         print *,'Nombre de maillages = ',nmaa
      endif
      print *,cret

C ** lecture des infos sur les maillages : **
C ** - nom, dimension, type,description
C ** - options : nom universel, dimension de l'espace
      if (cret.eq.0) then
         do i=1,nmaa  
            if (cret.eq.0) then               
               call efmaai(fid,i,maa,mdim,type,desc,cret)
               edim = -1
               call efespl(fid,maa,edim,cres)
	       call efunvl(fid,maa,nomu,ret)
               cret = cret + ret
               print '(A,I1,A,A4,A,I1,A,A65,A65)','maillage '
     &                ,i,' de nom ',maa,' et de dimension ',mdim,
     &                ' de description ',desc
     &                ,'et de nom univ. ',nomu
               if (type .eq. MED_NON_STRUCTURE) then
                  print *,'Maillage non structure'
               else
                  print *,'Maillage structure'
               endif
               if (cres .eq. 0) then
                  print *,'Dimension espace ', edim
               else
                  print *,'Dimension espace ', mdim
               endif
               print *,cret
            endif
         enddo         
      endif
         
C **  fermeture du fichier
      call efferm (fid,cret)
      print *,cret

      end 

