/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_outils.h> 
#include <string.h>

med_err
MEDdemonter(med_idt fid,med_idt mid, med_type_donnee type)
{
  med_err ret;
  med_idt root,did;
  char chemin[2*MED_TAILLE_NOM+1];
  char acces_montage[2*MED_TAILLE_NOM+1];

  /*
   * On inhibe le gestionnaire d'erreur HDF
   */
  _MEDmodeErreurVerrouiller();

  /*
   * On accede au type de la donnee
   */
  switch(type) {

  case MED_MAILLAGE :
   strcpy(chemin,MED_MAA);
    break;

  case MED_CHAMP :
    strcpy(chemin,MED_CHA);
    break;

  default :
    return -1;
  }


  /* 
   * On supprime le lien avec les champs|maillages du fichier a demonter 
   */
  chemin[strlen(chemin)-1] = '\0'; 
  if ((ret = _MEDdatagroupLienSupprimer(fid,chemin)) < 0)
    return -1;    

  /*
   * On demonte le fichier dans MED_MNT
   */
  strncpy(acces_montage,MED_MNT,strlen(MED_MNT)-1);
  acces_montage[strlen(MED_MNT)-1] = '\0';
  if ((ret = _MEDfichierDemonter(fid,acces_montage)) < 0)
    return -1;

  /*
   * On ferme le fichier que l'on vient de demonter
   */
  if ((ret = _MEDfichierFermer(mid)) < 0)
    return -1;  

  return ret;
}
