<?php
/*
 * Copyright 2003-2004 Jamin W. Collins <jcollins@asgardsrealm.net>
 * Copyright 2001-2003 Tony Collins
 *
 * This file is part of Media Mate
 * 
 * Media Mate is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Media Mate is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Media Mate; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 */

function dumpVar ($var, $name = "Variable") {
   //TODO: add debug check of some sort here
   echo "\n<!-- $name Dump\n";
   var_dump($var);
   echo "-->\n";
}

class MediaMate {

   var $dbtype;
   var $dblink;
 
/*
   function cleanseInput($string) {
      // replace ' with '' and ; with empty space
      $search = array("'", ";");
      $replace = array("''", "");
      
      $string = str_replace($search, $replace, $string);

      return $string;
   }
*/
   /* Replace undef values (treated as NULL in SQL database) with empty
   strings.
   @param arr  input array or false
   @return     SQL safe array (without undefined values)
   */
/*
   function dbUndefToEmpty($arr) {
       if (is_array($arr)) {
          $c = count($arr);

          for($i=0; $i<$c; $i++)
              if (!isset($arr[$i])) 
                  $arr[$i] = '';
       }
       return $arr;
   }
*/ 
   function getGlobalPrefs() {
      $get_prefs = $this->dbExec("SELECT name, value FROM global_prefs");
      
      $global_prefs = array();
      
      while (list($pref, $value) = $this->dbFetchRow($get_prefs)) {
         $temp_array = array("$pref"  => "$value");
         $global_prefs = $global_prefs + $temp_array;
      }
      
      return $global_prefs;
   }
   
   function dbOpen($dbhost = '', $dbuser = '', $dbpass = '', $dbname = '', 
      $dbtype = '') {
   
         $this->dbtype = $dbtype;

         $this->dblink = NewADOConnection($dbtype);
         $this->dblink->Connect($dbhost, $dbuser, $dbpass, $dbname);

         return true;
   }

   function dbClose() {
      $this->dblink->Close();
   }

   function dbExec($sql, $inputarr=false) {
      $ADODB_FETCH_MODE = ADODB_FETCH_ASSOC;
      
      dumpVar ($sql, "SQL Query");
      $result =  $this->dblink->Execute($sql, $inputarr) or 
         die($this->dblink->ErrorMsg());
      return $result;
   }
   
   function dbCountRows($result) {
      $num_rows = $result->RecordCount();
      return $num_rows;
   }

   function dbFetchRow(&$result) {
      $row = $result->FetchRow();
      return $row;
   }

// Compatibility functions
//    These functions will be phased out, the above functions should
//    be used instead

   function dbQuery($sql, $inputarr=false) {
      $result = $this->dbExec($sql, $inputarr);
      return $result;
   }

   function dbFetchArray(&$result) {
      $row = $this->dbFetchRow($result);
      return $row;
   }

}

?>
