/* interval.c -- check interval setting
 *
 * Copyright(C) 2001-2002 Elisa Manara <e@entropika.net>
 * This code is released under the GPL License version 2 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include "melon.h"

GtkWidget *entry;
static void update_interval(GtkWidget *widget, gpointer user_data);

gint set_interval (GtkWidget *widget, gpointer data)
{
	GtkWidget *window;
	GtkWidget *vbox, *hbox1, *hbox2;
	GtkWidget *button, *label;
	char text[16];

	/* window */
	window = gtk_window_new( GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
	gtk_widget_set_usize( GTK_WIDGET (window), 200, 50);
	gtk_window_set_title(GTK_WINDOW (window), "Set Interval");
	gtk_widget_show(window);

	/* vbox */
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( window ), vbox );
	gtk_widget_show( vbox );

	/* hbox1 */
	hbox1 = gtk_hbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( vbox ), hbox1);
	gtk_widget_show( hbox1 );

	/* label */
	label = gtk_label_new ("Interval (ms): ");
	gtk_box_pack_start (GTK_BOX (hbox1), label, FALSE, FALSE, 5);
	gtk_widget_show(label);

	/* entry */
	entry = gtk_entry_new();
	gtk_entry_set_max_length (GTK_ENTRY( entry ), 16);

	snprintf(text, 16, "%d", cfg_data.interval);
	gtk_entry_set_text (GTK_ENTRY( entry ), text);
	gtk_box_pack_start (GTK_BOX (hbox1), entry, FALSE, FALSE, 5);
	gtk_widget_show(entry);

	/* hbox2 */
	hbox2 = gtk_hbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( vbox ), hbox2);
	gtk_widget_show( hbox2 );

	/* APPLY button */
	button = gtk_button_new_with_label ("Apply");
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(update_interval), NULL);
	gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
	gtk_widget_show (button);

	/* CLOSE button */
	button = gtk_button_new_with_label ("Close");
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy),
		GTK_OBJECT (window));
	gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
	gtk_widget_show (button);

	return 1;

}

void update_interval(GtkWidget *widget, gpointer user_data)
{
	char *text;

	text = gtk_editable_get_chars(GTK_EDITABLE( entry ), 0, -1);
	if (text[0] != '\0') {
		cfg_data.interval = atoi(text);
		g_free(text);
	}

	dialog_message (" Interval value updated ");
	config_update();

	return;
}
	
