/*
dnsdcc.h - MessageWall DNS DCC declarations
Copyright (C) 2002 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _DNSDCC_H
#define _DNSDCC_H

#include <firestring.h>
#include "messagewall.h"

#define DNSDCC_BA_MAXLEN 1024

#define DNSDCC_WHITESPACE " \t\r\n"

char *dnsdcc_checksum_aa(struct firestring_estr_t *chunk);
char *dnsdcc_checksum_ba(struct firestring_estr_t *chunk);
int dnsdcc_clear_queries(int client);
int dnsdcc_send_queries(int client, int part, char * (*check)(struct firestring_estr_t *), struct firestring_estr_t *chunk);
int dnsdcc_resend_queries(int client);
int dnsdcc_response(int client, int part, int dnsdcc);
int dnsdcc_check_profile(int client, int force);

#endif
