/*
------------------------------------------------------------------------------
MetaCam - Extract EXIF information from digital camera files, with
support for Vendor specific blocks.
Copyright (C) 2000 Daniel Stephens (daniel@cheeseplant.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
------------------------------------------------------------------------------
*/

#include "dpyfuncs.h"

static const char *rcsid="$Id: nikontags.cc,v 1.2 2000/05/29 22:11:28 daniel Exp $";

// Nikon tags reverse engineered from a huge collection of well labeled images
// on imaging-resource.com (Great Site BTW)

knowntag nikon_known[] = {
    {0x0001, 7, 0, "        Nikon Version Number", dpyExifVersion},
    {0x0002, 3, 0, "              ISO Equivalent", dpyISO},
    {0x0003, 2, 0, "                    Color/BW", dpyString},
    {0x0004, 2, 0, "                 File Format", dpyString},
    {0x0005, 2, 0, "               White Balance", dpyString},
    {0x0006, 2, 0, "                  Sharpening", dpyString},
    {0x0007, 2, 0, "                       Focus", dpyString},
    {0x0008, 2, 0, "               Flash Mode???", dpyString},
    {0x0009, 2, 0, "      Flash Metering mode???", dpyString},
    {0x000b, 8, 0, "    White Balance Adjustment", dpySigned},
    {0x0084, 5, 0, "                        Lens", dpyLens},
    {0x0081, 2, 0, "     Some String Setting ???", dpyString},
//  {0x000c, 5, 0, "         ??? White Point ???", 0},
    {0,0,0,0}
};

