/* Metacity fixed tooltip routine */

/* 
 * Copyright (C) 2001 Havoc Pennington
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "fixedtip.h"

static GtkWidget *tip = NULL;
static GtkWidget *label = NULL;

static gint
expose_handler (GtkTooltips *tooltips)
{
  gtk_paint_flat_box (tip->style, tip->window,
                      GTK_STATE_NORMAL, GTK_SHADOW_OUT, 
                      NULL, tip, "tooltip",
                      0, 0, -1, -1);

  return FALSE;
}

void
meta_fixed_tip_show (Display *xdisplay,
                     int root_x, int root_y,
                     const char *markup_text)
{
  if (tip == NULL)
    {
      tip = gtk_window_new (GTK_WINDOW_POPUP);
      gtk_widget_set_app_paintable (tip, TRUE);
      gtk_window_set_policy (GTK_WINDOW (tip), FALSE, FALSE, TRUE);
      gtk_widget_set_name (tip, "gtk-tooltips");
      gtk_container_set_border_width (GTK_CONTAINER (tip), 4);

      gtk_signal_connect_object (GTK_OBJECT (tip), 
				 "expose_event",
				 GTK_SIGNAL_FUNC (expose_handler),
                                 NULL);

      label = gtk_label_new (NULL);
      gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
      gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
      gtk_widget_show (label);
      
      gtk_container_add (GTK_CONTAINER (tip), label);

      gtk_signal_connect (GTK_OBJECT (tip),
			  "destroy",
			  GTK_SIGNAL_FUNC (gtk_widget_destroyed),
			  &tip);
    }
  
  gtk_widget_set_uposition (tip, root_x, root_y);
  gtk_label_set_markup (GTK_LABEL (label), markup_text);

  gtk_widget_show (tip);
}

void
meta_fixed_tip_hide (void)
{
  if (tip)
    {
      gtk_widget_destroy (tip);
      tip = NULL;
    }
}
