/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QColor>
#include <QComboBox>
#include <QCursor>
#include <QDebug>
#include <QFile>
#include <QMenu>
#include <QMenuBar>
#include <QMessageBox>
#include <QSettings>
#include <QSortFilterProxyModel>
#include <QSplitter>
#include <QStackedWidget>
#include <QString>
#include <QStringList>
#include <QToolBar>
#include <QTextBrowser>
#include <QTreeView>
#include <QVBoxLayout>

#include <iostream>
#include <sstream>
#include <fstream>
#include <cstdio>
#include <stdio.h>
#include <stdlib.h>

#include "MvFileInfo.h"

#include "MvQObstatCurveTool.h"
#include "MvKeyProfile.h"

#include "MvQFileInfoLabel.h"
#include "MvQObstatCurveToolBase.h"
//#include "MvQGribKeyDialog.h"
//#include "MvQGribStdDumpModel.h"
//#include "MvQGribWmoDumpModel.h"
#include "MvQKeyManager.h"
#include "MvQKeyProfileModel.h"
#include "MvQLogBrowser.h"
//#include "MvQSearchLineBase.h"
#include "MvQTreeView.h"


MvQObstatCurveTool::MvQObstatCurveTool(QWidget *parent) : MvQMainWindow(parent)
{
	setAttribute(Qt::WA_DeleteOnClose);
	
	setWindowTitle("Metview - OBSTAT ScatterPlot Tool");

	QWidget *w;
	QLabel *label;

	//----------------------
	// Examiner base
	//----------------------

	examinerBase_= new MvQObstatCurveToolBase;

	//----------------------
	// Main splitter
	//----------------------

	mainSplitter_= new QSplitter;
	mainSplitter_->setOrientation(Qt::Vertical);

        mainSplitter_->setOpaqueResize(false);
	setCentralWidget(mainSplitter_);
	
	//-----------------------------------------------------
	// The main layout (the upper part of mainSplitter)
	//-----------------------------------------------------
  
	QVBoxLayout *mainLayout = new QVBoxLayout;
        mainLayout->setObjectName(QString::fromUtf8("vboxLayout"));
	mainLayout->setContentsMargins(0,0,0,0);
	//mainLayout->setSpacing(0);
	w=new QWidget;
	w->setLayout(mainLayout);
	mainSplitter_->addWidget(w);

	//------------------
	// File info label
	//------------------
      
 	//Add to layout 
	mainLayout->addWidget(examinerBase_->fileInfoLabel());

	//---------------------
	// Central splitter
	//---------------------

	centralSplitter_ = new QSplitter(this); 
	centralSplitter_->setOpaqueResize(false);	
	mainLayout->addWidget(centralSplitter_);

	//-------------------------
	// Populate central splitter
	//-------------------------
	
	centralSplitter_->addWidget(examinerBase_->itemPanel());
	centralSplitter_->addWidget(examinerBase_->plotPanel());
			
	//--------------------------
	// Log Area
	//--------------------------

	QVBoxLayout *logLayout = new QVBoxLayout;
        logLayout->setObjectName(QString::fromUtf8("vboxLayout"));
	logLayout->setContentsMargins(0,0,0,0);
	w=new QWidget;
	w->setLayout(logLayout);
	mainSplitter_->addWidget(w);

	//Label
	label = new QLabel(tr("Log"));
	label->setFrameShape(QFrame::StyledPanel);
	logLayout->addWidget(label);

	//Log browser
	logBrowser_= new MvQLogBrowser(logLayout);
	
	//----------------------------
	//
	//----------------------------

	setupMenus(examinerBase_->menuItems());
	
	//-------------------------
	//
	//-------------------------
	
	

	readSettings();

	//connect(examinerBase_,SIGNAL(keyProfileLoaded(MvKeyProfile*)),
	//	this,SLOT(slotLoadKeyProfile(MvKeyProfile*)));

	connect(examinerBase_,SIGNAL(logOutputChanged()),
		this,SLOT(slotUpdateLogOutput()));
	
	connect(examinerBase_,SIGNAL(blockSelected(int)),
		this,SLOT(slotSelectBlock(int)));
}
 
MvQObstatCurveTool::~MvQObstatCurveTool()
{
	writeSettings();
}

void MvQObstatCurveTool::init(MvQObstatCurveData *data)
{	
	data_=data;
		
	examinerBase_->init(data_);
	//examinerBase_->fileInfoLabel()->setVisible(fileInfoLabelVisibility_);
}

void MvQObstatCurveTool::slotLoadKeyProfile(MvKeyProfile *prof)
{		
	slotUpdateLogOutput();
}

void MvQObstatCurveTool::slotSelectMessage(int index)
{	
	slotUpdateLogOutput();
}

void MvQObstatCurveTool::slotSelectBlock(int index)
{	
	slotUpdateLogOutput();
}

void MvQObstatCurveTool::slotUpdateLogOutput()
{
	logBrowser_->update();
}

void MvQObstatCurveTool::writeSettings()
{
	QSettings settings("ECMWF","MvQObstatCurveTool");
	
	settings.beginGroup("mainWindow");
	settings.setValue("geometry",saveGeometry());
	settings.setValue("centralSplitter",centralSplitter_->saveState());
	settings.setValue("mainSplitter",mainSplitter_->saveState());

	//settings.setValue("fileInfoLabelVisibility",examinerBase_->fileInfoLabel()->isVisible());
	//qDebug() << "label: " << examinerBase_->fileInfoLabel()->isVisible();

	settings.endGroup();
}

void MvQObstatCurveTool::readSettings()
{
	QVariant value;

	QSettings settings("ECMWF","MvQObstatCurveTool");
	
	settings.beginGroup("mainWindow");
	restoreGeometry(settings.value("geometry").toByteArray());
	centralSplitter_->restoreState(settings.value("centralSplitter").toByteArray());
	mainSplitter_->restoreState(settings.value("mainSplitter").toByteArray());

	//fileInfoLabelVisibility_=settings.value("fileInfoLabelVisibility").toBool();
	//qDebug() << "label: " << fileInfoLabelVisibility_;

	settings.endGroup();
}
