/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef FolderInfo_H
#define FolderInfo_H

#include <map>
#include <string>

#include "Path.h"

using namespace std;

class Folder;
class IconInfo;
class Request;

class FolderInfo 
{
public:
	FolderInfo(Folder*);

	void write();
	IconInfo* add(const string &, IconInfo*);
	IconInfo* add(const string&,const string&);
	IconInfo* add(const string &, const Request&);
	IconInfo* find(const string&);
	void remove(const string &);
	void rename(const string &,const string &);

	static bool read(const Path& folderPath,std::map<std::string,std::string>& icons);

protected:
  	void read();
	void check();
  	
	Folder* folder_;
	std::map<string,IconInfo*> info_;
	bool checkWasDone_;
	
	static std::string fileName_;		
};

#endif