/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef LayoutDrawer_H
#include "LayoutDrawer.h"
#endif

#ifndef EditorDrawerFactory_H
#include "EditorDrawerFactory.h"
#endif

#ifndef ViewEditor_H
#include "ViewEditor.h"
#endif


LayoutDrawer::LayoutDrawer(ViewEditor& e):
	XEditorDrawer<UILayoutDrawer_c>(e),
	editor_(e)
{
}

LayoutDrawer::~LayoutDrawer()
{
}

void LayoutDrawer::update()
{
}

// Callbacks
void LayoutDrawer::splitVerCB(Widget w,XtPointer)
{
	editor_.splitSelection(1,atoi(XtName(w)),0,0);
}

void LayoutDrawer::splitHorCB(Widget w,XtPointer)
{
	editor_.splitSelection(atoi(XtName(w)),1,0,0);
}

void LayoutDrawer::groupSelectionCB(Widget w,XtPointer)
{
	editor_.groupSelection();
}

void LayoutDrawer::ungroupSelectionCB(Widget w,XtPointer)
{
	editor_.ungroupSelection();
}

void LayoutDrawer::joinSelectionCB(Widget w,XtPointer)
{ 
	editor_.joinSelection();
}

void LayoutDrawer::deleteSelectionCB(Widget w,XtPointer)
{
	editor_.deleteSelection();
}

void LayoutDrawer::addPageCB(Widget w,XtPointer)
{
	editor_.addPage();
}


static EditorDrawerMaker<LayoutDrawer,ViewEditor> maker(12);
