/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef PlotModHelp_H
#include "PlotModHelp.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef Parameter_H
#include "Parameter.h"
#endif

#ifndef HelpFactory_H
#include "HelpFactory.h"
#endif

#ifndef RequestPanel_H
#include "RequestPanel.h"
#endif

#include <mars.h>

PlotModHelp::PlotModHelp(Widget parent, RequestPanel& owner, const Parameter& def):
	DialogHelp(parent, owner, def)
{     
}

PlotModHelp::~PlotModHelp()
{
}

void PlotModHelp::start()
{
        attach(); // Will be decremented by ReplyHandler, so make sure it stays alive.

	Request info = param_.interfaceRequest();

	Request request("EDIT_MAP");

	// The parameter is in lower case because it
	// will be used to build the icon filename
	Cached input          = info("input_type");
	request("INPUT_TYPE") = input.toUpper();

        request("CUSTOM_WIDTH")  = 14.8;
	request("CUSTOM_HEIGHT") = 10.5;

	request = request + owner_.request();

	observe();

	callService("GeoToolManager", request);
}

void PlotModHelp::set(Request& r) 
{
	cout << "PlotModHelp::set " << endl;
//r.print();
	r.merge(request_);
	request_ = Request();
}

void PlotModHelp::reply(const Request& reply, int error)
{
	 if ( error == 0 ) reply.print();
}

void PlotModHelp::progress(const Request& progress)
{
	progress.print();
	request_ = progress;
	owner_.changed(*this);
}

void PlotModHelp::message(const string& msg)
{
	  cout << "PlotModHelp::message" << msg << endl;
}

void PlotModHelp::message(const Request& msg)
{
	  string s = msg.getVerb();
	  if (s != "INPUT") return;

          request_ = owner_.request();
	  request_.merge(msg);
          owner_.changed(*this);
}

static HelpMaker<PlotModHelp> maker("help_input");
