/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQVisDefManager_H
#define MvQVisDefManager_H

#include <iostream>
#include <map>
#include <vector>
#include <list>

#include <QMap>
#include <QString>
#include <QStringList>

using namespace std;

class MvKeyProfile;
//class MvRequest;
#include "MvRequest.h"

class MvQVisDef
{
public:
	MvQVisDef(QString name) : name_(name) {};
	QString name() {return name_;}

	const QMap<QString,QStringList>& keys() const {return keys_;}
	QStringList keyNames() {return keys_.keys();} 
	QStringList keyValues(QString key) {return (keys_.contains(key))?keys_[key]:QStringList();}
	const QStringList &visDefs() const {return visDefs_;}	

	void addKey(QString,QString);
	void addVisDef(QString visDef) {visDefs_.push_back(visDef);}

public:
	QString name_;
	QMap<QString,QStringList> keys_;
	QStringList  visDefs_;
}; 

class MvQVisDefManagerBase
{
public:
	enum DataType {GribType};

	virtual ~MvQVisDefManagerBase();
	MvQVisDef* addItem(QString);
	const QStringList& keys() {return keys_;}
	QString classType() {return classType_;}

	virtual QStringList visDefFile(MvKeyProfile*,int) {return QStringList();}
	virtual MvRequest visDefRequest(MvKeyProfile*,int) {return MvRequest();}

	bool isLoaded() {return loaded_;}
	void clear();
	void deleteItem(int);
	virtual void loadItems()=0 ;
	virtual void saveItems()=0 ;

protected:
	MvQVisDefManagerBase(string,DataType);	
	void collectKeys();

	//void createDefaultProfile(MvKeyProfile*);
	string fConf_;
	DataType dataType_;
	QString classType_;
	QMap<DataType,QString> dataTypeName_;
	QList<MvQVisDef*> items_;
	QStringList keys_;
	bool loaded_;	
};


class MvQVisDefManager : public MvQVisDefManagerBase
{
public:
	MvQVisDefManager(string,DataType);
	~MvQVisDefManager() {};

	QStringList visDefFile(MvKeyProfile*,int);
	void loadItems();
	void saveItems();	
};

class MvQObstatVisDefManager : public MvQVisDefManagerBase
{
public:
	MvQObstatVisDefManager(string,DataType);
	~MvQObstatVisDefManager() {};

	MvRequest visDefRequest(MvKeyProfile*,int);
	void loadItems();
	void saveItems() {};	

private:
	MvRequest baseRequest_;
};


#endif
