/* Copyright 2005 Matt Flax <flatmax@ieee.org>
   This file is part of MFFM GTK wrapper class set

   MFFM GTK wrapper class set is free software; you can redistribute
   it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MFFM GTK wrapper class set is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You have received a copy of the GNU General Public License
   along with MFFM GTK wrapper class set
 */
#ifndef SEPARATOR_H_
#define SEPARATOR_H_

#include <iomanip>
#include <gtk/gtk.h>
#include <mffm/LinkList.H>

class Separator : public LinkList<GtkWidget *> {
public:
  ~Separator(void){
    GtkWidget *temp;
    while (getCount()){
      temp=remove();
      gtk_widget_unref(temp);
    }
  }
};

class VSeparator : public Separator {
public:
  VSeparator(void){
    vSepAlloc(1);
  }

  VSeparator(int count){
    vSepAlloc(count);
  }

  void vSepAlloc(int count){
    for (int i=0;i<count;i++){
      add(gtk_vseparator_new());
      gtk_widget_ref(current());
      gtk_widget_show(current());
    }
  }
};

class HSeparator : public Separator {
public:
  HSeparator(void){
    hSepAlloc(1);
  }

  HSeparator(int count){
    hSepAlloc(count);
  }

  void hSepAlloc(int count){
    for (int i=0;i<count;i++){
      add(gtk_hseparator_new());
      gtk_widget_ref(current());
      gtk_widget_show(current());
    }
  }
};
#endif //SEPARATOR_H_
