/* Copyright 2005 Matt Flax <flatmax@ieee.org>
   This file is part of MFFM GTK wrapper class set

   MFFM GTK wrapper class set is free software; you can redistribute
   it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MFFM GTK wrapper class set is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You have received a copy of the GNU General Public License
   along with MFFM GTK wrapper class set
 */
#ifndef GTKINTERFACE_H_
#define GTKINTERFACE_H_

#include <gtk/gtk.h>
#include "Pixmap.H"
#include "Box.H"
#include "Separator.H"
#include "Labels.H"
#include "Buttons.H"

#define LOCKSEMAPHORE gdk_threads_enter()
#define UNLOCKSEMAPHORE gdk_threads_leave()

class GtkInterface {
public:
  GtkWidget *win;
  //  GtkInterface(int argc, char *argv[]);
  GtkInterface(void){
#ifdef DEBUG
    cout<<"GtkInterface: init "<<this<<endl;
#endif
    //int argc=0;
    win = gtk_window_new( GTK_WINDOW_TOPLEVEL );
    //gtk_widget_ref( win );
    gtk_signal_connect( GTK_OBJECT (win), "delete_event",
			GTK_SIGNAL_FUNC (quit), NULL );
    gtk_container_set_border_width( GTK_CONTAINER (win), 10 );
    gtk_widget_show( win );
  }

  ~GtkInterface(void){
#ifdef DEBUG
    cout<<"GtkInterface::~GtkInterface "<<endl;
#endif
    //    gtk_widget_unref( win );
    //gtk_widget_destroy( win );
    gtk_widget_hide( win );
  }

  static gint quit(GtkWidget *widget, GdkEvent *event, gpointer data){
    gtk_main_quit();
    return 0;
  }

  GtkInterface& operator <<(Box& b) {
    gtk_container_add (GTK_CONTAINER (win), b.getWidget());
    return *this;
  }
  GtkInterface& operator <<(Box * b) {
    gtk_container_add (GTK_CONTAINER (win), b->getWidget());
    return *this;
  }
  GtkInterface& operator <<(GtkWidget * w) {
    gtk_container_add (GTK_CONTAINER (win), w);
    return *this;
  }
  GtkInterface& operator >>(GtkWidget * w) {
    gtk_container_remove (GTK_CONTAINER (win), w);
    return *this;
  }
};
#endif
