/*  MikMod example player
	(c) 1999 Miodrag Vallat and others - see file AUTHORS for
	complete list.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
 
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

/*==============================================================================

  $Id: mwidget.h,v 1.1.1.1 2003/09/19 13:16:01 raph Exp $

  Widget and Dialog creation functions

==============================================================================*/

#ifndef MWIDGET_H
#define MWIDGET_H

#include "mwindow.h"

#define EVENT_HANDLED 100

#define FOCUS_NEXT     (1)               /* next widget gets focus */
#define FOCUS_PREV     (-1)              /* prev widget gets focus */
#define FOCUS_ACTIVATE (EVENT_HANDLED+1) /* button select, return in input field */

typedef enum {
	WID_GET_FOCUS,
	WID_HOTKEY,
	WID_KEY
} WID_EVENT;

typedef enum {
	TYPE_LABEL,
	TYPE_STR,
	TYPE_INT,
	TYPE_BUTTON
} WID_TYPE;

typedef struct {
	int active;             /* active widget */
	int cnt;                /* Nuber of widgets */
	MWINDOW *win;
	struct WIDGET **widget; /* the widgets */
} DIALOG;

typedef struct WIDGET {
	WID_TYPE type;
	BOOL can_focus; /* can the widget have the focus */
	BOOL has_focus; /* has this widget the focus */
	int x;          /* x-pos of widget(is calculated) */
	int y;          /* Before dialog_open():
	                   spacing(-1: Widget on the right side of last widget)
	                   After dialog_open():
	                   y-pos of widget */
	void(*w_free)(struct WIDGET*);
	void(*w_paint)(DIALOG*,struct WIDGET*);
	int(*w_handle_event)(DIALOG*,struct WIDGET*,WID_EVENT,int);
	void(*w_get_size)(struct WIDGET*,int*,int*);

	int(*handle_key)(DIALOG*,struct WIDGET*,int);
	int(*handle_focus)(DIALOG*,struct WIDGET*,int);
	void *data;     /* not used by menu functions */
} WIDGET;

typedef int(*handleKeyFunc)(DIALOG*,struct WIDGET*,int);
typedef int(*handleFocusFunc)(DIALOG*,struct WIDGET*,int);

/* Free substructs of w and w itself */
typedef void(*freeFunc)(WIDGET*);
/* Display widget w */
typedef void(*paintFunc)(DIALOG*,WIDGET*);
/*
   GET_FOCUS: Widget w gets the focus
     ch: -1: Last active widget was behind the new one
          1: Last active widget was before the new one
   HOTKEY:
     ch: The Key which was pressed
     back:
       FOCUS_ACTIVATE: Widget w gets the focus
       EVENT_HANDLED : Focus is not changed, Key is not processed any more,
                       e.g. necessary if function closes the dialog
   KEY: Key ch was pressed
     back:
       +/-n : Widget n entries before/behind Widget w gets the focus
       EVENT_HANDLED: Key is not processed any more
       0 : event HOTKEY is send to the widgets
*/
typedef int(*handleEventFunc)(DIALOG*,WIDGET*,WID_EVENT,int);
/* Return the size of widget w */
typedef void(*getSizeFunc)(WIDGET*,int*,int*);

typedef struct {
	WIDGET w;
	char *msg;
} WID_LABEL;

typedef struct {
	WIDGET w;
	char *input;
	int width;   /* width of input field */
	int cur_pos; /* cursor position */
	int start;   /* first visible char */
	int length;  /* max length of input */
} WID_STR;

typedef struct {
	WIDGET w;
	char *input;
	int width;   /* width of input field */
	int cur_pos; /* cursor position */
	int start;   /* first visible char */
	int length;  /* max length of input */
} WID_INT;

typedef struct {
	WIDGET w;
	char *button; /* &but1|but2|... */
	int cnt;      /* Number of buttons */
	int active;   /* active button */
} WID_BUTTON;

/* spacing: -1 : Widget on the right side of last widget
		    >=0: Number of free lines to last widget */
WIDGET* wid_label_add(DIALOG*,int,char*);
WIDGET* wid_str_add(DIALOG*,int,char*,int);
WIDGET* wid_int_add(DIALOG*,int,int,int);
WIDGET* wid_button_add(DIALOG*,int,char*,int);

void wid_set_func(WIDGET*,handleKeyFunc,handleFocusFunc,void*);

DIALOG* dialog_new(void);
void dialog_open(DIALOG*,char*);
BOOL dialog_repaint(MWINDOW*);
void dialog_close(DIALOG*);

#endif /* MWIDGET_H */
