.\" Hey, Emacs!  This is an -*- nroff -*- source file.
.\" Install-mime and this manpage were written by Brian White and
.\" have been placed in the public domain.
.\"
.TH INSTALL-MIME 8 "16th Aug 1998" "Debian Project" "Install MIME Programs"
.SH NAME
install\-mime
.B [obsolete]
\- create or update MIME information
.SH SYNOPSIS
.B install\-mime
[\-\-install] [\-\-remove] [\-\-list]
[\-\-package=<pkg\-name>] [\-\-content=<content\-type>]
[\-\-comment=<string>]
[\-\-test=<conditional>] [\-\-needsterminal=<t/f>]
[\-\-copiousoutput=<t/f>] [\-\-description=<string>]
[\-\-textualnewlines=<t/f>] [\-\-x11\-bitmap=<pathname>]
[\-\-nametemplate=<string>] [\-\-view=<program\-string>]
[\-\-compose=<program\-string>] [\-\-composetyped=<program\-string>]
[\-\-edit=<program\-string>] [\-\-print=<program\-string>]
.SH DESCRIPTION
.PP
.B install-mime
makes, updates or removes entries from the
.B /etc/mailcap
file.

.B install-mime
is
.B obsolete!
Please use
.B update-mime
instead.

.SS OPTIONS
All options are in the form --<opt>[=<value>].  Values can be a
'pkg-name' (any valid package name -- sans version numbers -- as
accepted by dpkg), 'content-type' (any valid content-type as
recognized by MIME), 'conditional' (a valid shell command line), 't/f'
(a true/false or t/f value), 'string', (any arbitrary ascii string),
\&'pathname' (a path to an existing file), and 'program-string' (how to
call a program with the given content-type as supported by MIME).
.SS Actions
These options specify what is to be done.
.TP
.BI \-\-install
Installs the given commands along with their modifiers into the
database and
.I mailcap
file.  This option requires the
.B \-\-package
and
.B \-\-content
options.
.TP
.BI \-\-remove
Removes all entries for the named package from the database and
.I mailcap
file.  This option requires the
.B \-\-package
option.
.TP
.BI \-\-list
Lists all entries in the database.  The
.B \-\-package
and
.B \-\-content
options can be specified to restrict which items will be listed.
.SS Install Info
.TP
.BI \-\-package=<pkg-name>
Specifies the name of the package under which to create or remove
entries.  This option is mandatory for both the
.B --install
and
.B --remove
actions.
.TP
.BI \-\-comment=<string>
Specifies a comment string to print out if it is necessary to prompt
the user to chose a priority for these commands.  Strings can be as
long as you want.  All newlines and tabs will be removed and the
string reformatted for the width of the screen.
.TP
.BI \-\-content=<content-type>
Specifies the MIME content-type the action applies to.  This option is
mandatory for the
.B --install
action.
.SS Commands
These options specify what to do for the given content-type.
.TP
.BI \-\-view=<program-string>
Specifies the program to run to view a file of the given content-type.
.TP
.BI \-\-compose=<program-string>
The "compose" command may be used to specify a program that can be
used to compose a new body or body part in the given format.  Its
intended use is to support mail composing agents that support the
composition of multiple types of mail using external composing agents.
The result of the composing program may be data that is not yet
suitable for mail transport -- that is, a Content-Transfer-Encoding
may need to be applied to the data.
.TP
.BI \-\-composetyped=<program-string>
The "composetyped" command is similar to "compose", but is to be used
when the composing program needs to specify the Content-type header
field to be applied to the composed data.  The "compose" option is
simpler, and is preferred for use with existing (non-mail-oriented)
programs for composing data in a given format.  The "composetyped"
option is necessary when the Content-type information must include
auxiliary parameters, and the composition program must then know
enough about mail formats to produce output that includes the mail
type information.
.TP
.BI \-\-edit=<program-string>
The "edit" command may be used to specify a program that can be used
to edit a body or body part in the given format.  In many cases, it
may be identical in content to the "compose" command.
.TP
.BI \-\-print=<program-string>
The "print" command may be used to specify a program that can be used to
print a message or body part in the given format.
.SS Modifiers
These options are modifiers to all the commands specified on the
command line.
.TP
.BI \-\-test=<conditional>
The "test" option may be used to test some external condition (e.g.,
the machine architecture, or the window system in use) to determine
whether or not the mailcap line applies.  It specifies a program to be
run to test some condition.  If the test fails, a subsequent mailcap
entry will be sought.  Multiple test options are not permitted --
since a test can call a program, it can already be arbitrarily
complex.
.TP
.BI \-\-needsterminal=<t/f>
The "needsterminal" option, if true, indicates that the commands must
be run on an interactive terminal.  This is needed to inform window-
oriented user agents that an interactive terminal is needed.  (The
decision is not left exclusively to the command because in some
circumstances it may not be possible for such programs to tell whether
or not they are on interactive terminals.)  The needsterminal command
applies to the view, compose and edit commands, if they exist.  Note
that this is NOT a test -- it is a requirement for the environment in
which the program will be executed, and should typically cause the
creation of a terminal window when not executed on either a real
terminal or a terminal window.  (default=false)
.TP
.BI \-\-copiousoutput=<t/f>
The "copiousoutput", if true, indicates that the output from the
view-command will be an extended stream of output, and is to be
interpreted as advice to the UA (User Agent mail-reading program) that
the output should be either paged or made scrollable. Note that it is
probably a mistake if needsterminal and copiousoutput are both
specified.  (default=false)
.SS Content-Type Info
These options provide additional information about the given
content-type.  These will be applied to all entries of that type
whether defined on the same invocation of
.B mime-support
or another.
.TP
.BI \-\-description=<string>
The "description" option simply provides a textual description that
describes the type of data, to be used optionally by mail readers that
wish to describe the data before offering to display it.
.TP
.BI \-\-textualnewlines=<t/f>
The "textualnewlines" option, if set to true, indicates that this type
of data is line-oriented and that, if encoded in a binary format, all
newlines should be converted to canonical form (CRLF) before encoding,
and will be in that form after decoding.  In general, this is needed
only if there is line-oriented data of some type other than text/* or
non-line- oriented data that is a subtype of text.  (default=false)
.TP
.BI \-\-x11-bitmap=<pathname>
The "x11-bitmap" option names a file, in X11 bitmap (xbm) format,
which points to an appropriate icon to be used to visually denote the
presence of this kind of data.
.TP
.BI \-\-nametemplate=<string>
The "nametemplate" option gives a file name format, in which %s will be
replaced by a short unique string to give the name of the temporary
file to be passed to the viewing command.  This is only expected to be
relevant in environments where filename extensions are meaningful,
e.g., one could specify that a GIF file being passed to a gif viewer
should have a name ending in ".gif" by using "nametemplate=%s.gif".
.SS Program settings
These options change the behavior of
.B mime-support
itself.  They have no effect on the final results of the program.
.TP
.BI \-\-quiet
The "quiet" flag will keep
.B mime-support
from generating any unnecessary messages.
.TP
.BI \-\-noparmcheck
The "noparmcheck" flag will tell
.B mime-support
to ignore any unrecognized parameters on the command line.  This flag
is useful
.I only
for allowing install scripts using newer options to work
semi-gracefully with older versions of
.B mime-support.
It should
.I not
be used for any other purpose and should be removed as soon as
possible.

.SH CONFLICTS
.B Mime-support
will correctly handle situations where multiple packages wish to
provide viewers, editors, and/or composers for the same mime-type.
When such a conflict arises, the user will be presented with a list of
current entries for that type and asked at what priority the new
program is to be inserted.

.I Note:
Because
.I install-mime
can become interactive, it is essential that
.I stdout
not be redirected.  Use the
.B --quiet
option instead.
.SH DEPENDENCIES
Packages that wish to provide MIME access to themselves should not
depend on, recommend, or suggest
.B mime-support,
but rather just put something like the following in the
.I postinst
and
.I prerm
scripts.

.ft CW
.nf
.ne 4
\&    if [ -x /usr/sbin/install-mime ]
\&    then
\&        install-mime [...]
\&    fi
.ft R
.SH "SEE ALSO"
RFC-1524 (/usr/doc/mime-support/rfc1524.txt)
.SH AUTHOR
.B install\-mime
was written by Brian White <bcwhite@pobox.com>
.SH COPYRIGHT
.B install\-mime
is in the public domain (the only true "free").
