Summary: Partition Image
Name: partimage
Version: 0.6.2
Release: 1
Copyright: GPL
Group: Utilities
Source: partimage-0.6.2.tar.bz2
Packager: Francois Dupoux <fdupoux@partimage.org>
%description

Partition Image is a Linux/UNIX partition imaging utility: it saves all used
blocks in a partition to an image file. This image file can be compressed
using gzip or bzip2 compression to save space, and even split into multiple
files to be copied to movable media such as Zip disks or CD-R.

The following partition types are supported:

  - Ext2FS   (the Linux standard)
  - ReiserFS (a new, powerful journalling file system)
  - NTFS     (Windows NT File System)
  - FAT16/32 (DOS & Windows file systems)
  - HPFS     (OS/2 File System)
  - JFS      (IBM Jounalized File System for AIX)
  - XFS      (SGI Jounalized File System for IRIX)
  - HFS      (Hierarchical File System for MacOS)

This allows you to back up a full Linux/Windows system with a single
operation. When problems such as viruses, crashes, or other errors occur, you
just have to restore, and after several minutes your system can be restored
(boot record and all your files) and fully working.

This is also very useful when installing the same software on many machines:
just install one of them, create an image, and just restore the image on all
other machines. Then, after the first one, each machine installation can take
just minutes.

%prep

%setup
%build
./configure --prefix=/usr --with-sysconfdir=/etc --with-log-dir=/var/log --disable-ssl --enable-all-static
make

%install
make install
strip /usr/sbin/partimage
strip /usr/sbin/partimaged
upx /usr/sbin/partimage
upx /usr/sbin/partimaged

%changelog

%files
/usr/sbin/partimage
/usr/sbin/partimaged
/usr/share/locale/fr/LC_MESSAGES/partimage.mo
/usr/share/locale/it/LC_MESSAGES/partimage.mo
/usr/share/locale/de/LC_MESSAGES/partimage.mo
/usr/share/locale/gl/LC_MESSAGES/partimage.mo
/usr/share/locale/da/LC_MESSAGES/partimage.mo
/usr/share/locale/pl/LC_MESSAGES/partimage.mo
/usr/share/locale/es/LC_MESSAGES/partimage.mo
