/*
 * Written by Bastien Chevreux (BaCh)
 *
 * Copyright (C) 2000 and later by Bastien Chevreux
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 * Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 * 
 */


/*
 * FASTA load routines
 */

#ifndef _bas_fasta_h_
#define _bas_fasta_h_

#include <iostream>
#include <fstream>
#include <string>

#include <string.h>

#include "stdinc/defines.H"
#include "stdinc/stlincludes.H"
#include "errorhandling/errorhandling.H"


using namespace std;



class FASTA
{
  //Variables
private:
  uint32 FA_valid;
  
  string         FA_fastaseqname;
  string         FA_qualseqname;
  string         FA_sequence;
  vector<int32>  FA_intvalues;


public:


  //Functions
private:
  void foolCompiler();
  void init();
  void zeroVars();
  void adjustNameNCBIHack(string & name);

public:
  FASTA();
  FASTA(FASTA const &other);
  ~FASTA();

  FASTA const & operator=(FASTA const & other);
  friend ostream & operator<<(ostream &ostr, FASTA const & fas);

  const string & getSeqName() const { return FA_fastaseqname;};
  const string & getQualName() const { return FA_qualseqname;};
  const string & getSequence() const { return FA_sequence;};
  const vector<base_quality_t> getQualities() const { 
    vector<base_quality_t> bla;
    bla.reserve(FA_sequence.size()+1);
    vector<int32>::const_iterator I=FA_intvalues.begin();
    for(;I != FA_intvalues.end(); I++){
      bla.push_back(static_cast<base_quality_t>(*I));
    }
    return bla;
  };

  const vector<int32> & getINTValues() const { return FA_intvalues;};

  void discard();
  void load(const char * fastain);
  void load(const char * fastain, const char * qualin);
  void loadQual(const char * qualin);
  void loadINT(const char * qualin, int32 maxvalue);

  void loadNext(ifstream & fastafin, ifstream & qualin);
  void loadNextSeq(ifstream & fastafin);
  void loadNextINTSeq(ifstream & qualfin, int32 maxvalue);

  void testIfSeqAndQualMatch();
  bool testIfEmpty();
  
  void dumpSequence(ostream & fout);
  void dumpQuality(ostream & fout);
};


#endif
