/*
 * Written by Bastien Chevreux (BaCh)
 *
 * Copyright (C) 2003 and later by Bastien Chevreux
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 * Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 * 
 */

// 	$Id$	

#ifndef _scfio_defines_h_
#define _scfio_defines_h_

#include <stdlib.h>
#include "types.H"


#define MIRA_HAS_EDIT
//#define HIDEPACBIO

#if 0
#define TIMERESTRICTED
#endif


#define BITSET(n,f) ((f)|=(1<<(n)))


#define MIRANOTIFY(nlevel, throwmsg) {ostringstream my__emsg; my__emsg << throwmsg; throw Notify(nlevel, THISFUNC, my__emsg.str().c_str());}

#ifdef TRACEFLAG
#define TRACE(bla)  cout << bla; cout.flush();
#define FUNCSTART(bla)  static const char * THISFUNC = bla; {cout << THISFUNC << " enter." << endl;}
#define FUNCTRACE(bla) { cout << THISFUNC << bla; cout.flush();}
#define FUNCEND() {cout << THISFUNC << " exit." << endl;}
#else
#define TRACE(bla)
#define FUNCSTART(bla) static const char * THISFUNC = bla; (void) THISFUNC;
#define FUNCTRACE(bla)
#define FUNCEND()
#endif


#define CEBUG(bla)
#define CEBUGF(bla)


#define ERROR(bla)  { cout.flush(); cerr << "\nFatal error in: " << THISFUNC << ":  " << bla; exit(1);}
#define WARNING(bla)  { cout.flush(); cerr << "Warning in: " << THISFUNC << ":  " << bla << endl;}


#ifdef BUGTRACKFLAG
#define BUGIFTHROW(ifcond, throwmsg) { if(ifcond) {ostringstream my__emsg; my__emsg << throwmsg; throw Notify(Notify::INTERNAL, THISFUNC, my__emsg.str().c_str());}}
#define BUGIF(ifcond, statement) { if(ifcond) {statement;}}
#define BUGSTAT(statement) {statement;}
#else
#define BUGIFTHROW(ifcond, throwmsg)
#define BUGIF(ifcond, statement)
#define BUGSTAT(statement)
#endif

#ifdef BOUNDTRACKFLAG
//#define BOUNDCHECK(x, l, h) assert((x) >= (l) && (x) < (h));
#define BOUNDCHECK(x, l, h) if(!((x) >= (l) && (x) < (h))) MIRANOTIFY(Notify::FATAL, "Oooops, boundcheck failed: " << x << ' ' << l << ' ' << h );
#else
#define BOUNDCHECK(x, l, h)
#endif


#endif
