// pulsegen.c

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include "valuerequester.h"
#include "request.h"
#include "pulsegen.h"

class PulseGenerateRequester : public ValueRequester<double> {
public:
	PulseGenerateRequester(PulseGenerator *);
protected:
	redefined void configureRequest(Request *);
private:
	PulseGenerator* client;
};

PulseGenerateRequester::PulseGenerateRequester(PulseGenerator* p)
	: ValueRequester<double>("Pulse Signal Generator:",
	                         "Gain Factor:", p->amplitude), client(p) {}

void
PulseGenerateRequester::configureRequest(Request* request) {
	request->appendValue("Pulse Spacing (samples):", &client->spacing,
	                     PositiveIntegers);
	ValueRequester<double>::configureRequest(request);
}

//********

PulseGenerator::PulseGenerator(Data* output)
	: SimpleFunction(output), count(0), spacing(2), amplitude(1.0) {}

PulseGenerator::PulseGenerator(Data* output, int space, double amp)
		: SimpleFunction(output),
		  count(0), spacing(space), amplitude(amp) {
	initialize();
}

Requester *
PulseGenerator::createRequester() {
	return new PulseGenerateRequester(this);
}

double 
PulseGenerator::operator () (double input) {
	return (count++ % spacing == 0) ? amplitude : 0.0;
}

