# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: Toolbar and menubar icon library.

# load libs
import wx

# load modules
import images


class mIcons(wx.ToolBar):
    """ Toolbar and menubar icon library. """

    # ----
    def __init__(self):

        # get icon file
        icons = images.getToolbarBitmap()

        # file
        self.fileOpen = icons.GetSubBitmap(wx.Rect(0, 0, 16, 16))
        self.fileSave = icons.GetSubBitmap(wx.Rect(16, 0, 16, 16))
        self.fileClose = icons.GetSubBitmap(wx.Rect(32, 0, 16, 16))
        self.filePrintSpectrum = icons.GetSubBitmap(wx.Rect(48, 0, 16, 16))
        self.filePrintReport = icons.GetSubBitmap(wx.Rect(64, 0, 16, 16))
        self.fileInfo = icons.GetSubBitmap(wx.Rect(80, 0, 16, 16))

        # modules
        self.toolsMSpec = icons.GetSubBitmap(wx.Rect(0, 16, 16, 16))
        self.toolsMSeq = icons.GetSubBitmap(wx.Rect(16, 16, 16, 16))
        self.toolsMCut = icons.GetSubBitmap(wx.Rect(32, 16, 16, 16))
        self.toolsMFrag = icons.GetSubBitmap(wx.Rect(48, 16, 16, 16))
        self.toolsMDiff = icons.GetSubBitmap(wx.Rect(64, 16, 16, 16))
        self.toolsMComp = icons.GetSubBitmap(wx.Rect(80, 16, 16, 16))

        # spectrum
        self.spectrumLabelPoint = icons.GetSubBitmap(wx.Rect(0, 32, 16, 16))
        self.spectrumLabelPeak = icons.GetSubBitmap(wx.Rect(16, 32, 16, 16))
        self.spectrumDeleteLabel = icons.GetSubBitmap(wx.Rect(32, 32, 16, 16))
        self.spectrumMeasureDistance = icons.GetSubBitmap(wx.Rect(48, 32, 16, 16))

        # processigng
        self.processingInternalCalibration = icons.GetSubBitmap(wx.Rect(64, 32, 16, 16))
        self.processingStatisticalCalibration = icons.GetSubBitmap(wx.Rect(80, 32, 16, 16))
        self.spectrumRefresh = icons.GetSubBitmap(wx.Rect(96, 32, 16, 16))

        # peaklist
        self.peaklistAddPeak = icons.GetSubBitmap(wx.Rect(0, 48, 16, 16))
        self.peaklistClearAllAnnots = icons.GetSubBitmap(wx.Rect(16, 48, 16, 16))
        self.peaklistDeleteAllPeaks = icons.GetSubBitmap(wx.Rect(32, 48, 16, 16))

        # matching
        self.matchingMatchData = icons.GetSubBitmap(wx.Rect(48, 48, 16, 16))
        self.matchingMatchInfo = icons.GetSubBitmap(wx.Rect(64, 48, 16, 16))
        self.matchingAnnotate = icons.GetSubBitmap(wx.Rect(80, 48, 16, 16))

        # mascot
        self.toolsMMascotPMF = icons.GetSubBitmap(wx.Rect(0, 64, 16, 16))
        self.toolsMMascotSeq = icons.GetSubBitmap(wx.Rect(16, 64, 16, 16))
        self.toolsMMascotMSMS = icons.GetSubBitmap(wx.Rect(32, 64, 16, 16))

        # sequence
        self.sequenceEditMod = icons.GetSubBitmap(wx.Rect(0, 80, 16, 16))
        self.sequenceSearchMass = icons.GetSubBitmap(wx.Rect(16, 80, 16, 16))
        self.sequenceSearchSeq = icons.GetSubBitmap(wx.Rect(32, 80, 16, 16))
        self.fileImportSequence = icons.GetSubBitmap(wx.Rect(80, 80, 16, 16))

        # config
        self.configMonoisotopic = icons.GetSubBitmap(wx.Rect(0, 96, 16, 16))
        self.configAverage = icons.GetSubBitmap(wx.Rect(16, 96, 16, 16))
        self.configTolerance = icons.GetSubBitmap(wx.Rect(32, 96, 16, 16))
        self.configShowPeaklist = icons.GetSubBitmap(wx.Rect(0, 112, 16, 16))
        self.configPeaklistBottom = icons.GetSubBitmap(wx.Rect(16, 112, 16, 16))
        self.configPreferences = icons.GetSubBitmap(wx.Rect(32, 112, 16, 16))
    # ----
