      SUBROUTINE MN_DMP(IDA,IDB,LUN)
*
      implicit none
*
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mncwn.inc"
#include "mncmd.inc"
#include "mnlun.inc"
#include "slate.inc"
C
      integer ida,idb,lun
C
      INTEGER IBIN(MDIMMX)
      REAL    AVAL(MDIMMX)
      CHARACTER*3 TBIN(3)
      character tcwn(5)*4,tmode(4)*5
C
      CHARACTER*255 TXT1,TXT2,CONCAT,CONCT0
      integer nh,idh,ioerr,lent,lenf,lend,lenc,lenb,lnblnk
      integer nn,i,j,k,ii,jj,nuof,ierr,kcmd,idelim,nvline,nv1,nv2,nline
     + ,nltot,nlidx,nptr,n1,n2,m1,m2,np,nloop,nvar,nelem,nsub,nelem_max
     + ,npnt1,npnt2,nc1,nc2,nvsize,nt1
     + ,nchfnd,nval,nv,nfact,ie(10)
      real xx,yy,dxx,dyy,rval
C
      integer icmtyq,nchscn,ivltyq
      logical  hntnew,qcwntp
      external hntnew,icmtyq,nchscn,ivltyq
C
      DATA TBIN/'UND','INS','OVE'/
      data tcwn/'REAL','INT','INT','LOG','CHAR'/
      data tmode/'Days','Hours','Mins','Secs'/
C
C     GET THE POINTERS ETC
C
      CALL MN_HGT(IDA,IDB,NH)
      IF(NH.LE.0) THEN
          WRITE(TXTERR,'(''Histogram'',I7,I4
     1     ,'' does not exist'')') IDA,IDB
          CALL MN_ERR('MN_DMP',TXTERR)
          GOTO 9000
      ENDIF
C
      WRITE(TXTMES,'('' Histogram'',I7,I4
     +   ,''  # of points'',I6,''  Dimension'',I5
     +   ,'' Date/Time'',1X,I6.6,''/'',I4.4)')
     +  IDA,IDB,NPNT,NDIM,NHDATE,NHTIME
      CALL MN_MES(LUN,'I',TXTMES)
      WRITE(TXTMES,'('' # of words/point'',I4
     + ,''  # of bits per word'',I3)') NWPPT,NBPPT
      CALL MN_MES(LUN,'I',TXTMES)
      WRITE(TXTMES,'('' Area'',F10.1
     + ,'', Limits on # of entries (incl errors)'',2(1PG13.5))'
     + ,IOSTAT=IOERR) EDENT,EDLO,EDHI
      CALL MN_MES(LUN,'I',TXTMES)
      LENT = MAX0(LNBLNK(TDTIT(NH)),1)
      CALL MN_MES(LUN,'I',' Title:     ' // TDTIT(NH)(1:LENT))
      LENF = MAX0(LNBLNK(TDFIL(NH)),1)
      CALL MN_MES(LUN,'I',' File:      ' // TDFIL(NH)(1:LENF))
      LEND = MAX0(LNBLNK(TDDIR(NH)),1)
      CALL MN_MES(LUN,'I',' Directory: ' // TDDIR(NH)(1:LEND))
      if(ntmode.ne.0) then
          write(txtmes, '('' Time mode:'',A
     +     ,'', Reference time: '',i6.6,''/'',i6.6)',iostat=ioerr)
     +     tmode(ntmode),nsdate,nstime
          CALL MN_MES(LUN,'I',txtmes)
      endif
C     DO 900 NN=NH-1,NH+1
C         IF(NN.LE.0 .OR. NN.GT.NDHIS) GOTO 900
C         IF(NN.EQ.NH-1) THEN
C             WRITE(LUN,'(/,'' Previous histogram'',I7,I4)')
C     1        IDIDA(NN),IDIDB(NN)
C         ELSEIF(NN.EQ.NH) THEN
C             WRITE(LUN,'('' Present  histogram'',I7,I4)')
C     1        IDIDA(NN),IDIDB(NN)
C         ELSEIF(NN.EQ.NH+1) THEN
C             WRITE(LUN,'('' Next     histogram'',I7,I4)')
C     1        IDIDA(NN),IDIDB(NN)
C         ENDIF
C         NNHPT = IABS(IDPTRH(NN))
C         WRITE(LUN,'('' Pointer to header'',I6,''  Data'',I6
C     1     ,/,'' Number of words'',I6,'' Header'',I6,'' Data'',I6)')
C     1     ,IDPTRH(NN),IDPTRD(NN),NINT(RDAT(NNHPT))
C     1     ,NINT(RDAT(NNHPT+1)),NINT(RDAT(NNHPT+2))
C900  CONTINUE
C
C     Set up the directories so that I can dump points for Ntuples
C     which are not in memory
C
      qcwntp = .false.
      if(ndim.lt.0 .and. nwdat.eq.0 .and. npnt.gt.0) then
          call m_sdir(0,ierr)
          if(ierr.ne.0) goto 9000
          idh = ida
          qcwntp = hntnew(idh)
          if(qcwntp) then
*             Seems to blow up on my DQM time history Ntuple!
c              call hprnt(idh)
c              txtmes = 'All CWN variables will be converted to real'
c              call mn_mes(luntto,'ME',txtmes)
              nvcwn = 0
              call m_ntppnt(ida,idb,0,ierr,aval)
*ICB          else
*ICB              call hprntu(idh)
          endif
      endif
C
      if(qcwntp .or. ndim.le.-3) then
          txtmes = ' List of Ntuple Variables:'
          call mn_mes(lun,'I',txtmes)
          if(qcwntp) then
              write(txtmes,'(1X,''Numb/Name''
     +         ,T30,''Type'',T40,''Block'',T50,''Definition'')')
              call mn_mes(lun,'I',txtmes)
          endif
      endif
      DO 1000 NN=1,IABS(NDIM)
          if(qcwntp) then
              lend = min0(35,lnblnk(cvdesc(nn)))
              call m_tsub(1,nh,ivsub(1,nn),ivsub(3,nn),ivelem(nn)
     +         ,txt1,n1)
              n1 = max0(1,n1)
              lent = lnblnk(tdnam(nn,nh))
              lenc = lnblnk(tcwn(ivtype(nn)))
              lenb = lnblnk(chblk(nn))
              WRITE(TXTMES,'(1X,I4,''/'',A,A,T30,A,''*'',I2,'',''
     +         ,T40,A,T50,A)')
     +         nn,tdnam(nn,nh)(:lent),txt1(:n1)
     +         ,tcwn(ivtype(nn))(:lenc),ivsize(nn),chblk(nn)(:lenb)
*ICB     +         ,ivsub(1,nn),ivsub(2,nn),ivelem(nn)
     +         ,cvdesc(nn)(:lend)
              CALL MN_MES(LUN,'I',TXTMES)
          elseif(ndim.gt.-3) then
              TXT1 = CONCAT(TDNAM(NN,NH),'axis:')
              lent = max(lnblnk(txt1),13)
              WRITE(TXTMES,'(1X,A,'' Number of bins'',I4
     +         ,''  Lower/upper limits'',2(1PG13.5))')
     +         TXT1(:lent),IDBIN(NN),ADLO(NN),ADHI(NN)
              CALL MN_MES(LUN,'I',TXTMES)
              WRITE(TXTMES
     +         ,'(15X,''Mean'',1PG13.5,''  Sigma'',1PG13.5)')
     +         AMEAN(NN),ASIG(NN)
              CALL MN_MES(LUN,'I',TXTMES)
          else
              lent = max0(8,lnblnk(tdnam(nn,nh)))
              WRITE(TXTMES,'(1X,I4,''/'',A,'':''
     +         ,'' Lower/upper limits'',2(1PG13.5))')
     +         nn,tdnam(nn,nh)(:lent),ADLO(NN),ADHI(NN)
              CALL MN_MES(LUN,'I',TXTMES)
          endif
1000  CONTINUE
C
C     DUMP THE UNDERFLOWS AND OVERFLOWS
C
      IF(.not.qcwntp .and. ndim.gt.-3 .and. ndim.le.3) THEN
          CALL MN_MES(LUN,'I',' Number of underflows and overflows:')
          NUOF = 3**IABS(NDIM)
          CALL MN_UOF(RDAT(NPTRH),ACONT)
          IBIN(1) = 0
          IBIN(2) = 0
          DO 1100 NN=3,IABS(NDIM)
              IBIN(NN) = 1
1100      CONTINUE
          DO 1300 I=1,NUOF,3
              IBIN(2) = IBIN(2) + 1
              IF(IBIN(2).GT.3) THEN
                  DO 1220 NN=3,IABS(NDIM)
                      IF(IBIN(NN-1).GT.3) THEN
                          IBIN(NN-1) = 1
                          IBIN(NN) = IBIN(NN) + 1
                      ENDIF
1220              CONTINUE
              ENDIF
C
              TXT1 = ' '
              TXT1 = CONCAT(TDNAM(1,NH),'axis UND|INS|OVE')
              DO 1230 II=2,IABS(NDIM)
                  TXT2 = CONCT0(TXT1,',')
                  TXT1 = CONCAT(TXT2,TDNAM(II,NH))
                  TXT2 = CONCAT(TXT1,'axis')
                  TXT1 = CONCAT(TXT2,TBIN(IBIN(II)))
1230          CONTINUE
C
              LENT = LNBLNK(TXT1)
              WRITE(TXTMES,'(1X,A,2X,3I11)',IOSTAT=IOERR) TXT1(1:LENT)
     1         ,(NINT(ACONT(JJ)),JJ=I,I+2)
              CALL MN_MES(LUN,'I',TXTMES)
1300      CONTINUE
      ENDIF
      CALL MN_MES(LUN,'E',' ')
C
C     Find out which points to dump
C
      call waityq(
     + 'Dump the points [Y/N] or give point numbers (<CR>=N)? ')
      kcmd = icmtyq(.true.,idelim,lognam)
      if(kcmd.lt.0) goto 9000
      nchfnd = nchscn()
      if(kcmd.eq.0 .and. nchfnd.eq.0) goto 9000
      if(kcmd.gt.0 .and. mod(kcmd,2).eq.0) goto 9000
      if(mod(kcmd,2).eq.1) then
          npnt1 = 1
          npnt2 = npnt
      else
          call restyq
          npnt1 = ivltyq(.true.,idelim)
          nchfnd = nchscn()
          if(idelim.gt.0) goto 9000
*
          if(npnt1.eq.0) then
              npnt1 = 1
              npnt2 = npnt
          else
              npnt1 = max0(1,min0(npnt,iabs(npnt1)))
              npnt2 = npnt1
              if(idelim.eq.0) then
                  np = ivltyq(.true.,idelim)
                  if(np.gt.0 .and. np.gt.npnt1) npnt2 = np
              endif
          endif
      endif
C
      IF(NDIM.GT.2) THEN
          WRITE(TXTMES,'('' Point'',20X,''Entries'')')
          CALL MN_MES(LUN,'IE',TXTMES)
      ELSEIF(.not.qcwntp .and. NDIM.EQ.-1 .AND. NWPPT.EQ.1) THEN
          WRITE(TXTMES,'('' Point'',6X,''X'')')
          CALL MN_MES(LUN,'IE',TXTMES)
      ELSEIF(.not.qcwntp .and. NDIM.EQ.-1 .AND. NWPPT.EQ.2) THEN
          WRITE(TXTMES,'('' Point'',6X,''X'',10X
     1     ,''Y'')')
          CALL MN_MES(LUN,'IE',TXTMES)
      ELSEIF(.not.qcwntp .and. NDIM.EQ.-1 .AND. NWPPT.EQ.4) THEN
          WRITE(TXTMES,'('' Point'',6X
     1     ,''X    +/-    DX'',14X
     1     ,''Y    +/-    DY'')')
          CALL MN_MES(LUN,'IE',TXTMES)
      ELSEIF(.not.qcwntp .and. NDIM.EQ.-1 .AND. NWPPT.EQ.6) THEN
          WRITE(TXTMES,'('' Point'',5X
     1     ,''X       -DX        +DX'',14X
     1     ,''Y       -DY        +DY'')')
          CALL MN_MES(LUN,'IE',TXTMES)
      ELSEIF(NDIM.EQ.1 .AND. NWPPT.EQ.4) THEN
          WRITE(TXTMES,'('' Point'',6X,''X'',10X,''Entries''
     +     ,17X,''Errors'',15X,''Weight'')')
          CALL MN_MES(LUN,'IE',TXTMES)
      ELSEIF(NDIM.EQ.1) THEN
          WRITE(TXTMES,'('' Point'',6X,''X'',10X,''Entries'')')
          CALL MN_MES(LUN,'IE',TXTMES)
      ELSEIF(NDIM.EQ.2) THEN
          WRITE(TXTMES,'(6X,''Point'',6X,''X'',11X,''Y'',19X
     +     ,''Entries'')')
          CALL MN_MES(LUN,'IE',TXTMES)
      elseif(qcwntp) then
          txtmes = ' Name(Elem)'
          CALL MN_MES(LUN,'IE',TXTMES)
      ELSE
          NVLINE = 4
          NLINE = (IABS(NDIM)-1) / NVLINE + 1
          DO 1400 J=1,NLINE
              NV1 = NVLINE*(J-1) + 1
              NV2 = MIN0(NVLINE*J,IABS(NDIM))
              IF(J.EQ.1) THEN
                  WRITE(TXTMES,'(1X,''Point/Var'',2X,4(I4,''/'',A12))'
     +             ,iostat=ioerr) (II,TDNAM(II,NH),II=NV1,NV2)
              ELSE
                  WRITE(TXTMES,'(12X,4(I4,''/'',A12))'
     +             ,iostat=ioerr) (II,TDNAM(II,NH),II=NV1,NV2)
              ENDIF
              CALL MN_MES(LUN,'I',TXTMES)
1400      CONTINUE
          CALL MN_MES(LUN,'IE',' ')
      ENDIF
C
      IBIN(1) = 0
      DO 6100 NN=2,IABS(NDIM)
          IBIN(NN) = 1
 6100 CONTINUE
      DXX = 0.0
      DYY = 0.0
      IF(NDIM.GT.0) THEN
          IF(IDBIN(1).GT.0) DXX  = (ADHI(1)-ADLO(1))/FLOAT(IDBIN(1))
          IF(NDIM.GT.1 .AND. IDBIN(2).GT.0)
     1     DYY = (ADHI(2)-ADLO(2))/FLOAT(IDBIN(2))
      ENDIF
C
      IF(.not.qcwntp .and. IABS(NDIM).LE.1 .or. ndim.eq.2) THEN
          if(iabs(ndim).eq.1) then
              ibin(1) = npnt1 -1
          else
              ibin(1) = mod(npnt1-1,idbin(1))
              ibin(2) = (npnt1-1) / idbin(1) + 1
          endif
          DO 6300 I=NPNT1,NPNT2
              IBIN(1) = IBIN(1) + 1
              IF(IBIN(1).GT.IDBIN(1)) THEN
                  DO 6220 NN=2,IABS(NDIM)
                      IF(IBIN(NN-1).GT.IDBIN(NN-1)) THEN
                          IBIN(NN-1) = 1
                          IBIN(NN) = IBIN(NN) + 1
                      ENDIF
 6220             CONTINUE
              ENDIF
              NPTR = NPTRD + NWPPT*(I-1) - 1
              IF(NDIM.GT.0) THEN
                  XX = ADLO(1) + FLOAT(IBIN(1)-1)*DXX + 0.5*DXX
                  IF(NDIM.GT.1) YY = ADLO(2)+FLOAT(IBIN(2)-1)*DYY +
     1             0.5*DYY
              ENDIF
C
              IF(NDIM.EQ.-1 .AND. NWPPT.EQ.1) THEN
                  WRITE(TXTMES,'(1X,I5,'':'',1(1PG13.5))',IOSTAT=IOERR)
     1             I,RDAT(NPTR+1)
              ELSEIF((NDIM.EQ.-1 .AND. NWPPT.EQ.2) .OR. NDIM.EQ.-2) THEN
                  WRITE(TXTMES,'(1X,I5,'':'',2(1PG13.5))',IOSTAT=IOERR)
     1             I,RDAT(NPTR+1),RDAT(NPTR+2)
              ELSEIF(NDIM.EQ.-1 .AND. NWPPT.EQ.4) THEN
                  WRITE(TXTMES,'(1X,I5,'':'',2(1PG13.5),2X,2(1PG13.5))'
     1             ,IOSTAT=IOERR) I
     1             ,RDAT(NPTR+1),RDAT(NPTR+3)
     1             ,RDAT(NPTR+2),RDAT(NPTR+4)
              ELSEIF(NDIM.EQ.-1 .AND. NWPPT.EQ.6) THEN
                  WRITE(TXTMES,'(1X,I5,'':'',3(1PG11.4),2X,3(1PG11.4))'
     1             ,IOSTAT=IOERR) I
     1             ,RDAT(NPTR+1),RDAT(NPTR+3),RDAT(NPTR+5)
     1             ,RDAT(NPTR+2),RDAT(NPTR+4),RDAT(NPTR+6)
              ELSEIF(NDIM.EQ.1 .AND. NWPPT.EQ.1) THEN
                 WRITE(TXTMES,'(1X,I5,'':'',1PG12.4,2X,1PG13.5)'
     1            ,IOSTAT=IOERR) I,XX,RDAT(NPTR+1)
              ELSEIF(NDIM.EQ.1 .AND. NWPPT.EQ.2) THEN
                 WRITE(TXTMES,'(1X,I5,'':'',1PG12.4
     1            ,2X,1PG13.5,'' +/-'',1PG13.5))',IOSTAT=IOERR)
     1            I,XX,RDAT(NPTR+1),RDAT(NPTR+2)
              ELSEIF(NDIM.EQ.1 .AND. NWPPT.EQ.3) THEN
                 WRITE(TXTMES,'(1X,I5,'':'',1PG12.4
     1            ,2X,1PG13.5,'' -'',1PG13.5,'' +'',1PG13.5))'
     +            ,IOSTAT=IOERR)
     1            I,XX,RDAT(NPTR+1),RDAT(NPTR+2),RDAT(NPTR+3)
              ELSEIF(NDIM.EQ.1 .AND. NWPPT.EQ.4) THEN
                 WRITE(TXTMES,'(1X,I5,'':'',1PG12.4
     1            ,2X,1PG13.5,'' -'',1PG13.5,'' +'',1PG13.5
     +            ,2X,1PG13.5))',IOSTAT=IOERR)
     1             I,XX,RDAT(NPTR+1),RDAT(NPTR+2),RDAT(NPTR+3)
     +            ,RDAT(NPTR+4)
              ELSEIF(NDIM.EQ.2 .AND. NWPPT.EQ.1) THEN
                 WRITE(TXTMES,'(1X,I5,'','',I5,'':'',2(1PG12.4)
     1            ,2X,1PG13.5)'
     1            ,IOSTAT=IOERR) IBIN(1),IBIN(2),XX,YY,RDAT(NPTR+1)
              ELSEIF(NDIM.EQ.2 .AND. NWPPT.EQ.2) THEN
                 WRITE(TXTMES,'(1X,I5,'','',I5,'':'',2(1PG12.4)
     1            ,2X,1PG13.5,'' +/-'',1PG13.5)',IOSTAT=IOERR)
     2            IBIN(1),IBIN(2),XX,YY
     1            ,RDAT(NPTR+1),RDAT(NPTR+2)
              ELSEIF(NDIM.EQ.2 .AND. NWPPT.EQ.3) THEN
                 WRITE(TXTMES,'(1X,I5,'','',I5,'':'',2(1PG12.4)
     1            ,2X,1PG13.5,'' -'',1PG13.5,'' +'',1PG13.5)'
     +            ,IOSTAT=IOERR)
     2            IBIN(1),IBIN(2),XX,YY
     1            ,RDAT(NPTR+1),RDAT(NPTR+2),RDAT(NPTR+3)
              ENDIF
              CALL MN_MES(LUN,'I',TXTMES)
              IF(I.LT.NPNT .AND. MOD(I,100).EQ.0) THEN
                  CALL MN_CRT(1,'Hit <CR> for more' //
     +             ' (q to quit, any character to stop):',IERR)
                  IF(IERR.NE.0) GOTO 9000
              ENDIF
 6300     CONTINUE
C
C     HISTOGRAMS WITH MORE THAN 2-DIMENSIONS ARE STORED IN I*2 FORMAT
C
      ELSEIF(NDIM.GT.2) THEN
          IF(NWPPT.EQ.1) THEN
              NLINE = (npnt2-npnt1)/5 + 1
              NPTR = 2*NPTRD - 1
              DO 6200 I=1,NLINE
                  N1 = 5*(I-1)+ npnt1
                  N2 = MIN0(5*I,NPNT2)
                  WRITE(TXTMES,'(1X,I6,'':'',5(I8,1X))')
     1             N1,(IDAT2(NPTR+JJ-1),JJ=N1,N2)
                  CALL MN_MES(LUN,'I',TXTMES)
                  IF(I.LT.NLINE .AND. MOD(I,100).EQ.0) THEN
                      CALL MN_CRT(1,'Hit <CR> for more' //
     +                 ' (q to quit, any character to stop):',IERR)
                      IF(IERR.NE.0) GOTO 9000
                  ENDIF
 6200         CONTINUE
          ELSE
              NLINE = (NPNT2-npnt1)/2 + 1
              DO 6250 I=1,NLINE
                  N1 = 2*(I-1)+ npnt1
                  N2 = MIN0(2*I,NPNT2)
                  M1 = 2*N1-1
                  M2 = 2*N2
                  WRITE(TXTMES,'(1X,I6,'':''
     1             ,2(1pG13.5,'' +/-'',1pG13.5,2X))')
     2             N1,(RDAT(NPTRD+JJ-1),JJ=M1,M2)
                  CALL MN_MES(LUN,'I',TXTMES)
                  IF(I.LT.NLINE .AND. MOD(I,100).EQ.0) THEN
                      CALL MN_CRT(1,'Hit <CR> for more' //
     +                 ' (q to quit, any character to stop):',IERR)
                      IF(IERR.NE.0) GOTO 9000
                  ENDIF
 6250         CONTINUE
          ENDIF
C
C     Dump an Ntuple
C
      ELSEif(qcwntp) then
          nvcwn = 0
          call m_ntppnt(ida,idb,0,ierr,aval)
          DO np=NPNT1,npnt2
              nltot = 0
              call m_ntppnt(ida,idb,np,ierr,aval)
              if(ierr.ne.0) then
                  write(txterr
     +             ,'(''Error unpacking Ntuple'',i7)') idh
                  call mn_err('MN_DMP',txterr)
                  goto 9000
              endif
C
              write(txtmes,'('' Event'',I8)') np
              call mn_mes(lun,'i',txtmes)
              if(nvcwn.eq.0) then
                  nloop = iabs(ndim)
              else
                  nloop = nvcwn
              endif
              do i=1,nloop
                  if(nvcwn.eq.0) then
                      nvar = i
                  else
                      nvar = ivcwn(i)
                  endif
                  nelem = ivelem(i)
                  nsub  = ivsub(1,nvar)
                  if(nsub.gt.0 .and. ivsub(2+nsub,nvar).lt.0) then
                      nv = -ivsub(2+nsub,nvar)
                      call m_ntpvar(nv,1,nval,rval,ierr)
                  else
                      nval = ivsub(2+nsub,nvar)
                  endif
*
*                 Values per line
*
                  if(ivtype(nvar).eq.5 .and. ivsize(nvar).ge.12) then
                      nvline = (65-1) / (ivsize(nvar)+1) + 1
                  else
                      nvline = 4
                  endif
*
                  if(nsub.gt.0) then
                      nelem = ivsub(2,nvar) * nval
                      if(nsub.gt.1 .and. ivsub(3,nvar).lt.nvline) then
                          nvline = ivsub(3,nvar)
                      endif
                      if(nsub.gt.1) then
                          nlidx = (ivsub(3,nvar)-1) / nvline + 1
                          nline = ivsub(2,nvar)/ivsub(3,nvar)*nlidx*nval
                      else
                          nlidx = 1
                          nline = (nelem-1) / nvline + 1
                      endif
                  else
                      nlidx = 1
                      nline = (nelem-1) / nvline + 1
                  endif
                  nelem_max = nelem
                  nltot = nltot + nline
                  nv  = nvline
                  nv1 = 1 - nv
                  do j=1,nline
                      nv1 = nv1 + nv
                      nv  = nvline
                      if(nsub.gt.1 .and. mod(j,nlidx).eq.0)
     +                 nv = mod(ivsub(3,nvar)-1,nvline) + 1
                      nv2 = nv1 + nv - 1
                      nv2 = min0(nv2,nelem_max)
*
*                     1st variable number
*
                      if(nsub.gt.0) then
                          nfact = ivsub(2,nvar)
                          nn = nv1
                          do k=ivsub(1,nvar),1,-1
                              ie(k) = (nn-1)/nfact + 1
                              nn    = mod(nn-1,nfact) + 1
                              if(k.gt.1) then
                                  nfact = nfact / ivsub(1+k,nvar)
                              else
                                  nfact = 1
                              endif
                          enddo
*
                          txt1 = chcwn(i)
                          n1 = lnblnk(txt1)+2
                          txt1(n1-1:n1-1) = '('
                          do k=1,ivsub(1,nvar)
                              n2 = n1 + 4
                              call csetdi(ie(k),txt1,n1,n2)
                              call cleft(txt1,n1,n2)
                              n1 = n1 + nd
                              if(k.lt.ivsub(1,nvar)) then
                                  txt1(n1:n1) = ','
                                  n1 = n1 + 1
                              endif
                          enddo
                          txt1(n1:n1) = ')'
                      else
                          txt1 = chcwn(nvar)
                      endif
                      lent = lnblnk(txt1)
*ICB                      nv1 = nvline*(j-1) + 1
*ICB                      nv2 = min0(nvline*j,nelem)
                      if(ivtype(nvar).eq.1 .and. ivsize(nvar).eq.4) then
                          write(txtmes,'(1x,a,'':''
     +                     ,t30,4(1pg12.5,1x))')
     +                     txt1(:lent)
     +                     ,(ar4(ivposn(nvar)+ii-1),ii=nv1,nv2)
                      elseif(ivtype(nvar).eq.1 .and.
     +                       ivsize(nvar).eq.8) then
                          write(txtmes,'(1x,a,'':''
     +                     ,t30,4(1pg12.5,1x))')
     +                     txt1(:lent)
     +                     ,(zr8(ivposn(nvar)+ii-1),ii=nv1,nv2)
                      elseif(ivtype(nvar).eq.2 .or.
     +                       ivtype(nvar).eq.3) then
                          write(txtmes,'(1x,a,'':''
     +                     ,t30,4(i12,1x))')
     +                     txt1(:lent)
     +                     ,(ir4(ivposn(nvar)+ii-1),ii=nv1,nv2)
                      elseif(ivtype(nvar).eq.4) then
                          write(txtmes,'(1x,a,'':''
     +                     ,t30,4(l12,1x))')
     +                     txt1(:lent)
     +                     ,(qr4(ivposn(nvar)+ii-1),ii=nv1,nv2)
                      elseif(ivtype(nvar).eq.5) then
                          lenc = max0(ivsize(nvar),12)
                          write(txtmes,'(1x,a,'':'')')
     +                     txt1(:lent)
                          do ii=nv1,nv2
                              nc1 = (ii-1) * ivsize(nvar)/4 + 1
                              nc2 = ii     * ivsize(nvar)/4
                              nt1 = 30 + mod((ii-1),nvline)*(lenc+1)
                              write(txtmes(nt1:),'(16a)')
     +                         (cch(ivposn(nvar)+jj-1),jj=nc1,nc2)
                          enddo
                      endif
                      if(ivtype(nvar).ne.5) then
                          nvsize = max0(ivsize(nvar),12) + 1
                          do ii=1,(nv2-nv1+1)
                              n1 = 30 + nvsize*(ii-1)
                              n2 = n1 + nvsize        - 1
                              call cright(txtmes,n1,n2)
                          enddo
                      endif
                      call mn_mes(lun,'i',txtmes)
                  enddo
              enddo
              IF(NLINE.GT.1) CALL MN_MES(LUN,'I',' ')
              IF(np.LT.NPNT2 .AND. MOD(np-npnt1+1,10).EQ.0) THEN
                  CALL MN_CRT(1,'Hit <CR> for more' //
     +             ' (q to quit, any character to stop):',IERR)
                  IF(IERR.NE.0) GOTO 9000
              ENDIF
          enddo
      else
          nvcwn = 0
          call m_ntppnt(ida,idb,0,ierr,aval)
          DO 7000 I=NPNT1,npnt2
              call m_ntppnt(ida,idb,i,ierr,aval)
              if(ierr.ne.0) then
                  write(txterr
     +             ,'(''Error unpacking Ntuple'',i7)') idh
                  call mn_err('MN_DMP',txterr)
                  goto 9000
              endif
C
              do 6900 j=1,nline
                  nv1 = nvline*(j-1) + 1
                  nv2 = min0(nvline*j,iabs(ndim))
                  if(j.eq.1) then
                      write(txtmes,'(1x,i5,''/'',i4,'':''
     +                 ,4(1pg13.6,4x))')
     +                 i,nv1,(aval(ii),ii=nv1,nv2)
                  else
                      write(txtmes,'(7x,i4,'':''
     +                 ,4(1pg13.6,4x))')
     +                 nv1,(aval(ii),ii=nv1,nv2)
                  endif
                  nvsize = 17
                  do ii=1,(nv2-nv1+1)
                      n1 = 13 + nvsize*(ii-1)
                      n2 = n1 + nvsize        - 1
                      call cright(txtmes,n1,n2)
                  enddo
                  call mn_mes(lun,'i',txtmes)
6900          continue
              IF(NLINE.GT.1) CALL MN_MES(LUN,'I',' ')
              IF(I.LT.NPNT .AND. MOD(I,100).EQ.0) THEN
                  CALL MN_CRT(1,'Hit <CR> for more' //
     +             ' (q to quit, any character to stop):',IERR)
                  IF(IERR.NE.0) GOTO 9000
              ENDIF
7000      CONTINUE
      ENDIF
      CALL MN_MES(LUN,'E',' ')
C
 9000 CONTINUE
      END
