      SUBROUTINE MN_DSS(IDELIM,QZERO,QPLOT,NPS1,NPS2)
C
C     Subroutine to set the parameters needed for the various L3
C     online displays
C
      IMPLICIT NONE
C
      INTEGER IDELIM,NPS1,NPS2
      LOGICAL QZERO,QPLOT
C
#if ( defined(L3DSP_SRC) || defined(ZEUSDSP_SRC) )
#include "mnpar.inc"
#include "mndsp.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      INTEGER NNUM,NPC,II,NP
      REAL RNUM(MDSPAR)
      CHARACTER*15 TKYS(MDSKEY)
     + ,TKYP(MDSKEY,MHPLT)
C
      CHARACTER*10 TPAR(MDSPAR)
      INTEGER IPAR(MDSPAR)
      REAL PRD(MDSPAR),PRS(MDSPAR),PRP(MDSPAR,MHPLT)
C
      CHARACTER*80 THELP,THEAD
      CHARACTER*80 TXTI,TEXT
C
      INTEGER KCMD,IERR
      INTEGER  ICMTYQ
      EXTERNAL ICMTYQ
#endif

C
#if ( !defined(L3DSP_SRC) ) && ( !defined(ZEUSDSP_SRC) )
          CALL MN_ERR('MN_DSS'
     +     ,'Command only valid in L3 or ZEUS environment')
C
#endif
#if ( defined(L3DSP_SRC) || defined(ZEUSDSP_SRC) )
C
      CALL WAITYQ('Give detector name: ')
      KCMD = ICMTYQ(.TRUE.,IDELIM,DETNAM)
C
      COMND3 = ' '
      IF(KCMD.GT.0) COMND3 = DETNAM(KCMD)
C
      IF(IDELIM.GT.0 .OR. KCMD.EQ.0) THEN
          CALL MN_DCK(IDELIM,KCMD,MDET,DETNAM,IERR)
          IF(IERR.EQ.2) CALL MN_UNK('MN_DSS')
          GOTO 9000
      ELSEIF(KCMD.LT.0) THEN
          GOTO 9000
      ENDIF
      THELP = 'SET ' // COMND2 // ' ' // COMND3
      IF(QPLOT) NPC = NPS2 - NPS1 + 1
C
C     Copy the detector parameters to local arrays for manipulation
#endif
#if ( defined(L3DSP_SRC) )
C
C     Electromagnetic calorimeter
C
      IF(COMND3.EQ.'ECAL') THEN
          THEAD = 'Electromagnetic calorimeter display parameters'
          IF(COMND2.EQ.'PARAMETER') THEN
              CALL TCOPY(TPAREC,TPAR,MDSPAR)
              CALL UCOPY_i(IPAREC,IPAR,MDSPAR)
              CALL UCOPY_r(PRD_EC,PRD,MDSPAR)
              CALL UCOPY_r(PRS_EC,PRS,MDSPAR)
              IF(QPLOT) THEN
                  CALL UCOPY_r(PRP_EC(1,NPS1),PRP(1,NPS1),NPC*MDSPAR)
              ENDIF
          ELSEIF(COMND2.EQ.'KEY') THEN
              CALL TCOPY(TKYSEC,TKYS,MDSKEY)
              IF(QPLOT) THEN
                  CALL TCOPY(TKYPEC(1,NPS1),TKYP(1,NPS1),MDSKEY)
              ENDIF
          ENDIF
C
C     Luminosity Monitor BGO
C
      ELSEIF(COMND3.EQ.'FBGO') THEN
          THEAD = 'Luminosity Monitor BGO display parameters'
          IF(COMND2.EQ.'PARAMETER') THEN
              CALL TCOPY(TPARFB,TPAR,MDSPAR)
              CALL UCOPY_i(IPARFB,IPAR,MDSPAR)
              CALL UCOPY_r(PRD_FB,PRD,MDSPAR)
              CALL UCOPY_r(PRS_FB,PRS,MDSPAR)
              IF(QPLOT) THEN
                  NPC = NPS2 - NPS1 + 1
                  CALL UCOPY_r(PRP_FB(1,NPS1),PRP(1,NPS1),NPC*MDSPAR)
              ENDIF
          ELSEIF(COMND2.EQ.'KEY') THEN
              CALL TCOPY(TKYSFB,TKYS,MDSKEY)
              IF(QPLOT) THEN
                  CALL TCOPY(TKYPFB(1,NPS1),TKYP(1,NPS1),MDSKEY)
              ENDIF
          ENDIF
C
C     Luminosity Monitor Chambers
C
      ELSEIF(COMND3.EQ.'FWCH') THEN
          THEAD = 'Luminosity Monitor Chamber display parameters'
          IF(COMND2.EQ.'PARAMETER') THEN
              CALL TCOPY(TPARFW,TPAR,MDSPAR)
              CALL UCOPY_i(IPARFW,IPAR,MDSPAR)
              CALL UCOPY_r(PRD_FW,PRD,MDSPAR)
              CALL UCOPY_r(PRS_FW,PRS,MDSPAR)
              IF(QPLOT) THEN
                  NPC = NPS2 - NPS1 + 1
                  CALL UCOPY_r(PRP_FW(1,NPS1),PRP(1,NPS1),NPC*MDSPAR)
              ENDIF
          ELSEIF(COMND2.EQ.'KEY') THEN
              CALL TCOPY(TKYSFW,TKYS,MDSKEY)
              IF(QPLOT) THEN
                  CALL TCOPY(TKYPFW(1,NPS1),TKYP(1,NPS1),MDSKEY)
              ENDIF
          ENDIF
C
C     Luminosity Silicon Detector
C
      ELSEIF(COMND3.EQ.'FSIL') THEN
          THEAD = 'Luminosity Monitor Silicon display parameters'
          IF(COMND2.EQ.'PARAMETER') THEN
              CALL TCOPY(TPARFS,TPAR,MDSPAR)
              CALL UCOPY_i(IPARFS,IPAR,MDSPAR)
              CALL UCOPY_r(PRD_FS,PRD,MDSPAR)
              CALL UCOPY_r(PRS_FS,PRS,MDSPAR)
              IF(QPLOT) THEN
                  NPC = NPS2 - NPS1 + 1
                  CALL UCOPY_r(PRP_FS(1,NPS1),PRP(1,NPS1),NPC*MDSPAR)
              ENDIF
          ELSEIF(COMND2.EQ.'KEY') THEN
              CALL TCOPY(TKYSFS,TKYS,MDSKEY)
              IF(QPLOT) THEN
                  CALL TCOPY(TKYPFS(1,NPS1),TKYP(1,NPS1),MDSKEY)
              ENDIF
          ENDIF
C
C     L3 TEC
C
      ELSEIF(COMND3.EQ.'TECH') THEN
          THEAD = 'TEC display parameters'
          IF(COMND2.EQ.'PARAMETER') THEN
              CALL TCOPY(TPARTE,TPAR,MDSPAR)
              CALL UCOPY_i(IPARTE,IPAR,MDSPAR)
              CALL UCOPY_r(PRD_TE,PRD,MDSPAR)
              CALL UCOPY_r(PRS_TE,PRS,MDSPAR)
              IF(QPLOT) THEN
                  NPC = NPS2 - NPS1 + 1
                  CALL UCOPY_r(PRP_TE(1,NPS1),PRP(1,NPS1),NPC*MDSPAR)
              ENDIF
          ELSEIF(COMND2.EQ.'KEY') THEN
              CALL TCOPY(TKYSTE,TKYS,MDSKEY)
              IF(QPLOT) THEN
                  CALL TCOPY(TKYPTE(1,NPS1),TKYP(1,NPS1),MDSKEY)
              ENDIF
          ENDIF
#endif
#if ( defined(ZEUSDSP_SRC) )
C
C     ZEUS FDET
C
      IF(COMND3.EQ.'FDET') THEN
          THEAD = 'Forward detector display parameters'
          IF(COMND2.EQ.'PARAMETER') THEN
              CALL TCOPY(TPARFD,TPAR,MDSPAR)
              CALL UCOPY_i(IPARFD,IPAR,MDSPAR)
              CALL UCOPY_r(PRD_FD,PRD,MDSPAR)
              CALL UCOPY_r(PRS_FD,PRS,MDSPAR)
              IF(QPLOT) THEN
                  CALL UCOPY_r(PRP_FD(1,NPS1),PRP(1,NPS1),NPC*MDSPAR)
              ENDIF
          ELSEIF(COMND2.EQ.'KEY') THEN
              CALL TCOPY(TKYSFD,TKYS,MDSKEY)
              IF(QPLOT) THEN
                  CALL TCOPY(TKYPFD(1,NPS1),TKYP(1,NPS1),MDSKEY)
              ENDIF
          ENDIF
C
C     ZEUS FTD
C
      ELSEIF(COMND3.EQ.'FTD') THEN
          THEAD = 'Forward tracking detector display parameters'
          IF(COMND2.EQ.'PARAMETER') THEN
              CALL TCOPY(TPARFT,TPAR,MDSPAR)
              CALL UCOPY_i(IPARFT,IPAR,MDSPAR)
              CALL UCOPY_r(PRD_FT,PRD,MDSPAR)
              CALL UCOPY_r(PRS_FT,PRS,MDSPAR)
              IF(QPLOT) THEN
                  CALL UCOPY_r(PRP_FT(1,NPS1),PRP(1,NPS1),NPC*MDSPAR)
              ENDIF
          ELSEIF(COMND2.EQ.'KEY') THEN
              CALL TCOPY(TKYSFT,TKYS,MDSKEY)
              IF(QPLOT) THEN
                  CALL TCOPY(TKYPFT(1,NPS1),TKYP(1,NPS1),MDSKEY)
              ENDIF
          ENDIF
C
C     ZEUS TRD
C
      ELSEIF(COMND3.EQ.'TRD') THEN
          THEAD = 'Transition radiation detector display parameters'
          IF(COMND2.EQ.'PARAMETER') THEN
              CALL TCOPY(TPARTR,TPAR,MDSPAR)
              CALL UCOPY_i(IPARTR,IPAR,MDSPAR)
              CALL UCOPY_r(PRD_TR,PRD,MDSPAR)
              CALL UCOPY_r(PRS_TR,PRS,MDSPAR)
              IF(QPLOT) THEN
                  CALL UCOPY_r(PRP_TR(1,NPS1),PRP(1,NPS1),NPC*MDSPAR)
              ENDIF
          ELSEIF(COMND2.EQ.'KEY') THEN
              CALL TCOPY(TKYSTR,TKYS,MDSKEY)
              IF(QPLOT) THEN
                  CALL TCOPY(TKYPTR(1,NPS1),TKYP(1,NPS1),MDSKEY)
              ENDIF
          ENDIF
#endif
#if ( defined(L3DSP_SRC) || defined(ZEUSDSP_SRC) )
      ELSE
          CALL MN_ERR('MN_DSS','Detector ' // COMND3 //
     +     ' not implemented yet')
          GOTO 9000
      ENDIF
C
C     Set the new values of the parameters
C
      IF(COMND2.EQ.'PARAMETER') THEN
          IF(QPLOT) THEN
              CALL MN_ENM(IDELIM,THELP,THEAD,MDSPAR,TPAR,IPAR
     1         ,PRP(1,NPS1),NNUM,RNUM,IERR)
          ELSE
              CALL MN_ENM(IDELIM,THELP,THEAD,MDSPAR,TPAR,IPAR
     1         ,PRS,NNUM,RNUM,IERR)
          ENDIF
C
          DO 3000 II=1,NNUM
              IF(RNUM(II).EQ.0.0) RNUM(II) = PRD(II)
              IF(QPLOT) THEN
                  DO 2900 NP=NPS1,NPS2
                      PRP(II,NP) = RNUM(II)
2900              CONTINUE
              ENDIF
C
              IF(.NOT.QPLOT .OR.QZERO) THEN
                  PRS(II) = RNUM(II)
              ENDIF
3000      CONTINUE
      ELSEIF(COMND2.EQ.'KEY') THEN
          DO 3100 II=1,MDSKEY
              IF(QPLOT) THEN
                  TXTI = TKYP(II,NPS1)
              ELSE
                  TXTI = TKYS(II)
              ENDIF
              CALL MN_ETX(0,IDELIM,THEAD,TXTI,TEXT,IERR)
              IF(TEXT.EQ.' ') GOTO 3110
3100      CONTINUE
3110      CONTINUE
          IF(QPLOT) THEN
              DO 3200 NP=NPS1,NPS2
                  TKYP(II,NP) = TEXT
3200          CONTINUE
          ENDIF
C
          IF(.NOT.QPLOT .OR.QZERO) THEN
              TKYS(II) = TEXT
          ENDIF
      ENDIF
C
C     Put the parameters back in the arrays they belong in
C
#endif
#if ( defined(L3DSP_SRC) )
C     Electromagnetic calorimeter
C
      IF(COMND3.EQ.'ECAL') THEN
          IF(COMND2.EQ.'PARAMETER') THEN
              CALL UCOPY_r(PRS,PRS_EC,MDSPAR)
              IF(QPLOT) THEN
                  CALL UCOPY_r(PRP(1,NPS1),PRP_EC(1,NPS1),NPC*MDSPAR)
              ENDIF
          ELSEIF(COMND2.EQ.'KEY') THEN
              CALL TCOPY(TKYS,TKYSEC,MDSKEY)
              IF(QPLOT) THEN
                  CALL TCOPY(TKYP(1,NPS1),TKYPEC(1,NPS1),MDSKEY)
              ENDIF
          ENDIF
C
C     Luminosity Monitor BGO
C
      ELSEIF(COMND3.EQ.'FBGO') THEN
          IF(COMND2.EQ.'PARAMETER') THEN
              CALL UCOPY_r(PRS,PRS_FB,MDSPAR)
              IF(QPLOT) THEN
                  CALL UCOPY_r(PRP(1,NPS1),PRP_FB(1,NPS1),NPC*MDSPAR)
              ENDIF
          ELSEIF(COMND2.EQ.'KEY') THEN
              CALL TCOPY(TKYS,TKYSFB,MDSKEY)
              IF(QPLOT) THEN
                  CALL TCOPY(TKYP(1,NPS1),TKYPFB(1,NPS1),MDSKEY)
              ENDIF
          ENDIF
C
C     Luminosity Monitor Chambers
C
      ELSEIF(COMND3.EQ.'FWCH') THEN
          IF(COMND2.EQ.'PARAMETER') THEN
              CALL UCOPY_r(PRS,PRS_FW,MDSPAR)
              IF(QPLOT) THEN
                  CALL UCOPY_r(PRP(1,NPS1),PRP_FW(1,NPS1),NPC*MDSPAR)
              ENDIF
          ELSEIF(COMND2.EQ.'KEY') THEN
              CALL TCOPY(TKYS,TKYSFW,MDSKEY)
              IF(QPLOT) THEN
                  CALL TCOPY(TKYP(1,NPS1),TKYPFW(1,NPS1),MDSKEY)
              ENDIF
          ENDIF
C
C     Luminosity Monitor Silicon
C
      ELSEIF(COMND3.EQ.'FSIL') THEN
          IF(COMND2.EQ.'PARAMETER') THEN
              CALL UCOPY_r(PRS,PRS_FS,MDSPAR)
              IF(QPLOT) THEN
                  CALL UCOPY_r(PRP(1,NPS1),PRP_FS(1,NPS1),NPC*MDSPAR)
              ENDIF
          ELSEIF(COMND2.EQ.'KEY') THEN
              CALL TCOPY(TKYS,TKYSFS,MDSKEY)
              IF(QPLOT) THEN
                  CALL TCOPY(TKYP(1,NPS1),TKYPFS(1,NPS1),MDSKEY)
              ENDIF
          ENDIF
C
C     TEC
C
      ELSEIF(COMND3.EQ.'TECH') THEN
          IF(COMND2.EQ.'PARAMETER') THEN
              CALL UCOPY_r(PRS,PRS_TE,MDSPAR)
              IF(QPLOT) THEN
                  CALL UCOPY_r(PRP(1,NPS1),PRP_TE(1,NPS1),NPC*MDSPAR)
              ENDIF
          ELSEIF(COMND2.EQ.'KEY') THEN
              CALL TCOPY(TKYS,TKYSTE,MDSKEY)
              IF(QPLOT) THEN
                  CALL TCOPY(TKYP(1,NPS1),TKYPTE(1,NPS1),MDSKEY)
              ENDIF
          ENDIF
      ENDIF
#endif
#if ( defined(ZEUSDSP_SRC) )
C
C     ZEUS FDET
C
      IF(COMND3.EQ.'FDET') THEN
          IF(COMND2.EQ.'PARAMETER') THEN
              CALL UCOPY_r(PRS,PRS_FD,MDSPAR)
              IF(QPLOT) THEN
                  CALL UCOPY_r(PRP(1,NPS1),PRP_FD(1,NPS1),NPC*MDSPAR)
              ENDIF
          ELSEIF(COMND2.EQ.'KEY') THEN
              CALL TCOPY(TKYS,TKYSFD,MDSKEY)
              IF(QPLOT) THEN
                  CALL TCOPY(TKYP(1,NPS1),TKYPFD(1,NPS1),MDSKEY)
              ENDIF
          ENDIF
C
C     ZEUS FTD
C
      ELSEIF(COMND3.EQ.'FTD') THEN
          IF(COMND2.EQ.'PARAMETER') THEN
              CALL UCOPY_r(PRS,PRS_FT,MDSPAR)
              IF(QPLOT) THEN
                  CALL UCOPY_r(PRP(1,NPS1),PRP_FT(1,NPS1),NPC*MDSPAR)
              ENDIF
          ELSEIF(COMND2.EQ.'KEY') THEN
              CALL TCOPY(TKYS,TKYSFT,MDSKEY)
              IF(QPLOT) THEN
                  CALL TCOPY(TKYP(1,NPS1),TKYPFT(1,NPS1),MDSKEY)
              ENDIF
          ENDIF
C
C     ZEUS TRD
C
      ELSEIF(COMND3.EQ.'TRD') THEN
          IF(COMND2.EQ.'PARAMETER') THEN
              CALL UCOPY_r(PRS,PRS_TR,MDSPAR)
              IF(QPLOT) THEN
                  CALL UCOPY_r(PRP(1,NPS1),PRP_TR(1,NPS1),NPC*MDSPAR)
              ENDIF
          ELSEIF(COMND2.EQ.'KEY') THEN
              CALL TCOPY(TKYS,TKYSTR,MDSKEY)
              IF(QPLOT) THEN
                  CALL TCOPY(TKYP(1,NPS1),TKYPTR(1,NPS1),MDSKEY)
              ENDIF
          ENDIF
      ENDIF
#endif

C
9000  CONTINUE
      END
