      SUBROUTINE MN_CMD(NCFLG,NCERR)
C
C     CHECKS IF THE COMMAND IS A KNOWN STANDARD COMMAND
C     NCFLG = -1  CALLED FROM COMAND
C     NCFLG = +1  CALLED FROM MN_CMI
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mnfit.inc"
#include "mnfun.inc"
#include "mnhpj.inc"
#include "mncmd.inc"
#include "mntyq.inc"
#include "mngrn.inc"
#include "mntmp.inc"
#include "mnlun.inc"
C
      INTEGER MCMD,MCMD1
      PARAMETER (MCMD = 126, MCMD1 = 56)
      CHARACTER*10 CMDNAM(MCMD),CMDNM1(MCMD1),CMDNM2(MCMD-MCMD1)
      EQUIVALENCE(CMDNAM(1),      CMDNM1(1))
      EQUIVALENCE(CMDNAM(MCMD1+1),CMDNM2(1))
C
      INTEGER MREAD,MWRIT
      PARAMETER (MREAD=3)
      CHARACTER*10 REDNAM(MREAD)
      PARAMETER (MWRIT=3)
      CHARACTER*10 WRTNAM(MWRIT)
C
      INTEGER NCFLG,NCERR
C
      CHARACTER*255 TXT1,TXT2
      CHARACTER*50 FILNAM
C
      INTEGER ICMD,JCMD,NCMD,IDELIM,IERR,NMODE,NPAR,LUN,IOERR
     + ,N1,N2,I,LENT,NCMMOD,NTYPFL,NDERR,NDEV,NNID,NDHIS0
     + ,IDA,IDB,IDA1,IDB1,IDA2,IDB2
     + ,NCHAR,NCHR,IDUM
C
      INTEGER  ICMTYQ,INTTYQ,ISTTYQ,IQSTYQ,LNBLNK
      EXTERNAL ICMTYQ,INTTYQ,ISTTYQ,IQSTYQ
C
      DATA CMDNM1/
     1 'HELP',      'FUNCTION',  'COMIS',    'MESSAGE',   'WAIT',
     2 'HB_OPEN',   'OPEN',      'READ',
     3 'FETCH',     'HB_FETCH',  'HB3_FETCH',
     4 'AVE_FETCH', 'SCT_FETCH', 'DAT_FETCH','MN_FETCH',
     5 'WRITE',     'STORE',     'HB_STORE', 'DAT_STORE', 'MN_STORE',
     6 'HISTOGRAM', 'PLOT',      'OVERLAY',  'EXTRACT',   'LEGO',
     7 'DISPLAY',   'SURFACE',   'IGTABLE',  '2DIM',
     8 'NTUPLE',    'SCAN',      'MERGE',
     9 'SET',       'SHOW',      'COMMENT',  'KEY',       'DRAW',
     A 'CLEAR',     'REDRAW',    'CAPTURE',  'HARDCOPY',
     B 'CLOSE',     'HCLOSE',    'HB_MN_FIT',
     C 'DIRECTORY', 'INDEX',     'HINDEX',   'DBG_INDEX', 'PRINT',
     D 'PARTITION', 'COPY',      'RENAME',   'DELETE',    'TITLE',
     E 'ROOT_OPEN', 'ROOT_FETCH'
     Z /
      DATA CMDNM2/
     1 'HCOPY',     'HRENAME',   'HDELETE',   'HMAKE',    'HMERGE',
     + 'HRECOVER',
     2 'LDIRECTORY','ZDIRECTORY','CDIRECTORY','MDIRECTORY','WDIRECTORY',
     + 'LS',        'PWD',
     3 'ADD',       'SUBTRACT',  'MULTIPLY',  'DIVIDE',   'EFFICIENCY',
     4 'NORMALIZE', 'SCALE',     'AVERAGE',   'STAT',
     5 'XSHIFT',    'XSCALE',    'YSHIFT',    'YSCALE',
     6 'ZSHIFT',    'ZSCALE',
     6 'MADD',      'MSUBTRACT',
     7 'REBIN',     'SUM',       'INTEGRATE',
     8 'CALCULATE', 'DEPOSIT',   'EXAMINE',   'REMOVE',
     9 'BOOK',      'FILL',      'DUMP',      'SQUEEZE',
     A 'CUT',       'NO_CUT',    'PROJECT',   'WINDOW',   'NO_WINDOW',
     B 'EXECUTE',   'RETURN',    'DEFINE',    'UNDEFINE', 'INQUIRE',
     C 'SHELL',     'SPAWN',     'EDIT',      'ATTACH',
     D 'SMOOTH',    'SPLINE',
     E 'DO',        'ENDDO',     'IF',        'ELIF',     'PARSE',
     F 'CALL_COMIS','ALIAS',     'UNALIAS',
     G 'DATABASE',  'DB_HISTORY','DB_SNAP',
     H 'DBG_BREAK',
     Z ' '/
C
      DATA REDNAM/'DATA','COMMAND',' '/
C
      DATA WRTNAM/'DATA','LOG',' '/
C
      NCERR = 0
C
      CALL WAITYQ('Give command: ')
      ICMD = ICMTYQ(.TRUE.,IDELIM,CMDNAM)
      COMND1 = ' '
      IF(ICMD.GT.0) COMND1 = CMDNAM(ICMD)
      CALL MN_DCK(IDELIM,ICMD,MCMD,CMDNAM,IERR)
      IF(ICMD.LT.0 .OR. IERR.NE.0) THEN
          NCERR = IERR
          GOTO 9000
      ENDIF
C
C     DO AN OPERATION ON A FUNCTION
C
      IF(COMND1.EQ.'FUNCTION') THEN
          CALL MN_FUN
C
C     READ IN A LIST OF COMMANDS FROM A FILE
C     OR DATA TO FIT FROM A FILE
C
      ELSEIF(COMND1.EQ.'READ' .OR. COMND1.EQ.'EXECUTE') THEN
cif          IF(QIF) IFIIFL = IFIIFL + 1
          IF(COMND1.EQ.'EXECUTE') THEN
              JCMD = 2
              COMND2 = 'COMMAND'
              GOTO 2210
          ENDIF
 2200     CONTINUE
          CALL WAITYQ('Read in data, commands or ?: ')
          JCMD = ICMTYQ(.TRUE.,IDELIM,REDNAM)
          IF(JCMD.LT.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
              CALL QUOTYQ(COMND1)
              IDELIM = 0
              CALL MN_HLP(IDELIM,IERR)
              GOTO 2200
          ENDIF
C
          COMND2 = ' '
          IF(JCMD.GT.0) COMND2 = REDNAM(JCMD)
 2210     CONTINUE
          IF(JCMD.LE.0 .OR. IDELIM.GT.0) THEN
              CALL MN_DCK(IDELIM,JCMD,MREAD,REDNAM,IERR)
              IF(IERR.EQ.2) CALL MN_UNK('MN_CMD')
              GOTO 9000
          ELSEIF(COMND2.EQ.'DATA') THEN
              CALL MN_CDF(IDELIM)
          ELSEIF(COMND2.EQ.'COMMAND') THEN
              NMODE = -1
              CALL TYQOPN(NMODE,IDELIM)
          ELSE
              CALL MN_ERR('MN_CMD','Command not valid here')
          ENDIF
C
C     Get the value of a parameter
C
      ELSEIF(COMND1.EQ.'INQUIRE') THEN
          NPAR = 0
          CALL TYQINQ(NPAR,IDELIM)
C
C     START A DO LOOP
C
      ELSEIF(COMND1.EQ.'DO') THEN
          CALL M_LOOP(IDELIM,IERR)
C
C     ENDDO command - Do nothing. It should not even get here
C     The only time it does get here is if there is an END command somewhere
C
C      ELSEIF(COMND1.EQ.'ENDDO') THEN
C          CALL M_EMSG('MN_CMD','ENDDO command found in MN_CMD')
C          CALL M_EMSG('MN_CMD','This should have been caught earlier')
C          CALL MN_ERR('MN_CMD','Report this error to the author please')
C          GOTO 9000
C
C     Evaluate an IF block or an ELSEIF block
C
      ELSEIF(COMND1.EQ.'IF' .or. COMND1.EQ.'ELIF')THEN
          IF(.NOT.QRFILE) THEN
              CALL MN_ERR('MN_CMD','Command only valid' //
     1         ' inside a file or an internally defined command')
              GOTO 9000
          ENDIF
          CALL M_IFPRS(IERR)
          IF(IERR.NE.0)THEN
             QIF(NTDEP) = .FALSE.
             IIFLV(NTDEP) = 0
             IF(IERR .EQ. 5) THEN
                 CALL MN_ERR('MN_CMD','Too many nested IFs.')
             ENDIF
          ELSE
             QIF(NTDEP) = .TRUE.
          ENDIF
C
C     Should never see ELSE or ENDIF, as these are taken care of in TYQRED.
C
C
C     Open an HBOOK4 histogram file
C
      ELSEIF(COMND1.EQ.'OPEN' .OR. COMND1.EQ.'HB_OPEN') THEN
          NMODE = -4
          CALL MN_HBF(IDELIM,NMODE)
C
C     Fetch an HBOOK version 4 histogram
C
      ELSEIF(COMND1.EQ.'FETCH' .OR. COMND1.EQ.'HB_FETCH') THEN
          NMODE = 4
          CALL MN_HBF(IDELIM,NMODE)
C
C     Fetch an HBOOK version 3 histogram
C
      ELSEIF(COMND1.EQ.'HB3_FETCH') THEN
          NMODE = 3
          CALL MN_HBF(IDELIM,NMODE)
C
C     READ IN AVEHST FORMAT HISTOGRAMS
C
      ELSEIF(COMND1.EQ.'AVE_FETCH') THEN
          CALL MN_AVF(IDELIM)
C
C     READ IN AVEHST SCATTER PLOTS
C
      ELSEIF(COMND1.EQ.'SCT_FETCH') THEN
          CALL MN_SCF(IDELIM)
C
C     READ IN DATA CARDS WHICH SPECIFY A HISTOGRAM
C
      ELSEIF(COMND1.EQ.'DAT_FETCH') THEN
          CALL MN_CDF(IDELIM)
C
C     READ IN N-DIMENSIONAL HISTOGRAMS
C
      ELSEIF(COMND1.EQ.'MN_FETCH') THEN
          CALL MN_MNF(IDELIM)
C
C     Open a root file
C
      ELSEIF(COMND1.EQ.'ROOT_OPEN') then
          CALL MN_rooto(IDELIM,IERR)
          if(ierr.ne.0) goto 9000
C
C     Read in root histograms
C
      ELSEIF(COMND1.EQ.'ROOT_FETCH') THEN
          CALL MN_rootf(IDELIM)
C
C     STORE THE HISTOGRAMS
C
      ELSEIF(COMND1.EQ.'STORE' .OR. COMND1.EQ.'HB_STORE') THEN
          CALL MN_HBS(IDELIM)
C
C     WRITE OUT SOMETHING
C
      ELSEIF(COMND1.EQ.'WRITE') THEN
 2600     CONTINUE
          CALL WAITYQ('Write data, log or ?: ')
          JCMD = ICMTYQ(.TRUE.,IDELIM,WRTNAM)
          COMND2 = ' '
          IF(JCMD.GT.0) COMND2 = WRTNAM(JCMD)
          IF(JCMD.LT.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
              CALL QUOTYQ(COMND1)
              IDELIM = 0
              CALL MN_HLP(IDELIM,IERR)
              GOTO 2600
          ELSEIF(JCMD.LE.0 .OR. IDELIM.GT.0) THEN
              CALL MN_DCK(IDELIM,JCMD,MWRIT,WRTNAM,IERR)
              IF(IERR.EQ.2) CALL MN_UNK('MN_CMD')
              GOTO 9000
          ELSEIF(COMND2.EQ.'DATA') THEN
              CALL MN_CDS(IDELIM)
C
C         WRITE THE LAST N COMMANDS TO A FILE
C
          ELSEIF(COMND2.EQ.'LOG') THEN
              LUN = 0
              CALL MN_FIL(-23,LUN,FILNAM,IDELIM,IERR)
              IF(IERR.NE.0) GOTO 9000
C
              TXT1 = 'Give number of commands to write (<CR>=   ): '
              IF(QTLOOP) THEN
                  WRITE(TXT1(40:42),'(I3)',IOSTAT=IOERR) MTCMD
              ELSE
                  WRITE(TXT1(40:42),'(I3)',IOSTAT=IOERR) NTCMD
              ENDIF
              CALL WAITYQ(TXT1(1:45))
              NCMD = INTTYQ(.TRUE.,IDELIM)
              IF(NCMD.LE.0 .OR. IDELIM.GT.0) THEN
                  IF(QTLOOP) THEN
                      NCMD = MTCMD
                  ELSE
                      NCMD = NTCMD
                  ENDIF
              ENDIF
C
              NCMD = MIN0(NCMD,MTCMD)
              N1 = NTCMD - NCMD + 1
              N2 = NTCMD
              IF(N1.LT.0 .AND. QTLOOP) THEN
                  N1 = N1 + MTCMD
                  DO 2660 I=N1,MTCMD
                      LENT= LNBLNK(TXTCMD(I))
                      WRITE(LUN,'(A)',IOSTAT=IOERR) TXTCMD(I)(1:LENT)
 2660             CONTINUE
                  N1 = 1
              ENDIF
              DO 2670 I=N1,N2
                  LENT= LNBLNK(TXTCMD(I))
                  WRITE(LUN,'(A)',IOSTAT=IOERR) TXTCMD(I)(1:LENT)
 2670         CONTINUE
C
              CLOSE(UNIT=LUN)
              CALL CLEO_FRELUN(LUN,'MN_FIL')
          ENDIF
C
C     WRITE OUT DATA CARDS
C
      ELSEIF(COMND1.EQ.'DAT_STORE') THEN
          CALL MN_CDS(IDELIM)
C
C     STORE AN N-DIMENSIONAL HISTOGRAM
C
      ELSEIF(COMND1.EQ.'MN_STORE') THEN
          CALL MN_MNS
C
C     EITHER PLOT A HISTOGRAM OR ADD ANOTHER HISTOGRAM TO THE PLOT
C
      ELSEIF(COMND1.EQ.'HISTOGRAM' .OR.
     +       COMND1.EQ.'PLOT'      .OR. COMND1.EQ.'OVERLAY' .OR.
     +       COMND1.EQ.'EXTRACT'   .OR.
     +       COMND1.EQ.'LEGO'      .OR. COMND1.EQ.'SURFACE' .OR.
     +       COMND1.EQ.'DISPLAY'   .OR.
     +       COMND1.EQ.'IGTABLE'   .OR. COMND1.EQ.'2DIM'    .OR.
     +       COMND1.EQ.'BOOK'      .OR. COMND1.EQ.'FILL'    .OR.
     +       COMND1.EQ.'DUMP') THEN
          CALL MN_HIS
C
C     Do an operation on an Ntuple
C
      ELSEIF(COMND1.EQ.'NTUPLE'    .OR.
     +       COMND1.EQ.'SCAN'      .OR. COMND1.EQ.'MERGE') THEN
          CALL MN_NTP
C
C     Update all Mn_Fit histograms from the HBOOK histograms
C
      ELSEIF(COMND1.EQ.'HB_MN_FIT') THEN
          IF(IDELIM.EQ.0) THEN
              CALL WAITYQ('Give histogram number(s): ')
              CALL MN_HRN(IDA1,IDA2,IDB1,IDB2,IDELIM,NNID)
              IF(NNID.LE.0) GOTO 9000
          ELSE
              IDA1 = 0
              IDA2 = 0
          ENDIF
          IDB    = NDIDB
          NDHIS0 = NDHIS
          CALL M_HBMN(IDA1,IDA2,IDB,4)
          NNID   = 1
          CALL MN_HNG('M_NTPSCN',NNID,NDHIS0,1,IDA1,IDA2,IDB,IDB)
C
C     SET AN OPTION OR VALUE FOR PLOT
C
      ELSEIF(COMND1.EQ.'SET') THEN
          CALL MN_SET(IDELIM)
C
C     Show the SET values. If MN_SHW does not have the parameter it passes it
C     to MN_SET.
C
      ELSEIF(COMND1.EQ.'SHOW') THEN
          CALL MN_SHW(' ')
C
C     Call a COMIS subroutine
C
      ELSEIF(COMND1.EQ.'CALL_COMIS') THEN
          CALL M_CALL_COMIS
C
C     INVOKE COMIS
C
      ELSEIF(COMND1.EQ.'COMIS') THEN
          CALL CSPAUS('Entering COMIS')
C
C     ADD A COMMENT TO A HISTOGRAM
C
      ELSEIF(COMND1.EQ.'COMMENT') THEN
          NCMMOD = 1
          CALL MN_COM(NCMMOD,IDELIM)
C
C     GIVE A KEY TO THE MEANING OF SYMBOLS
C
      ELSEIF(COMND1.EQ.'KEY') THEN
          NCMMOD = 2
          CALL MN_COM(NCMMOD,IDELIM)
C
C     REDRAW THE LAST PLOT
C
      ELSEIF(COMND1.EQ.'REDRAW') THEN
          NTYPFL = 2
          IF(QDFIT) NTYPFL = -2
          CALL MN_DRW(NTYPFL,NDERR)
C
C     CAPTURE A NEW OUTPUT DEVICE
C
      ELSEIF(COMND1.EQ.'CAPTURE') THEN
          NDEV = 0
          CALL M_CAPT(0,NDEV,IDELIM,IERR)
C
C     MAKE A HARD COPY
C
      ELSEIF(COMND1.EQ.'HARDCOPY') THEN
          NTYPFL = 3
          IF(QDFIT) NTYPFL = -3
          CALL M_HARD(NTYPFL,IDELIM)
C
C     CLOSE THE CURRENT HARDCOPY DEVICES
C
      ELSEIF(COMND1.EQ.'CLOSE') THEN
          CALL TVHCLS(0)
          CALL MN_TOF(.FALSE.)
C
C     Close all current open histogram files
C
      ELSEIF(COMND1.EQ.'HCLOSE') THEN
          CALL M_HCLS
C
C     GIVE AN INDEX OF HISTOGRAMS READ IN
C
      ELSEIF(COMND1.EQ.'DIRECTORY' .OR. COMND1.EQ.'INDEX' .OR.
     +       COMND1.EQ.'DBG_INDEX') THEN
          NNID = 0
          IDA1 = 0
          IDB1 = 0
          IDA2 = 0
          IDB2 = 0
          FILNAM = ' '
          IF(IDELIM.EQ.0) THEN
              CALL MN_HRN(IDA1,IDA2,IDB1,IDB2,IDELIM,NNID)
              IF(NNID.LE.0) GOTO 9000
          ENDIF
C
          IF(COMND1.EQ.'DBG_INDEX') THEN
              NMODE = 1
          ELSE
              NMODE = 0
          ENDIF
C
C         TURN OFF AND ON BREAK ENABLE AND TEKTRONIX MODE
C
          CALL MN_TOF(.FALSE.)
          CALL MN_IDX(IDA1,IDA2,IDB1,IDB2,NNID,NMODE)
C
C     GET HBOOK INDEX
C
      ELSEIF(COMND1.EQ.'HINDEX') THEN
          WRITE(LUNDMP,'(/,'' The following HBOOK histograms are''
     1     ,'' just available for plotting:'')')
          CALL MN_TOF(.FALSE.)
          CALL HOUTPU(LUNDMP)
          CALL HINDEX
          CALL HOUTPU(LUNTTO)
C
C     PRINT A HISTOGRAM ON THE DUMP DEVICE
C
      ELSEIF(COMND1.EQ.'PRINT') THEN
          CALL WAITYQ('Give histogram number: ')
          CALL MN_HRN(IDA1,IDA2,IDB1,IDB2,IDELIM,NNID)
          IF(NNID.LE.0) GOTO 9000
          CALL MN_TOF(.FALSE.)
          CALL HOUTPU(LUNDMP)
          NMODE = 0
          CALL MN_PRN(IDA1,IDA2,IDB1,IDB2,NNID,NMODE)
          CALL HOUTPU(LUNTTO)
C
C     TAKE OUT PART OF A HISTOGRAM
C
      ELSEIF(COMND1.EQ.'PARTITION') THEN
          CALL MN_PRT
C
C     COPY OR RENAME A HISTOGRAM
C
      ELSEIF(COMND1.EQ.'COPY'  .OR. COMND1.EQ.'RENAME' .OR.
     2       COMND1.EQ.'HCOPY' .OR. COMND1.EQ.'HRENAME') THEN
          CALL M_HCOP(IDELIM)
C
C     DELETE A HISTOGRAM
C
      ELSEIF(COMND1.EQ.'DELETE' .OR. COMND1.EQ.'HDELETE') THEN
          CALL M_HDEL(IDELIM)
C
C     NEW TITLE
C
      ELSEIF(COMND1.EQ.'TITLE') THEN
          CALL M_HTIT(IDELIM)
C
C     MAKE AN HBOOK HISTOGRAM FROM AN MN_FIT HISTOGRAM
C
      ELSEIF(COMND1.EQ.'HMAKE') THEN
          CALL WAITYQ('Give histogram number: ')
          CALL MN_HNO(IDA,IDB,IDELIM,NNID)
          IF(NNID.LE.0) GOTO 9000
          IF(IDA.LE.0) GOTO 9000
          CALL MN_HBN(IDA,IDB,IERR)
          IF(IERR.NE.0) THEN
              CALL MN_ERR('MN_CMD','Error making HBOOK plot')
          ENDIF
C
C     Change the current HBOOK directory
C
      ELSEIF(COMND1.EQ.'CDIRECTORY') THEN
          CALL M_CDIR(IDELIM,1,IERR)
C
C     List the contents of the current directory and change the
C     directory if necessary
C
      ELSEIF(COMND1.EQ.'LDIRECTORY' .OR. COMND1.EQ.'ZDIRECTORY' .or.
     +     comnd1.eq.'LS') THEN
          CALL M_LDIR(COMND1)
C
C     List the current directory and change the directory if necessary
C
      ELSEIF(COMND1.EQ.'PWD') THEN
          CALL M_LDIR(COMND1)
C
C     Make a new directory in memory
C
      ELSEIF(COMND1.EQ.'MDIRECTORY') THEN
          CALL M_MDIR(IDELIM)
C
C     Print the statistics of the HBOOK input file
C
      ELSEIF(COMND1.EQ.'STAT') THEN
          CALL M_HSTAT(IDELIM)
C
C     Set the working directory for file opening
C
      ELSEIF(COMND1.EQ.'WDIRECTORY') THEN
          CALL M_SPWD(IDELIM,1,IERR)
C
C     Call HMERGE to merge RZ files
C
      ELSEIF(COMND1.EQ.'HMERGE') THEN
        CALL M_HMERGE(IDELIM,IERR)
C
C     Call HRECOV to recover an Ntuple in a RZ file
C
      ELSEIF(COMND1.EQ.'HRECOVER') THEN
        CALL M_HRECOVER(IDELIM,IERR)
C
C     DO HISTOGRAM OPERATIONS
C
      ELSEIF(COMND1.EQ.'MADD' .OR. COMND1.EQ.'MSUBTRACT' .OR.
     + COMND1.EQ.'ADD'        .OR. COMND1.EQ.'SUBTRACT'  .OR.
     + COMND1.EQ.'MULTIPLY'   .OR. COMND1.EQ.'DIVIDE'    .OR.
     + COMND1.EQ.'EFFICIENCY' .OR. COMND1.EQ.'AVERAGE'   .OR.
     + COMND1.EQ.'NORMALIZE'  .OR. COMND1.EQ.'SCALE'     .OR.
     + COMND1.EQ.'XSHIFT'     .OR. COMND1.EQ.'XSCALE'    .OR.
     + COMND1.EQ.'YSHIFT'     .OR. COMND1.EQ.'YSCALE'    .OR.
     + COMND1.EQ.'ZSHIFT'     .OR. COMND1.EQ.'ZSCALE') THEN
          CALL MN_OPR
C
C     REBIN A HISTOGRAM
C
      ELSEIF(COMND1.EQ.'REBIN') THEN
          CALL MN_PRT
C
C     Sum a histogram or integrate a function over a range
C
      ELSEIF(COMND1.EQ.'SUM' .OR. COMND1.EQ.'INTEGRATE') THEN
          CALL MN_SUM(COMND1,IDELIM)
C
C     CALCULATE AN EXPRESSION
C
      ELSEIF(COMND1.EQ.'DEPOSIT' .OR. COMND1.EQ.'CALCULATE') THEN
5800      CONTINUE
          CALL WAITYQ('Give expression or ?: ')
          NCHAR = ISTTYQ(.TRUE.,IDELIM,TXT1)
          IF(NCHAR.LE.0) GOTO 9000
          IF(TXT1(1:1).EQ.'?') THEN
              CALL QUOTYQ('DEPOSIT')
              IDELIM = 0
              CALL MN_HLP(IDELIM,IERR)
              GOTO 5800
          ELSE
              CALL RESTYQ
          ENDIF
          CALL MN_CLC
C
C     EXAMINE THE VALUE OF A REGISTER, PARAMETER ETC.
C
      ELSE IF(COMND1.EQ.'EXAMINE') THEN
          CALL MN_EXM(IDELIM)
C
C     Remove a variable
C
      ELSE IF(COMND1.EQ.'REMOVE') THEN
          CALL M_REMV(IDELIM)
C
C     MAKE CUTS ON A HISTOGRAM
C
      ELSEIF(COMND1.EQ.'CUT') THEN
          CALL MN_CUT(0,IDELIM)
C
C     REMOVE CUTS ON A HISTOGRAM
C
      ELSEIF(COMND1.EQ.'NO_CUT') THEN
          CALL MN_CUT(1,IDELIM)
C
C     MAKE A PROJECTION OF A HISTOGRAM
C
      ELSEIF(COMND1.EQ.'PROJECT') THEN
          IDA = 0
          IDB = 0
          comnd2 = comnd1
          comnd1 = 'NTUPLE'
          CALL MN_PRJ(0,IDA,IDB)
C
C     DO SEVERAL PLOTS PER PAGE
C
      ELSEIF(COMND1.EQ.'WINDOW') THEN
          CALL MN_WND(1,IDELIM,.FALSE.,IDUM,IDUM)
C
C     TURN OFF WINDOWING
C
      ELSEIF(COMND1.EQ.'NO_WINDOW') THEN
          CALL MN_WND(-1,IDELIM,.FALSE.,IDUM,IDUM)
C
C     DRAW SOMETHING ON THE PICTURE
C
      ELSEIF(COMND1.EQ.'DRAW') THEN
          CALL MN_LDW(IDELIM)
C
C     COMPRESS THE DATA ARRAY
C
      ELSEIF(COMND1.EQ.'SQUEEZE') THEN
          CALL MN_SQZ
C
C     CLEAR THE OUTPUT SCREEN
C     Also remove any comments and keys and store the picture cordinates
C     the usual registers
C
      ELSEIF(COMND1.EQ.'CLEAR') THEN
          CALL M_CLEAR(IERR)
C
C     COMMANDS FOR SPAWNING SUBPROCESSES AND EDTING FILES FROM WITHIN
C     MN_FIT
C
      ELSEIF(COMND1.EQ.'SPAWN'  .OR. COMND1.EQ.'SHELL' .OR.
     1       COMND1.EQ.'ATTACH' .OR. COMND1.EQ.'EDIT') THEN
         CALL MN_SPW(COMND1,IDELIM)
C
C     Smooth or spline fit a histogram.
C
      ELSEIF(COMND1.EQ.'SMOOTH'  .OR. COMND1.EQ.'SPLINE') THEN
          CALL MN_SPL(IDELIM)
C
C     Write a message to the current output device
C
      ELSEIF(COMND1.EQ.'MESSAGE') THEN
          CALL WAITYQ('Give the message: ')
          TXT1 = ' '
          NCHR = IQSTYQ(.TRUE.,IDELIM,TXT1)
          NCHR = MAX0(NCHR,1)
          TXT2 = ' ' // TXT1(1:NCHR)
          CALL MN_TVL(TXT2,TXT1)
          CALL MN_MES(LUNDMP,'ME',TXT1)
C
C     Make a command line that also includes formatting
C
      ELSEIF(COMND1.EQ.'PARSE') THEN
          CALL WAITYQ('Give the command: ')
          TXT1 = ' '
          NCHR = IQSTYQ(.TRUE.,IDELIM,TXT1)
          TXT2 = TXT1(:NCHR)
          CALL MN_TVL(TXT2,TXT1)
          NCHR = LNBLNK(TXT1)
          IF(NCHR.GT.0) CALL QUOTYQ(TXT1(:NCHR))
C
C     Wait
C
      ELSEIF(COMND1.EQ.'WAIT') THEN
          CALL M_WAIT(IDELIM)
C
C     DEFINE A NEW COMMAND
C
      ELSEIF(COMND1.EQ.'DEFINE' .OR. COMND1.EQ.'UNDEFINE') THEN
          CALL M_DEFI(IDELIM,COMND1)
C
C     Define or undefine an alias
C
      ELSEIF(COMND1.EQ.'ALIAS' .OR. COMND1.EQ.'UNALIAS') THEN
          CALL M_ALIAS(IDELIM)
C
C     Get some information out of the database
C
      ELSEIF(COMND1.EQ.'DATABASE' .OR. COMND1.EQ.'DB_HISTORY' .OR.
     +       COMND1.EQ.'DB_SNAP') THEN
          CALL M_DBASE(IDELIM)
C
C     Generate a break or other arithmetic fault to check they work
C
      ELSEIF(COMND1.EQ.'DBG_BREAK') THEN
          CALL M_DBGBRK
C
      ELSE
          NCERR = 1
          IF(NCFLG.EQ.0) THEN
              WRITE(TXTERR,'(''Command: '',A
     1         ,'' not valid here'')') COMND1(1:LNBLNK(COMND1))
              CALL MN_ERR('MN_CMD',TXTERR)
          ENDIF
      ENDIF
C
 9000 CONTINUE
      END
