      SUBROUTINE MN_MNR(IDA1,IDA2,IDB1,IDB2,NNID,LUN,TFILE)
C
C     ROUTINE FOR READING IN MNBOOK PLOTS
C     NOTE THAT THEY WILL NOW ALWAYS BE READ INTO MEMORY
C
      implicit none
*
#include "mnpar.inc"
#include "mndat.inc"
#include "mntmp.inc"
#include "mnlun.inc"
C
#include "mnscr.inc"
      REAL BUFDAT(100)
      EQUIVALENCE(SCRATCH(1),BUFDAT(1))
*
      integer ida1,ida2,idb1,idb2,nnid,lun
C
      CHARACTER*(*) TFILE
      CHARACTER*80 TITLE
      CHARACTER*32 TNAME(MDIMMX)
C
      INTEGER IDBIN(MDIMMX)
      REAL ADLO(MDIMMX),ADHI(MDIMMX),AMEAN(MDIMMX),ASIG(MDIMMX)
      LOGICAL QRNGE
*
      integer nw,ii,jj,nwhead,nwdat,ida,idb,ndim,nwppt,npnt
     + ,nhdate,nhtime,nsdate,nstime,ntmode,lnblok,lnrec,nww,nh
     + ,nptrh,nptrd,nwh,nbt,nbppt,lentit,lennam,nd1,nwwtot,nnwd,nwtot
      real    edent,edlo,edhi
C
      QRNGE = IDA1.NE.IDA2 .OR. IDB1.NE.IDB2
C
C     READ IN THE HEADER
C
 1000 CONTINUE
      READ(LUN,ERR=9100,END=9200) NW,(BUFDAT(II),II=1,NW)
      NWHEAD = NINT(BUFDAT(2))
      NWDAT  = NINT(BUFDAT(3))
      IDA   = NINT(BUFDAT(4))
      IDB   = NINT(BUFDAT(5))
      CALL MN_HDR(BUFDAT(1),NDIM,NWPPT,NPNT
     + ,NHDATE,NHTIME,NSDATE,NSTIME,NTMODE
     + ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT,AMEAN,ASIG)
      LNBLOK = NINT(BUFDAT(NW-1))
      LNREC  = NINT(BUFDAT(NW))
C
C     SORT OUT THE NUMBER OF DATA WORDS TO READ IN
C
      IF(NDIM.GT.0) THEN
          NWW = NWDAT
      ELSE
          NWW = NPNT * NWPPT
      ENDIF
C
C     SEE IF THIS IS THE CORRECT HISTOGRAM
C
      IF((.NOT.QRNGE .AND.
     1    (IDA1.EQ.0 .AND. NNID.EQ.1) .OR.
     1    (IDA1.EQ.0 .AND. IDB.EQ.IDB1) .OR.
     2    (IDA1.EQ.IDA .AND. IDB1.EQ.IDB)) .OR.
     4   (QRNGE .AND.
     5    (IDA1.EQ.0 .AND. NNID.EQ.1) .OR.
     6    (IDA1.EQ.0 .AND. IDB.GE.IDB1 .AND. IDB.LE.IDB2) .OR.
     7    (IDA.GE.IDA1 .AND. IDA.LE.IDA2 .AND.
     8     IDB.GE.IDB1 .AND. IDB.LE.IDB2))) THEN
C
C         BOOK THE NEW HISTOGRAM
C
          CALL MN_HNW(IDA,IDB,NDIM,NWDAT,NH,NPTRH,NPTRD,NWH
     +     ,NBPPT,NTMODE)
          IF(NH.LE.0) GOTO 9000
C
          IF(NDIM.LT.0) THEN
              NWDAT = NWW
              BUFDAT(1) = FLOAT(NWHEAD + NWDAT)
              BUFDAT(3) = FLOAT(NWDAT)
          ENDIF
C
C         COPY THE HEADER TO THE RIGHT PLACE
C
          CALL UCOPY_r(BUFDAT(1),RDAT(NPTRH),NWHEAD)
C
C         For dimension -1 see if the underflows and overflows are
*         really stored
*
          IF(NDIM.EQ.-1) THEN
              IF(NWHEAD.EQ.15       .OR.
     +           NWHEAD.EQ.15+2     .OR.
     +           NWHEAD.EQ.15+2+2  ) THEN
*ICB     +           NWHEAD.EQ.15+2+2+3) THEN
                  RDAT(15+1) = -1.0
                  RDAT(15+2) = -1.0
                  RDAT(15+3) = -1.0
                  IF(NWHEAD.GT.15)
     +             CALL UCOPY_r(BUFDAT(15+1),RDAT(NPTRH+15+3),NWHEAD-15)
                  NWHEAD = NWHEAD + 3
                  RDAT(NPTRH)   = RDAT(NPTRH) + 3
                  RDAT(NPTRH+1) = RDAT(NPTRH+1) + 3
              ENDIF
          ENDIF
C
C         Zero any header words that have come from header expansion
C         and fix up the total number of words
C
          IF(NWH.GT.NWHEAD) THEN
              CALL VZERO_r(RDAT(NPTRH+NWHEAD),NWH-NWHEAD)
              RDAT(NPTRH)   = NWH + NWDAT
              RDAT(NPTRH+1) = NWH
          ENDIF
C
          READ(LUN,ERR=9100,END=9300) NBT,LENTIT,LENNAM
     1     ,TITLE,(TNAME(II)(1:LENNAM),II=1,IABS(NDIM))
C
C         READ IN ALL THE POINTS FOR N-DIMENSIONAL HISTOGRAMS AND EITHER
C         1 OR 2 DIMENSIONAL SCATTER PLOTS.
C         ALSO READ IN THE DATA POINTS
C         FOR A SCATTER PLOT WITH MORE THEN 2 DIMENSIONS
C
          ND1 = NPTRD
            NWWTOT = 0
          DO 2900 JJ=1,LNREC
              READ(LUN,ERR=9100,END=9300) NNWD
     1         ,(RDAT(II),II=ND1,ND1+NNWD-1)
              ND1 = ND1 + NNWD
              NWWTOT = NWWTOT + NNWD
 2900     CONTINUE
C
C         CHECK THAT WE REALLY READ IN THE NUMBER OF WORDS EXPECTED
C
          IF(NWWTOT.NE.NWW) THEN
              WRITE(LUNTTO,'('' MN_MNR: Histogram'',I7,I4
     1         ,'' I read in'',I6,'' while expecting'',I6,'' words'')')
     2         IDA,IDB,NWWTOT,NWW
              GOTO 3000
          ENDIF
C
C         UPDATE THE POINTERS
C
          NWTOT = NWH + NWDAT
          CALL MN_PTU(NH,NWTOT,IDA,IDB,NPTRH,NPTRD,TITLE
     1     ,TFILE,' ',TNAME)
C
3000      CONTINUE
          IF(QRNGE .OR. IDA1.EQ.0) GOTO 1000
C
C     NOT THE RIGHT HISTOGRAM
C
      ELSE
          READ(LUN) BUFDAT(1)
          DO 3900 JJ=1,LNREC
              READ(LUN,ERR=9100,END=9300) BUFDAT(1)
 3900     CONTINUE
          GOTO 1000
      ENDIF
C
 9000 CONTINUE
      GOTO 9900
C
C     ERROR FETCHING A PLOT
C
 9100 CONTINUE
      WRITE(LUNTTO,'('' *** MN_MNR: Error fetching MNBOOK histogram''
     1 ,I7,I4)') IDA,IDB
      GOTO 9900
C
C     END OF FILE READING THE HEADER
C
9200  CONTINUE
      GOTO 9900
C
C     END OF FILE TRYING TO READ IN DATA
C
 9300 CONTINUE
      WRITE(LUNTTO,'('' *** MN_MNR: End of file fetching MNBOOK''
     1 ,'' histogram'',I7,I4)') IDA1,IDB1
      GOTO 9900
C
9900  CONTINUE
      RETURN
      END
