      FUNCTION VALSUB(LWAIT,IDELIM,IFLG)

C  -------------------------------------------------------------------
C     Get value. Can be number, register, parameter, or function value
C     IFLG = 0 means try as a real number
C     IFLG = 1 means try as an integer
C     However a real number is always returned
C  -------------------------------------------------------------------
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mnfun.inc"
#include "mncmd.inc"
#include "mnprs.inc"
C
      LOGICAL LWAIT
      LOGICAL QPASS,QMNRGT
      DOUBLE PRECISION XMNFUN,XMNALL,WMNHER
C
      CHARACTER*32 COMAND
C
      VALSUB = 0.
C
C     See if it's a real number
C
      IF(IFLG.EQ.0) THEN
          REL = RELTYP(LWAIT,IDELIM)
      ELSE
          REL = FLOAT(INTTYP(LWAIT,IDELIM))
      ENDIF
      IF(IDELIM.GT.0) THEN
          NCHFND = NCHSCN()
          IF(NCHFND.GT.0) THEN
              VALSUB = REL
              RETURN
          ENDIF
      ELSEIF(IDELIM .LE. 0) THEN
          VALSUB = REL
          GOTO 999
      ENDIF
C
C     It's not; see if it's one of our defined entities
C     Increase the list of standard delimiters
C
      TS2SCN = TSDSCN
      TSDSCN = ',()[]{}&:'
      LENT   = LENOCC(TSDSCN)
      CALL SDLSCN(TSDSCN(1:LENT))
C
      CALL RESTYP
      CALL M_CGET(0,COMAND,ICMD,IDELIM)
C
C     If no characters found set IDELIM to the delimiter
C
      IF(ICMD.LE.0) THEN
          ICH = LCHTYP()
          LEN = LENOCC(TS2SCN)
          DO 1000 I=1,LEN
              IF(ICH.EQ.ICHAR(TS2SCN(I:I))) THEN
                  GOTO 9000
              ENDIF
1000      CONTINUE
          IDELIM = ICH
      ENDIF
      IF(ICMD.LE.0 .OR. IDELIM.GT.0) GOTO 9000
C
C     A variable - leave the pointer on the delimiter
C     Do not position the pointer just before the delimiter
C
      IF(ICMD.GT.MDEPI) THEN
cicb          CALL M_VRES(IDELIM)
C
          NUM = ICMD - MDEPI + MVAR0
          VALSUB = REGIS(NUM)
C
C     Resister
C
      ELSEIF(COMAND .EQ. 'R' .OR. COMAND .EQ. 'IR') THEN
          CALL WAITYP('Register #: ')
          CALL RESTYP
          CALL M_RGET(1,COMAND,NUM,QPASS,IDELIM)
          IF(.NOT.QPASS) GOTO 9000
C
          VALSUB = REGIS(NUM)
C
C     Parameter
C
      ELSE IF(COMAND .EQ. 'P'   .OR. COMAND.EQ.'ERR' .OR.
     +        COMAND.EQ.'ERP'   .OR. COMAND.EQ.'ERN' .OR.
     +        COMAND.EQ.'LOLIM' .OR. COMAND.EQ.'HILIM') THEN
          CALL WAITYP('Function #: ')
          CALL RESTYP
          CALL M_PGET(2,COMAND,IFUN,IPAR,QPASS,IDELIM)
          IF(.NOT.QPASS) GOTO 9000
C
          IF(COMAND.EQ.'P') THEN
              IF(IFUN.GT.0) THEN
                  VALSUB = FPAR(IPAR,IFUN)
              ELSE
                  VALSUB = F00
              ENDIF
          ELSE IF(COMAND.EQ.'ERR') THEN
              IF(IFUN.GT.0) THEN
                  VALSUB = DFPAR(IPAR,IFUN)
              ELSE
                  VALSUB = DF00
              ENDIF
          ELSE IF(COMAND.EQ.'ERP') THEN
              IF(IFUN.GT.0) THEN
                  VALSUB = DPFPAR(IPAR,IFUN)
              ELSE
                  VALSUB = DPF00
              ENDIF
          ELSE IF(COMAND.EQ.'ERN') THEN
              IF(IFUN.GT.0) THEN
                  VALSUB = DNFPAR(IPAR,IFUN)
              ELSE
                  VALSUB = DNF00
              ENDIF
          ELSE IF(COMAND.EQ.'LOLIM') THEN
              IF(IFUN.GT.0) THEN
                  VALSUB = FPARLO(IPAR,IFUN)
              ELSE
                  VALSUB = F00LO
              ENDIF
          ELSE IF(COMAND.EQ.'HILIM') THEN
              IF(IFUN.GT.0) THEN
                  VALSUB = FPARHI(IPAR,IFUN)
              ELSE
                  VALSUB = F00HI
              ENDIF
          ENDIF
C
C     Function
C
      ELSE IF(COMAND .EQ. 'F') THEN
          CALL WAITYP('Function #: ')
          CALL RESTYP
          CALL M_FGET(0,COMAND,IFUN,ARG,QPASS,IDELIM)
          IF(.NOT.QPASS) GOTO 9000
C
          ARG  = VL2TYP(LWAIT,IDELIM)
C
C         Check for right parenthesis
C
          ICH = LCHTYP()
          IF(.NOT.QMNRGT(CHAR(ICH))) THEN
              CALL MN_ERR('VALSUB','Right parenthesis not found')
              GOTO 9000
          ENDIF
C
          VAL2 = 0.0
          IF(IFUN .EQ. 0) THEN
            VALSUB = XMNALL(ARG,VAL2,NNHDT,WMNHER)
          ELSE
            VALSUB = XMNFUN(ARG,VAL2,IFUN,NNHDT,FPAR(1,IFUN),WMNHER)
          ENDIF
C
C     Data value
C
      ELSE IF(COMAND.EQ.'X'   .OR. COMAND.EQ.'Y'   .OR.
     +        COMAND.EQ.'DX'  .OR. COMAND.EQ.'DY'  .OR.
     +        COMAND.EQ.'DNX' .OR. COMAND.EQ.'DNY' .OR.
     +        COMAND.EQ.'DPX' .OR. COMAND.EQ.'DPY') THEN
          CALL WAITYP('Histogram #: ')
          CALL RESTYP
          CALL M_HGET(2,COMAND,ISET,IBIN,IVAR,QPASS,IDELIM)
          IF(.NOT.QPASS) GOTO 9000
C
          NERR = 0
          IF(COMAND.EQ.'X' .AND. IVAR.GT.0) THEN
              VALSUB = AMNP(IBIN,ISET,IVAR,1,IERR)
          ELSEIF(COMAND.EQ.'X') THEN
              VALSUB = AMNX(IBIN,ISET,NERR)
          ELSE IF(COMAND.EQ.'Y') THEN
              VALSUB = AMNE(IBIN,ISET,NERR)
          ELSE IF(COMAND.EQ.'DX') THEN
              VALSUB = AMNDXN(IBIN,ISET,NERR)
          ELSE IF(COMAND.EQ.'DY') THEN
              VALSUB = AMNDEN(IBIN,ISET,NERR)
          ELSE IF(COMAND.EQ.'DNX') THEN
              VALSUB = AMNDXN(IBIN,ISET,NERR)
          ELSE IF(COMAND.EQ.'DNY') THEN
              VALSUB = AMNDEN(IBIN,ISET,NERR)
          ELSE IF(COMAND.EQ.'DPX') THEN
              VALSUB = AMNDXP(IBIN,ISET,NERR)
          ELSE IF(COMAND.EQ.'DPY') THEN
              VALSUB = AMNDEP(IBIN,ISET,NERR)
          ENDIF
      ENDIF
C
C     Use old standard delimiters
C
9000  CONTINUE
      TSDSCN = TS2SCN
      LENT   = LENOCC(TSDSCN)
      CALL SDLSCN(TSDSCN(1:LENT))
999   END
