      SUBROUTINE MN_ENM (IDELIM,THELP,THEAD,MDIM,TNAME,INAME,RNAME
     1 ,NSET,RSET,IERR)
C
C     GENERAL SUBROUTINE WHICH GIVES THE PRESENT VALUES OF A SET
C     OF PARAMETERS AND THEN RETURNS THE NEW ONES
C     THIS ROUTINE WILL USE SMG ROUTINES IN THE NEAR FUTURE
C     TO GIVE A MENU TYPE DISPLAY
C
C     INPUT PARAMETERS:
C
C     THELP IS THE STRING TO PASS TO MN_HLP FOR HELP
C           If THELP = 'SHOW' then the current values of the parameters
C           will be listed only.
C     THEAD IS HEADER TEXT
C     TNAME ARE THE NAMES OF THE PARAMETERS
C     INAME = 0 MEANS NO MORE PARAMETERS
C           = 1 MEANS REAL PARAMETER
C           = 2 MEANS INTEGER PARAMETER
C           = 3 MEANS AN OPTION (LEFT, CENTRE OR RIGHT)
C           = 4 MEANS DIMENSIONS (CM OR PLOT)
C           = 5 means colour
C           = 6 means a date yymmdd.hhmmss format
C           = 7 means a time hh:mm format
C     RNAME ARE THE PRESENT VALUES OF THE PARAMETERS
C
C     OUTPUT PARAMETERS:
C
C     NSET ARE THE NUMBER OF PARAMETERS WHICH HAVE BEEN CHANGED
C     RSET ARE THE NEW VALUES
C     IERR IS AN ERROR RETURN
C      0 IS NORMAL
C     -1 TERMINATED BY A MODE COMMAND
C
      implicit none
*
#include "mncmd.inc"
#include "mnflg.inc"
#include "mnlun.inc"
C
      INTEGER IDELIM,MDIM,NSET,IERR
      CHARACTER*(*) THELP,THEAD,TNAME(MDIM)
      INTEGER INAME(MDIM)
      REAL RNAME(MDIM),RSET(MDIM)
C
C      CHARACTER*10 HLPNAM(2)
C
      CHARACTER*30 TFORMAT
      CHARACTER*13 TNUMB(2)
      LOGICAL QNEW,Q2COL,QUMOUS
      integer nparm,nnum,nopt,ndim,ncol
     + ,ntmin,ndate,ntime,nhour,nmin,ntdb,i,lenpr,lnblnk
     + ,istat,nval,nherr,jcmd,nnext,jdelim,nchfnd
     + ,nmatch,nlist,ilist(2)
      real xpos,ypos,rval
*
      integer  icmtyq,inttyq,ivltyq,ichtyp,nchscn,icmlst
      real     valtyq,am_tdif
      external icmtyq,inttyq,ivltyq,ichtyp,nchscn,icmlst,valtyq,am_tdif
C
C      DATA HLPNAM/'HELP',' '/
C
      NSET = 0
      NPARM = 0
      IERR = 0
C
      DO 1000 I=1,MDIM
          IF(INAME(I).EQ.0) THEN
              NPARM = I - 1
              GOTO 1010
          ENDIF
1000  CONTINUE
      NPARM = MDIM
1010  CONTINUE
      IF(NPARM.LE.0) THEN
          CALL MN_ERR('MN_ENM','There are no parameters given')
          GOTO 9000
      ENDIF
C
      Q2COL = THELP.EQ.'SHOW' .OR. NPARM.GE.10
C
      QNEW = .TRUE.
      DO 1100 I=1,NPARM
          IF(RNAME(I).NE.0.0) THEN
              QNEW= .FALSE.
              GOTO 1110
          ENDIF
1100  CONTINUE
1110  CONTINUE
C
C     Check if the mouse should be used
C
CICB      QUMOUS = THELP.NE.'SHOW' .AND. .NOT.QRFILE .AND.
      QUMOUS = THELP.NE.'SHOW' .AND.
     + QMOUSE .AND. NPARM.GE.2 .AND.
     + TNAME(1).EQ.'X position' .AND. TNAME(2).EQ.'Y position'
C
      IF(THELP.EQ.'SHOW' .OR.
     +   (IDELIM.LT.0 .AND. .NOT.QRFILE)) THEN
          LENPR = LNBLNK(THEAD)
          IF(LENPR.GT.0) THEN
              TXTMES = ' '//THEAD(1:LENPR)
              CALL MN_MES(LUNTTO,'I',TXTMES)
          ENDIF
C
          DO 2000 I=1,NPARM
              IF(Q2COL .AND. MOD(I,2).EQ.0) THEN
                  NNUM = 2
              ELSE
                  NNUM = 1
              ENDIF
C
              IF(INAME(I).EQ.1) THEN
                  TFORMAT = '(1PG11.4)'
              ELSE IF(INAME(I).EQ.2) THEN
                  TFORMAT = '(I11)'
              ELSE IF(INAME(I).EQ.6) THEN
                  TFORMAT = '(I6.6,''/'',I6.6)'
              ELSE IF(INAME(I).EQ.7) THEN
                  TFORMAT = '(I2.2,'':'',I2.2)'
              ELSE
                  TFORMAT = '(A11)'
              ENDIF
              IF(INAME(I).EQ.1) THEN
                  WRITE(TNUMB(NNUM),TFORMAT) RNAME(I)
              ELSEIF(INAME(I).EQ.2) THEN
                  WRITE(TNUMB(NNUM),TFORMAT) NINT(RNAME(I))
              ELSEIF(INAME(I).EQ.3) THEN
                  NOPT = NINT(RNAME(I)) + 2
                  WRITE(TNUMB(NNUM),TFORMAT) OPTNAM(NOPT)
              ELSEIF(INAME(I).EQ.4) THEN
                  NDIM = NINT(RNAME(I)) + 1
                  WRITE(TNUMB(NNUM),TFORMAT) UNTNAM(NDIM)
*
*             Colour
*
              ELSEIF(INAME(I).EQ.5) THEN
                  NCOL = NINT(RNAME(I))
                  WRITE(TNUMB(NNUM),TFORMAT) COLNAM(NCOL)
*
*             Date - stored in days
*             Try to decide what format the date is in
*
              ELSEIF(INAME(I).EQ.6) THEN
*
*                 It is a date
*
                  if(rname(i).gt.800000.0) then
                      ndate = nint(rname(i))
                      ntime = max0(0
     +                 ,nint(10000.0*(rname(i)-float(ndate))))
*
*                 It is a number of days since 1 Jan 1980
*
                  else
                      ntmin = nint(rname(i)*60.0*24.0)
                      call m_ptim(ndate,ntime,ntmin)
                  endif
*
                  write(tnumb(nnum),tformat) ndate,ntime*100
*
*             Time - stored in hours
*
              elseif(iname(i).eq.7) then
                  ntmin = nint(rname(i)*60.0)
                  call m_ptim(ndate,ntime,ntmin)
                  nhour = ntime / 100
                  nmin  = ntime - 100*nhour
                  write(tnumb(nnum),tformat) nhour,nmin
              ENDIF
C
              IF(Q2COL .AND. MOD(I,2).EQ.0)  THEN
                  WRITE(TXTMES,'(1X,A,A,T40,A,A)')
     +             TNAME(I-1),TNUMB(1),TNAME(I),TNUMB(2)
                  CALL MN_MES(LUNTTO,'I',TXTMES)
              ELSEIF(.NOT.Q2COL .OR. I.EQ.NPARM) THEN
                  WRITE(TXTMES,'(1X,A,A)')
     +             TNAME(I),TNUMB(1)
                  CALL MN_MES(LUNTTO,'I',TXTMES)
              ENDIF
2000      CONTINUE
          CALL MN_MES(LUNTTO,'E',' ')
          IF(THELP.EQ.'SHOW') GOTO 9000
C
          IF(THELP.NE.'SHOW' .AND. QUMOUS) THEN
              IF(QNEW) THEN
                  TXTMES = ' Give position using the mouse'
              ELSE
                  TXTMES = ' Give new position using the mouse'
              ENDIF
              CALL MN_MES(LUNTTO,'ME',TXTMES)
          ENDIF
      ENDIF
C
      NNUM = 0
C
C     Get the cursor position
C
      IF(QUMOUS) THEN
          CALL TVQLC(XPOS,YPOS,ISTAT)
          IF(ISTAT.EQ.1) THEN
              RSET(1) = XPOS
              RSET(2) = YPOS
              NNUM = 2
          ELSE
              RSET(1) = RNAME(1)
              RSET(2) = RNAME(2)
              NNUM = 2
c          ELSE
c              CALL MN_ERR('MN_ENM','Error getting x,y position')
c              IERR = 1
c              GOTO 4000
          ENDIF
          IF(TNAME(3).EQ.' ') GOTO 4000
      ENDIF
C
3000  CONTINUE
      IF(QNEW) THEN
          CALL WAITYQ('Give values or ?: ')
      ELSE
          CALL WAITYQ('Give new values or ?: ')
      ENDIF
C
      RVAL = 0.0
      NVAL = INTTYQ(.TRUE.,IDELIM)
      IF(NVAL.EQ.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
          IDELIM = 0
          IF(THELP.NE.' ') THEN
              CALL QUOTYQ(THELP)
              CALL MN_HLP(IDELIM,NHERR)
          ELSE
              CALL MN_ERR('MN_ENM'
     +         ,'No help available for these parameters')
          ENDIF
          NNUM = 0
          GOTO 3000
      ENDIF
      CALL RESTYQ
C
C     SEE IF IT IS AN OPTION - allow center and centre as spellings
C
      IF(INAME(NNUM+1).EQ.3) THEN
          JCMD = ICMTYQ(.TRUE.,IDELIM,OPTNAM)
          IF(JCMD.GT.0) THEN
              IF(JCMD.EQ.4) JCMD = 2
              RVAL = FLOAT(JCMD-2)
          elseif(jcmd.eq.0) then
              nlist  = 2
              nmatch = icmlst(nlist,ilist)
              if(nmatch.eq.2 .and. ilist(1).eq.2) then
                  rval = 0.0
              else
                  call restyq
                  nval = ivltyq(.true.,idelim)
                  nchfnd = nchscn()
                  if(nchfnd.eq.0) goto 4000
*
                  if(idelim.ne.ichar('=') .and.
     +               (nval.lt.-1 .or. nval.gt.1)) then
                      ierr = 1
                      call mn_err('MN_ENM'
     +                 ,'Error specifying the option')
                      goto 4000
                  else
                      rval = float(nval)
                  endif
              endif
          ENDIF
C
C     SEE IF IT IS UNITS
C
      ELSEIF(INAME(NNUM+1).EQ.4) THEN
          JCMD = ICMTYQ(.TRUE.,IDELIM,UNTNAM)
          if(idelim.ne.ichar('=')) then
              nchfnd = nchscn()
              if(nchfnd.eq.0) goto 4000
          endif
          IF(JCMD.GT.0) THEN
              RVAL = FLOAT(JCMD-1)
          elseif(idelim.ne.ichar('=')) then
              ierr = 1
              call mn_err('MN_ENM','Error specifying the units')
              goto 4000
          ENDIF
C
C     SEE IF IT IS A COLOUR
C
      ELSEIF(INAME(NNUM+1).EQ.5) THEN
          JCMD = ICMTYQ(.TRUE.,IDELIM,COLNAM)
          IF(JCMD.GT.0) THEN
              RVAL = FLOAT(JCMD - 1)
          ELSE
              CALL RESTYQ
              RVAL = VALTYQ(.TRUE.,IDELIM)
          ENDIF
C
C     See if it is a date
C
      elseif(iname(nnum+1).eq.6) then
          ndate = ivltyq(.true.,idelim)
          if(idelim.eq.ichar('.') .or. idelim.eq.ichar('/')) then
              ntime = ivltyq(.true.,idelim)
              nchfnd = nchscn()
              if(nchfnd.eq.3 .or. nchfnd.eq.4) then
                  ntime = ntime * 100
              endif
          else
              ntime = 0
          endif
          call m_pkts(ndate,ntime,ntdb)
          rval = am_tdif(0,ntdb,'D')
C
C     See if it is a time
C
      elseif(iname(nnum+1).eq.7) then
          nhour = ivltyq(.true.,idelim)
          if(idelim.eq.ichar('.') .or. idelim.eq.ichar(':')) then
              nmin = ivltyq(.true.,idelim)
          else
              nmin = 0
          endif
          rval = float(nhour) + float(nmin)/60.0
C
C     ALL OTHER CASES
C
      ELSE
          RVAL = VALTYQ(.TRUE.,IDELIM)
      ENDIF
C
      IF(IDELIM.GT.0) THEN
          IF(IDELIM.EQ.ICHAR('=')) THEN
              NNUM = NNUM + 1
              RSET(NNUM) = RNAME(NNUM)
C
C             LOOK TO SEE IF I WANT TO ADD, SUBTRACT
C             MULTIPLY OR DIVIDE SOMETHING TO THE CURRENT VALUE
C
              NNEXT = ICHTYP(.TRUE.)
              IF(NNEXT.EQ.ICHAR('+') .OR. NNEXT.EQ.ICHAR('-') .OR.
     1           NNEXT.EQ.ICHAR('*') .OR. NNEXT.EQ.ICHAR('/')) THEN
                  RVAL = VALTYQ(.TRUE.,JDELIM)
                  CALL MN_RCK(RVAL,JDELIM,IERR)
                  IF(IERR.EQ.2) GOTO 3000
                  IF(IERR.GT.0) GOTO 4000
                  IF(NNEXT.EQ.ICHAR('+')) THEN
                      RSET(NNUM) = RSET(NNUM) + RVAL
                  ELSEIF(NNEXT.EQ.ICHAR('-')) THEN
                      RSET(NNUM) = RSET(NNUM) - RVAL
                  ELSEIF(NNEXT.EQ.ICHAR('*')) THEN
                      RSET(NNUM) = RSET(NNUM) * RVAL
                  ELSEIF(NNEXT.EQ.ICHAR('/')) THEN
                      IF(RVAL.NE.0.0) RSET(NNUM) = RSET(NNUM) / RVAL
                  ENDIF
              ELSE
                  JDELIM = IDELIM
                  CALL RESTYQ
              ENDIF
C
              IF(NNUM.GE.NPARM .OR. JDELIM.LT.0) THEN
                  IDELIM = JDELIM
                  GOTO 4000
              ELSE
                  GOTO 3000
              ENDIF
          ENDIF
C
          CALL MN_RCK(RVAL,IDELIM,IERR)
          GOTO 4000
      ENDIF
C
      IF(RVAL.EQ.0.0) THEN
          NCHFND = NCHSCN()
          IF(NCHFND.EQ.0) GOTO 4000
      ENDIF
C
      NNUM = NNUM + 1
      RSET(NNUM) = RVAL
      IF(NNUM.LT.NPARM .AND. IDELIM.EQ.0) GOTO 3000
C
4000  CONTINUE
      NSET = NNUM
C
9000  CONTINUE
      END
