<?
/*   load_soundex_from_ispell.php v.1.0 for mnoGoSearch engine
 *   (C) 2000 by Sergey Kartashoff <gluke@biosys.net>,
 *                          mnoGoSearch Developers Team
 */

// This file can be sound in the mnoGoSearch-php sources
require('db_func.inc');

$dbhost='';
$dbtype='mysql';
$dbname='udm';
$dbuser='root';
$dbpass='';

$DEBUG=1;
$LC_ALL='ru_RU.KOI8-R';

$ispell_dicts = array('/opt/udm/ispell/en.dict');

initdb();
set_time_limit(30000);

if ($LC_CTYPE != '') {
    setlocale("LC_ALL",$LC_CTYPE);
} elseif ($LC_ALL != '') {
    setlocale("LC_ALL",$LC_ALL);
} elseif ($LANG != '') {
    setlocale("LC_ALL",$LANG);
}

print "Soundex table loader (from ispell dictionaries)<br>\n";

$query="DELETE FROM soundex";

if($DEBUG) echo $query,"<BR><HR>";

if (!($res=query($query))) {
    print("Query error:".db_error($res));
    exit();
}

for ($i=0; $i<count($ispell_dicts); $i++ ) {
    $dict_file=$ispell_dicts[$i];
    print "Loading $dict_file<br>\n";
    if (!file_exists($dict_file)) {
	print " $dict_file not exist !<br>\n";
	continue;
    }
    
    flush();
    
    $dict_arr=file($dict_file);
    sort($dict_arr);
    
    print "Total words in $dict_file: ".count($dict_arr)."<br>\n";
    
    for($j=0; $j<count($dict_arr);$j++) {
	$word=strtolower(substr($dict_arr[$j],0,strpos($dict_arr[$j],'/')));
	
	if (strlen($word) <= 3) continue;
	
	$sdx=soundex($word);
	if ($sdx=='0000') continue;
	
	print "$word: $sdx<br>\n";
	
	$word=AddSlashes($word);
	if (!query("INSERT INTO soundex VALUES ('$sdx', '$word')")) print("Query error:".db_error($res));
    }
}

?>

