#include "udm_config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "udm_common.h"
#include "udm_robots.h"
#include "udm_spell.h"
#include "udm_db.h"
#include "udm_utils.h"
#include "udm_mutex.h"


int UdmFreeRobots(UDM_ROBOTS * Robots){
	size_t i; 
	
	if(!Robots->nrobots){
		return(0);
	}
	for(i=0;i<Robots->nrobots;i++){
		free(Robots->robots[i].hostinfo);
		free(Robots->robots[i].path);
	}
	UDM_FREE(Robots->robots);
	Robots->nrobots = 0;
	return(0);
}
	
UDM_ROBOT * UdmFindRobots(UDM_ENV * Conf,UDM_URL * URL){
	size_t i;
	char path[UDM_URLSIZE];

	strcpy(path, URL->path);
	strcat(path, URL->filename);

	for(i=0;i<Conf->Robots.nrobots;i++){
		if(!strcmp(URL->hostinfo,Conf->Robots.robots[i].hostinfo)&&!strncmp(path,Conf->Robots.robots[i].path,strlen(Conf->Robots.robots[i].path)))
		return(&Conf->Robots.robots[i]);
	}
	return(NULL);
}

int UdmParseRobots(UDM_AGENT *Indexer,UDM_ROBOTS * Robots,char *content,char *hostinfo){
	int myrule=0;
	char *s,*e,*lt;

	UdmDeleteRobotsFromHost(Indexer,hostinfo);
	s=UdmGetToken(content,"\r\n",&lt);
	while(s){
		if(*s=='#'){
		}else
		if(!(UDM_STRNCASECMP(s,"User-Agent"))){
			if(strstr(s,UDM_USER_AGENT))myrule=1;
			else
			if(strstr(s,"*"))myrule=1;
			else
				myrule=0;
		}else
		if((!(UDM_STRNCASECMP(s,"Disallow")))&&(myrule)){
			if((e=strchr(s+9,'#')))*e=0;
			e=s+9;UDM_SKIP(e," \t");s=e;
			UDM_SKIPN(e," \t");*e=0;
			if(*s){
				if(IND_ERROR==UdmAddRobotsToHost(Indexer,hostinfo,s))
					return(IND_ERROR);
			}
		}
		s=UdmGetToken(NULL,"\n\r",&lt);
	}
	return(IND_OK);
}
