///////////////////////////////////////////////////////////////////////////////
// $Id: tileset.h,v 1.3 2004/06/30 23:40:48 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    tileset.h
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Declaration of the tile set handler class
*/

#ifndef TILESET_H
#define TILESET_H

// Qt includes
#include <qintdict.h>

// forward declarations
class TileGroup;

///////////////////////////////////////////////////////////////////////////////

//! This class groups TileGroups belonging to the same set
/*!
*/

class TileSet {
public: 
	TileSet();
	TileSet(const TileSet& other) {
		copy(other);
	}

	~TileSet();

	TileSet& operator=(const TileSet& other) {
		if (&other == this) return *this;
		copy(other);
		return *this;
	}

	bool load(const QString& filename);

	uint count() const { return m_count; }

	QString name(int index) const;

	TileGroup* group(int index);

protected:
	QIntDict<TileGroup> m_groups;
	uint m_count;

private:
	void copy(const TileSet& other);
};

#endif

// End of file

