/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import org.jhotdraw.contrib.TriangleFigure;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractHandle;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

class TriangleRotationHandle
extends AbstractHandle {
    private Point fOrigin;

    public TriangleRotationHandle(TriangleFigure triangleFigure) {
        super(triangleFigure);
    }

    public void invokeStart(int n, int n2, DrawingView drawingView) {
        this.fOrigin = this.getOrigin();
        UndoActivity undoActivity = (UndoActivity)this.createUndoActivity(drawingView);
        this.setUndoActivity(undoActivity);
        undoActivity.setAffectedFigures(new SingleFigureEnumerator(this.owner()));
        double d = ((TriangleFigure)this.owner()).getRotationAngle();
        undoActivity.setRotationAngle(d);
    }

    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        Point point = this.owner().center();
        double d = Math.atan2(this.fOrigin.y + n2 - n4 - point.y, this.fOrigin.x + n - n3 - point.x);
        ((TriangleFigure)this.owner()).rotate(d);
    }

    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        this.fOrigin = null;
    }

    public Point locate() {
        return this.getOrigin();
    }

    Point getOrigin() {
        Polygon polygon = ((TriangleFigure)this.owner()).getPolygon();
        Point point = new Point(polygon.xpoints[0], polygon.ypoints[0]);
        Point point2 = this.owner().center();
        double d = Geom.length(point.x, point.y, point2.x, point2.y);
        if (d == 0.0) {
            return new Point(point.x - 4, point.y + 4);
        }
        double d2 = 8.0 / d;
        if (d2 > 1.0) {
            return new Point((point.x * 3 + point2.x) / 4, (point.y * 3 + point2.y) / 4);
        }
        return new Point((int)((double)point.x * (1.0 - d2) + (double)point2.x * d2), (int)((double)point.y * (1.0 - d2) + (double)point2.y * d2));
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.yellow);
        graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected Undoable createUndoActivity(DrawingView drawingView) {
        return new UndoActivity(drawingView);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private double myRotationAngle;

        public UndoActivity(DrawingView drawingView) {
            super(drawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            return this.resetRotationAngle();
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            return this.resetRotationAngle();
        }

        protected boolean resetRotationAngle() {
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            if (!figureEnumeration.hasNextFigure()) {
                return false;
            }
            TriangleFigure triangleFigure = (TriangleFigure)figureEnumeration.nextFigure();
            double d = triangleFigure.getRotationAngle();
            triangleFigure.willChange();
            triangleFigure.rotate(this.getRotationAngle());
            triangleFigure.changed();
            this.setRotationAngle(d);
            return true;
        }

        protected void setRotationAngle(double d) {
            this.myRotationAngle = d;
        }

        public double getRotationAngle() {
            return this.myRotationAngle;
        }
    }
}

