/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jdt.core.ICompilationUnit;
import sharpen.core.Configuration;
import sharpen.core.ConfigurationFactory;
import sharpen.core.JavaModelUtility;
import sharpen.core.JavaProject;
import sharpen.core.Sharpen;
import sharpen.core.SharpenCommandLine;
import sharpen.core.SharpenConversionBatch;
import sharpen.core.XmlDocumentationOverlay;
import sharpen.core.framework.ConsoleProgressMonitor;
import sharpen.core.io.IO;

public class SharpenApplication
implements IApplication {
    private SharpenCommandLine _args;

    public Object start(IApplicationContext context) throws Exception {
        try {
            String[] args = this.argv(context);
            this._args = SharpenCommandLine.parse(args);
            System.err.println("Configuration Class: " + this._args.configurationClass);
            Sharpen.getDefault().configuration(ConfigurationFactory.newConfiguration(this._args.configurationClass, this._args.runtimeTypeName));
            this.safeRun();
        }
        catch (Exception x) {
            System.err.println("ERROR: " + x.getMessage());
            x.printStackTrace();
            throw x;
        }
        return IApplication.EXIT_OK;
    }

    private String[] argv(IApplicationContext context) {
        return (String[])context.getArguments().get("application.args");
    }

    public void stop() {
    }

    void safeRun() throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            this.convert();
        }
        finally {
            System.out.println("Conversion finished in " + (System.currentTimeMillis() - startTime) + "ms.");
        }
    }

    private void convert() throws CoreException, IOException, InterruptedException {
        JavaProject project = this.setUpJavaProject();
        List<ICompilationUnit> units = this.sortedByName(project.getAllCompilationUnits());
        this.convertTo(units, this.resetTargetFolder(project));
    }

    private IProject resetTargetFolder(JavaProject project) throws CoreException {
        return this.deleteTargetProject(project);
    }

    private void convertTo(List<ICompilationUnit> units, IProject targetFolder) throws IOException, CoreException, InterruptedException {
        SharpenConversionBatch converter = new SharpenConversionBatch(this.getConfiguration());
        converter.setProgressMonitor(this.newProgressMonitor());
        converter.setTargetProject(targetFolder);
        converter.setSource(units);
        converter.run();
    }

    private IProject deleteTargetProject(JavaProject project) throws CoreException {
        return JavaModelUtility.deleteTargetProject(project.getJavaProject());
    }

    private Configuration getConfiguration() throws IOException {
        Configuration configuration = Sharpen.getDefault().configuration();
        SharpenApplication.ods("Pascal case mode: " + (Object)((Object)this._args.pascalCase));
        configuration.setNamingStrategy(this._args.pascalCase.getNamingStrategy());
        if (this._args.nativeTypeSystem) {
            SharpenApplication.ods("Native type system mode on.");
            configuration.enableNativeTypeSystem();
        }
        if (this._args.nativeInterfaces) {
            SharpenApplication.ods("Native interfaces mode on.");
            configuration.enableNativeInterfaces();
        }
        if (this._args.organizeUsings) {
            SharpenApplication.ods("Organize usings mode on.");
            configuration.enableOrganizeUsings();
        }
        if (this._args.junitConversion) {
            SharpenApplication.ods("JUnit conversion mode on.");
            configuration.enableJUnitConversion();
        }
        if (this._args.flatNamespaceDirectoryStructure) {
            SharpenApplication.ods("Flat namespace directory structure mode on.");
            configuration.enableFlatNamespaceDirectoryStructure();
        }
        if (this._args.headerFile != null) {
            SharpenApplication.ods("Header file: " + this._args.headerFile);
            configuration.setHeader(IO.readFile(new File(this._args.headerFile)));
        }
        if (this._args.xmldoc != null) {
            SharpenApplication.ods("Xml documentation: " + this._args.xmldoc);
            configuration.setDocumentationOverlay(new XmlDocumentationOverlay(this._args.xmldoc));
        }
        configuration.mapEventAdds(this._args.eventAddMappings);
        configuration.mapEvents(this._args.eventMappings);
        configuration.mapNamespaces(this._args.namespaceMappings);
        configuration.mapMembers(this._args.memberMappings);
        configuration.conditionalCompilation(this._args.conditionalCompilation);
        for (String fullyQualifiedType : this._args.fullyQualifiedTypes) {
            configuration.addFullyQualifiedTypeName(fullyQualifiedType);
        }
        for (String typeName : this._args.partialTypes) {
            configuration.addPartialType(typeName);
        }
        for (Configuration.NameMapping mapping : this._args.typeMappings) {
            configuration.mapType(mapping.from, mapping.to);
        }
        return configuration;
    }

    private List<ICompilationUnit> sortedByName(List<ICompilationUnit> units) {
        Collections.sort(units, new Comparator<ICompilationUnit>(){

            @Override
            public int compare(ICompilationUnit o1, ICompilationUnit o2) {
                return o1.getElementName().compareTo(o2.getElementName());
            }
        });
        return units;
    }

    private IProgressMonitor newProgressMonitor() {
        return new ConsoleProgressMonitor();
    }

    JavaProject setUpJavaProject() throws CoreException {
        SharpenApplication.ods("project: " + this._args.project);
        return new JavaProject.Builder((IProgressMonitor)this.newProgressMonitor(), (String)this._args.project).classpath(this._args.classpath).sourceFolders(this._args.sourceFolders).project;
    }

    private static void ods(String message) {
        System.out.println(message);
    }
}

