/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 33 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  int opcode;   /* Either TK_GLOB or TK_LIKE */
  int not;      /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 239
#define YYACTIONTYPE unsigned short int
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  struct AttachKey yy40;
  int yy60;
  struct TrigEvent yy62;
  struct {int value; int mask;} yy243;
  struct LikeOp yy258;
  ExprList* yy266;
  IdList* yy272;
  Select* yy331;
  struct LimitVal yy348;
  Token yy406;
  SrcList* yy427;
  Expr* yy454;
  TriggerStep* yy455;
  int yy477;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 564
#define YYNRULE 305
#define YYERRORSYMBOL 141
#define YYERRSYMDT yy477
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   263,    9,  261,  154,  124,  126,  128,  130,  132,  134,
 /*    10 */   136,  138,  140,  142,    3,  562,  145,  641,   83,  369,
 /*    20 */   144,  114,  116,  112,  118,  286,  124,  126,  128,  130,
 /*    30 */   132,  134,  136,  138,  140,  142,  136,  138,  140,  142,
 /*    40 */   110,   94,  146,  157,  162,  167,  156,  161,  120,  122,
 /*    50 */   114,  116,  112,  118,  567,  124,  126,  128,  130,  132,
 /*    60 */   134,  136,  138,  140,  142,    7,  223,  407,  262,  124,
 /*    70 */   126,  128,  130,  132,  134,  136,  138,  140,  142,  399,
 /*    80 */   309,  145,  870,    1,  563,  144,  398,    4,  371,   92,
 /*    90 */   435,  373,  380,  385,  132,  134,  136,  138,  140,  142,
 /*   100 */   279,   10,  415,  388,  410,  110,   94,  146,  157,  162,
 /*   110 */   167,  156,  161,  120,  122,  114,  116,  112,  118,   96,
 /*   120 */   124,  126,  128,  130,  132,  134,  136,  138,  140,  142,
 /*   130 */   145,  574,   77,   13,  144,  152,  222,  163,  168,   75,
 /*   140 */    44,   45,  367,  176,  280,  258,  839,   28,   13,  281,
 /*   150 */   402,   33,  233,   13,  110,   94,  146,  157,  162,  167,
 /*   160 */   156,  161,  120,  122,  114,  116,  112,  118,  572,  124,
 /*   170 */   126,  128,  130,  132,  134,  136,  138,  140,  142,  421,
 /*   180 */   371,  298,  720,  373,  380,  385,  107,  106,  108,  107,
 /*   190 */   106,  108,  169,  217,  295,  388,   13,  575,  471,   14,
 /*   200 */    15,  371,  175,  145,  373,  380,  385,  144,    2,  343,
 /*   210 */   346,    4,  292,   13,   14,   15,  388,  423,  345,   14,
 /*   220 */    15,  345,   95,  261,   12,   95,  802,  110,   94,  146,
 /*   230 */   157,  162,  167,  156,  161,  120,  122,  114,  116,  112,
 /*   240 */   118,   51,  124,  126,  128,  130,  132,  134,  136,  138,
 /*   250 */   140,  142,   36,  340,  800,  101,  102,  103,  101,  102,
 /*   260 */   103,  335,   14,   15,  847,  152,  188,  163,  168,   37,
 /*   270 */   341,   40,   59,   67,   69,  305,  336,  145,  265,   14,
 /*   280 */    15,  144,  171,  338,  173,  174,  351,  356,  357,  262,
 /*   290 */   171,   34,  173,  174,  366,  349,   51,   72,  460,  244,
 /*   300 */   197,  110,   94,  146,  157,  162,  167,  156,  161,  120,
 /*   310 */   122,  114,  116,  112,  118,  288,  124,  126,  128,  130,
 /*   320 */   132,  134,  136,  138,  140,  142,   40,   59,   67,   69,
 /*   330 */   305,  336,  152,   13,  163,  168,  248,  258,  338,   96,
 /*   340 */    96,  145,   16,   17,   18,  144,  687,  170,  358,    6,
 /*   350 */     5,  494,  466,  456,  171,   25,  173,  174,   20,   75,
 /*   360 */    75,  507,   81,  176,  176,  110,   94,  146,  157,  162,
 /*   370 */   167,  156,  161,  120,  122,  114,  116,  112,  118,   77,
 /*   380 */   124,  126,  128,  130,  132,  134,  136,  138,  140,  142,
 /*   390 */   364,  362,  596,   77,  623,  367,  327,   48,  297,   14,
 /*   400 */    15,  243,  213,   32,   33,   96,   49,  688,   96,  250,
 /*   410 */   534,   96,  278,  217,  217,  145,   13,   50,  518,  144,
 /*   420 */    46,   52,  354,  356,  357,   75,  368,  401,   75,  190,
 /*   430 */    47,   75,  235,   54,  171,  235,  173,  174,  211,  110,
 /*   440 */    94,  146,  157,  162,  167,  156,  161,  120,  122,  114,
 /*   450 */   116,  112,  118,  387,  124,  126,  128,  130,  132,  134,
 /*   460 */   136,  138,  140,  142,  303,   13,   48,  227,  236,   13,
 /*   470 */    96,  229,   96,   64,  294,   49,  191,  252,  293,  406,
 /*   480 */    96,  145,   14,   15,  358,  144,   50,   78,  564,  201,
 /*   490 */    75,  580,   75,  801,  176,  588,  493,    3,  562,  152,
 /*   500 */    75,  163,  168,  251,  296,  110,   94,  146,  157,  162,
 /*   510 */   167,  156,  161,  120,  122,  114,  116,  112,  118,   77,
 /*   520 */   124,  126,  128,  130,  132,  134,  136,  138,  140,  142,
 /*   530 */   660,   14,   15,   96,   81,   14,   15,  817,  489,   96,
 /*   540 */   310,   39,  250,  263,  216,  261,  145,  487,  533,  335,
 /*   550 */   144,  442,  350,   75,   13,  453,  261,  302,  253,   75,
 /*   560 */   852,  397,  255,  493,  535,  536,  573,  499,  850,   11,
 /*   570 */   110,   94,  146,  157,  162,  167,  156,  161,  120,  122,
 /*   580 */   114,  116,  112,  118,  845,  124,  126,  128,  130,  132,
 /*   590 */   134,  136,  138,  140,  142,   65,  662,  171,  312,  173,
 /*   600 */   174,   66,  505,  338,  501,  525,  866,   57,   58,   42,
 /*   610 */   252,  262,  195,  145,  207,  172,  441,  144,  665,  455,
 /*   620 */    14,   15,  262,   13,  640,  358,   31,  726,  313,  320,
 /*   630 */   322,  421,  171,  844,  173,  174,  251,  110,   94,  146,
 /*   640 */   157,  162,  167,  156,  161,  120,  122,  114,  116,  112,
 /*   650 */   118,   77,  124,  126,  128,  130,  132,  134,  136,  138,
 /*   660 */   140,  142,  171,   96,  173,  174,  432,  434,  433,  500,
 /*   670 */   171,  318,  173,  174,  581,   96,  479,   27,  145,  403,
 /*   680 */   310,  824,  144,   75,  455,   22,  503,   91,  246,   14,
 /*   690 */    15,  319,  461,  452,  537,   75,  582,  463,  171,   93,
 /*   700 */   173,  174,  110,   94,  146,  157,  162,  167,  156,  161,
 /*   710 */   120,  122,  114,  116,  112,  118,   77,  124,  126,  128,
 /*   720 */   130,  132,  134,  136,  138,  140,  142,  265,   96,  171,
 /*   730 */    96,  173,  174,  331,  810,   96,   96,  214,  312,  215,
 /*   740 */   275,  479,  272,  145,  273,  532,  315,  144,   75,  299,
 /*   750 */    75,  215,  109,  348,  111,   75,   75,  465,  426,  113,
 /*   760 */   115,  342,  463,  265,  266,  187,  325,  110,  165,  146,
 /*   770 */   157,  162,  167,  156,  161,  120,  122,  114,  116,  112,
 /*   780 */   118,  247,  124,  126,  128,  130,  132,  134,  136,  138,
 /*   790 */   140,  142,   26,   96,   96,   96,   96,   77,  271,  159,
 /*   800 */   283,   96,   96,   96,   96,  326,  275,  327,  145,  332,
 /*   810 */   364,  362,  144,   75,   75,   75,   75,  117,  119,  121,
 /*   820 */   123,   75,   75,   75,   75,  125,  127,  129,  131,  158,
 /*   830 */   317,  316,   24,   94,  146,  157,  162,  167,  156,  161,
 /*   840 */   120,  122,  114,  116,  112,  118,   96,  124,  126,  128,
 /*   850 */   130,  132,  134,  136,  138,  140,  142,   96,  331,   96,
 /*   860 */    96,  331,   96,  331,  436,   96,   75,   96,   96,  273,
 /*   870 */   133,  360,  361,   96,  145,   96,  583,   75,  144,   75,
 /*   880 */    75,  135,   75,  137,  139,   75,  141,   75,   75,  143,
 /*   890 */   689,  153,  155,   75,  376,   75,  382,  164,  331,  166,
 /*   900 */   146,  157,  162,  167,  156,  161,  120,  122,  114,  116,
 /*   910 */   112,  118,  261,  124,  126,  128,  130,  132,  134,  136,
 /*   920 */   138,  140,  142,   76,   96,   96,  438,   71,  457,  437,
 /*   930 */    96,  391,   29,   96,  328,   96,   96,  332,  352,  332,
 /*   940 */   353,  439,  148,  689,   75,   75,  147,  840,  178,  180,
 /*   950 */    75,  199,   96,   75,  182,   75,   75,  184,  652,  196,
 /*   960 */   198,  107,  106,  108,  383,  720,  327,  177,  404,  860,
 /*   970 */   150,  151,   75,   30,  332,   96,  208,  392,  262,  327,
 /*   980 */   430,  431,  476,  219,  183,  181,  300,   96,   96,  587,
 /*   990 */    96,  654,  179,   73,   74,   75,   96,   95,  149,  210,
 /*  1000 */    77,   96,  290,   96,   96,  331,  546,   75,   75,   76,
 /*  1010 */    75,  212,  224,   71,  240,  689,   75,  548,  414,   96,
 /*  1020 */   245,   75,   75,   75,   75,  277,  287,  386,  427,  219,
 /*  1030 */   101,  102,  103,  104,  105,  185,  189,  199,  449,   75,
 /*  1040 */    96,  275,   96,  474,  450,  470,  327,  107,  106,  108,
 /*  1050 */    77,  219,   42,  177,  458,   45,  484,  486,  273,  492,
 /*  1060 */    75,  490,   75,  476,  478,  522,  491,   35,  421,  421,
 /*  1070 */   183,  181,  421,  421,  421,  421,  421,   81,  179,   73,
 /*  1080 */    74,  332,  244,   95,  526,   38,  490,   42,   41,   77,
 /*  1090 */   523,   43,   53,   56,   55,   60,   64,   77,   70,  483,
 /*  1100 */    61,   76,   81,   62,   63,   71,  502,  504,   68,  597,
 /*  1110 */   506,  510,  514,  520,  558,  598,  101,  102,  103,  104,
 /*  1120 */   105,  185,  189,   79,   81,   80,  516,  244,  241,  199,
 /*  1130 */    82,   84,  239,  225,   85,   90,   97,   86,   98,  107,
 /*  1140 */   106,  108,   87,   89,   88,  177,   99,  100,  142,  160,
 /*  1150 */   218,  186,  666,  667,  668,  194,  209,  200,  203,  202,
 /*  1160 */   206,  205,  183,  181,  204,  192,  220,  193,  221,  219,
 /*  1170 */   179,   73,   74,  228,  232,   95,  226,  230,  231,  233,
 /*  1180 */   234,  237,  215,  257,  242,  238,  249,  276,  260,  267,
 /*  1190 */   254,  256,  259,   76,  264,  269,  268,   71,  270,  284,
 /*  1200 */   274,  282,  291,  301,  285,  306,  304,  324,  101,  102,
 /*  1210 */   103,  104,  105,  185,  189,  803,  311,  355,  307,  374,
 /*  1220 */   375,  199,  308,  309,  359,  337,  314,  321,  329,  330,
 /*  1230 */   363,  107,  106,  108,  333,  323,  372,  177,  344,  334,
 /*  1240 */   347,  365,  378,  379,  381,  339,  389,  377,  384,  390,
 /*  1250 */   393,  400,  394,  370,  183,  181,  289,  395,  408,  396,
 /*  1260 */    54,  409,  179,   73,   74,  411,  412,   95,  413,  416,
 /*  1270 */   417,  420,  422,  428,  832,  429,  440,  837,  838,   76,
 /*  1280 */   443,  444,  445,   71,  446,  451,  448,  808,  809,  459,
 /*  1290 */   418,  454,  447,  727,  728,  831,  462,  464,  846,  457,
 /*  1300 */   101,  102,  103,  104,  105,  185,  189,  199,  467,  468,
 /*  1310 */   469,  475,  419,  472,  424,  473,  848,  107,  106,  108,
 /*  1320 */   477,  425,  480,  177,  482,  485,  488,  481,  849,  495,
 /*  1330 */   851,  659,  496,  661,  497,  816,  858,  511,  509,  719,
 /*  1340 */   183,  181,  722,  513,  515,  517,  725,  521,  179,   73,
 /*  1350 */    74,  519,  528,   95,  524,  818,  530,  819,  531,  820,
 /*  1360 */     8,  821,  822,  538,  539,   19,   21,   23,  405,  823,
 /*  1370 */   549,  542,  859,  544,  861,  543,  862,  547,  552,  540,
 /*  1380 */   541,  865,  545,  551,  555,  550,  101,  102,  103,  104,
 /*  1390 */   105,  185,  189,  554,  867,  557,  560,  559,  529,  561,
 /*  1400 */   460,  868,  545,  545,  545,  527,  545,  553,  545,  545,
 /*  1410 */   545,  545,  556,  545,  545,  545,  545,  545,  545,  545,
 /*  1420 */   545,  545,  545,  545,  545,  545,  545,  545,  545,  545,
 /*  1430 */   545,  545,  545,  545,  545,  545,  545,  545,  545,  545,
 /*  1440 */   545,  545,  545,  545,  545,  545,  545,  545,  545,  545,
 /*  1450 */   545,  545,  545,  508,  512,  456,  545,  545,  545,  498,
 /*  1460 */   545,  545,  545,  545,   81,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    24,  148,   26,   78,   79,   80,   81,   82,   83,   84,
 /*    10 */    85,   86,   87,   88,    9,   10,   40,   23,  192,   25,
 /*    20 */    44,   74,   75,   76,   77,  199,   79,   80,   81,   82,
 /*    30 */    83,   84,   85,   86,   87,   88,   85,   86,   87,   88,
 /*    40 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*    50 */    74,   75,   76,   77,    9,   79,   80,   81,   82,   83,
 /*    60 */    84,   85,   86,   87,   88,    9,   25,   20,   92,   79,
 /*    70 */    80,   81,   82,   83,   84,   85,   86,   87,   88,  177,
 /*    80 */   178,   40,  142,  143,  144,   44,  184,  147,   94,   48,
 /*    90 */    47,   97,   98,   99,   83,   84,   85,   86,   87,   88,
 /*   100 */   157,  149,   55,  109,   57,   64,   65,   66,   67,   68,
 /*   110 */    69,   70,   71,   72,   73,   74,   75,   76,   77,  150,
 /*   120 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   130 */    40,    9,  189,   26,   44,  217,  218,  219,  220,  170,
 /*   140 */   186,  187,  150,  174,  201,  202,  103,  155,   26,  206,
 /*   150 */   158,  159,   26,   26,   64,   65,   66,   67,   68,   69,
 /*   160 */    70,   71,   72,   73,   74,   75,   76,   77,    9,   79,
 /*   170 */    80,   81,   82,   83,   84,   85,   86,   87,   88,  150,
 /*   180 */    94,  212,    9,   97,   98,   99,   60,   61,   62,   60,
 /*   190 */    61,   62,   22,  224,   23,  109,   26,    9,   25,   92,
 /*   200 */    93,   94,   23,   40,   97,   98,   99,   44,  144,   83,
 /*   210 */    84,  147,   85,   26,   92,   93,  109,  188,   92,   92,
 /*   220 */    93,   92,   96,   26,  150,   96,  136,   64,   65,   66,
 /*   230 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   240 */    77,   66,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   250 */    87,   88,  168,  169,   17,  129,  130,  131,  129,  130,
 /*   260 */   131,  177,   92,   93,   17,  217,   23,  219,  220,   94,
 /*   270 */    95,   96,   97,   98,   99,  100,  101,   40,  163,   92,
 /*   280 */    93,   44,  111,  108,  113,  114,  165,  166,  167,   92,
 /*   290 */   111,  160,  113,  114,  163,  164,   66,   22,   51,  126,
 /*   300 */   137,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   310 */    73,   74,   75,   76,   77,  200,   79,   80,   81,   82,
 /*   320 */    83,   84,   85,   86,   87,   88,   96,   97,   98,   99,
 /*   330 */   100,  101,  217,   26,  219,  220,  201,  202,  108,  150,
 /*   340 */   150,   40,   13,   14,   15,   44,   23,  157,  227,  145,
 /*   350 */   146,  104,  105,  106,  111,  151,  113,  114,  149,  170,
 /*   360 */   170,  157,  115,  174,  174,   64,   65,   66,   67,   68,
 /*   370 */    69,   70,   71,   72,   73,   74,   75,   76,   77,  189,
 /*   380 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   390 */    83,   84,  117,  189,   23,  150,   25,   18,   23,   92,
 /*   400 */    93,  212,  212,  158,  159,  150,   27,   23,  150,   25,
 /*   410 */   103,  150,   22,  224,  224,   40,   26,   38,  214,   44,
 /*   420 */    41,   96,  165,  166,  167,  170,  181,  182,  170,  174,
 /*   430 */    51,  170,  174,  108,  111,  174,  113,  114,  137,   64,
 /*   440 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   450 */    75,   76,   77,  171,   79,   80,   81,   82,   83,   84,
 /*   460 */    85,   86,   87,   88,   23,   26,   18,  209,  210,   26,
 /*   470 */   150,  210,  150,  102,  112,   27,  221,   93,  116,  153,
 /*   480 */   150,   40,   92,   93,  227,   44,   38,  157,    0,   41,
 /*   490 */   170,    9,  170,   17,  174,    9,  174,    9,   10,  217,
 /*   500 */   170,  219,  220,  119,  174,   64,   65,   66,   67,   68,
 /*   510 */    69,   70,   71,   72,   73,   74,   75,   76,   77,  189,
 /*   520 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   530 */     9,   92,   93,  150,  115,   92,   93,    9,  216,  150,
 /*   540 */    45,  169,   25,   24,  224,   26,   40,  128,  150,  177,
 /*   550 */    44,  225,   22,  170,   26,  229,   26,  174,  119,  170,
 /*   560 */     9,   66,  119,  174,  166,  167,    9,   20,    9,   12,
 /*   570 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   580 */    74,   75,   76,   77,   11,   79,   80,   81,   82,   83,
 /*   590 */    84,   85,   86,   87,   88,   29,    9,  111,  103,  113,
 /*   600 */   114,   35,   55,  108,   57,  216,    9,   13,   14,  103,
 /*   610 */    93,   92,  136,   40,  138,  112,   21,   44,  115,  157,
 /*   620 */    92,   93,   92,   26,   23,  227,   25,    9,  104,  105,
 /*   630 */   106,  150,  111,   11,  113,  114,  119,   64,   65,   66,
 /*   640 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   650 */    77,  189,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   660 */    87,   88,  111,  150,  113,  114,  104,  105,  106,  188,
 /*   670 */   111,   32,  113,  114,    9,  150,  214,   22,   40,   24,
 /*   680 */    45,    9,   44,  170,  157,  149,  139,  174,   25,   92,
 /*   690 */    93,   52,  230,   98,   22,  170,    9,  235,  111,  174,
 /*   700 */   113,  114,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   710 */    72,   73,   74,   75,   76,   77,  189,   79,   80,   81,
 /*   720 */    82,   83,   84,   85,   86,   87,   88,  163,  150,  111,
 /*   730 */   150,  113,  114,  150,  139,  150,  150,   23,  103,   25,
 /*   740 */   150,  214,   23,   40,   25,   73,  107,   44,  170,   23,
 /*   750 */   170,   25,  174,  162,  174,  170,  170,  230,  136,  174,
 /*   760 */   174,  170,  235,  163,  200,  157,  183,   64,   65,   66,
 /*   770 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   780 */    77,  118,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   790 */    87,   88,  152,  150,  150,  150,  150,  189,  208,   66,
 /*   800 */   200,  150,  150,  150,  150,   23,  150,   25,   40,  226,
 /*   810 */    83,   84,   44,  170,  170,  170,  170,  174,  174,  174,
 /*   820 */   174,  170,  170,  170,  170,  174,  174,  174,  174,   96,
 /*   830 */    95,   96,  149,   65,   66,   67,   68,   69,   70,   71,
 /*   840 */    72,   73,   74,   75,   76,   77,  150,   79,   80,   81,
 /*   850 */    82,   83,   84,   85,   86,   87,   88,  150,  150,  150,
 /*   860 */   150,  150,  150,  150,  208,  150,  170,  150,  150,   25,
 /*   870 */   174,  129,  130,  150,   40,  150,    9,  170,   44,  170,
 /*   880 */   170,  174,  170,  174,  174,  170,  174,  170,  170,  174,
 /*   890 */    24,  174,  174,  170,  183,  170,  183,  174,  150,  174,
 /*   900 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   910 */    76,   77,   26,   79,   80,   81,   82,   83,   84,   85,
 /*   920 */    86,   87,   88,   22,  150,  150,   28,   26,   64,   31,
 /*   930 */   150,  183,  156,  150,  226,  150,  150,  226,   23,  226,
 /*   940 */    25,   43,   40,    9,  170,  170,   44,  103,  174,  174,
 /*   950 */   170,   50,  150,  170,  174,  170,  170,  174,    9,  174,
 /*   960 */   174,   60,   61,   62,   23,    9,   25,   66,  157,    9,
 /*   970 */    68,   69,  170,   23,  226,  150,  174,   23,   92,   25,
 /*   980 */    53,   54,  150,  117,   83,   84,   85,  150,  150,    9,
 /*   990 */   150,  127,   91,   92,   93,  170,  150,   96,   96,  174,
 /*  1000 */   189,  150,  150,  150,  150,  150,   46,  170,  170,   22,
 /*  1010 */   170,  174,  174,   26,  174,  103,  170,  131,  157,  150,
 /*  1020 */   174,  170,  170,  170,  170,  174,  174,  174,  174,  117,
 /*  1030 */   129,  130,  131,  132,  133,  134,  135,   50,  183,  170,
 /*  1040 */   150,  150,  150,  174,   23,  213,   25,   60,   61,   62,
 /*  1050 */   189,  117,  103,   66,  186,  187,   23,  157,   25,   23,
 /*  1060 */   170,   25,  170,  150,  174,  157,  174,  161,  150,  150,
 /*  1070 */    83,   84,  150,  150,  150,  150,  150,  115,   91,   92,
 /*  1080 */    93,  226,  126,   96,   23,  150,   25,  103,  171,  189,
 /*  1090 */   128,   33,  171,   42,  180,   46,  102,  189,   22,  208,
 /*  1100 */   172,   22,  115,  171,  173,   26,  188,  188,  171,  117,
 /*  1110 */   188,  188,  188,  188,  188,  117,  129,  130,  131,  132,
 /*  1120 */   133,  134,  135,  190,  115,  189,  213,  126,  123,   50,
 /*  1130 */   191,  193,  124,  121,  194,  125,  117,  195,  150,   60,
 /*  1140 */    61,   62,  196,  198,  197,   66,  117,  150,   88,   96,
 /*  1150 */   150,   22,  115,  115,  115,   17,  136,   22,  187,   23,
 /*  1160 */    23,  150,   83,   84,   25,  222,  150,  223,  154,  117,
 /*  1170 */    91,   92,   93,   25,  101,   96,  122,  211,  172,   26,
 /*  1180 */   162,  211,   25,  119,  122,  172,  203,  103,  154,  204,
 /*  1190 */   150,  150,  150,   22,  150,  120,  205,   26,   22,  204,
 /*  1200 */   150,   23,  117,   23,  205,  150,  171,   22,  129,  130,
 /*  1210 */   131,  132,  133,  134,  135,  136,  150,   23,  175,   46,
 /*  1220 */    22,   50,  176,  178,  228,  162,  179,  179,  211,  172,
 /*  1230 */   228,   60,   61,   62,  211,  179,  150,   66,  170,  172,
 /*  1240 */   170,  163,   23,  171,   22,  180,   46,  173,  171,   22,
 /*  1250 */   100,  182,  150,  182,   83,   84,   85,  175,  150,  176,
 /*  1260 */   108,  154,   91,   92,   93,  150,  154,   96,   24,  150,
 /*  1270 */   154,  103,  154,   39,   11,   37,   47,  103,  103,   22,
 /*  1280 */   139,  150,  154,   26,  103,  171,   22,    9,  139,  185,
 /*  1290 */   231,   11,  150,  127,  127,    9,   17,    9,   17,   64,
 /*  1300 */   129,  130,  131,  132,  133,  134,  135,   50,  185,  150,
 /*  1310 */   107,  194,  232,  150,  233,   73,    9,   60,   61,   62,
 /*  1320 */    73,  234,  127,   66,   22,  215,   22,  150,    9,  118,
 /*  1330 */     9,    9,  150,    9,  194,    9,    9,  194,  118,    9,
 /*  1340 */    83,   84,    9,  185,  107,  194,    9,  215,   91,   92,
 /*  1350 */    93,  127,  150,   96,   22,    9,  150,    9,  154,    9,
 /*  1360 */    11,    9,    9,  150,   23,   16,   17,   18,   19,    9,
 /*  1370 */    34,  163,    9,  150,    9,   24,    9,  163,  150,   30,
 /*  1380 */   236,    9,  237,  236,  154,   36,  129,  130,  131,  132,
 /*  1390 */   133,  134,  135,  150,    9,   20,  140,   59,   49,  150,
 /*  1400 */    51,    9,  238,  238,  238,   56,  238,   58,  238,  238,
 /*  1410 */   238,  238,   63,  238,  238,  238,  238,  238,  238,  238,
 /*  1420 */   238,  238,  238,  238,  238,  238,  238,  238,  238,  238,
 /*  1430 */   238,  238,  238,  238,  238,  238,  238,  238,  238,  238,
 /*  1440 */   238,  238,  238,  238,  238,  238,  238,  238,  238,  238,
 /*  1450 */   238,  238,  238,  104,  105,  106,  238,  238,  238,  110,
 /*  1460 */   238,  238,  238,  238,  115,
};
#define YY_SHIFT_USE_DFLT (-76)
static const short yy_shift_ofst[] = {
 /*     0 */     5,  488,  -76,  -76, 1349,   45,   56,  -76,  329,  557,
 /*    10 */   159,  122,  188,  -76,  -76,  -76,  -76,  -76,  -76,  557,
 /*    20 */   482,  557,  665,  557,  687,  655,  867,  187,  601,  950,
 /*    30 */   980,  107,  -76,  197,  -76,  175,  -76,  187,  230,  -76,
 /*    40 */   984,  -76, 1058,  379,  -76,  -76,  -76,  -76,  -76,  -76,
 /*    50 */   -76,  325,  984,  -76, 1051,  -76,  594,  -76,  -76, 1049,
 /*    60 */   566,  984,  994,  -76,  -76,  -76,  -76,  984,  -76, 1076,
 /*    70 */  1257,  275,  901,  992,  998,  -76,  987,  -76,  171, 1009,
 /*    80 */   -76,  362,  -76,  663, 1001, 1005, 1008, 1012, 1010,  -76,
 /*    90 */  1257,   41, 1257,  638, 1257,  -76, 1019,  187, 1029,  187,
 /*   100 */   -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,  834,
 /*   110 */  1257,  768, 1257,  -10, 1257,  -10, 1257,  -10, 1257,  -10,
 /*   120 */  1257,  -53, 1257,  -53, 1257,   11, 1257,   11, 1257,   11,
 /*   130 */  1257,   11, 1257,  -49, 1257,  -49, 1257, 1060, 1257, 1060,
 /*   140 */  1257, 1060, 1257,  -76,  -76,  -76,  902,  -76,  -76,  -76,
 /*   150 */   -76,  -76, 1257,  -75, 1257,  -10,  -76,  733,  -76, 1053,
 /*   160 */   -76,  -76,  -76, 1257,  703, 1257,  -53,  -76,  170,  987,
 /*   170 */   179,  503, 1037, 1038, 1039,  -76,  638, 1257,  834, 1257,
 /*   180 */   -76, 1257,  -76, 1257,  -76, 1129, 1009,  243,  -76, 1079,
 /*   190 */    90, 1020,  476, 1138,  -76, 1257,  163, 1257,  638, 1135,
 /*   200 */   448, 1136,  -76, 1139,  187, 1137,  -76, 1257,  237, 1257,
 /*   210 */   301, 1257,  638,  714,  -76, 1257,  -76,  -76, 1052,  187,
 /*   220 */   -76,  -76,  -76, 1257,  638, 1054, 1257, 1148, 1257, 1073,
 /*   230 */   566,  -76, 1153,  -76,  -76,  638, 1073,  566,  -76, 1257,
 /*   240 */   638, 1062, 1257, 1157, 1257,  638,  -76,  -76,  517,  -76,
 /*   250 */   -76,  -76,  439,  -76,  443,  -76, 1064,  -76,  390, 1052,
 /*   260 */   519,  -76,  -76,  187,  -76,  -76, 1084, 1075,  -76, 1176,
 /*   270 */   187,  719,  -76,  187,  -76,  -76, 1257,  638, 1009,  323,
 /*   280 */   384, 1178,  519, 1084, 1075,  -76, 1171,  -24,  -76,  -76,
 /*   290 */  1085,  127,  -76,  -76,  -76,  -76,  375,  -76,  726,  -76,
 /*   300 */  1180,  -76,  441,  984,  -76,  187, 1185,  -76,  635,  -76,
 /*   310 */   187,  -76,  524,  639,  -76,  735,  -76,  -76,  -76,  -76,
 /*   320 */   639,  -76,  639,  -76,  187,  782,  -76,  187, 1073,  566,
 /*   330 */   -76,  -76, 1073,  566,  -76,  -76, 1153,  -76, 1051,  -76,
 /*   340 */   -76,  126,  -76,  129,  -76,  -76,  129,  -76,  -76,  530,
 /*   350 */   727,  915,  -76,  727, 1194,  -76,  -76,  -76,  742,  -76,
 /*   360 */   -76,  -76,  742,  -76,  -76,  -76,  -76,  -76,   -6,   86,
 /*   370 */   -76,  187,  -76, 1173, 1198,  187,  371, 1219,  984,  -76,
 /*   380 */  1222,  187,  941,  984,  -76, 1257,  506,  -76, 1200, 1227,
 /*   390 */   187,  954, 1150,  187, 1185,  -76,  495, 1152,  -76,  -76,
 /*   400 */   -76,  -76,  -76, 1009,  486,  595,   47,  187, 1052,  -76,
 /*   410 */   187,  866, 1244, 1009,  521,  187, 1052,  898,  562, 1168,
 /*   420 */   187, 1052,  -76, 1234,  622, 1263, 1257,  573, 1238,  927,
 /*   430 */   -76,  -76, 1174, 1175,   43,  187,  844,  -76,  -76, 1229,
 /*   440 */   -76,  -76, 1141,  187,  912, 1181,  187, 1264,  187, 1021,
 /*   450 */   949, 1278, 1149, 1280,  247,  551,  864,  379,  -76, 1166,
 /*   460 */  1167, 1279, 1286, 1288,  247, 1281, 1235,  187, 1203,  187,
 /*   470 */   173,  187, 1242, 1257,  638, 1307, 1247, 1257,  638, 1195,
 /*   480 */   187, 1302,  187, 1033,  -76,  419,  559, 1304, 1257, 1036,
 /*   490 */  1257,  638, 1319,  638, 1211,  187,  956, 1321,  547,  187,
 /*   500 */  1322,  187, 1324,  187, 1326,  187, 1327,  587, 1220,  187,
 /*   510 */   956, 1330, 1235,  187, 1237,  187,  173, 1333, 1224,  187,
 /*   520 */  1302,  962,  618, 1332, 1257, 1061, 1337,  528, 1346,  187,
 /*   530 */  1052,  672,  307, 1348, 1350, 1352, 1353,  187, 1341, 1360,
 /*   540 */  1336,  197, 1351,  187,  960, 1363,  886, 1365, 1367,  -76,
 /*   550 */  1336,  187, 1372,  597,  934, 1385, 1375,  187, 1338, 1256,
 /*   560 */   187, 1392,  -76,  -76,
};
#define YY_REDUCE_USE_DFLT (-175)
static const short yy_reduce_ofst[] = {
 /*     0 */   -60,   64, -175, -175,  204, -175, -175, -175, -147,  -48,
 /*    10 */  -175,   74, -175, -175, -175, -175, -175, -175, -175,  209,
 /*    20 */  -175,  536, -175,  683, -175,  640, -175,   -8,  776, -175,
 /*    30 */  -175,  245, -175,  131,  906,   84, -175,  935,  372, -175,
 /*    40 */   917, -175, -175,  -46, -175, -175, -175, -175, -175, -175,
 /*    50 */  -175, -175,  921, -175,  914, -175, -175, -175, -175, -175,
 /*    60 */   928,  932,  931, -175, -175, -175, -175,  937, -175, -175,
 /*    70 */   383, -175,  -31, -175, -175, -175,  330, -175,  933,  936,
 /*    80 */  -175,  939, -174,  938,  940,  942,  946,  947,  945, -175,
 /*    90 */   513,   48,  525,   48,  578, -175, -175,  988, -175,  997,
 /*   100 */  -175, -175, -175, -175, -175, -175, -175, -175, -175,   48,
 /*   110 */   580,   48,  585,   48,  586,   48,  643,   48,  644,   48,
 /*   120 */   645,   48,  646,   48,  651,   48,  652,   48,  653,   48,
 /*   130 */   654,   48,  696,   48,  707,   48,  709,   48,  710,   48,
 /*   140 */   712,   48,  715,   48, -175, -175, -175, -175, -175, -175,
 /*   150 */  -175, -175,  717,  -82,  718,   48, -175, -175, -175, -175,
 /*   160 */  -175, -175, -175,  723,   48,  725,   48, -175, 1000,  190,
 /*   170 */   933, -175, -175, -175, -175, -175,   48,  774,   48,  775,
 /*   180 */    48,  780,   48,  783,   48, -175,  608,  933, -175,  255,
 /*   190 */    48,  943,  944, -175, -175,  785,   48,  786,   48, -175,
 /*   200 */   971, -175, -175, -175, 1011, -175, -175,  802,   48,  825,
 /*   210 */    48,  837,   48, -175, -175,  320, -175, -175, 1014, 1016,
 /*   220 */  -175, -175, -175,  838,   48, -175,  258, -175,  261,  966,
 /*   230 */  1006, -175, 1018, -175, -175,   48,  970, 1013, -175,  840,
 /*   240 */    48, -175,  189, -175,  846,   48, -175,  135,  983, -175,
 /*   250 */  -175, -175, 1040, -175, 1041, -175, -175, -175, 1042, 1034,
 /*   260 */   564, -175, -175, 1044, -175, -175,  985,  991, -175, -175,
 /*   270 */   590, -175, -175, 1050, -175, -175,  851,   48,  -57,  933,
 /*   280 */   983, -175,  600,  995,  999, -175,  852,  115, -175, -175,
 /*   290 */  -175,  988, -175, -175, -175, -175,   48, -175, -175, -175,
 /*   300 */  -175, -175,   48, 1035, -175, 1055, 1043, 1046, 1045, -175,
 /*   310 */  1066, -175, -175, 1047, -175, -175, -175, -175, -175, -175,
 /*   320 */  1048, -175, 1056, -175,  583, -175, -175,  708, 1017, 1057,
 /*   330 */  -175, -175, 1023, 1067, -175, -175, 1063, -175, 1065, -175,
 /*   340 */  -175,  591, -175, 1068, -175, -175, 1070, -175, -175, 1078,
 /*   350 */   121, -175, -175,  257, -175, -175, -175, -175,  996, -175,
 /*   360 */  -175, -175, 1002, -175, -175, -175, -175, -175, 1069, 1071,
 /*   370 */  -175, 1086, -175, -175, -175,  711, 1074, -175, 1072, -175,
 /*   380 */  -175,  713, -175, 1077, -175,  853,  282, -175, -175, -175,
 /*   390 */   748, -175, -175, 1102, 1082, 1083,  -98, -175, -175, -175,
 /*   400 */  -175, -175, -175,  811,  933,  326, -175, 1108, 1107, -175,
 /*   410 */  1115, 1112, -175,  861,  933, 1119, 1116, 1059, 1080, -175,
 /*   420 */    29, 1118, -175, 1081, 1087, -175,  854,   48, -175, -175,
 /*   430 */  -175, -175, -175, -175, -175,  656, -175, -175, -175, -175,
 /*   440 */  -175, -175, -175, 1131, 1128, -175, 1142, -175,  855, -175,
 /*   450 */  1114, -175, -175, -175,  462,  933, 1104,  868, -175, -175,
 /*   460 */  -175, -175, -175, -175,  527, -175, 1123, 1159, -175,  832,
 /*   470 */  1117, 1163, -175,  869,   48, -175, -175,  890,   48, -175,
 /*   480 */  1177, 1110,  891, -175, -175,  900,  933, -175,  322, -175,
 /*   490 */   892,   48, -175,   48, -175, 1182, 1140, -175, -175,  481,
 /*   500 */  -175,  918, -175,  919, -175,  922, -175,  933, -175,  923,
 /*   510 */  1143, -175, 1158,  924, -175,  913, 1151, -175, -175,  925,
 /*   520 */  1132,  908,  933, -175,  389, -175, -175, 1202, -175, 1206,
 /*   530 */  1204, -175,  398, -175, -175, -175, -175, 1213, -175, -175,
 /*   540 */  1144, 1208, -175, 1223, 1145, -175, 1214, -175, -175, -175,
 /*   550 */  1147, 1228, -175, 1243, 1230, -175, -175,  926, -175, -175,
 /*   560 */  1249, -175, -175, -175,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   570,  570,  565,  568,  869,  869,  869,  569,  576,  869,
 /*    10 */   869,  869,  869,  596,  597,  598,  577,  578,  579,  869,
 /*    20 */   869,  869,  869,  869,  869,  869,  869,  869,  869,  869,
 /*    30 */   869,  869,  589,  599,  608,  591,  607,  869,  869,  609,
 /*    40 */   652,  615,  869,  869,  653,  656,  657,  658,  855,  856,
 /*    50 */   857,  869,  652,  616,  637,  635,  869,  638,  639,  869,
 /*    60 */   708,  652,  623,  617,  624,  706,  707,  652,  618,  869,
 /*    70 */   869,  738,  807,  744,  739,  735,  869,  663,  869,  869,
 /*    80 */   664,  672,  674,  681,  720,  711,  713,  701,  715,  669,
 /*    90 */   869,  716,  869,  717,  869,  737,  869,  869,  740,  869,
 /*   100 */   741,  742,  743,  745,  746,  747,  750,  751,  752,  753,
 /*   110 */   869,  754,  869,  755,  869,  756,  869,  757,  869,  758,
 /*   120 */   869,  759,  869,  760,  869,  761,  869,  762,  869,  763,
 /*   130 */   869,  764,  869,  765,  869,  766,  869,  767,  869,  768,
 /*   140 */   869,  769,  869,  770,  771,  772,  869,  773,  774,  781,
 /*   150 */   788,  791,  869,  776,  869,  775,  778,  869,  779,  869,
 /*   160 */   782,  780,  787,  869,  869,  869,  789,  790,  869,  807,
 /*   170 */   869,  869,  869,  869,  869,  794,  806,  869,  783,  869,
 /*   180 */   784,  869,  785,  869,  786,  869,  869,  869,  796,  869,
 /*   190 */   869,  869,  869,  869,  797,  869,  869,  869,  798,  869,
 /*   200 */   869,  869,  853,  869,  869,  869,  854,  869,  869,  869,
 /*   210 */   869,  869,  799,  869,  792,  807,  804,  805,  689,  869,
 /*   220 */   690,  795,  777,  869,  718,  869,  869,  702,  869,  709,
 /*   230 */   708,  703,  869,  593,  710,  705,  709,  708,  704,  869,
 /*   240 */   714,  869,  807,  712,  869,  721,  673,  684,  682,  683,
 /*   250 */   692,  693,  869,  694,  869,  695,  869,  696,  869,  689,
 /*   260 */   680,  594,  595,  869,  678,  679,  698,  700,  685,  869,
 /*   270 */   869,  869,  699,  869,  733,  734,  869,  697,  684,  869,
 /*   280 */   869,  869,  680,  698,  700,  686,  869,  680,  675,  676,
 /*   290 */   869,  869,  677,  670,  671,  793,  869,  736,  869,  748,
 /*   300 */   869,  749,  869,  652,  619,  869,  811,  625,  620,  626,
 /*   310 */   869,  627,  869,  869,  628,  869,  631,  632,  633,  634,
 /*   320 */   869,  629,  869,  630,  869,  869,  812,  869,  709,  708,
 /*   330 */   813,  815,  709,  708,  814,  621,  869,  622,  637,  636,
 /*   340 */   610,  869,  611,  869,  612,  744,  869,  613,  614,  600,
 /*   350 */   830,  869,  601,  830,  869,  602,  605,  606,  869,  825,
 /*   360 */   827,  828,  869,  826,  829,  604,  603,  592,  869,  869,
 /*   370 */   642,  869,  645,  869,  869,  869,  869,  869,  652,  646,
 /*   380 */   869,  869,  869,  652,  647,  869,  652,  648,  869,  869,
 /*   390 */   869,  869,  869,  869,  811,  625,  650,  869,  649,  651,
 /*   400 */   643,  644,  590,  869,  869,  586,  869,  869,  689,  584,
 /*   410 */   869,  869,  869,  869,  869,  869,  689,  836,  869,  869,
 /*   420 */   869,  689,  691,  841,  869,  869,  869,  869,  869,  869,
 /*   430 */   842,  843,  869,  869,  869,  869,  869,  833,  834,  869,
 /*   440 */   835,  585,  869,  869,  869,  869,  869,  869,  869,  869,
 /*   450 */   869,  869,  869,  869,  869,  869,  869,  869,  655,  869,
 /*   460 */   869,  869,  869,  869,  869,  869,  654,  869,  869,  869,
 /*   470 */   869,  869,  869,  869,  723,  869,  869,  869,  724,  869,
 /*   480 */   869,  731,  869,  869,  732,  869,  869,  869,  869,  869,
 /*   490 */   869,  729,  869,  730,  869,  869,  869,  869,  869,  869,
 /*   500 */   869,  869,  869,  869,  869,  869,  869,  869,  869,  869,
 /*   510 */   869,  869,  654,  869,  869,  869,  869,  869,  869,  869,
 /*   520 */   731,  869,  869,  869,  869,  869,  869,  869,  869,  869,
 /*   530 */   689,  869,  830,  869,  869,  869,  869,  869,  869,  869,
 /*   540 */   864,  869,  869,  869,  869,  869,  869,  869,  869,  863,
 /*   550 */   864,  869,  869,  869,  869,  869,  869,  869,  869,  869,
 /*   560 */   869,  869,  571,  566,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*      SPACE => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*     COLUMN => nothing */
    0,  /* AGG_FUNCTION => nothing */
    0,  /*       SEMI => nothing */
   26,  /*    EXPLAIN => ID */
   26,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   26,  /*   DEFERRED => ID */
   26,  /*  IMMEDIATE => ID */
   26,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   26,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   26,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   26,  /*      ABORT => ID */
   26,  /*      AFTER => ID */
   26,  /*        ASC => ID */
   26,  /*     ATTACH => ID */
   26,  /*     BEFORE => ID */
   26,  /*    CASCADE => ID */
   26,  /*   CONFLICT => ID */
   26,  /*   DATABASE => ID */
   26,  /*       DESC => ID */
   26,  /*     DETACH => ID */
   26,  /*       EACH => ID */
   26,  /*       FAIL => ID */
   26,  /*        FOR => ID */
   26,  /*       GLOB => ID */
   26,  /*     IGNORE => ID */
   26,  /*  INITIALLY => ID */
   26,  /*    INSTEAD => ID */
   26,  /*       LIKE => ID */
   26,  /*      MATCH => ID */
   26,  /*        KEY => ID */
   26,  /*         OF => ID */
   26,  /*     OFFSET => ID */
   26,  /*     PRAGMA => ID */
   26,  /*      RAISE => ID */
   26,  /*    REPLACE => ID */
   26,  /*   RESTRICT => ID */
   26,  /*        ROW => ID */
   26,  /*  STATEMENT => ID */
   26,  /*    TRIGGER => ID */
   26,  /*     VACUUM => ID */
   26,  /*       VIEW => ID */
   26,  /*    REINDEX => ID */
   26,  /*     RENAME => ID */
   26,  /*      CDATE => ID */
   26,  /*      CTIME => ID */
   26,  /* CTIMESTAMP => ID */
   26,  /*      ALTER => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*         TO => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "END_OF_FILE",   "ILLEGAL",       "SPACE",       
  "UNCLOSED_STRING",  "COMMENT",       "FUNCTION",      "COLUMN",      
  "AGG_FUNCTION",  "SEMI",          "EXPLAIN",       "BEGIN",       
  "TRANSACTION",   "DEFERRED",      "IMMEDIATE",     "EXCLUSIVE",   
  "COMMIT",        "END",           "ROLLBACK",      "CREATE",      
  "TABLE",         "TEMP",          "LP",            "RP",          
  "AS",            "COMMA",         "ID",            "ABORT",       
  "AFTER",         "ASC",           "ATTACH",        "BEFORE",      
  "CASCADE",       "CONFLICT",      "DATABASE",      "DESC",        
  "DETACH",        "EACH",          "FAIL",          "FOR",         
  "GLOB",          "IGNORE",        "INITIALLY",     "INSTEAD",     
  "LIKE",          "MATCH",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "STATEMENT",     "TRIGGER",     
  "VACUUM",        "VIEW",          "REINDEX",       "RENAME",      
  "CDATE",         "CTIME",         "CTIMESTAMP",    "ALTER",       
  "OR",            "AND",           "NOT",           "IS",          
  "BETWEEN",       "IN",            "ISNULL",        "NOTNULL",     
  "NE",            "EQ",            "GT",            "LE",          
  "LT",            "GE",            "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "COLLATE",       "AUTOINCR",      "ON",          
  "DELETE",        "UPDATE",        "INSERT",        "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "UNION",       
  "ALL",           "INTERSECT",     "EXCEPT",        "SELECT",      
  "DISTINCT",      "DOT",           "FROM",          "JOIN",        
  "USING",         "ORDER",         "BY",            "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "REGISTER",      "VARIABLE",      "EXISTS",        "CASE",        
  "WHEN",          "THEN",          "ELSE",          "INDEX",       
  "TO",            "error",         "input",         "cmdlist",     
  "ecmd",          "cmdx",          "cmd",           "explain",     
  "transtype",     "trans_opt",     "nm",            "create_table",
  "create_table_args",  "temp",          "dbnm",          "columnlist",  
  "conslist_opt",  "select",        "column",        "columnid",    
  "type",          "carglist",      "id",            "ids",         
  "typename",      "signed",        "plus_num",      "minus_num",   
  "carg",          "ccons",         "term",          "onconf",      
  "sortorder",     "autoinc",       "expr",          "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "raisetype",   
  "fullname",      "oneselect",     "multiselect_op",  "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "sclp",        
  "as",            "seltablist",    "stl_prefix",    "joinop",      
  "on_opt",        "using_opt",     "seltablist_paren",  "joinop2",     
  "inscollist",    "sortlist",      "sortitem",      "collate",     
  "exprlist",      "setlist",       "insert_cmd",    "inscollist_opt",
  "itemlist",      "likeop",        "escape",        "between_op",  
  "in_op",         "case_operand",  "case_exprlist",  "case_else",   
  "expritem",      "uniqueflag",    "idxitem",       "plus_opt",    
  "number",        "trigger_decl",  "trigger_cmd_list",  "trigger_time",
  "trigger_event",  "foreach_clause",  "when_clause",   "trigger_cmd", 
  "database_kw_opt",  "key_opt",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "cmd ::= BEGIN transtype trans_opt",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "transtype ::=",
 /*  13 */ "transtype ::= DEFERRED",
 /*  14 */ "transtype ::= IMMEDIATE",
 /*  15 */ "transtype ::= EXCLUSIVE",
 /*  16 */ "cmd ::= COMMIT trans_opt",
 /*  17 */ "cmd ::= END trans_opt",
 /*  18 */ "cmd ::= ROLLBACK trans_opt",
 /*  19 */ "cmd ::= create_table create_table_args",
 /*  20 */ "create_table ::= CREATE temp TABLE nm dbnm",
 /*  21 */ "temp ::= TEMP",
 /*  22 */ "temp ::=",
 /*  23 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  24 */ "create_table_args ::= AS select",
 /*  25 */ "columnlist ::= columnlist COMMA column",
 /*  26 */ "columnlist ::= column",
 /*  27 */ "column ::= columnid type carglist",
 /*  28 */ "columnid ::= nm",
 /*  29 */ "id ::= ID",
 /*  30 */ "ids ::= ID",
 /*  31 */ "ids ::= STRING",
 /*  32 */ "nm ::= ID",
 /*  33 */ "nm ::= STRING",
 /*  34 */ "nm ::= JOIN_KW",
 /*  35 */ "type ::=",
 /*  36 */ "type ::= typename",
 /*  37 */ "type ::= typename LP signed RP",
 /*  38 */ "type ::= typename LP signed COMMA signed RP",
 /*  39 */ "typename ::= ids",
 /*  40 */ "typename ::= typename ids",
 /*  41 */ "signed ::= plus_num",
 /*  42 */ "signed ::= minus_num",
 /*  43 */ "carglist ::= carglist carg",
 /*  44 */ "carglist ::=",
 /*  45 */ "carg ::= CONSTRAINT nm ccons",
 /*  46 */ "carg ::= ccons",
 /*  47 */ "carg ::= DEFAULT term",
 /*  48 */ "carg ::= DEFAULT PLUS term",
 /*  49 */ "carg ::= DEFAULT MINUS term",
 /*  50 */ "carg ::= DEFAULT id",
 /*  51 */ "ccons ::= NULL onconf",
 /*  52 */ "ccons ::= NOT NULL onconf",
 /*  53 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  54 */ "ccons ::= UNIQUE onconf",
 /*  55 */ "ccons ::= CHECK LP expr RP onconf",
 /*  56 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  57 */ "ccons ::= defer_subclause",
 /*  58 */ "ccons ::= COLLATE id",
 /*  59 */ "autoinc ::=",
 /*  60 */ "autoinc ::= AUTOINCR",
 /*  61 */ "refargs ::=",
 /*  62 */ "refargs ::= refargs refarg",
 /*  63 */ "refarg ::= MATCH nm",
 /*  64 */ "refarg ::= ON DELETE refact",
 /*  65 */ "refarg ::= ON UPDATE refact",
 /*  66 */ "refarg ::= ON INSERT refact",
 /*  67 */ "refact ::= SET NULL",
 /*  68 */ "refact ::= SET DEFAULT",
 /*  69 */ "refact ::= CASCADE",
 /*  70 */ "refact ::= RESTRICT",
 /*  71 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  72 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  73 */ "init_deferred_pred_opt ::=",
 /*  74 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  75 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  76 */ "conslist_opt ::=",
 /*  77 */ "conslist_opt ::= COMMA conslist",
 /*  78 */ "conslist ::= conslist COMMA tcons",
 /*  79 */ "conslist ::= conslist tcons",
 /*  80 */ "conslist ::= tcons",
 /*  81 */ "tcons ::= CONSTRAINT nm",
 /*  82 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  83 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  84 */ "tcons ::= CHECK expr onconf",
 /*  85 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  86 */ "defer_subclause_opt ::=",
 /*  87 */ "defer_subclause_opt ::= defer_subclause",
 /*  88 */ "onconf ::=",
 /*  89 */ "onconf ::= ON CONFLICT resolvetype",
 /*  90 */ "orconf ::=",
 /*  91 */ "orconf ::= OR resolvetype",
 /*  92 */ "resolvetype ::= raisetype",
 /*  93 */ "resolvetype ::= IGNORE",
 /*  94 */ "resolvetype ::= REPLACE",
 /*  95 */ "cmd ::= DROP TABLE fullname",
 /*  96 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /*  97 */ "cmd ::= DROP VIEW fullname",
 /*  98 */ "cmd ::= select",
 /*  99 */ "select ::= oneselect",
 /* 100 */ "select ::= select multiselect_op oneselect",
 /* 101 */ "multiselect_op ::= UNION",
 /* 102 */ "multiselect_op ::= UNION ALL",
 /* 103 */ "multiselect_op ::= INTERSECT",
 /* 104 */ "multiselect_op ::= EXCEPT",
 /* 105 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 106 */ "distinct ::= DISTINCT",
 /* 107 */ "distinct ::= ALL",
 /* 108 */ "distinct ::=",
 /* 109 */ "sclp ::= selcollist COMMA",
 /* 110 */ "sclp ::=",
 /* 111 */ "selcollist ::= sclp expr as",
 /* 112 */ "selcollist ::= sclp STAR",
 /* 113 */ "selcollist ::= sclp nm DOT STAR",
 /* 114 */ "as ::= AS nm",
 /* 115 */ "as ::= ids",
 /* 116 */ "as ::=",
 /* 117 */ "from ::=",
 /* 118 */ "from ::= FROM seltablist",
 /* 119 */ "stl_prefix ::= seltablist joinop",
 /* 120 */ "stl_prefix ::=",
 /* 121 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 122 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 123 */ "seltablist_paren ::= select",
 /* 124 */ "seltablist_paren ::= seltablist",
 /* 125 */ "dbnm ::=",
 /* 126 */ "dbnm ::= DOT nm",
 /* 127 */ "fullname ::= nm dbnm",
 /* 128 */ "joinop ::= COMMA",
 /* 129 */ "joinop ::= JOIN",
 /* 130 */ "joinop ::= JOIN_KW JOIN",
 /* 131 */ "joinop ::= JOIN_KW nm JOIN",
 /* 132 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 133 */ "on_opt ::= ON expr",
 /* 134 */ "on_opt ::=",
 /* 135 */ "using_opt ::= USING LP inscollist RP",
 /* 136 */ "using_opt ::=",
 /* 137 */ "orderby_opt ::=",
 /* 138 */ "orderby_opt ::= ORDER BY sortlist",
 /* 139 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 140 */ "sortlist ::= sortitem collate sortorder",
 /* 141 */ "sortitem ::= expr",
 /* 142 */ "sortorder ::= ASC",
 /* 143 */ "sortorder ::= DESC",
 /* 144 */ "sortorder ::=",
 /* 145 */ "collate ::=",
 /* 146 */ "collate ::= COLLATE id",
 /* 147 */ "groupby_opt ::=",
 /* 148 */ "groupby_opt ::= GROUP BY exprlist",
 /* 149 */ "having_opt ::=",
 /* 150 */ "having_opt ::= HAVING expr",
 /* 151 */ "limit_opt ::=",
 /* 152 */ "limit_opt ::= LIMIT expr",
 /* 153 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 154 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 155 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 156 */ "where_opt ::=",
 /* 157 */ "where_opt ::= WHERE expr",
 /* 158 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 159 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 160 */ "setlist ::= nm EQ expr",
 /* 161 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 162 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 163 */ "insert_cmd ::= INSERT orconf",
 /* 164 */ "insert_cmd ::= REPLACE",
 /* 165 */ "itemlist ::= itemlist COMMA expr",
 /* 166 */ "itemlist ::= expr",
 /* 167 */ "inscollist_opt ::=",
 /* 168 */ "inscollist_opt ::= LP inscollist RP",
 /* 169 */ "inscollist ::= inscollist COMMA nm",
 /* 170 */ "inscollist ::= nm",
 /* 171 */ "expr ::= term",
 /* 172 */ "expr ::= LP expr RP",
 /* 173 */ "term ::= NULL",
 /* 174 */ "expr ::= ID",
 /* 175 */ "expr ::= JOIN_KW",
 /* 176 */ "expr ::= nm DOT nm",
 /* 177 */ "expr ::= nm DOT nm DOT nm",
 /* 178 */ "term ::= INTEGER",
 /* 179 */ "term ::= FLOAT",
 /* 180 */ "term ::= STRING",
 /* 181 */ "term ::= BLOB",
 /* 182 */ "expr ::= REGISTER",
 /* 183 */ "expr ::= VARIABLE",
 /* 184 */ "expr ::= ID LP exprlist RP",
 /* 185 */ "expr ::= ID LP STAR RP",
 /* 186 */ "term ::= CTIME",
 /* 187 */ "term ::= CDATE",
 /* 188 */ "term ::= CTIMESTAMP",
 /* 189 */ "expr ::= expr AND expr",
 /* 190 */ "expr ::= expr OR expr",
 /* 191 */ "expr ::= expr LT expr",
 /* 192 */ "expr ::= expr GT expr",
 /* 193 */ "expr ::= expr LE expr",
 /* 194 */ "expr ::= expr GE expr",
 /* 195 */ "expr ::= expr NE expr",
 /* 196 */ "expr ::= expr EQ expr",
 /* 197 */ "expr ::= expr BITAND expr",
 /* 198 */ "expr ::= expr BITOR expr",
 /* 199 */ "expr ::= expr LSHIFT expr",
 /* 200 */ "expr ::= expr RSHIFT expr",
 /* 201 */ "expr ::= expr PLUS expr",
 /* 202 */ "expr ::= expr MINUS expr",
 /* 203 */ "expr ::= expr STAR expr",
 /* 204 */ "expr ::= expr SLASH expr",
 /* 205 */ "expr ::= expr REM expr",
 /* 206 */ "expr ::= expr CONCAT expr",
 /* 207 */ "likeop ::= LIKE",
 /* 208 */ "likeop ::= GLOB",
 /* 209 */ "likeop ::= NOT LIKE",
 /* 210 */ "likeop ::= NOT GLOB",
 /* 211 */ "escape ::= ESCAPE expr",
 /* 212 */ "escape ::=",
 /* 213 */ "expr ::= expr likeop expr escape",
 /* 214 */ "expr ::= expr ISNULL",
 /* 215 */ "expr ::= expr IS NULL",
 /* 216 */ "expr ::= expr NOTNULL",
 /* 217 */ "expr ::= expr NOT NULL",
 /* 218 */ "expr ::= expr IS NOT NULL",
 /* 219 */ "expr ::= NOT expr",
 /* 220 */ "expr ::= BITNOT expr",
 /* 221 */ "expr ::= MINUS expr",
 /* 222 */ "expr ::= PLUS expr",
 /* 223 */ "between_op ::= BETWEEN",
 /* 224 */ "between_op ::= NOT BETWEEN",
 /* 225 */ "expr ::= expr between_op expr AND expr",
 /* 226 */ "in_op ::= IN",
 /* 227 */ "in_op ::= NOT IN",
 /* 228 */ "expr ::= expr in_op LP exprlist RP",
 /* 229 */ "expr ::= LP select RP",
 /* 230 */ "expr ::= expr in_op LP select RP",
 /* 231 */ "expr ::= expr in_op nm dbnm",
 /* 232 */ "expr ::= EXISTS LP select RP",
 /* 233 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 234 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 235 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 236 */ "case_else ::= ELSE expr",
 /* 237 */ "case_else ::=",
 /* 238 */ "case_operand ::= expr",
 /* 239 */ "case_operand ::=",
 /* 240 */ "exprlist ::= exprlist COMMA expritem",
 /* 241 */ "exprlist ::= expritem",
 /* 242 */ "expritem ::= expr",
 /* 243 */ "expritem ::=",
 /* 244 */ "cmd ::= CREATE uniqueflag INDEX nm dbnm ON nm LP idxlist RP onconf",
 /* 245 */ "uniqueflag ::= UNIQUE",
 /* 246 */ "uniqueflag ::=",
 /* 247 */ "idxlist_opt ::=",
 /* 248 */ "idxlist_opt ::= LP idxlist RP",
 /* 249 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 250 */ "idxlist ::= idxitem collate sortorder",
 /* 251 */ "idxitem ::= nm",
 /* 252 */ "cmd ::= DROP INDEX fullname",
 /* 253 */ "cmd ::= VACUUM",
 /* 254 */ "cmd ::= VACUUM nm",
 /* 255 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 256 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 257 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 258 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 259 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 260 */ "cmd ::= PRAGMA nm dbnm",
 /* 261 */ "plus_num ::= plus_opt number",
 /* 262 */ "minus_num ::= MINUS number",
 /* 263 */ "number ::= INTEGER",
 /* 264 */ "number ::= FLOAT",
 /* 265 */ "plus_opt ::= PLUS",
 /* 266 */ "plus_opt ::=",
 /* 267 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 268 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 269 */ "trigger_time ::= BEFORE",
 /* 270 */ "trigger_time ::= AFTER",
 /* 271 */ "trigger_time ::= INSTEAD OF",
 /* 272 */ "trigger_time ::=",
 /* 273 */ "trigger_event ::= DELETE",
 /* 274 */ "trigger_event ::= INSERT",
 /* 275 */ "trigger_event ::= UPDATE",
 /* 276 */ "trigger_event ::= UPDATE OF inscollist",
 /* 277 */ "foreach_clause ::=",
 /* 278 */ "foreach_clause ::= FOR EACH ROW",
 /* 279 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 280 */ "when_clause ::=",
 /* 281 */ "when_clause ::= WHEN expr",
 /* 282 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 283 */ "trigger_cmd_list ::=",
 /* 284 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 285 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 286 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 287 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 288 */ "trigger_cmd ::= select",
 /* 289 */ "expr ::= RAISE LP IGNORE RP",
 /* 290 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 291 */ "raisetype ::= ROLLBACK",
 /* 292 */ "raisetype ::= ABORT",
 /* 293 */ "raisetype ::= FAIL",
 /* 294 */ "cmd ::= DROP TRIGGER fullname",
 /* 295 */ "cmd ::= ATTACH database_kw_opt ids AS nm key_opt",
 /* 296 */ "key_opt ::=",
 /* 297 */ "key_opt ::= KEY ids",
 /* 298 */ "key_opt ::= KEY BLOB",
 /* 299 */ "database_kw_opt ::= DATABASE",
 /* 300 */ "database_kw_opt ::=",
 /* 301 */ "cmd ::= DETACH database_kw_opt nm",
 /* 302 */ "cmd ::= REINDEX",
 /* 303 */ "cmd ::= REINDEX nm dbnm",
 /* 304 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 157:
    case 189:
    case 206:
#line 325 "parse.y"
{sqlite3SelectDelete((yypminor->yy331));}
#line 1315 "parse.c"
      break;
    case 170:
    case 174:
    case 194:
    case 196:
    case 204:
    case 210:
    case 224:
#line 584 "parse.y"
{sqlite3ExprDelete((yypminor->yy454));}
#line 1326 "parse.c"
      break;
    case 175:
    case 183:
    case 192:
    case 195:
    case 197:
    case 199:
    case 209:
    case 212:
    case 213:
    case 216:
    case 222:
#line 803 "parse.y"
{sqlite3ExprListDelete((yypminor->yy266));}
#line 1341 "parse.c"
      break;
    case 188:
    case 193:
    case 201:
    case 202:
#line 454 "parse.y"
{sqlite3SrcListDelete((yypminor->yy427));}
#line 1349 "parse.c"
      break;
    case 198:
#line 516 "parse.y"
{
  sqlite3ExprDelete((yypminor->yy348).pLimit);
  sqlite3ExprDelete((yypminor->yy348).pOffset);
}
#line 1357 "parse.c"
      break;
    case 205:
    case 208:
    case 215:
#line 472 "parse.y"
{sqlite3IdListDelete((yypminor->yy272));}
#line 1364 "parse.c"
      break;
    case 230:
    case 235:
#line 896 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy455));}
#line 1370 "parse.c"
      break;
    case 232:
#line 880 "parse.y"
{sqlite3IdListDelete((yypminor->yy62).b);}
#line 1375 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 142, 1 },
  { 143, 2 },
  { 143, 1 },
  { 145, 1 },
  { 144, 1 },
  { 144, 3 },
  { 147, 0 },
  { 147, 1 },
  { 146, 3 },
  { 149, 0 },
  { 149, 1 },
  { 149, 2 },
  { 148, 0 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 146, 2 },
  { 146, 2 },
  { 146, 2 },
  { 146, 2 },
  { 151, 5 },
  { 153, 1 },
  { 153, 0 },
  { 152, 4 },
  { 152, 2 },
  { 155, 3 },
  { 155, 1 },
  { 158, 3 },
  { 159, 1 },
  { 162, 1 },
  { 163, 1 },
  { 163, 1 },
  { 150, 1 },
  { 150, 1 },
  { 150, 1 },
  { 160, 0 },
  { 160, 1 },
  { 160, 4 },
  { 160, 6 },
  { 164, 1 },
  { 164, 2 },
  { 165, 1 },
  { 165, 1 },
  { 161, 2 },
  { 161, 0 },
  { 168, 3 },
  { 168, 1 },
  { 168, 2 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 2 },
  { 169, 5 },
  { 169, 4 },
  { 169, 1 },
  { 169, 2 },
  { 173, 0 },
  { 173, 1 },
  { 176, 0 },
  { 176, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 179, 2 },
  { 179, 2 },
  { 179, 1 },
  { 179, 1 },
  { 177, 3 },
  { 177, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 2 },
  { 156, 0 },
  { 156, 2 },
  { 181, 3 },
  { 181, 2 },
  { 181, 1 },
  { 182, 2 },
  { 182, 7 },
  { 182, 5 },
  { 182, 3 },
  { 182, 10 },
  { 184, 0 },
  { 184, 1 },
  { 171, 0 },
  { 171, 3 },
  { 185, 0 },
  { 185, 2 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 146, 3 },
  { 146, 7 },
  { 146, 3 },
  { 146, 1 },
  { 157, 1 },
  { 157, 3 },
  { 190, 1 },
  { 190, 2 },
  { 190, 1 },
  { 190, 1 },
  { 189, 9 },
  { 191, 1 },
  { 191, 1 },
  { 191, 0 },
  { 199, 2 },
  { 199, 0 },
  { 192, 3 },
  { 192, 2 },
  { 192, 4 },
  { 200, 2 },
  { 200, 1 },
  { 200, 0 },
  { 193, 0 },
  { 193, 2 },
  { 202, 2 },
  { 202, 0 },
  { 201, 6 },
  { 201, 7 },
  { 206, 1 },
  { 206, 1 },
  { 154, 0 },
  { 154, 2 },
  { 188, 2 },
  { 203, 1 },
  { 203, 1 },
  { 203, 2 },
  { 203, 3 },
  { 203, 4 },
  { 204, 2 },
  { 204, 0 },
  { 205, 4 },
  { 205, 0 },
  { 197, 0 },
  { 197, 3 },
  { 209, 5 },
  { 209, 3 },
  { 210, 1 },
  { 172, 1 },
  { 172, 1 },
  { 172, 0 },
  { 211, 0 },
  { 211, 2 },
  { 195, 0 },
  { 195, 3 },
  { 196, 0 },
  { 196, 2 },
  { 198, 0 },
  { 198, 2 },
  { 198, 4 },
  { 198, 4 },
  { 146, 4 },
  { 194, 0 },
  { 194, 2 },
  { 146, 6 },
  { 213, 5 },
  { 213, 3 },
  { 146, 8 },
  { 146, 5 },
  { 214, 2 },
  { 214, 1 },
  { 216, 3 },
  { 216, 1 },
  { 215, 0 },
  { 215, 3 },
  { 208, 3 },
  { 208, 1 },
  { 174, 1 },
  { 174, 3 },
  { 170, 1 },
  { 174, 1 },
  { 174, 1 },
  { 174, 3 },
  { 174, 5 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 174, 1 },
  { 174, 1 },
  { 174, 4 },
  { 174, 4 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 217, 1 },
  { 217, 1 },
  { 217, 2 },
  { 217, 2 },
  { 218, 2 },
  { 218, 0 },
  { 174, 4 },
  { 174, 2 },
  { 174, 3 },
  { 174, 2 },
  { 174, 3 },
  { 174, 4 },
  { 174, 2 },
  { 174, 2 },
  { 174, 2 },
  { 174, 2 },
  { 219, 1 },
  { 219, 2 },
  { 174, 5 },
  { 220, 1 },
  { 220, 2 },
  { 174, 5 },
  { 174, 3 },
  { 174, 5 },
  { 174, 4 },
  { 174, 4 },
  { 174, 5 },
  { 222, 5 },
  { 222, 4 },
  { 223, 2 },
  { 223, 0 },
  { 221, 1 },
  { 221, 0 },
  { 212, 3 },
  { 212, 1 },
  { 224, 1 },
  { 224, 0 },
  { 146, 11 },
  { 225, 1 },
  { 225, 0 },
  { 175, 0 },
  { 175, 3 },
  { 183, 5 },
  { 183, 3 },
  { 226, 1 },
  { 146, 3 },
  { 146, 1 },
  { 146, 2 },
  { 146, 5 },
  { 146, 5 },
  { 146, 5 },
  { 146, 5 },
  { 146, 6 },
  { 146, 3 },
  { 166, 2 },
  { 167, 2 },
  { 228, 1 },
  { 228, 1 },
  { 227, 1 },
  { 227, 0 },
  { 146, 5 },
  { 229, 10 },
  { 231, 1 },
  { 231, 1 },
  { 231, 2 },
  { 231, 0 },
  { 232, 1 },
  { 232, 1 },
  { 232, 1 },
  { 232, 3 },
  { 233, 0 },
  { 233, 3 },
  { 233, 3 },
  { 234, 0 },
  { 234, 2 },
  { 230, 3 },
  { 230, 0 },
  { 235, 6 },
  { 235, 8 },
  { 235, 5 },
  { 235, 4 },
  { 235, 1 },
  { 174, 4 },
  { 174, 6 },
  { 187, 1 },
  { 187, 1 },
  { 187, 1 },
  { 146, 3 },
  { 146, 6 },
  { 237, 0 },
  { 237, 2 },
  { 237, 2 },
  { 236, 1 },
  { 236, 0 },
  { 146, 3 },
  { 146, 1 },
  { 146, 3 },
  { 146, 6 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 84 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1907 "parse.c"
        break;
      case 6:
#line 87 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1912 "parse.c"
        break;
      case 7:
#line 89 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1917 "parse.c"
        break;
      case 8:
#line 95 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy60);}
#line 1922 "parse.c"
        break;
      case 12:
#line 100 "parse.y"
{yygotominor.yy60 = TK_DEFERRED;}
#line 1927 "parse.c"
        break;
      case 13:
      case 14:
      case 15:
      case 101:
      case 103:
      case 104:
#line 101 "parse.y"
{yygotominor.yy60 = yymsp[0].major;}
#line 1937 "parse.c"
        break;
      case 16:
      case 17:
#line 104 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1943 "parse.c"
        break;
      case 18:
#line 106 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1948 "parse.c"
        break;
      case 20:
#line 111 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-4].minor.yy0,&yymsp[-1].minor.yy406,&yymsp[0].minor.yy406,yymsp[-3].minor.yy60,0);
}
#line 1955 "parse.c"
        break;
      case 21:
      case 60:
      case 74:
      case 106:
      case 224:
      case 227:
#line 115 "parse.y"
{yygotominor.yy60 = 1;}
#line 1965 "parse.c"
        break;
      case 22:
      case 59:
      case 73:
      case 75:
      case 86:
      case 107:
      case 108:
      case 223:
      case 226:
#line 116 "parse.y"
{yygotominor.yy60 = 0;}
#line 1978 "parse.c"
        break;
      case 23:
#line 117 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[0].minor.yy0,0);
}
#line 1985 "parse.c"
        break;
      case 24:
#line 120 "parse.y"
{
  sqlite3EndTable(pParse,0,yymsp[0].minor.yy331);
  sqlite3SelectDelete(yymsp[0].minor.yy331);
}
#line 1993 "parse.c"
        break;
      case 28:
#line 132 "parse.y"
{sqlite3AddColumn(pParse,&yymsp[0].minor.yy406);}
#line 1998 "parse.c"
        break;
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 263:
      case 264:
#line 138 "parse.y"
{yygotominor.yy406 = yymsp[0].minor.yy0;}
#line 2010 "parse.c"
        break;
      case 36:
#line 193 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy406,&yymsp[0].minor.yy406);}
#line 2015 "parse.c"
        break;
      case 37:
#line 194 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-3].minor.yy406,&yymsp[0].minor.yy0);}
#line 2020 "parse.c"
        break;
      case 38:
#line 196 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-5].minor.yy406,&yymsp[0].minor.yy0);}
#line 2025 "parse.c"
        break;
      case 39:
      case 114:
      case 115:
      case 126:
      case 146:
      case 251:
      case 261:
      case 262:
#line 198 "parse.y"
{yygotominor.yy406 = yymsp[0].minor.yy406;}
#line 2037 "parse.c"
        break;
      case 40:
#line 199 "parse.y"
{yygotominor.yy406.z=yymsp[-1].minor.yy406.z; yygotominor.yy406.n=yymsp[0].minor.yy406.n+(yymsp[0].minor.yy406.z-yymsp[-1].minor.yy406.z);}
#line 2042 "parse.c"
        break;
      case 41:
#line 201 "parse.y"
{ yygotominor.yy60 = atoi(yymsp[0].minor.yy406.z); }
#line 2047 "parse.c"
        break;
      case 42:
#line 202 "parse.y"
{ yygotominor.yy60 = -atoi(yymsp[0].minor.yy406.z); }
#line 2052 "parse.c"
        break;
      case 47:
      case 48:
#line 207 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy454);}
#line 2058 "parse.c"
        break;
      case 49:
#line 209 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy454, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2066 "parse.c"
        break;
      case 50:
#line 213 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy406);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2074 "parse.c"
        break;
      case 52:
#line 222 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy60);}
#line 2079 "parse.c"
        break;
      case 53:
#line 224 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy60,yymsp[0].minor.yy60);}
#line 2084 "parse.c"
        break;
      case 54:
#line 225 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy60,0,0);}
#line 2089 "parse.c"
        break;
      case 56:
#line 228 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy406,yymsp[-1].minor.yy266,yymsp[0].minor.yy60);}
#line 2094 "parse.c"
        break;
      case 57:
#line 229 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy60);}
#line 2099 "parse.c"
        break;
      case 58:
#line 230 "parse.y"
{sqlite3AddCollateType(pParse, yymsp[0].minor.yy406.z, yymsp[0].minor.yy406.n);}
#line 2104 "parse.c"
        break;
      case 61:
#line 243 "parse.y"
{ yygotominor.yy60 = OE_Restrict * 0x010101; }
#line 2109 "parse.c"
        break;
      case 62:
#line 244 "parse.y"
{ yygotominor.yy60 = (yymsp[-1].minor.yy60 & yymsp[0].minor.yy243.mask) | yymsp[0].minor.yy243.value; }
#line 2114 "parse.c"
        break;
      case 63:
#line 246 "parse.y"
{ yygotominor.yy243.value = 0;     yygotominor.yy243.mask = 0x000000; }
#line 2119 "parse.c"
        break;
      case 64:
#line 247 "parse.y"
{ yygotominor.yy243.value = yymsp[0].minor.yy60;     yygotominor.yy243.mask = 0x0000ff; }
#line 2124 "parse.c"
        break;
      case 65:
#line 248 "parse.y"
{ yygotominor.yy243.value = yymsp[0].minor.yy60<<8;  yygotominor.yy243.mask = 0x00ff00; }
#line 2129 "parse.c"
        break;
      case 66:
#line 249 "parse.y"
{ yygotominor.yy243.value = yymsp[0].minor.yy60<<16; yygotominor.yy243.mask = 0xff0000; }
#line 2134 "parse.c"
        break;
      case 67:
#line 251 "parse.y"
{ yygotominor.yy60 = OE_SetNull; }
#line 2139 "parse.c"
        break;
      case 68:
#line 252 "parse.y"
{ yygotominor.yy60 = OE_SetDflt; }
#line 2144 "parse.c"
        break;
      case 69:
#line 253 "parse.y"
{ yygotominor.yy60 = OE_Cascade; }
#line 2149 "parse.c"
        break;
      case 70:
#line 254 "parse.y"
{ yygotominor.yy60 = OE_Restrict; }
#line 2154 "parse.c"
        break;
      case 71:
      case 72:
      case 87:
      case 89:
      case 91:
      case 92:
      case 163:
#line 256 "parse.y"
{yygotominor.yy60 = yymsp[0].minor.yy60;}
#line 2165 "parse.c"
        break;
      case 82:
#line 273 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy266,yymsp[0].minor.yy60,yymsp[-2].minor.yy60);}
#line 2170 "parse.c"
        break;
      case 83:
#line 275 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy266,yymsp[0].minor.yy60,0,0);}
#line 2175 "parse.c"
        break;
      case 85:
#line 278 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy266, &yymsp[-3].minor.yy406, yymsp[-2].minor.yy266, yymsp[-1].minor.yy60);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy60);
}
#line 2183 "parse.c"
        break;
      case 88:
      case 90:
#line 292 "parse.y"
{yygotominor.yy60 = OE_Default;}
#line 2189 "parse.c"
        break;
      case 93:
#line 297 "parse.y"
{yygotominor.yy60 = OE_Ignore;}
#line 2194 "parse.c"
        break;
      case 94:
      case 164:
#line 298 "parse.y"
{yygotominor.yy60 = OE_Replace;}
#line 2200 "parse.c"
        break;
      case 95:
#line 302 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy427, 0);
}
#line 2207 "parse.c"
        break;
      case 96:
#line 309 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy406, &yymsp[-2].minor.yy406, yymsp[0].minor.yy331, yymsp[-5].minor.yy60);
}
#line 2214 "parse.c"
        break;
      case 97:
#line 312 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy427, 1);
}
#line 2221 "parse.c"
        break;
      case 98:
#line 319 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy331, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy331);
}
#line 2229 "parse.c"
        break;
      case 99:
      case 123:
#line 329 "parse.y"
{yygotominor.yy331 = yymsp[0].minor.yy331;}
#line 2235 "parse.c"
        break;
      case 100:
#line 331 "parse.y"
{
  if( yymsp[0].minor.yy331 ){
    yymsp[0].minor.yy331->op = yymsp[-1].minor.yy60;
    yymsp[0].minor.yy331->pPrior = yymsp[-2].minor.yy331;
  }
  yygotominor.yy331 = yymsp[0].minor.yy331;
}
#line 2246 "parse.c"
        break;
      case 102:
#line 340 "parse.y"
{yygotominor.yy60 = TK_ALL;}
#line 2251 "parse.c"
        break;
      case 105:
#line 345 "parse.y"
{
  yygotominor.yy331 = sqlite3SelectNew(yymsp[-6].minor.yy266,yymsp[-5].minor.yy427,yymsp[-4].minor.yy454,yymsp[-3].minor.yy266,yymsp[-2].minor.yy454,yymsp[-1].minor.yy266,yymsp[-7].minor.yy60,yymsp[0].minor.yy348.pLimit,yymsp[0].minor.yy348.pOffset);
}
#line 2258 "parse.c"
        break;
      case 109:
      case 248:
#line 366 "parse.y"
{yygotominor.yy266 = yymsp[-1].minor.yy266;}
#line 2264 "parse.c"
        break;
      case 110:
      case 137:
      case 147:
      case 247:
#line 367 "parse.y"
{yygotominor.yy266 = 0;}
#line 2272 "parse.c"
        break;
      case 111:
#line 368 "parse.y"
{
   yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-2].minor.yy266,yymsp[-1].minor.yy454,yymsp[0].minor.yy406.n?&yymsp[0].minor.yy406:0);
}
#line 2279 "parse.c"
        break;
      case 112:
#line 371 "parse.y"
{
  yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-1].minor.yy266, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2286 "parse.c"
        break;
      case 113:
#line 374 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy406);
  yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-3].minor.yy266, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2295 "parse.c"
        break;
      case 116:
#line 386 "parse.y"
{yygotominor.yy406.n = 0;}
#line 2300 "parse.c"
        break;
      case 117:
#line 398 "parse.y"
{yygotominor.yy427 = sqliteMalloc(sizeof(*yygotominor.yy427));}
#line 2305 "parse.c"
        break;
      case 118:
#line 399 "parse.y"
{yygotominor.yy427 = yymsp[0].minor.yy427;}
#line 2310 "parse.c"
        break;
      case 119:
#line 404 "parse.y"
{
   yygotominor.yy427 = yymsp[-1].minor.yy427;
   if( yygotominor.yy427 && yygotominor.yy427->nSrc>0 ) yygotominor.yy427->a[yygotominor.yy427->nSrc-1].jointype = yymsp[0].minor.yy60;
}
#line 2318 "parse.c"
        break;
      case 120:
#line 408 "parse.y"
{yygotominor.yy427 = 0;}
#line 2323 "parse.c"
        break;
      case 121:
#line 409 "parse.y"
{
  yygotominor.yy427 = sqlite3SrcListAppend(yymsp[-5].minor.yy427,&yymsp[-4].minor.yy406,&yymsp[-3].minor.yy406);
  if( yymsp[-2].minor.yy406.n ) sqlite3SrcListAddAlias(yygotominor.yy427,&yymsp[-2].minor.yy406);
  if( yymsp[-1].minor.yy454 ){
    if( yygotominor.yy427 && yygotominor.yy427->nSrc>1 ){ yygotominor.yy427->a[yygotominor.yy427->nSrc-2].pOn = yymsp[-1].minor.yy454; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy454); }
  }
  if( yymsp[0].minor.yy272 ){
    if( yygotominor.yy427 && yygotominor.yy427->nSrc>1 ){ yygotominor.yy427->a[yygotominor.yy427->nSrc-2].pUsing = yymsp[0].minor.yy272; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy272); }
  }
}
#line 2339 "parse.c"
        break;
      case 122:
#line 423 "parse.y"
{
    yygotominor.yy427 = sqlite3SrcListAppend(yymsp[-6].minor.yy427,0,0);
    yygotominor.yy427->a[yygotominor.yy427->nSrc-1].pSelect = yymsp[-4].minor.yy331;
    if( yymsp[-2].minor.yy406.n ) sqlite3SrcListAddAlias(yygotominor.yy427,&yymsp[-2].minor.yy406);
    if( yymsp[-1].minor.yy454 ){
      if( yygotominor.yy427 && yygotominor.yy427->nSrc>1 ){ yygotominor.yy427->a[yygotominor.yy427->nSrc-2].pOn = yymsp[-1].minor.yy454; }
      else { sqlite3ExprDelete(yymsp[-1].minor.yy454); }
    }
    if( yymsp[0].minor.yy272 ){
      if( yygotominor.yy427 && yygotominor.yy427->nSrc>1 ){ yygotominor.yy427->a[yygotominor.yy427->nSrc-2].pUsing = yymsp[0].minor.yy272; }
      else { sqlite3IdListDelete(yymsp[0].minor.yy272); }
    }
  }
#line 2356 "parse.c"
        break;
      case 124:
#line 444 "parse.y"
{
     yygotominor.yy331 = sqlite3SelectNew(0,yymsp[0].minor.yy427,0,0,0,0,0,0,0);
  }
#line 2363 "parse.c"
        break;
      case 125:
#line 450 "parse.y"
{yygotominor.yy406.z=0; yygotominor.yy406.n=0;}
#line 2368 "parse.c"
        break;
      case 127:
#line 455 "parse.y"
{yygotominor.yy427 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy406,&yymsp[0].minor.yy406);}
#line 2373 "parse.c"
        break;
      case 128:
      case 129:
#line 459 "parse.y"
{ yygotominor.yy60 = JT_INNER; }
#line 2379 "parse.c"
        break;
      case 130:
#line 461 "parse.y"
{ yygotominor.yy60 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2384 "parse.c"
        break;
      case 131:
#line 462 "parse.y"
{ yygotominor.yy60 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy406,0); }
#line 2389 "parse.c"
        break;
      case 132:
#line 464 "parse.y"
{ yygotominor.yy60 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy406,&yymsp[-1].minor.yy406); }
#line 2394 "parse.c"
        break;
      case 133:
      case 141:
      case 150:
      case 157:
      case 171:
      case 211:
      case 236:
      case 238:
      case 242:
#line 468 "parse.y"
{yygotominor.yy454 = yymsp[0].minor.yy454;}
#line 2407 "parse.c"
        break;
      case 134:
      case 149:
      case 156:
      case 212:
      case 237:
      case 239:
      case 243:
#line 469 "parse.y"
{yygotominor.yy454 = 0;}
#line 2418 "parse.c"
        break;
      case 135:
      case 168:
#line 473 "parse.y"
{yygotominor.yy272 = yymsp[-1].minor.yy272;}
#line 2424 "parse.c"
        break;
      case 136:
      case 167:
#line 474 "parse.y"
{yygotominor.yy272 = 0;}
#line 2430 "parse.c"
        break;
      case 138:
      case 148:
#line 485 "parse.y"
{yygotominor.yy266 = yymsp[0].minor.yy266;}
#line 2436 "parse.c"
        break;
      case 139:
#line 486 "parse.y"
{
  yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-4].minor.yy266,yymsp[-2].minor.yy454,yymsp[-1].minor.yy406.n>0?&yymsp[-1].minor.yy406:0);
  if( yygotominor.yy266 ) yygotominor.yy266->a[yygotominor.yy266->nExpr-1].sortOrder = yymsp[0].minor.yy60;
}
#line 2444 "parse.c"
        break;
      case 140:
#line 490 "parse.y"
{
  yygotominor.yy266 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy454,yymsp[-1].minor.yy406.n>0?&yymsp[-1].minor.yy406:0);
  if( yygotominor.yy266 && yygotominor.yy266->a ) yygotominor.yy266->a[0].sortOrder = yymsp[0].minor.yy60;
}
#line 2452 "parse.c"
        break;
      case 142:
      case 144:
#line 499 "parse.y"
{yygotominor.yy60 = SQLITE_SO_ASC;}
#line 2458 "parse.c"
        break;
      case 143:
#line 500 "parse.y"
{yygotominor.yy60 = SQLITE_SO_DESC;}
#line 2463 "parse.c"
        break;
      case 145:
#line 502 "parse.y"
{yygotominor.yy406.z = 0; yygotominor.yy406.n = 0;}
#line 2468 "parse.c"
        break;
      case 151:
#line 520 "parse.y"
{yygotominor.yy348.pLimit = 0; yygotominor.yy348.pOffset = 0;}
#line 2473 "parse.c"
        break;
      case 152:
#line 521 "parse.y"
{yygotominor.yy348.pLimit = yymsp[0].minor.yy454; yygotominor.yy348.pOffset = 0;}
#line 2478 "parse.c"
        break;
      case 153:
#line 523 "parse.y"
{yygotominor.yy348.pLimit = yymsp[-2].minor.yy454; yygotominor.yy348.pOffset = yymsp[0].minor.yy454;}
#line 2483 "parse.c"
        break;
      case 154:
#line 525 "parse.y"
{yygotominor.yy348.pOffset = yymsp[-2].minor.yy454; yygotominor.yy348.pLimit = yymsp[0].minor.yy454;}
#line 2488 "parse.c"
        break;
      case 155:
#line 529 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy427,yymsp[0].minor.yy454);}
#line 2493 "parse.c"
        break;
      case 158:
#line 543 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy427,yymsp[-1].minor.yy266,yymsp[0].minor.yy454,yymsp[-4].minor.yy60);}
#line 2498 "parse.c"
        break;
      case 159:
#line 546 "parse.y"
{yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-4].minor.yy266,yymsp[0].minor.yy454,&yymsp[-2].minor.yy406);}
#line 2503 "parse.c"
        break;
      case 160:
#line 547 "parse.y"
{yygotominor.yy266 = sqlite3ExprListAppend(0,yymsp[0].minor.yy454,&yymsp[-2].minor.yy406);}
#line 2508 "parse.c"
        break;
      case 161:
#line 553 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy427, yymsp[-1].minor.yy266, 0, yymsp[-4].minor.yy272, yymsp[-7].minor.yy60);}
#line 2513 "parse.c"
        break;
      case 162:
#line 555 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy427, 0, yymsp[0].minor.yy331, yymsp[-1].minor.yy272, yymsp[-4].minor.yy60);}
#line 2518 "parse.c"
        break;
      case 165:
      case 240:
#line 565 "parse.y"
{yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-2].minor.yy266,yymsp[0].minor.yy454,0);}
#line 2524 "parse.c"
        break;
      case 166:
      case 241:
#line 566 "parse.y"
{yygotominor.yy266 = sqlite3ExprListAppend(0,yymsp[0].minor.yy454,0);}
#line 2530 "parse.c"
        break;
      case 169:
#line 575 "parse.y"
{yygotominor.yy272 = sqlite3IdListAppend(yymsp[-2].minor.yy272,&yymsp[0].minor.yy406);}
#line 2535 "parse.c"
        break;
      case 170:
#line 576 "parse.y"
{yygotominor.yy272 = sqlite3IdListAppend(0,&yymsp[0].minor.yy406);}
#line 2540 "parse.c"
        break;
      case 172:
#line 587 "parse.y"
{yygotominor.yy454 = yymsp[-1].minor.yy454; sqlite3ExprSpan(yygotominor.yy454,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2545 "parse.c"
        break;
      case 173:
      case 178:
      case 179:
      case 180:
      case 181:
#line 588 "parse.y"
{yygotominor.yy454 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2554 "parse.c"
        break;
      case 174:
      case 175:
#line 589 "parse.y"
{yygotominor.yy454 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2560 "parse.c"
        break;
      case 176:
#line 591 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy406);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy406);
  yygotominor.yy454 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2569 "parse.c"
        break;
      case 177:
#line 596 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy406);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy406);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy406);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy454 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2580 "parse.c"
        break;
      case 182:
#line 607 "parse.y"
{yygotominor.yy454 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2585 "parse.c"
        break;
      case 183:
#line 608 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy454 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2594 "parse.c"
        break;
      case 184:
#line 613 "parse.y"
{
  yygotominor.yy454 = sqlite3ExprFunction(yymsp[-1].minor.yy266, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2602 "parse.c"
        break;
      case 185:
#line 617 "parse.y"
{
  yygotominor.yy454 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2610 "parse.c"
        break;
      case 186:
      case 187:
      case 188:
#line 621 "parse.y"
{yygotominor.yy454 = sqlite3Expr(yymsp[0].major,0,0,0);}
#line 2617 "parse.c"
        break;
      case 189:
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
      case 198:
      case 199:
      case 200:
      case 201:
      case 202:
      case 203:
      case 204:
      case 205:
      case 206:
#line 624 "parse.y"
{yygotominor.yy454 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy454, yymsp[0].minor.yy454, 0);}
#line 2639 "parse.c"
        break;
      case 207:
#line 643 "parse.y"
{yygotominor.yy258.opcode = TK_LIKE; yygotominor.yy258.not = 0;}
#line 2644 "parse.c"
        break;
      case 208:
#line 644 "parse.y"
{yygotominor.yy258.opcode = TK_GLOB; yygotominor.yy258.not = 0;}
#line 2649 "parse.c"
        break;
      case 209:
#line 645 "parse.y"
{yygotominor.yy258.opcode = TK_LIKE; yygotominor.yy258.not = 1;}
#line 2654 "parse.c"
        break;
      case 210:
#line 646 "parse.y"
{yygotominor.yy258.opcode = TK_GLOB; yygotominor.yy258.not = 1;}
#line 2659 "parse.c"
        break;
      case 213:
#line 650 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy454, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy454, 0);
  if( yymsp[0].minor.yy454 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy454, 0);
  }
  yygotominor.yy454 = sqlite3ExprFunction(pList, 0);
  if( yygotominor.yy454 ) yygotominor.yy454->op = yymsp[-2].minor.yy258.opcode;
  if( yymsp[-2].minor.yy258.not ) yygotominor.yy454 = sqlite3Expr(TK_NOT, yygotominor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454, &yymsp[-3].minor.yy454->span, &yymsp[-1].minor.yy454->span);
}
#line 2674 "parse.c"
        break;
      case 214:
#line 662 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_ISNULL, yymsp[-1].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-1].minor.yy454->span,&yymsp[0].minor.yy0);
}
#line 2682 "parse.c"
        break;
      case 215:
#line 666 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-2].minor.yy454->span,&yymsp[0].minor.yy0);
}
#line 2690 "parse.c"
        break;
      case 216:
#line 670 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_NOTNULL, yymsp[-1].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-1].minor.yy454->span,&yymsp[0].minor.yy0);
}
#line 2698 "parse.c"
        break;
      case 217:
#line 674 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-2].minor.yy454->span,&yymsp[0].minor.yy0);
}
#line 2706 "parse.c"
        break;
      case 218:
#line 678 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-3].minor.yy454->span,&yymsp[0].minor.yy0);
}
#line 2714 "parse.c"
        break;
      case 219:
      case 220:
#line 682 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy454->span);
}
#line 2723 "parse.c"
        break;
      case 221:
#line 690 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy454->span);
}
#line 2731 "parse.c"
        break;
      case 222:
#line 694 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy454->span);
}
#line 2739 "parse.c"
        break;
      case 225:
#line 701 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy454, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy454, 0);
  yygotominor.yy454 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy454, 0, 0);
  if( yygotominor.yy454 ) yygotominor.yy454->pList = pList;
  if( yymsp[-3].minor.yy60 ) yygotominor.yy454 = sqlite3Expr(TK_NOT, yygotominor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-4].minor.yy454->span,&yymsp[0].minor.yy454->span);
}
#line 2751 "parse.c"
        break;
      case 228:
#line 713 "parse.y"
{
    yygotominor.yy454 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy454, 0, 0);
    if( yygotominor.yy454 ){
      yygotominor.yy454->pList = yymsp[-1].minor.yy266;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy266);
    }
    if( yymsp[-3].minor.yy60 ) yygotominor.yy454 = sqlite3Expr(TK_NOT, yygotominor.yy454, 0, 0);
    sqlite3ExprSpan(yygotominor.yy454,&yymsp[-4].minor.yy454->span,&yymsp[0].minor.yy0);
  }
#line 2765 "parse.c"
        break;
      case 229:
#line 723 "parse.y"
{
    yygotominor.yy454 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy454 ) yygotominor.yy454->pSelect = yymsp[-1].minor.yy331;
    if( !yygotominor.yy454 ) sqlite3SelectDelete(yymsp[-1].minor.yy331);
    sqlite3ExprSpan(yygotominor.yy454,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2775 "parse.c"
        break;
      case 230:
#line 729 "parse.y"
{
    yygotominor.yy454 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy454, 0, 0);
    if( yygotominor.yy454 ) yygotominor.yy454->pSelect = yymsp[-1].minor.yy331;
    if( !yygotominor.yy454 ) sqlite3SelectDelete(yymsp[-1].minor.yy331);
    if( yymsp[-3].minor.yy60 ) yygotominor.yy454 = sqlite3Expr(TK_NOT, yygotominor.yy454, 0, 0);
    sqlite3ExprSpan(yygotominor.yy454,&yymsp[-4].minor.yy454->span,&yymsp[0].minor.yy0);
  }
#line 2786 "parse.c"
        break;
      case 231:
#line 736 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy406,&yymsp[0].minor.yy406);
    yygotominor.yy454 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy454, 0, 0);
    if( yygotominor.yy454 ) yygotominor.yy454->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    if( yymsp[-2].minor.yy60 ) yygotominor.yy454 = sqlite3Expr(TK_NOT, yygotominor.yy454, 0, 0);
    sqlite3ExprSpan(yygotominor.yy454,&yymsp[-3].minor.yy454->span,yymsp[0].minor.yy406.z?&yymsp[0].minor.yy406:&yymsp[-1].minor.yy406);
  }
#line 2797 "parse.c"
        break;
      case 232:
#line 743 "parse.y"
{
    Expr *p = yygotominor.yy454 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy331;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }
    if( !p ) sqlite3SelectDelete(yymsp[-1].minor.yy331);
  }
#line 2809 "parse.c"
        break;
      case 233:
#line 754 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy454, yymsp[-1].minor.yy454, 0);
  if( yygotominor.yy454 ) yygotominor.yy454->pList = yymsp[-2].minor.yy266;
  sqlite3ExprSpan(yygotominor.yy454, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2818 "parse.c"
        break;
      case 234:
#line 761 "parse.y"
{
  yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-4].minor.yy266, yymsp[-2].minor.yy454, 0);
  yygotominor.yy266 = sqlite3ExprListAppend(yygotominor.yy266, yymsp[0].minor.yy454, 0);
}
#line 2826 "parse.c"
        break;
      case 235:
#line 765 "parse.y"
{
  yygotominor.yy266 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy454, 0);
  yygotominor.yy266 = sqlite3ExprListAppend(yygotominor.yy266, yymsp[0].minor.yy454, 0);
}
#line 2834 "parse.c"
        break;
      case 244:
#line 790 "parse.y"
{
  if( yymsp[-9].minor.yy60!=OE_None ) yymsp[-9].minor.yy60 = yymsp[0].minor.yy60;
  if( yymsp[-9].minor.yy60==OE_Default) yymsp[-9].minor.yy60 = OE_Abort;
  sqlite3CreateIndex(pParse, &yymsp[-7].minor.yy406, &yymsp[-6].minor.yy406, sqlite3SrcListAppend(0,&yymsp[-4].minor.yy406,0),yymsp[-2].minor.yy266,yymsp[-9].minor.yy60, &yymsp[-10].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 2843 "parse.c"
        break;
      case 245:
      case 292:
#line 797 "parse.y"
{yygotominor.yy60 = OE_Abort;}
#line 2849 "parse.c"
        break;
      case 246:
#line 798 "parse.y"
{yygotominor.yy60 = OE_None;}
#line 2854 "parse.c"
        break;
      case 249:
#line 808 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy406.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy406.z, yymsp[-1].minor.yy406.n);
  }
  yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-4].minor.yy266, p, &yymsp[-2].minor.yy406);
}
#line 2866 "parse.c"
        break;
      case 250:
#line 816 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy406.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy406.z, yymsp[-1].minor.yy406.n);
  }
  yygotominor.yy266 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy406);
}
#line 2878 "parse.c"
        break;
      case 252:
#line 829 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy427);}
#line 2883 "parse.c"
        break;
      case 253:
      case 254:
#line 833 "parse.y"
{sqlite3Vacuum(pParse,0);}
#line 2889 "parse.c"
        break;
      case 255:
      case 257:
#line 839 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy406,&yymsp[-2].minor.yy406,&yymsp[0].minor.yy406,0);}
#line 2895 "parse.c"
        break;
      case 256:
#line 840 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy406,&yymsp[-2].minor.yy406,&yymsp[0].minor.yy0,0);}
#line 2900 "parse.c"
        break;
      case 258:
#line 842 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy406,&yymsp[-2].minor.yy406,&yymsp[0].minor.yy406,1);
}
#line 2907 "parse.c"
        break;
      case 259:
#line 845 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy406,&yymsp[-3].minor.yy406,&yymsp[-1].minor.yy406,0);}
#line 2912 "parse.c"
        break;
      case 260:
#line 846 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy406,&yymsp[0].minor.yy406,0,0);}
#line 2917 "parse.c"
        break;
      case 267:
#line 859 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy406.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy406.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy455, &all);
}
#line 2927 "parse.c"
        break;
      case 268:
#line 868 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy406, &yymsp[-6].minor.yy406, yymsp[-5].minor.yy60, yymsp[-4].minor.yy62.a, yymsp[-4].minor.yy62.b, yymsp[-2].minor.yy427, yymsp[-1].minor.yy60, yymsp[0].minor.yy454, yymsp[-9].minor.yy60);
  yygotominor.yy406 = (yymsp[-6].minor.yy406.n==0?yymsp[-7].minor.yy406:yymsp[-6].minor.yy406);
}
#line 2935 "parse.c"
        break;
      case 269:
      case 272:
#line 874 "parse.y"
{ yygotominor.yy60 = TK_BEFORE; }
#line 2941 "parse.c"
        break;
      case 270:
#line 875 "parse.y"
{ yygotominor.yy60 = TK_AFTER;  }
#line 2946 "parse.c"
        break;
      case 271:
#line 876 "parse.y"
{ yygotominor.yy60 = TK_INSTEAD;}
#line 2951 "parse.c"
        break;
      case 273:
      case 274:
      case 275:
#line 881 "parse.y"
{yygotominor.yy62.a = yymsp[0].major; yygotominor.yy62.b = 0;}
#line 2958 "parse.c"
        break;
      case 276:
#line 884 "parse.y"
{yygotominor.yy62.a = TK_UPDATE; yygotominor.yy62.b = yymsp[0].minor.yy272;}
#line 2963 "parse.c"
        break;
      case 277:
      case 278:
#line 887 "parse.y"
{ yygotominor.yy60 = TK_ROW; }
#line 2969 "parse.c"
        break;
      case 279:
#line 889 "parse.y"
{ yygotominor.yy60 = TK_STATEMENT; }
#line 2974 "parse.c"
        break;
      case 280:
#line 892 "parse.y"
{ yygotominor.yy454 = 0; }
#line 2979 "parse.c"
        break;
      case 281:
#line 893 "parse.y"
{ yygotominor.yy454 = yymsp[0].minor.yy454; }
#line 2984 "parse.c"
        break;
      case 282:
#line 897 "parse.y"
{
  yymsp[-2].minor.yy455->pNext = yymsp[0].minor.yy455;
  yygotominor.yy455 = yymsp[-2].minor.yy455;
}
#line 2992 "parse.c"
        break;
      case 283:
#line 901 "parse.y"
{ yygotominor.yy455 = 0; }
#line 2997 "parse.c"
        break;
      case 284:
#line 907 "parse.y"
{ yygotominor.yy455 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy406, yymsp[-1].minor.yy266, yymsp[0].minor.yy454, yymsp[-4].minor.yy60); }
#line 3002 "parse.c"
        break;
      case 285:
#line 912 "parse.y"
{yygotominor.yy455 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy406, yymsp[-4].minor.yy272, yymsp[-1].minor.yy266, 0, yymsp[-7].minor.yy60);}
#line 3007 "parse.c"
        break;
      case 286:
#line 915 "parse.y"
{yygotominor.yy455 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy406, yymsp[-1].minor.yy272, 0, yymsp[0].minor.yy331, yymsp[-4].minor.yy60);}
#line 3012 "parse.c"
        break;
      case 287:
#line 919 "parse.y"
{yygotominor.yy455 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy406, yymsp[0].minor.yy454);}
#line 3017 "parse.c"
        break;
      case 288:
#line 922 "parse.y"
{yygotominor.yy455 = sqlite3TriggerSelectStep(yymsp[0].minor.yy331); }
#line 3022 "parse.c"
        break;
      case 289:
#line 925 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy454->iColumn = OE_Ignore;
  sqlite3ExprSpan(yygotominor.yy454, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3031 "parse.c"
        break;
      case 290:
#line 930 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy406); 
  yygotominor.yy454->iColumn = yymsp[-3].minor.yy60;
  sqlite3ExprSpan(yygotominor.yy454, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3040 "parse.c"
        break;
      case 291:
#line 938 "parse.y"
{yygotominor.yy60 = OE_Rollback;}
#line 3045 "parse.c"
        break;
      case 293:
#line 940 "parse.y"
{yygotominor.yy60 = OE_Fail;}
#line 3050 "parse.c"
        break;
      case 294:
#line 945 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy427);
}
#line 3057 "parse.c"
        break;
      case 295:
#line 951 "parse.y"
{
  sqlite3Attach(pParse, &yymsp[-3].minor.yy406, &yymsp[-1].minor.yy406, yymsp[0].minor.yy40.type, &yymsp[0].minor.yy40.key);
}
#line 3064 "parse.c"
        break;
      case 296:
#line 955 "parse.y"
{ yygotominor.yy40.type = 0; }
#line 3069 "parse.c"
        break;
      case 297:
#line 956 "parse.y"
{ yygotominor.yy40.type=1; yygotominor.yy40.key = yymsp[0].minor.yy406; }
#line 3074 "parse.c"
        break;
      case 298:
#line 957 "parse.y"
{ yygotominor.yy40.type=2; yygotominor.yy40.key = yymsp[0].minor.yy0; }
#line 3079 "parse.c"
        break;
      case 301:
#line 963 "parse.y"
{
  sqlite3Detach(pParse, &yymsp[0].minor.yy406);
}
#line 3086 "parse.c"
        break;
      case 302:
#line 969 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3091 "parse.c"
        break;
      case 303:
#line 970 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy406, &yymsp[0].minor.yy406);}
#line 3096 "parse.c"
        break;
      case 304:
#line 975 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy427,&yymsp[0].minor.yy406);
}
#line 3103 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 23 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
  }
#line 3170 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
