# copyright (C) 1997-2001 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: preferen.tcl,v 1.13 2000/12/31 23:14:19 jfontain Exp $}


namespace eval preferences {
    # there is no knowledge in this file about which global variables are handled in preferences: only each folder namespace code
    # in the configuration interfeace knows and deals with them

    variable rcFileName ~/.moodssrc

    proc read {} {
        variable rcFileName

        if {![file readable $rcFileName]} {
            return {}
        }
        set file [::open $rcFileName]
        set list {}
        foreach {name value} [::read $file] {
            set name [namespace tail $name]     ;# moodss versions before 8.1 wrote fully qualified names (such as global::variable)
            variable $name $value                                                                    ;# initialize in this namespace
            lappend list $name $value
        }
        close $file
        return $list
    }

    proc save {variables} {                                                                                       ;# save to rc file
        # at this point, variables in this namespace have been updated in the configuration interface
        variable rcFileName

        if {[catch {::open $rcFileName w} file]} {
            tk_messageBox -type ok -default ok -icon error -message $file
            return
        }
        set data [record::globalData]
        foreach name $variables {
            append data [list $name [set ::preferences::$name]]\n
        }
        puts -nonewline $file $data
        close $file
    }

}
