/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FRMJAVA_H
#define FRMJAVA_H

#include "frmjava_base.h"
#include "custmsg.h"

class PhoneMan;
class appConfig;
class QFileDialog;

class frmJava : public frmJava_base
{
Q_OBJECT
public:
    frmJava(QWidget *parent = 0, PhoneMan * phone =0, appConfig * cfg = 0, const char *name = 0);

    ~frmJava();

private:
	PhoneMan * phone;
	QWidget * host;
	appConfig * myCfg;
	int updateRequested;
	P2kFile * files;
	int fileCount;
	int reqID;
	
	P2kFile * icons;
	int iconsCount;

	int freeNumber();
	void parseMidletList();
	void parseIcons();
	void checkIcon(int n);
	P2kFile writeJ2MEST(char justCreate=0);
	
public slots:
	void onUpdateList();
	void onRemove();
	void onAdd();
	void onSetPat();
	void onSave();
	
	void onComplete(int act, const QString&);
	void onFileList(int, P2kFile * lst, int count);
};

#endif
