/***************************************************************************
                          preferences.h  -  description
                             -------------------
    begin                : Fri Feb 23 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PREFERENCES_H
#define PREFERENCES_H

#include <qlineedit.h>
#include <qwidget.h>
#include <kfontdialog.h>
#include <kdialogbase.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>

class Preferences : public KDialogBase
{
     Q_OBJECT
public:
     Preferences (QWidget* parent=0, const char* name = 0);
     ~Preferences();

     QFont getFont();
     const QString getPlayerExe() const;
     /*const QString getPlayerPath() const*/

protected slots:
      void slotSave();
      void slotOk();
      void slotCancel();
      void slotButTempDialEx();
      void slotEnableTemplate();
private:

     void initGeneral();
     void initMp3Options();
     void initFontOptions();
     void initExportOptions();
     void initViewOptions();

     QString getCdPath();
     bool getEject();
     bool getRecursiveVol();
     bool getRecursiveCd();
     void setOptions();

     QLineEdit* cdpath;
     QCheckBox* eject;
     QCheckBox* recursiveVol;
     QCheckBox* recursiveCd;
     KFontChooser* mFont;

     QButtonGroup* groupWriteTag;
     QRadioButton *idv1, *idv2, *idv1and2;
     QComboBox* filetype;
     QComboBox* playerExe;


     QButtonGroup* groupEx;
     QCheckBox *titleEx, *artistEx, *albumEx, *genreEx, *yearEx, *commentEx;
     QCheckBox *lengthEx, *pathEx, *nameEx, *volumeEx, *sizeEx, *modeEx;
     QCheckBox *bitrateEx, *sampleEx, *trackEx;
     QCheckBox *createLinkEx;
     QRadioButton *useTemplateEx;
     QLineEdit *templatePathEx;
     QPushButton *butTempDialEx;

     QButtonGroup* groupView;
     QCheckBox *titleView, *artistView, *albumView, *genreView, *yearView;
     QCheckBox *commentView, *lengthView, *pathView, *nameView, *volumeView;
     QCheckBox *sizeView, *modeView, *bitrateView, *sampleView, *trackView;

     bool modified;
};

#endif
