/***************************************************************************
                          mp3info.h  -  description
                             -------------------
    begin                : Sun Feb 24 2002
    copyright            : (C) 2002 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MP3INFO_H
#define MP3INFO_H

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include "fileinfo.h"

class Mp3Info : public FileInfo
{

public:
     Mp3Info(const char* filein);
     ~Mp3Info();

     int getBitrate();
     int getSamplerate();
		 bool getVbr() {return vbr;};
     const char* getMpegver();
     int getLayer();
     static const char* getMode(int mode);
     int getMode();
     int getLength();
     char* getLengthChar();
     int getSize();
     const char* getPath();
     const char* getName();
     void deleteTag(int mod);

     const char* getArtist();
     const char* getTitle();
     const char* getAlbum();
     const char* getComment();
     const char* getYear();
     static const char* getGenre(int numgen);
     int getGenre();
     const char* getGenreC();
     const char* getTrack();
     bool getResult();

     void writeTagInfo(const char* title, const char* artist, const char* album,
                       const char* comment,  const char* year, int genre,
                       const char* track, int mod);
private:

	typedef struct {
		char tag[3];
		char title[30];
		char artist[30];
		char album[30];
		char year[4];
		char comment[30];
		unsigned char genre;
	} Mp3Tag;

	typedef struct {
		int version;
		int layer;
		int error_protection;
		int bitrate_index;
		int sampling_frequency;
		int padding;
		int extension;
		int mode;
		int mode_ext;
		int copyright;
		int original;
		int emphasis;
		int lsf;
		int mpeg25;
		int stereo;
		int framesize;
	} mpegFrameHeader;

	typedef struct
	{
		int h_id;		/* from MPEG header, 0=MPEG2, 1=MPEG1 */
		int samprate;		/* determined from MPEG header */
		int flags;		/* from Xing header data */
		int frames;		/* total bit stream frames from Xing header data */
		int bytes;		/* total bit stream bytes from Xing header data */
		int vbr_scale;		/* encoded vbr scale from Xing header data */
		unsigned char *toc;	/* pointer to unsigned char toc_buffer[100] */
		/* may be NULL if toc not desired */
	}mpegXingHeader;


     bool success;
     bool existsTag;
     // Mp3Tag tag;
     char* fileglob;
     int length;
     char* lengthchar;
     char* path;
     char* name;
     //int version;
     int filelen;
   /*  int layer;
     int error_protection;
     int bitrate_index;
     int sampling_frequency;
     int padding;
     int extension;
     int mode;
     int mode_ext;
     int copyright;
     int original;
     int emphasis;*/

     char* artist;
     char* title;
     char* album;
     char* comment;
     char* year;
     int genre;
     char* track;
		 int numFrames;
	double tpf;
	bool vbr;
	mpegFrameHeader frameH;
	mpegXingHeader xingH;
     bool headCheck(unsigned long head);
     bool readLayerInfo(FILE* file);
		 bool loadHeader(unsigned long head);
		 bool checkXingHeader(mpegXingHeader * x, unsigned char *buf);
		 double computeTpf(mpegFrameHeader *fr);
		 double computeBpf(mpegFrameHeader *fr);
		 int extractI4(unsigned char *buf);
     bool readTagInfo (const char* filein, FILE* file);
     void setDefault();
     void copyTagInfo(char* to, char *from, int maxlen);

};

#endif
