#pragma warning( disable : 4786 )

#if defined(__WXGTK__) || defined(__WXMOTIF__)
	#include <wx/wx.h>
#endif


#include <wx/wxprec.h>
#include <wx/statline.h>
#include <wx/treectrl.h>
#include <wx/dir.h>
#include <wx/config.h>
#include <wx/timer.h>
#include <wx/busyinfo.h>
#include <wx/progdlg.h>
#include <wx/spinctrl.h>
#include <wx/filename.h>
#include <wx/filedlg.h>
#include <wx/dirdlg.h>


#include "MRIConvert.h"
#include "Converter.h"
#include "DicomTree.h"
#include "InfoFrame.h"
#include "DicomViewer.h"
#include "ImageView.h"
#include "OutputFactory.h"
#include "McPanel.h"
#include "OptionsDialogs.h"
#include "MessageList.h"

#include <map>
#include <algorithm>

using namespace jcs;

using std::vector;
using std::string;
using std::map;

BEGIN_EVENT_TABLE(McPanel, wxPanel)

	EVT_BUTTON(COMMAND_NEW,					McPanel::OnNew)
	EVT_BUTTON(COMMAND_ADD_FILES,			McPanel::OnAddFiles)
	EVT_BUTTON(COMMAND_ADD_DIR,				McPanel::OnAddDir)
	EVT_BUTTON(COMMAND_DIRECTORY,			McPanel::OnDirectory)
	EVT_BUTTON(COMMAND_CONVERT,				McPanel::OnConvert)
	EVT_BUTTON(COMMAND_REMOVE,				McPanel::OnRemove)
	EVT_BUTTON(COMMAND_RENAME,				McPanel::OnRename)
	EVT_BUTTON(COMMAND_OPTIONS,				McPanel::OnOptions)
	EVT_BUTTON(wxID_EXIT,					McPanel::OnQuit)

	EVT_CHOICE(CHOICE_OUTPUT,				McPanel::OnChoiceOutput)

	EVT_TREE_SEL_CHANGED(SOURCE_CTRL,		McPanel::OnSourceSelect)
	EVT_TREE_SEL_CHANGED(OUTPUT_CTRL,		McPanel::OnOutputSelect)
	EVT_TREE_END_LABEL_EDIT(OUTPUT_CTRL,	McPanel::OnEditEnd)

//	EVT_TREE_BEGIN_LABEL_EDIT(OUTPUT_CTRL,  McPanel::OnEditBegin)
	EVT_CONTEXT_MENU(						McPanel::OnContextMenu)

	EVT_MENU(COMMAND_REMOVE,				McPanel::OnRemove)
	EVT_MENU(COMMAND_INFO,					McPanel::OnInfo)
	EVT_MENU(COMMAND_DICOM,					McPanel::OnDicom)
	EVT_MENU(COMMAND_IMAGE,					McPanel::OnImage)

	EVT_MENU(COMMAND_DIRECTORY,				McPanel::OnDirectory)
	EVT_MENU(COMMAND_RENAME,				McPanel::OnRename)

	EVT_DROP_FILES(							McPanel::OnDropFiles)

END_EVENT_TABLE()

McPanel::McPanel(wxWindow* parent) : wxPanel(parent, -1)

{
	m_output_type = 0;
	m_split_dirs = true;
	mpConverter = new Converter(m_output_type);

	// create sizer for panel
	wxBoxSizer* panelSizer = new wxBoxSizer(wxVERTICAL);

	panelSizer->Add(new wxStaticLine(this, -1), 0, wxEXPAND);

	// create sizer for source list
	wxBoxSizer* sSizer = new wxBoxSizer(wxHORIZONTAL);

	// add title
	panelSizer->Add(new wxStaticText(this, -1, _T("Dicom series to convert"),
					wxDefaultPosition), 0, wxLEFT|wxTOP, 20);

	panelSizer->Add(0, 10, 0, wxEXPAND);

	// add list box
	mpSourceCtrl = new DicomTreeCtrl(this, SOURCE_CTRL);
	sSizer->Add(mpSourceCtrl, 1, wxEXPAND);

	// add buttons
	wxBoxSizer* sSizer_buttons = new wxBoxSizer(wxVERTICAL);

	sSizer_buttons->Add(new ttButton(this, COMMAND_ADD_FILES, _T("Add files"),
		_T("Add files to convert")), 0, wxBOTTOM, 10);

	sSizer_buttons->Add(new ttButton(this, COMMAND_ADD_DIR, _T("Add folder"),
		_T("Add directory of files to convert")), 0, wxBOTTOM, 10);
	
	mpRemoveButton = new ttButton(this, COMMAND_REMOVE, _T("Remove"),
		_T("Remove series from list"));
	sSizer_buttons->Add(mpRemoveButton, 0, wxBOTTOM, 10);
//	mpRemoveButton->Disable();
	
	sSizer->Add(sSizer_buttons, 0, wxLEFT, 20);

	// add source list box sizer to panel sizer
	panelSizer->Add(sSizer, 1, wxEXPAND|wxLEFT|wxRIGHT, 20);	

	// add output selector
//	wxBoxSizer* osSizer = new wxBoxSizer(wxHORIZONTAL);

	mpOutputChooser = new wxChoice(this, CHOICE_OUTPUT);
	for (int i = 0; i < OutputFactory::GetNumberOfTypes(); ++i) 
		mpOutputChooser->Append(wxString(OutputFactory::GetDescription(i), wxConvLocal));

	mpOutputChooser->SetSize(mpOutputChooser->GetBestSize());
	mpOutputChooser->SetSelection(m_output_type);

	panelSizer->Add(mpOutputChooser, 0, wxLEFT|wxTOP, 20);

	panelSizer->Add(0, 10, 0, wxEXPAND);
	
	// create sizer for output tree control
	wxBoxSizer* oSizer = new wxBoxSizer(wxHORIZONTAL);

	// add output tree control
	wxString rootdir;
	wxConfig::Get()->Read(_T("dir"), &rootdir);

	while (!wxDir::Exists(rootdir)) 
		rootdir = wxDirSelector(_T("Choose a directory for output"));

	mpOutputCtrl = new NewOutputTreeCtrl(this, OUTPUT_CTRL, rootdir);

	oSizer->Add(mpOutputCtrl, 1, wxEXPAND);

	// add buttons
	wxBoxSizer* oSizer_buttons = new wxBoxSizer(wxVERTICAL);

	mpOptionsButton = new ttButton(this, COMMAND_OPTIONS,
		_T("Options"), _T("Options for this format"));
	oSizer_buttons->Add(mpOptionsButton, 0, wxBOTTOM, 10);

	oSizer_buttons->Add(new ttButton(this, COMMAND_DIRECTORY, 
		_T("Directory"), _T("Select directory for converted files")),
		0, wxBOTTOM, 10);

	mpRenameButton = new ttButton(this, COMMAND_RENAME, _T("Rename"),
		_T("Change names of output files/directories"));
	oSizer_buttons->Add(mpRenameButton);

	oSizer->Add(oSizer_buttons, 0, wxLEFT, 20);

	// add output control sizer to panel sizer
	panelSizer->Add(oSizer, 1, wxEXPAND|wxLEFT|wxRIGHT, 20);

	mpPathInfo = new wxStaticText(this, -1, ::wxGetCwd());
	panelSizer->Add(mpPathInfo, 0, wxALL, 20);

	panelSizer->Add(new wxStaticLine(this, -1), 0, wxEXPAND);

	// create button sizer
	wxBoxSizer* buttonSizer = new wxBoxSizer(wxHORIZONTAL);

	// add buttons to button sizer
	buttonSizer->Add(new ttButton(this, COMMAND_NEW, 
		_T("New session"), _T("Clear list and start new session")),
		0, wxRIGHT, 20);

	buttonSizer->Add(new ttButton(this, COMMAND_CONVERT, 
		_T("Convert all"), _T("Convert all files")), 0, wxRIGHT, 20);

	buttonSizer->Add(new ttButton(this, wxID_EXIT, _T("Quit"),
		_T("Quit the application")));

	// add button sizer to panel sizer
	panelSizer->Add(0, 10, 0, wxEXPAND);
	panelSizer->Add(buttonSizer, 0, wxALIGN_RIGHT|wxRIGHT, 20);
	panelSizer->Add(0, 10, 0, wxEXPAND);

	// set the sizer and layout
	SetSizer(panelSizer);

	// check dictionary file available
//	wxLogError(_T("Dictionary file not found"));
//	GetParent()->Close(false);

	mpOutputCtrl->SetOutputter(mpConverter->GetOutputter());

	#if defined(__WXMSW__) 
		DragAcceptFiles(true);
	#endif

	// todo: handle dir drop
	if (wxGetApp().argc > 1) {
		for (int i = 1; i < wxGetApp().argc; ++i) {
			wxFileName filename(wxGetApp().argv[i]);
			if (filename.FileExists())
				mpConverter->AddFile(filename.GetFullPath());

			else if (filename.DirExists()) {
				wxArrayString files;
				wxDir::GetAllFiles(filename.GetFullPath(), &files, _T("*.*"));
				wxLogStatus(_T("Adding files..."));
				unsigned int nfiles = files.GetCount();
				wxProgressDialog* p_dlg = new wxProgressDialog(_T("Progress"), 
					_T("Adding files..."), nfiles, this, wxPD_CAN_ABORT | wxPD_APP_MODAL);
				for (unsigned int i = 0; i < files.GetCount(); ++i) {
					mpConverter->AddFile(files.Item(i).c_str());
					if (!p_dlg->Update(i)) break;
				}
				p_dlg->Destroy();
			}
		}

		mpConverter->UpdateOutput();
		ResetOutput();
		RefreshSourceCtrl();
		ShowMessageBox();
		::wxGetTopLevelParent(this)->Raise();

	}
}


McPanel::~McPanel()
{
	wxString rootdir = mpOutputCtrl->GetItemText(mpOutputCtrl->GetRootItem());
	wxConfig::Get()->Write(_T("dir"), rootdir);
	delete mpConverter;
}

// kindof annoying this way, but okay for now
void
McPanel::RefreshSourceCtrl()
{
	
	vector <string> sv = mpConverter->GetSeriesList();
	vector<string>::iterator it = sv.begin();
	vector<string>::iterator it_end = sv.end();
	while (it != it_end) {
		SeriesHandler* series = mpConverter->GetHandler(*it);
		mpSourceCtrl->AddSeries(series);
		++it;
	}
	
}


void
McPanel::ResetOutput()
{
	wxBusyCursor busy;
	mpOutputCtrl->Reset();
	mpOutputCtrl->RefreshList();

}

void
McPanel::SetSplitDirs(bool split)
{
	m_split_dirs = split;
	mpOutputCtrl->SplitDirectories(split);
}


// event handlers
void
McPanel::OnQuit(wxCommandEvent& event)
{
	GetParent()->Close(false);
}


void
McPanel::OnContextMenu(wxContextMenuEvent& event)
{
	wxPoint pos = event.GetPosition();

	wxTreeItemId item = mpSourceCtrl->HitTest(mpSourceCtrl->ScreenToClient(pos));
	if (item.IsOk()) {

		mpSourceCtrl->SelectItem(item);
		wxMenu menu;
		switch (mpSourceCtrl->GetItemType(item)) {

			case dtFILE :
				menu.Append(COMMAND_DICOM, _T("View DICOM"));
				menu.Append(COMMAND_IMAGE, _T("View Image"));
				menu.Append(COMMAND_INFO, _T("Series Info"));
				break;

			case dtSERIES : 
				menu.Append(COMMAND_INFO, _T("Series Info"));

			default : 
				menu.Append(COMMAND_REMOVE, _T("Remove"));
				break;
		}
		PopupMenu(&menu, ScreenToClient(pos));
	}

}

void
McPanel::OnChoiceOutput(wxCommandEvent& event)
{
	if (m_output_type != mpOutputChooser->GetSelection()) {
		m_output_type = mpOutputChooser->GetSelection();

		mpConverter->SetOutput(m_output_type);

		mpOutputCtrl->SetOutputter(mpConverter->GetOutputter());
		mpOutputCtrl->SetItemTextColour(mpOutputCtrl->GetRootItem(),
			mpOutputCtrl->GetForegroundColour());


	}

}

void
McPanel::OnSourceSelect(wxTreeEvent& event)
{
// I think we used to enable/disable buttons here...

	// Only do anything if this is a "select" event
//	wxTreeItemId item = mpSourceCtrl->GetSelection();
//	if (item.IsOk()) mpOutputCtrl->Unselect();
}

void
McPanel::OnOutputSelect(wxTreeEvent& event)
{	
	// Only do anything if this is a "select" event
	wxTreeItemId item = mpOutputCtrl->GetSelection();
	if (item.IsOk()) {
		SetPathInfo(mpOutputCtrl->GetStringSelection());
		mpSourceCtrl->Unselect();
	}
}

void
McPanel::OnEditBegin(wxTreeEvent& event)
{
}

void
McPanel::OnEditEnd(wxTreeEvent& event)
{
	if (!event.IsEditCancelled()) SetPathInfo(event.GetLabel());

}

void
McPanel::SetPathInfo(wxString path)
{
	wxTreeItemId item = mpOutputCtrl->GetSelection();
	wxTreeItemId root = mpOutputCtrl->GetRootItem();

	if (!item.IsOk() || item == root)
		path = mpOutputCtrl->GetItemText(root);

	else {
		while(item != root) {
			item = mpOutputCtrl->GetItemParent(item);
			path.Prepend(wxFileName::GetPathSeparator());
			path.Prepend(mpOutputCtrl->GetItemText(item));
		}
	}

	mpPathInfo->SetLabel(path);

}

void
McPanel::OnAddFiles(wxCommandEvent& event)
{
	wxFileDialog *dlg = new wxFileDialog(this, _T("Choose files"),
		_T(""), _T(""), _T("DICOM files (*.dcm)|*.dcm|All files|*"), wxOPEN|wxMULTIPLE);

	if(dlg->ShowModal() == wxID_OK)	{
		
		wxBusyCursor busy;
		wxLogStatus(_T("Searching directories..."));
		wxArrayString files;
		dlg->GetPaths(files);
		wxLogStatus(_T("Adding files..."));
		unsigned int nfiles = files.GetCount();
		wxProgressDialog* p_dlg = new wxProgressDialog(_T("Progress"), 
			_T("Adding files..."), nfiles, this, wxPD_CAN_ABORT | wxPD_APP_MODAL);

		files.Sort();
		for (unsigned int i = 0; i < files.GetCount(); ++i) {
			mpConverter->AddFile(files.Item(i).c_str());
			if (!p_dlg->Update(i)) break;
		}
		p_dlg->Destroy();

		mpConverter->UpdateOutput();
		wxLogStatus(_T("Creating tree..."));

		RefreshSourceCtrl();
		ResetOutput();

	}

	dlg->Destroy();
	wxLogStatus(_T("Finished."));
	ShowMessageBox();
	::wxGetTopLevelParent(this)->Raise();

}

// Fix: handle dropping dirs too
void
McPanel::OnDropFiles(wxDropFilesEvent& event)
{
	int nfiles = event.GetNumberOfFiles();
	wxString* dropfiles = event.GetFiles();
		
	for (int i = 0; i < nfiles; ++i) {
		wxFileName filename(dropfiles[i]);
		if (filename.FileExists()) {
			mpConverter->AddFile(filename.GetFullPath().c_str());
		}
		else if (filename.DirExists()) {
			wxArrayString files;
			wxDir::GetAllFiles(filename.GetFullPath(), &files, _T("*.*"));
			unsigned int n_files = files.GetCount();
			wxProgressDialog* p_dlg = new wxProgressDialog(_T("Progress"), 
				_T("Adding files..."), n_files, this, wxPD_CAN_ABORT | wxPD_APP_MODAL);
			files.Sort();
			for (unsigned int i = 0; i < files.GetCount(); ++i) {
				mpConverter->AddFile(files.Item(i).c_str());
			if (!p_dlg->Update(i)) break;
			}
			p_dlg->Destroy();
		}
	}

	mpConverter->UpdateOutput();
	ResetOutput();
	RefreshSourceCtrl();
	ShowMessageBox();
	::wxGetTopLevelParent(this)->Raise();

}

void
McPanel::OnAddDir(wxCommandEvent& event)
{
	wxString lastDir;
	wxConfig::Get()->Read(_T("lastdir"), &lastDir);

//	wxGenericDirDialog dlg(this, _T("Select a directory of files to convert"),
//		lastDir);

	wxDirDialog dlg(this, _T("Select a directory of files to convert"),
		lastDir, wxRESIZE_BORDER);

	if(dlg.ShowModal() == wxID_OK)	{
	
		wxBusyCursor busy;
		wxLogStatus(_T("Searching directories..."));
		wxArrayString files;
		wxDir::GetAllFiles(dlg.GetPath(), &files);
		wxLogStatus(_T("Adding files..."));
		unsigned int nfiles = files.GetCount();
		wxProgressDialog* p_dlg = new wxProgressDialog(_T("Progress"), 
			_T("Adding files..."), nfiles, this, wxPD_CAN_ABORT | wxPD_APP_MODAL);

		files.Sort();
		for (unsigned int i = 0; i < files.GetCount(); ++i) {
			mpConverter->AddFile(files.Item(i).c_str());
			if (!p_dlg->Update(i)) break;
		}

		p_dlg->Destroy();

		lastDir = dlg.GetPath();
		wxConfig::Get()->Write(_T("lastdir"), dlg.GetPath());


	}

	//dlg->Destroy();

	RefreshSourceCtrl();
	mpConverter->UpdateOutput();
	ResetOutput();
	wxLogStatus(_T("Finished."));
	ShowMessageBox();
	::wxGetTopLevelParent(this)->Raise();

}


void
McPanel::OnDicom(wxCommandEvent& event)
{
	if (mpSourceCtrl->GetSelectionType() == dtFILE) {
		wxString filename =  mpSourceCtrl->GetStringSelection();
		DicomViewer* viewer = new DicomViewer(this, filename.mb_str(wxConvLocal)); 
		viewer->Show();
	}
}

void
McPanel::OnImage(wxCommandEvent& event)
{
	if (mpSourceCtrl->GetSelectionType() == dtFILE) {
		wxString filename =  mpSourceCtrl->GetStringSelection();

		DicomFile dfile(filename.mb_str(wxConvLocal));
		int frames = 1;
		dfile.Find("NumberOfFrames", frames);
		if (frames > 1) {
			MultiFrameImageViewer* viewer = new MultiFrameImageViewer(
				this, filename);
			viewer->Show();
		}
		else {
			vector<wxString> filenames = mpSourceCtrl->GetFilesInSeries();
			ImageViewer* viewer = new ImageViewer(this, filenames, 
				mpSourceCtrl->GetStringSelection());
			viewer->Show();
		}
//		viewer->Destroy();
	}
	wxLogStatus(_T(""));
}

void
McPanel::OnInfo(wxCommandEvent& event)
{
	wxTreeItemId selection = mpSourceCtrl->GetSelection();
	int type = mpSourceCtrl->GetItemType(selection);

	if ((type == dtSERIES) || (type == dtFILE)) {
		wxBusyCursor busy;
		std::string series_uid;
		if (type == dtSERIES)
			series_uid = mpSourceCtrl->GetItemUid(selection);
		else if (type == dtFILE) {
			wxTreeItemId series = mpSourceCtrl->GetItemParent(selection);
			series_uid = mpSourceCtrl->GetItemUid(series);
		}
		std::vector<std::string> info = mpConverter->GetStringInfo(series_uid);
		InfoFrame* infoFrame = new InfoFrame(this, info);
		infoFrame->Show();
	}
}

void
McPanel::OnRemove(wxCommandEvent& event)
{
	wxTreeItemId selected = mpSourceCtrl->GetSelection();
	if(!selected.IsOk()) return;

	if (mpSourceCtrl->GetSelectionType() == dtFILE) {
		wxLogError(_T("Sorry, you'll have to remove the whole series."));
		return;
	}

	std::vector<std::string> series_vector = 
		mpSourceCtrl->GetChildSeries(selected);

	std::vector<std::string>::iterator it = series_vector.begin();
	while (it < series_vector.end()) {
		mpConverter->RemoveSeries(*it);
		mpOutputCtrl->RemoveSeries(*it);
		++it;
	}

	mpSourceCtrl->RemoveBranch(selected);
//	mpOutputCtrl->RefreshList();

}


void
McPanel::OnOptions(wxCommandEvent& event)
{
	if (ShowOptionsDlg(m_output_type, mpConverter->GetOutputter()) == 1) {
		mpConverter->UpdateAllOutput();
		ResetOutput();
	}
}

void
McPanel::OnDirectory(wxCommandEvent& event)
{
	mpOutputCtrl->ChooseRootDir();
}

void
McPanel::OnNew(wxCommandEvent& event)
{
	delete mpConverter;
	mpConverter = new Converter(m_output_type);
	mpSourceCtrl->Reset();
	mpOutputCtrl->Reset();
	mpOutputCtrl->SetOutputter(mpConverter->GetOutputter());
	mpOutputCtrl->SetItemTextColour(mpOutputCtrl->GetRootItem(),
		mpOutputCtrl->GetForegroundColour());

}

void
McPanel::OnConvert(wxCommandEvent& event)
{
	wxWindowDisabler disableAll;
	wxBusyCursor cursor;
	wxBusyInfo wait(_T("Converting files, please wait..."));
	mpConverter->ConvertAll();
	wxLogStatus(_T("Finished."));
	::wxGetTopLevelParent(this)->Raise();
}

void
McPanel::OnRename(wxCommandEvent& event)
{
	mpOutputCtrl->OnMenuRename(event);
	wxString pathInfo = mpOutputCtrl->GetStringSelection();
	if (pathInfo != _T("error")) SetPathInfo(pathInfo);
}

void
McPanel::OnMenuOverride()
{
	wxCommandEvent nullEvent(0,0);
	mpOutputCtrl->OnMenuOverride(nullEvent);
}

void
McPanel::OnOverride(const std::string& seriesUid)
{
	if (ShowOverride(m_output_type, mpConverter->GetOutputter(), seriesUid) == 1) {
		mpConverter->UpdateAllOutput();
		ResetOutput();
	}

}

void
McPanel::ShowMessageBox()
{
	// don't bother if no messages
	if (mpConverter->messages.empty()) return;

	wxWindowDisabler disableAll;
	MessageListDlg lmd(_T("Finished adding files"));
	Message m;
	m.push_back(_T("File name"));
	m.push_back(_T("Status"));
	m.push_back(_T("Information"));
	lmd.SetColumns(m);
	lmd.AddMessages(mpConverter->messages);
	lmd.ShowModal();
	mpConverter->messages.clear();
}
//void
//McPanel::UpdateOutputCtrl()
//{
//	mpOutputCtrl->RefreshList();
//}


