/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001  CodeFactory AB 
 * Copyright (C) 2001  Richard Hult <rhult@codefactory.se>
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the 
 * License, or (at your option) any later version. 
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>
#include <time.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>
#include <libgnome/gnome-paper.h>
#include <libgnomeui/gnome-dialog.h>
#include <libgnomeui/gnome-stock.h>
#include <libgnomeui/gnome-uidefs.h>
#include <libgnomeui/gnome-paper-selector.h>
#include <libgnomeprint/gnome-printer.h>
#include <libgnomeprint/gnome-print.h>
#include <libgnomeprint/gnome-printer-dialog.h>
#include <libgnomeprint/gnome-print-master.h>
#include <libgnomeprint/gnome-print-master-preview.h>
#include "print-resources.h"

void
resource_print_dialog (ResourceComponent *component,
		       ETable            *e_table,
		       gboolean           preview_only)
{
	GtkWidget         *dialog;
	GnomePrinter      *printer;
	gchar             *paper_name;
	GnomePrintMaster  *print_master;
	GnomePrintContext *ctx;
	const GnomePaper  *paper;
	gboolean           preview;
       	int                btn;
	EPrintable        *e_printable;
	
	dialog     = NULL;
	printer    = NULL;
	paper_name = NULL;
	preview    = FALSE;

	if (!preview_only) {
		dialog = gnome_print_dialog_new (_("Print Resource Table"), 0);

		gtk_window_set_wmclass (GTK_WINDOW (dialog),
					"PrintResourceTable",
					"MrProject");

		btn = gnome_dialog_run (GNOME_DIALOG (dialog));

		switch (btn) {
		case -1:
			return;

		case GNOME_PRINT_CANCEL:
			gtk_widget_destroy (dialog);
			return;
			
		case GNOME_PRINT_PREVIEW:
			preview = TRUE;
			break;
		default:
			break;
		};

		gnome_print_dialog_get_printer (GNOME_PRINT_DIALOG (dialog));
	} else {
		preview = TRUE;
	}
		
	print_master = gnome_print_master_new ();

	/* Get the paper metrics. */
	if (paper_name) {
		paper = gnome_paper_with_name (paper_name);
	} else {
		paper = gnome_paper_with_name (gnome_paper_name_default ());
	}

	gnome_print_master_set_paper (print_master, paper);

	if (printer) {
		gnome_print_master_set_printer (print_master, printer);
	}

	ctx = gnome_print_master_get_context (print_master);

	/* Perform the printing. */
	e_printable = e_table_get_printable (e_table);
	e_printable_print_page (e_printable, ctx, 8*72, 10*72, FALSE);

	gnome_print_master_close (print_master);

	if (preview) {
		GnomePrintMasterPreview *preview;
		
		preview = gnome_print_master_preview_new_with_orientation (
			print_master, _("Print Preview"), TRUE); /* Landscape */
		gtk_window_set_wmclass (GTK_WINDOW (preview),
					"PrintPreviewResource",
					"MrProject");

		gtk_widget_show (GTK_WIDGET (preview));
	} else {
		int result = gnome_print_master_print (print_master);

		if (result == -1) {
			g_warning (_("Printing failed."));
		}
	}

	/* Done. */
	gtk_object_unref (GTK_OBJECT (print_master));

	if (!preview_only) {
		gtk_widget_destroy (dialog);
	}
}


