/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Mikael Hallendal <micke@codefactory.se>
 */

#ifndef __RESOURCE_TABLE_MODEL_H__
#define __RESOURCE_TABLE_MODEL_H__

#include <glib.h>
#include <gal/e-table/e-table-model.h>
#include <gtk/gtktypeutils.h>
#include "libmrproject/GNOME_MrProject.h"

#define TYPE_RESOURCE_TABLE_MODEL        (resource_tm_get_type ())
#define RESOURCE_TABLE_MODEL(o)          (GTK_CHECK_CAST ((o), TYPE_RESOURCE_TABLE_MODEL, ResourceTableModel))
#define RESOURCE_TABLE_MODEL_CLASS(k)    (GTK_CHECK_CLASS_CAST ((k), TYPE_RESOURCE_TABLE_MODEL, ResourceTableModelClass))
#define IS_RESOURCE_TABLE_MODEL(o)       (GTK_CHECK_TYPE ((o), TYPE_RESOURCE_TABLE_MODEL))
#define IS_RESOURCE_TABLE_MODEL_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), TYPE_RESOURCE_TABLE_MODEL))

enum {
	RT_COL_ID,
	RT_COL_NAME,
	RT_COL_TYPE,
	RT_COL_GROUP,
	RT_COL_UNITS,
	RT_COL_EMAIL,
	RT_COL_RATE_STD,
	RT_COL_RATE_OVT,
	LAST_RT_COL
};

typedef struct _ResourceTableModel      ResourceTableModel;
typedef struct _ResourceTableModelClass ResourceTableModelClass;
typedef struct _ResourceTableModelPriv  ResourceTableModelPriv;
typedef struct _ResourceTableRow        ResourceTableRow;

struct _ResourceTableModel {
	ETableModel             parent;
	
	ResourceTableModelPriv *priv;
	
};

struct _ResourceTableModelClass {
	ETableModelClass        parent_class;

	/* Signals */
	/* FIX: Add signal here */
};

GtkType       resource_tm_get_type        (void);
ETableModel * resource_tm_new             (void); 

guint         resource_tm_add_resource         (ResourceTableModel     *rtm,
						GM_Resource            *resource);

void          resource_tm_remove_resource      (ResourceTableModel     *rtm,
						gint                    id );

void          resource_tm_remove_all_resources (ResourceTableModel     *rtm);

void          resource_tm_update_resource      (ResourceTableModel     *rtm,
						GM_Resource            *resource);

void          resource_tm_add_group            (ResourceTableModel     *rtm,
						GM_ResourceGroup       *group);
void          resource_tm_update_group         (ResourceTableModel     *rtm,
						GM_ResourceGroup       *group);


void          resource_tm_remove_group         (ResourceTableModel     *rtm,
						gint                    gid);

void          resource_tm_remove_all_groups    (ResourceTableModel     *rtm);

GM_Resource * resource_tm_get_resource_on_row  (ResourceTableModel     *rtm,
						gint                    row);


GList *       resource_tm_get_type_strings     (ResourceTableModel     *rtm);
GList *       resource_tm_get_group_strings    (ResourceTableModel     *rtm);

gint          resource_tm_get_row              (ResourceTableModel     *rtm,
					        gint                    id);

GSList *      resource_tm_get_resources_with_group (ResourceTableModel *rtm,
						    GM_Id               gid);

#endif /* __RESOURCE_TABLE_MODEL_H__ */


