/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000 CodeFactory AB
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Mikael Hallendal <micke@codefactory.se>
 */

#ifndef __TASK_MANAGER_CLIENT_H__
#define __TASK_MANAGER_CLIENT_H__

#include <bonobo.h>
#include <gtk/gtkobject.h>
#include <gtk/gtksignal.h>
#include "util/corba-utils.h"
#include "manager-client.h"

#define TASK_MANAGER_CLIENT_TYPE        (task_mc_get_type ())
#define TASK_MANAGER_CLIENT(o)          (GTK_CHECK_CAST ((o), TASK_MANAGER_CLIENT_TYPE, TaskManagerClient))
#define TASK_MANAGER_CLIENT_CLASS(k)     (GTK_CHECK_CLASS_CAST((k), TASK_MANAGER_CLIENT_TYPE, TaskManagerClientClass))
#define IS_TASK_MANAGER_CLIENT(o)       (GTK_CHECK_TYPE ((o), TASK_MANAGER_CLIENT_TYPE))
#define IS_TASK_MANAGER_CLIENT_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), TASK_MANAGER_CLIENT_TYPE))

typedef struct _TaskManagerClient      TaskManagerClient;
typedef struct _TaskManagerClientClass TaskManagerClientClass;
typedef struct _TaskManagerClientPriv  TaskManagerClientPriv;

struct _TaskManagerClient {
        ManagerClient          parent;

        TaskManagerClientPriv *priv;
};

struct _TaskManagerClientClass 
{
        ManagerClientClass     parent_class;
	
	/* Signals */
	void (*task_inserted)       (TaskManagerClient   *tmc,
				     GM_Task             *task);
	void (*tasks_removed)       (TaskManagerClient   *tmc,
				     GSList              *tasks);
	void (*task_updated)        (TaskManagerClient   *tmc,
				     GM_Task             *task);
	void (*task_repositioned)   (TaskManagerClient   *tmc,
				     GM_Id                task_id,
				     GM_Id                sibling_id,
				     GM_TaskOrderType     type);
	void (*task_reparented)     (TaskManagerClient   *tmc,
				     GM_Id                task_id,
				     GM_Id                new_parent_id);
	void (*tasks_linked)        (TaskManagerClient   *tmc,
				     GM_Dependency       *dependency);
	void (*tasks_unlinked)      (TaskManagerClient   *tmc,
				     GM_Dependency       *dependency);
	void (*note_changed)        (TaskManagerClient   *tmc,
				     GM_Id                task_id,
				     gchar               *note);
};


GtkType         task_mc_get_type          (void);

ManagerClient * task_mc_new               (GM_Shell             shell,
					   gboolean             set,
					   CORBA_Environment   *ev);

GM_Task *       task_mc_create_task       (TaskManagerClient   *tmc,
					   CORBA_Environment   *ev);

GM_Id           task_mc_insert_task       (TaskManagerClient   *tmc,
					   GM_Task             *task,
					   GM_Id                parent_id,
					   CORBA_Environment   *ev);

void            task_mc_update_task       (TaskManagerClient   *tmc,
					   GM_Id                task_id,
					   GM_Task             *task,
					   CORBA_Environment   *ev);

void            task_mc_move_task         (TaskManagerClient   *tmc,
					   GM_Id                id,
					   time_t               start,
					   GM_TaskEdge          edge,
					   CORBA_Environment   *ev);
void            task_mc_set_task_duration (TaskManagerClient   *tmc,
					   GM_Id                task_id,
					   GM_Time              duration,
					   GM_TaskEdge          relativeEdge,
					   CORBA_Environment   *ev);
void            task_mc_reparent_task     (TaskManagerClient   *tmc,
					   GM_Id                task_id,
					   GM_Id                parent_id,
					   CORBA_Environment   *ev);

void            task_mc_reposition_task   (TaskManagerClient   *tmc,
					   GM_Id                task_id,
					   GM_Id                sibling_id,
					   GM_TaskOrderType     type,
					   CORBA_Environment   *ev);

GM_Task *       task_mc_get_task          (TaskManagerClient   *tmc,
					   GM_Id                task_id,
					   CORBA_Environment   *ev);

GSList *        task_mc_get_all_tasks     (TaskManagerClient   *tmc,
					   CORBA_Environment   *ev);

void            task_mc_remove_tasks      (TaskManagerClient   *tmc,
					   GSList              *task_ids,
					   CORBA_Environment   *ev);

gboolean        task_mc_is_task_summary   (TaskManagerClient   *tmc,
					   GM_Id                task_id,
					   CORBA_Environment   *ev);

gboolean        task_mc_is_task_recurrent (TaskManagerClient   *tmc,
					   GM_Id                task_id,
					   CORBA_Environment   *ev);

GM_Id           task_mc_link_tasks        (TaskManagerClient   *tmc,
					   GM_Id                task_id,
					   GM_Id                predecessor_id,
					   GM_DependencyType    type,
					   CORBA_Environment   *ev);

void            task_mc_unlink_tasks      (TaskManagerClient   *tmc,
					   GM_Id                task_id,
					   GM_Id                predecessor_id,
					   CORBA_Environment   *ev);

void            task_mc_remove_dependency (TaskManagerClient   *tmc,
					   GM_Id                link_id,
					   CORBA_Environment   *ev);

GM_Dependency * task_mc_get_dependency    (TaskManagerClient   *tmc,
					   GM_Id                dependency_id,
					   CORBA_Environment   *ev);

GSList *        task_mc_get_predecessors  (TaskManagerClient   *tmc,
					   GM_Id                task_id,
					   CORBA_Environment   *ev);

GSList *        task_mc_get_sucessors     (TaskManagerClient   *tmc,
					   GM_Id                task_id,
					   CORBA_Environment   *ev);

GM_TaskManager  task_mc_get_manager       (TaskManagerClient   *tmc);

GM_Id           task_mc_insert_task_full  (TaskManagerClient   *tmc,
					   GM_Task             *task,
					   GM_Id                parent_id,
					   GM_Id                sibling_id,
					   GM_TaskOrderType     type,
					   CORBA_Environment   *ev);

gchar *         task_mc_get_note          (TaskManagerClient   *tmc,
					   GM_Id                task_id,
					   CORBA_Environment   *ev);

void            task_mc_set_note          (TaskManagerClient   *tmc,
					   GM_Id                task_id,
					   gchar               *note,
					   CORBA_Environment   *ev);


#endif /* __TASK_MANAGER_CLIENT_H__ */

