/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __ENGINE_H__
#define __ENGINE_H__

#include <bonobo/bonobo-xobject.h>
#include <gtk/gtktypeutils.h>
#include "libmrproject/GNOME_MrProject.h"

#define ENGINE_TYPE        (engine_get_type ())
#define ENGINE(o)          (GTK_CHECK_CAST ((o), ENGINE_TYPE, Engine))
#define ENGINE_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), ENGINE_TYPE, EngineClass))
#define IS_ENGINE(o)       (GTK_CHECK_TYPE ((o), ENGINE_TYPE))
#define IS_ENGINE_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), ENGINE_TYPE))

typedef struct _Engine       Engine;
typedef struct _EnginePriv   EnginePriv;

struct _Engine {
	BonoboXObject  parent;
	EnginePriv    *priv;
};

typedef struct {
	BonoboXObjectClass              parent_class;
	POA_GNOME_MrProject_Engine__epv epv;
} EngineClass;


GtkType	 engine_get_type       (void);
Engine  *engine_new            (void);
Project *engine_create_project (Engine *engine);


#endif /* __ENGINE_H__ */

