/* GIMP Minolta Raw Format plugin
 * Copyright (C) 2002 Laurent HOUDARD <lhoudard@netcourrier.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <string.h>
#include <alloca.h>

#include "../../config.h"
#include <glib/gthread.h>
#include <gtk/gtk.h>
#include <gtk/gtkenums.h>
#include <libgimp/gimp.h>

#include <MRI.h>
#include "../options.h"
#include "PersistentVals.h"
#include "histogram.h"
#include "mrwplugin-intl.h"

static GtkWidget *histogramWidget;

void
histogram_new (GtkWidget *parent, int width, int height)
{
  GtkWidget *histogram_frame;
  GtkWidget *prev;

  histogram_frame = gtk_frame_new (NULL);
  histWidth = width;
  histHeight = height;
  gtk_widget_show (histogram_frame);
  gtk_container_add (GTK_CONTAINER (parent), histogram_frame);
  gtk_frame_set_shadow_type (GTK_FRAME(histogram_frame), GTK_SHADOW_IN);

  prev = gtk_preview_new (GTK_PREVIEW_COLOR);
  gtk_preview_size (GTK_PREVIEW (prev), histWidth, histHeight);
  gtk_container_add (GTK_CONTAINER (histogram_frame), prev);
  gtk_widget_show (prev);
  histogramWidget = prev;

  do_histogram (NULL);
}

void
init_histogram ()
{
  histogramWidget = NULL;
}

void
do_histogram (int *hvals)
{
  guchar *data = alloca (sizeof (guchar) * histWidth * 3);
  int i, y;

  if (histogramWidget != NULL) {
      gdouble scale = 0.0;
      if (hvals) {
          for (i = 0; i < histWidth; i++)
	      if (hvals[i] > scale) scale = hvals[i];
	  scale /= histHeight;
      }
      for (y = 0; y < histHeight; y++) {
          guchar *dest = data;
	  double yy = y * scale;
          for (i = 0; i < histWidth; i++) {
		if (hvals && yy < hvals[i]) {
	            *dest++ = 0x00;
	            *dest++ = 0x00;
	            *dest++ = 0x00;
		}
		else {
	            *dest++ = 0xFF;
	            *dest++ = 0xFF;
	            *dest++ = 0xFF;
		}
          }
          gtk_preview_draw_row (GTK_PREVIEW (histogramWidget), data, 0, y, histWidth);
      }
      gtk_widget_draw (histogramWidget, NULL);
  }
  gdk_flush ();
}

